/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.component;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.awt.Color;
import journeymap.client.Constants;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.util.text.ITextComponent;

public class TextBox
extends TextFieldWidget {
    protected final String numericRegex;
    protected final boolean numeric;
    protected final boolean allowNegative;
    protected int minLength;
    protected Integer clampMin;
    protected Integer clampMax;

    public TextBox(Object text, FontRenderer fontRenderer, int width, int height) {
        this(text, fontRenderer, width, height, false, false);
    }

    public TextBox(Object text, FontRenderer fontRenderer, int width, int height, boolean isNumeric, boolean negative) {
        super(fontRenderer, 0, 0, width, height, (ITextComponent)Constants.getStringTextComponent(text.toString()));
        this.func_146180_a(text.toString());
        this.numeric = isNumeric;
        this.allowNegative = negative;
        String regex = null;
        if (this.numeric) {
            regex = this.allowNegative ? "[^-?\\d]" : "[^\\d]";
        }
        this.numericRegex = regex;
    }

    public void setClamp(Integer min, Integer max) {
        this.clampMin = min;
        this.clampMax = max;
    }

    public void setMinLength(int minLength) {
        this.minLength = minLength;
    }

    public void func_146191_b(String par1Str) {
        super.func_146191_b(par1Str);
        if (this.numeric) {
            String fixed = this.func_146179_b().replaceAll(this.numericRegex, "");
            if (this.allowNegative) {
                String start = fixed.startsWith("-") ? "-" : "";
                fixed = start + fixed.replaceAll("-", "");
            }
            super.func_146180_a(fixed);
        }
    }

    public void setText(Object object) {
        super.func_146180_a(object.toString());
    }

    public boolean isNumeric() {
        return this.numeric;
    }

    public boolean hasMinLength() {
        String text = this.func_146179_b();
        int textLen = text == null ? 0 : text.length();
        return this.minLength <= textLen;
    }

    public boolean func_231042_a_(char c, int key) {
        if (this.numeric && this.func_230999_j_()) {
            this.clamp();
        }
        super.func_231042_a_(c, key);
        return true;
    }

    public boolean func_231046_a_(int key, int value, int modifier) {
        super.func_231046_a_(key, value, modifier);
        return true;
    }

    public void func_230430_a_(MatrixStack mStack, int mouseX, int mouseY, float partialTicks) {
        super.func_230430_a_(mStack, mouseX, mouseY, partialTicks);
        if (this.func_146176_q() && !this.hasMinLength()) {
            int red = Color.red.getRGB();
            int x1 = this.getX() - 1;
            int y1 = this.getY() - 1;
            int x2 = x1 + this.func_230998_h_() + 1;
            int y2 = y1 + this.func_238483_d_() + 1;
            TextBox.func_238467_a_((MatrixStack)mStack, (int)x1, (int)y1, (int)x2, (int)(y1 + 1), (int)red);
            TextBox.func_238467_a_((MatrixStack)mStack, (int)x1, (int)y2, (int)x2, (int)(y2 + 1), (int)red);
            TextBox.func_238467_a_((MatrixStack)mStack, (int)x1, (int)y1, (int)(x1 + 1), (int)y2, (int)red);
            TextBox.func_238467_a_((MatrixStack)mStack, (int)x2, (int)y1, (int)(x2 + 1), (int)y2, (int)red);
        }
    }

    public Integer clamp() {
        if (!this.numeric) {
            return null;
        }
        String text = this.func_146179_b();
        if (this.clampMin != null) {
            if (text == null || text.length() == 0 || text.equals("-")) {
                return null;
            }
            try {
                this.setText(Math.max(this.clampMin, Integer.parseInt(text)));
            }
            catch (Exception e) {
                this.setText(this.clampMin);
            }
            if (this.clampMax != null) {
                try {
                    this.setText(Math.min(this.clampMax, Integer.parseInt(text)));
                }
                catch (Exception e) {
                    this.setText(this.clampMax);
                }
            }
        }
        try {
            return Integer.parseInt(text);
        }
        catch (Exception e) {
            return null;
        }
    }

    public int getX() {
        return this.field_230690_l_;
    }

    public void func_212952_l(int x) {
        this.field_230690_l_ = x;
    }

    public int getY() {
        return this.field_230691_m_;
    }

    public void setY(int y) {
        this.field_230691_m_ = y;
    }

    public int func_230998_h_() {
        return this.field_230688_j_;
    }

    public void func_230991_b_(int w) {
        this.field_230688_j_ = w;
    }

    public int func_238483_d_() {
        return this.field_230689_k_;
    }

    public void setHeight(int h) {
        this.field_230689_k_ = h;
    }

    public int getCenterX() {
        return this.getX() + this.func_230998_h_() / 2;
    }

    public int getMiddleY() {
        return this.getY() + this.func_238483_d_() / 2;
    }

    public int getBottomY() {
        return this.getY() + this.func_238483_d_();
    }

    public int getRightX() {
        return this.getX() + this.func_230998_h_();
    }
}

