/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.command;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.awt.Color;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import journeymap.common.Journeymap;
import journeymap.common.util.PermissionsManager;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.ColorArgument;
import net.minecraft.command.arguments.DimensionArgument;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.command.arguments.ILocationArgument;
import net.minecraft.command.arguments.Vec3Argument;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.server.ServerWorld;

public class CreateWaypoint {
    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        LiteralCommandNode waypoint = dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"waypoint").requires(CreateWaypoint::canUseCommand)).then(Commands.func_197057_a((String)"create").then(Commands.func_197056_a((String)"name", (ArgumentType)StringArgumentType.string()).then(Commands.func_197056_a((String)"dimension", (ArgumentType)DimensionArgument.func_212595_a()).then(Commands.func_197056_a((String)"location", (ArgumentType)Vec3Argument.func_197301_a()).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.func_197056_a((String)"color", (ArgumentType)ColorArgument.func_197063_a()).executes(ctx -> CreateWaypoint.createWaypoint((CommandSource)ctx.getSource(), null, StringArgumentType.getString((CommandContext)ctx, (String)"name"), DimensionArgument.func_212592_a((CommandContext)ctx, (String)"dimension"), Vec3Argument.func_200385_b((CommandContext)ctx, (String)"location"), ColorArgument.func_197064_a((CommandContext)ctx, (String)"color"), false))).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"player", (ArgumentType)EntityArgument.func_197093_b()).executes(ctx -> CreateWaypoint.createWaypoint((CommandSource)ctx.getSource(), EntityArgument.func_197089_d((CommandContext)ctx, (String)"player"), StringArgumentType.getString((CommandContext)ctx, (String)"name"), DimensionArgument.func_212592_a((CommandContext)ctx, (String)"dimension"), Vec3Argument.func_200385_b((CommandContext)ctx, (String)"location"), ColorArgument.func_197064_a((CommandContext)ctx, (String)"color"), false))).then(Commands.func_197056_a((String)"announce", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> CreateWaypoint.createWaypoint((CommandSource)ctx.getSource(), EntityArgument.func_197089_d((CommandContext)ctx, (String)"player"), StringArgumentType.getString((CommandContext)ctx, (String)"name"), DimensionArgument.func_212592_a((CommandContext)ctx, (String)"dimension"), Vec3Argument.func_200385_b((CommandContext)ctx, (String)"location"), ColorArgument.func_197064_a((CommandContext)ctx, (String)"color"), BoolArgumentType.getBool((CommandContext)ctx, (String)"announce")))))).then(Commands.func_197056_a((String)"announce", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> CreateWaypoint.createWaypoint((CommandSource)ctx.getSource(), null, StringArgumentType.getString((CommandContext)ctx, (String)"name"), DimensionArgument.func_212592_a((CommandContext)ctx, (String)"dimension"), Vec3Argument.func_200385_b((CommandContext)ctx, (String)"location"), ColorArgument.func_197064_a((CommandContext)ctx, (String)"color"), BoolArgumentType.getBool((CommandContext)ctx, (String)"announce")))))))))).then(Commands.func_197057_a((String)"delete").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.func_197056_a((String)"name", (ArgumentType)StringArgumentType.string()).executes(ctx -> CreateWaypoint.deleteWaypoint((CommandSource)ctx.getSource(), null, StringArgumentType.getString((CommandContext)ctx, (String)"name"), false))).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"player", (ArgumentType)EntityArgument.func_197093_b()).executes(ctx -> CreateWaypoint.deleteWaypoint((CommandSource)ctx.getSource(), EntityArgument.func_197089_d((CommandContext)ctx, (String)"player"), StringArgumentType.getString((CommandContext)ctx, (String)"name"), false))).then(Commands.func_197056_a((String)"announce", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> CreateWaypoint.deleteWaypoint((CommandSource)ctx.getSource(), EntityArgument.func_197089_d((CommandContext)ctx, (String)"player"), StringArgumentType.getString((CommandContext)ctx, (String)"name"), BoolArgumentType.getBool((CommandContext)ctx, (String)"announce")))))).then(Commands.func_197056_a((String)"announce", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> CreateWaypoint.deleteWaypoint((CommandSource)ctx.getSource(), null, StringArgumentType.getString((CommandContext)ctx, (String)"name"), BoolArgumentType.getBool((CommandContext)ctx, (String)"announce")))))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"wp").requires(CreateWaypoint::canUseCommand)).redirect((CommandNode)waypoint));
    }

    private static boolean canUseCommand(CommandSource ctx) {
        return ctx.func_197034_c(2) || PermissionsManager.getInstance().canServerAdmin((ServerPlayerEntity)ctx.func_197022_f()) || !ctx.func_197028_i().func_71262_S();
    }

    private static int deleteWaypoint(CommandSource source, @Nullable ServerPlayerEntity player, String name, boolean announce) {
        CommandWaypoint wp = new CommandWaypoint(name);
        CreateWaypoint.sendPacket(source, player, wp, "delete", announce);
        return 1;
    }

    private static int createWaypoint(CommandSource source, @Nullable ServerPlayerEntity player, String name, ServerWorld dimension, ILocationArgument location, TextFormatting textFormatting, boolean announce) {
        CommandWaypoint wp = new CommandWaypoint(name, location.func_197280_c(source), new Color(textFormatting.func_211163_e()), dimension.func_234923_W_().func_240901_a_().toString());
        CreateWaypoint.sendPacket(source, player, wp, "create", announce);
        return 1;
    }

    private static void sendPacket(CommandSource source, @Nullable ServerPlayerEntity player, CommandWaypoint wp, String action, boolean announce) {
        if (player == null) {
            for (ServerPlayerEntity p : source.func_197028_i().func_184103_al().func_181057_v()) {
                Journeymap.getInstance().getDispatcher().sendWaypointPacket(p, wp.toString(), announce, action);
            }
        } else {
            Journeymap.getInstance().getDispatcher().sendWaypointPacket(player, wp.toString(), announce, action);
        }
    }

    public static class CommandWaypoint
    implements Serializable {
        public static final Gson GSON = new GsonBuilder().create();
        String id;
        public String name;
        String icon = "waypoint-normal.png";
        boolean enable = true;
        String type = "Normal";
        public String origin = "command";
        int x;
        int y;
        int z;
        int r;
        int g;
        int b;
        boolean persistent = true;
        List<String> dimensions;

        public CommandWaypoint(String name) {
            this.name = name;
        }

        public CommandWaypoint(String name, BlockPos pos, Color color, String dimensions) {
            this.name = name;
            this.x = pos.func_177958_n();
            this.y = pos.func_177956_o();
            this.z = pos.func_177952_p();
            this.r = color.getRed();
            this.g = color.getGreen();
            this.b = color.getBlue();
            this.id = name + "_" + this.x + "," + this.y + "," + this.z;
            this.dimensions = Collections.singletonList(dimensions);
        }

        public String toString() {
            return GSON.toJson((Object)this);
        }

        public static CommandWaypoint fromString(String json) {
            return (CommandWaypoint)GSON.fromJson(json, CommandWaypoint.class);
        }
    }
}

