/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.properties;

import journeymap.common.properties.DefaultDimensionProperties;
import journeymap.common.properties.PermissionProperties;
import journeymap.common.properties.PropertiesManager;
import journeymap.common.properties.catagory.Category;
import journeymap.common.properties.config.BooleanField;

public class DimensionProperties
extends PermissionProperties {
    public final BooleanField enabled = new BooleanField(Category.Inherit, "jm.server.edit.chkbox.enable", false, 1).categoryMaster(true);
    protected final String dimension;

    public DimensionProperties(String dimension) {
        super(String.format("Dimension %s Configuration", dimension), "Overrides the Global Server Configuration for this dimension - sent enable true to override global settings for this dim");
        this.dimension = dimension;
    }

    @Override
    public String getName() {
        return this.dimension;
    }

    public String getDimension() {
        return this.dimension;
    }

    public DimensionProperties build() {
        DefaultDimensionProperties defaultProp = PropertiesManager.getInstance().getDefaultDimensionProperties();
        this.teleportEnabled.set(defaultProp.teleportEnabled.get());
        this.enabled.set(defaultProp.enabled.get());
        this.caveMapping.set(defaultProp.caveMapping.get());
        this.topoMapping.set(defaultProp.topoMapping.get());
        this.surfaceMapping.set(defaultProp.surfaceMapping.get());
        this.radarEnabled.set(defaultProp.radarEnabled.get());
        this.playerRadarEnabled.set(defaultProp.playerRadarEnabled.get());
        this.villagerRadarEnabled.set(defaultProp.villagerRadarEnabled.get());
        this.animalRadarEnabled.set(defaultProp.animalRadarEnabled.get());
        this.mobRadarEnabled.set(defaultProp.mobRadarEnabled.get());
        this.save();
        return this;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        Object clone = super.clone();
        return ((DimensionProperties)clone).fromJsonString(this.toJsonString(false), this.getClass(), false);
    }
}

