/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.blocks.tileentity;

import de.maxhenkel.car.Main;
import de.maxhenkel.car.blocks.BlockCarWorkshopOutter;
import de.maxhenkel.car.blocks.ModBlocks;
import de.maxhenkel.car.blocks.tileentity.TileEntityBase;
import de.maxhenkel.car.corelib.item.ItemUtils;
import de.maxhenkel.car.entity.car.base.EntityCarBase;
import de.maxhenkel.car.entity.car.base.EntityCarDamageBase;
import de.maxhenkel.car.entity.car.base.EntityGenericCar;
import de.maxhenkel.car.entity.car.parts.PartRegistry;
import de.maxhenkel.car.items.ICarPart;
import de.maxhenkel.car.items.ItemKey;
import de.maxhenkel.car.sounds.ModSounds;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.IIntArray;
import net.minecraft.util.IntArray;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.Util;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class TileEntityCarWorkshop
extends TileEntityBase
implements IInventory {
    private Inventory craftingMatrix = new Inventory(15);
    private Inventory repairInventory = new Inventory(3);
    private EntityGenericCar currentCraftingCar;
    private List<ITextComponent> messages = new ArrayList<ITextComponent>();

    public TileEntityCarWorkshop() {
        super(Main.CAR_WORKSHOP_TILE_ENTITY_TYPE);
    }

    public Inventory getRepairInventory() {
        return this.repairInventory;
    }

    public EntityCarBase getCarOnTop() {
        BlockState ownState = this.field_145850_b.func_180495_p(this.field_174879_c);
        if (!ownState.func_177230_c().equals(ModBlocks.CAR_WORKSHOP)) {
            return null;
        }
        BlockPos start = this.field_174879_c.func_177972_a(Direction.UP);
        AxisAlignedBB aabb = new AxisAlignedBB((double)start.func_177958_n(), (double)start.func_177956_o(), (double)start.func_177952_p(), (double)(start.func_177958_n() + 1), (double)(start.func_177956_o() + 1), (double)(start.func_177952_p() + 1));
        List cars = this.field_145850_b.func_217357_a(EntityCarBase.class, aabb);
        if (cars.isEmpty()) {
            return null;
        }
        return (EntityCarBase)((Object)cars.get(0));
    }

    public void spawnCar(PlayerEntity player) {
        if (!this.areBlocksAround()) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent("message.incomplete_structure"), Util.field_240973_b_);
            return;
        }
        if (!this.isTopFree()) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent("message.blocks_on_top"), Util.field_240973_b_);
            return;
        }
        this.updateRecipe();
        EntityGenericCar car = this.currentCraftingCar;
        if (car == null || !this.isCurrentCraftingCarValid()) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent("message.no_reciepe"), Util.field_240973_b_);
            return;
        }
        BlockPos spawnPos = this.field_174879_c.func_177984_a();
        car.func_70107_b((double)spawnPos.func_177958_n() + 0.5, spawnPos.func_177956_o(), (double)spawnPos.func_177952_p() + 0.5);
        this.removeCraftItems();
        car.setFuelAmount(100);
        this.field_145850_b.func_217376_c((Entity)car);
        car.setIsSpawned(true);
        car.initTemperature();
    }

    public void checkValidity() {
        if (this.areBlocksAround()) {
            this.placeStructure();
        }
    }

    private void placeStructure() {
        this.field_145850_b.func_175656_a(this.field_174879_c.func_177982_a(0, 0, -1), this.getState(1));
        this.field_145850_b.func_175656_a(this.field_174879_c.func_177982_a(1, 0, -1), this.getState(2));
        this.field_145850_b.func_175656_a(this.field_174879_c.func_177982_a(1, 0, 0), this.getState(3));
        this.field_145850_b.func_175656_a(this.field_174879_c.func_177982_a(1, 0, 1), this.getState(4));
        this.field_145850_b.func_175656_a(this.field_174879_c.func_177982_a(0, 0, 1), this.getState(5));
        this.field_145850_b.func_175656_a(this.field_174879_c.func_177982_a(-1, 0, 1), this.getState(6));
        this.field_145850_b.func_175656_a(this.field_174879_c.func_177982_a(-1, 0, 0), this.getState(7));
        this.field_145850_b.func_175656_a(this.field_174879_c.func_177982_a(-1, 0, -1), this.getState(8));
        this.setOwnBlockValid(true);
    }

    private void setOwnBlockValid(boolean valid) {
        BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        if (!state.func_177230_c().equals(ModBlocks.CAR_WORKSHOP)) {
            return;
        }
        ModBlocks.CAR_WORKSHOP.setValid(this.field_145850_b, this.field_174879_c, state, valid);
    }

    private BlockState getState(int meta) {
        return (BlockState)ModBlocks.CAR_WORKSHOP_OUTTER.func_176223_P().func_206870_a((Property)BlockCarWorkshopOutter.POSITION, (Comparable)Integer.valueOf(meta));
    }

    public boolean areBlocksAround() {
        if (!this.checkSideBlock(this.field_174879_c.func_177982_a(0, 0, 1))) {
            return false;
        }
        if (!this.checkSideBlock(this.field_174879_c.func_177982_a(1, 0, 0))) {
            return false;
        }
        if (!this.checkSideBlock(this.field_174879_c.func_177982_a(1, 0, 1))) {
            return false;
        }
        if (!this.checkSideBlock(this.field_174879_c.func_177982_a(0, 0, -1))) {
            return false;
        }
        if (!this.checkSideBlock(this.field_174879_c.func_177982_a(-1, 0, 0))) {
            return false;
        }
        if (!this.checkSideBlock(this.field_174879_c.func_177982_a(-1, 0, -1))) {
            return false;
        }
        if (!this.checkSideBlock(this.field_174879_c.func_177982_a(-1, 0, 1))) {
            return false;
        }
        return this.checkSideBlock(this.field_174879_c.func_177982_a(1, 0, -1));
    }

    public boolean isTopFree() {
        for (int x = -1; x <= 1; ++x) {
            for (int y = 1; y <= 2; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    if (this.checkBlockAir(this.field_174879_c.func_177982_a(x, y, z))) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private boolean checkBlockAir(BlockPos p) {
        return this.field_145850_b.func_175623_d(p);
    }

    private boolean checkSideBlock(BlockPos p) {
        return this.field_145850_b.func_180495_p(p).func_177230_c().equals(ModBlocks.CAR_WORKSHOP_OUTTER);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        ItemUtils.saveInventory(compound, "crafting", (IInventory)this.craftingMatrix);
        ItemUtils.saveInventory(compound, "repair", (IInventory)this.repairInventory);
        return super.func_189515_b(compound);
    }

    @Override
    public void func_230337_a_(BlockState blockState, CompoundNBT compound) {
        ItemUtils.readInventory(compound, "crafting", (IInventory)this.craftingMatrix);
        ItemUtils.readInventory(compound, "repair", (IInventory)this.repairInventory);
        super.func_230337_a_(blockState, compound);
    }

    public void updateRecipe() {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (int i = 0; i < this.craftingMatrix.func_70302_i_(); ++i) {
            ItemStack stack = this.craftingMatrix.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            if (stack.func_77973_b() instanceof ICarPart) {
                if (((ICarPart)stack.func_77973_b()).getPart(stack) == null) continue;
                items.add(stack);
                continue;
            }
            this.currentCraftingCar = null;
            this.messages = Arrays.asList(new TranslationTextComponent("message.parts.no_car_part", new Object[]{stack.func_200301_q()}));
            return;
        }
        ArrayList<ITextComponent> messages = new ArrayList<ITextComponent>();
        this.currentCraftingCar = TileEntityCarWorkshop.createCar(this.field_145850_b, items, messages);
        this.messages = messages;
    }

    public static EntityGenericCar createCar(World world, List<ItemStack> partStacks, List<ITextComponent> messages) {
        EntityGenericCar car = new EntityGenericCar(world);
        car.func_70299_a(0, ItemKey.getKeyForCar(car.func_110124_au()));
        car.func_70299_a(1, ItemKey.getKeyForCar(car.func_110124_au()));
        car.setIsSpawned(false);
        for (int i = 0; i < partStacks.size(); ++i) {
            car.getPartInventory().func_70299_a(i, partStacks.get(i).func_77946_l().func_77979_a(1));
        }
        car.initParts();
        boolean showable = PartRegistry.isValid(car, messages);
        if (!showable) {
            return null;
        }
        car.tryInitPartsAndModel();
        car.setPartSerializer();
        return car;
    }

    public static EntityGenericCar createCar(World world, List<ItemStack> partStacks) {
        return TileEntityCarWorkshop.createCar(world, partStacks, new ArrayList<ITextComponent>());
    }

    public void removeCraftItems() {
        for (int i = 0; i < this.craftingMatrix.func_70302_i_(); ++i) {
            ItemStack stack = this.craftingMatrix.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            stack.func_190918_g(1);
        }
    }

    public int func_70302_i_() {
        return this.craftingMatrix.func_70302_i_();
    }

    public ItemStack func_70301_a(int index) {
        return this.craftingMatrix.func_70301_a(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        ItemStack stack = this.craftingMatrix.func_70298_a(index, count);
        this.updateRecipe();
        return stack;
    }

    public ItemStack func_70304_b(int index) {
        ItemStack stack = this.craftingMatrix.func_70304_b(index);
        this.updateRecipe();
        return stack;
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.craftingMatrix.func_70299_a(index, stack);
        this.updateRecipe();
    }

    public int func_70297_j_() {
        return this.craftingMatrix.func_70297_j_();
    }

    public boolean func_70300_a(PlayerEntity player) {
        return this.craftingMatrix.func_70300_a(player);
    }

    public boolean func_191420_l() {
        return this.craftingMatrix.func_191420_l();
    }

    public void func_174889_b(PlayerEntity player) {
        this.craftingMatrix.func_174889_b(player);
    }

    public void func_174886_c(PlayerEntity player) {
        this.craftingMatrix.func_174889_b(player);
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return this.craftingMatrix.func_94041_b(index, stack);
    }

    public void func_174888_l() {
        this.craftingMatrix.func_174888_l();
        this.updateRecipe();
    }

    public EntityGenericCar getCurrentCraftingCar() {
        return this.currentCraftingCar;
    }

    public boolean isCurrentCraftingCarValid() {
        return this.messages.size() <= 0;
    }

    public List<ITextComponent> getMessages() {
        return this.messages;
    }

    public void repairCar(PlayerEntity player) {
        if (!this.areBlocksAround()) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent("message.incomplete_structure"), Util.field_240973_b_);
            return;
        }
        if (!this.areRepairItemsInside()) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent("message.no_repair_items"), Util.field_240973_b_);
            return;
        }
        EntityCarBase carBase = this.getCarOnTop();
        if (!(carBase instanceof EntityCarDamageBase)) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent("message.no_car"), Util.field_240973_b_);
            return;
        }
        EntityCarDamageBase car = (EntityCarDamageBase)carBase;
        if (car.getDamage() <= 0.0f) {
            return;
        }
        this.damageRepairItemsInside(player);
        car.setDamage(car.getDamage() - 10.0f);
        ModSounds.playSound(ModSounds.RATCHET, this.field_145850_b, this.field_174879_c, null, SoundCategory.BLOCKS);
    }

    public boolean areRepairItemsInside() {
        for (int i = 0; i < this.repairInventory.func_70302_i_(); ++i) {
            if (!this.repairInventory.func_70301_a(i).func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public void damageRepairItemsInside(PlayerEntity player) {
        for (int i = 0; i < this.repairInventory.func_70302_i_(); ++i) {
            ItemStack stack = this.repairInventory.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            stack.func_222118_a(10, (LivingEntity)player, playerEntity -> {});
        }
    }

    @Override
    public ITextComponent getTranslatedName() {
        return new TranslationTextComponent(ModBlocks.CAR_WORKSHOP.func_149739_a());
    }

    @Override
    public IIntArray getFields() {
        return new IntArray(0);
    }
}

