/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.blocks.tileentity.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import de.maxhenkel.car.blocks.tileentity.TileEntitySplitTank;
import de.maxhenkel.car.corelib.client.RenderUtils;
import de.maxhenkel.car.fluids.ModFluids;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Atlases;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraftforge.fluids.FluidStack;

public class TileEntitySpecialRendererSplitTank
extends TileEntityRenderer<TileEntitySplitTank> {
    private static final FluidStack BIO_DIESEL_STACK = new FluidStack((Fluid)ModFluids.BIO_DIESEL, 1);
    private static final FluidStack GLYCERIN_STACK = new FluidStack((Fluid)ModFluids.GLYCERIN, 1);

    public TileEntitySpecialRendererSplitTank(TileEntityRendererDispatcher tileEntityRendererDispatcher) {
        super(tileEntityRendererDispatcher);
    }

    public void render(TileEntitySplitTank te, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer buffer, int light, int overlay) {
        matrixStack.func_227860_a_();
        float bioDiesel = te.getBioDieselPerc() / 2.0f;
        float glycerin = te.getGlycerinPerc() / 2.0f;
        if (bioDiesel > 0.0f) {
            this.renderFluid(BIO_DIESEL_STACK, bioDiesel, 0.0625f, matrixStack, buffer, light, overlay);
        }
        if (glycerin > 0.0f) {
            this.renderFluid(GLYCERIN_STACK, glycerin, bioDiesel + 0.0625f, matrixStack, buffer, light, overlay);
        }
        matrixStack.func_227865_b_();
    }

    public void renderFluid(FluidStack fluid, float amount, float yStart, MatrixStack matrixStack, IRenderTypeBuffer buffer, int light, int overlay) {
        matrixStack.func_227860_a_();
        matrixStack.func_227862_a_(0.98f, 0.98f, 0.98f);
        matrixStack.func_227861_a_((double)0.01f, (double)0.01f, (double)0.01f);
        IVertexBuilder builder = buffer.getBuffer(Atlases.func_239280_i_());
        TextureAtlasSprite texture = Minecraft.func_71410_x().func_209506_al().func_229356_a_(PlayerContainer.field_226615_c_).func_195424_a(fluid.getFluid().getAttributes().getStillTexture());
        float uMin = texture.func_94209_e();
        float uMax = texture.func_94212_f();
        float vMin = texture.func_94206_g();
        float vMax = texture.func_94210_h();
        float vHeight = vMax - vMin;
        float s = 0.0f;
        RenderUtils.vertex(builder, matrixStack, 1.0f - s, yStart, 0.0f + s, uMax, vMin, light, overlay);
        RenderUtils.vertex(builder, matrixStack, 0.0f + s, yStart, 0.0f + s, uMin, vMin, light, overlay);
        RenderUtils.vertex(builder, matrixStack, 0.0f + s, yStart + amount - s * 2.0f, 0.0f + s, uMin, vMin + vHeight * amount, light, overlay);
        RenderUtils.vertex(builder, matrixStack, 1.0f - s, yStart + amount - s * 2.0f, 0.0f + s, uMax, vMin + vHeight * amount, light, overlay);
        RenderUtils.vertex(builder, matrixStack, 1.0f - s, yStart, 1.0f - s, uMin, vMin, light, overlay);
        RenderUtils.vertex(builder, matrixStack, 1.0f - s, yStart + amount - s * 2.0f, 1.0f - s, uMin, vMin + vHeight * amount, light, overlay);
        RenderUtils.vertex(builder, matrixStack, 0.0f + s, yStart + amount - s * 2.0f, 1.0f - s, uMax, vMin + vHeight * amount, light, overlay);
        RenderUtils.vertex(builder, matrixStack, 0.0f + s, yStart, 1.0f - s, uMax, vMin, light, overlay);
        RenderUtils.vertex(builder, matrixStack, 1.0f - s, yStart, 0.0f + s, uMin, vMin, light, overlay);
        RenderUtils.vertex(builder, matrixStack, 1.0f - s, yStart + amount - s * 2.0f, 0.0f + s, uMin, vMin + vHeight * amount, light, overlay);
        RenderUtils.vertex(builder, matrixStack, 1.0f - s, yStart + amount - s * 2.0f, 1.0f - s, uMax, vMin + vHeight * amount, light, overlay);
        RenderUtils.vertex(builder, matrixStack, 1.0f - s, yStart, 1.0f - s, uMax, vMin, light, overlay);
        RenderUtils.vertex(builder, matrixStack, 0.0f + s, yStart, 1.0f - s, uMin, vMin, light, overlay);
        RenderUtils.vertex(builder, matrixStack, 0.0f + s, yStart + amount - s * 2.0f, 1.0f - s, uMin, vMin + vHeight * amount, light, overlay);
        RenderUtils.vertex(builder, matrixStack, 0.0f + s, yStart + amount - s * 2.0f, 0.0f + s, uMax, vMin + vHeight * amount, light, overlay);
        RenderUtils.vertex(builder, matrixStack, 0.0f + s, yStart, 0.0f + s, uMax, vMin, light, overlay);
        RenderUtils.vertex(builder, matrixStack, 0.0f + s, yStart + amount - s * 2.0f, 0.0f + s, uMax, vMax, light, overlay);
        RenderUtils.vertex(builder, matrixStack, 0.0f + s, yStart + amount - s * 2.0f, 1.0f - s, uMin, vMax, light, overlay);
        RenderUtils.vertex(builder, matrixStack, 1.0f - s, yStart + amount - s * 2.0f, 1.0f - s, uMin, vMin, light, overlay);
        RenderUtils.vertex(builder, matrixStack, 1.0f - s, yStart + amount - s * 2.0f, 0.0f + s, uMax, vMin, light, overlay);
        matrixStack.func_227865_b_();
    }
}

