/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity;

import com.github.alexthe666.alexsmobs.config.AMConfig;
import com.github.alexthe666.alexsmobs.entity.AMEntityRegistry;
import com.github.alexthe666.alexsmobs.entity.ai.DirectPathNavigator;
import com.github.alexthe666.alexsmobs.entity.ai.EntityAINearestTarget3D;
import com.github.alexthe666.alexsmobs.entity.ai.FlightMoveController;
import com.github.alexthe666.alexsmobs.entity.ai.GroundPathNavigatorWide;
import com.github.alexthe666.alexsmobs.misc.AMSoundRegistry;
import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.animation.AnimationHandler;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import java.util.EnumSet;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.merchant.villager.AbstractVillagerEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class EntityDropBear
extends MonsterEntity
implements IAnimatedEntity {
    public static final Animation ANIMATION_BITE = Animation.create((int)9);
    public static final Animation ANIMATION_SWIPE_R = Animation.create((int)15);
    public static final Animation ANIMATION_SWIPE_L = Animation.create((int)15);
    public static final Animation ANIMATION_JUMPUP = Animation.create((int)20);
    private static final DataParameter<Boolean> UPSIDE_DOWN = EntityDataManager.func_187226_a(EntityDropBear.class, (IDataSerializer)DataSerializers.field_187198_h);
    public float prevUpsideDownProgress;
    public float upsideDownProgress;
    public boolean fallRotation;
    private int animationTick;
    private boolean jumpingUp;
    private Animation currentAnimation;
    private int upwardsFallingTicks;
    private boolean isUpsideDownNavigator;
    private boolean prevOnGround;

    protected EntityDropBear(EntityType type, World world) {
        super(type, world);
        this.fallRotation = this.field_70146_Z.nextBoolean();
        this.jumpingUp = false;
        this.upwardsFallingTicks = 0;
        this.prevOnGround = false;
        this.switchNavigator(true);
    }

    public static AttributeModifierMap.MutableAttribute bakeAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, 22.0).func_233815_a_(Attributes.field_233819_b_, 20.0).func_233815_a_(Attributes.field_233820_c_, (double)0.7f).func_233815_a_(Attributes.field_233823_f_, 2.0).func_233815_a_(Attributes.field_233821_d_, 0.25);
    }

    public static BlockPos getLowestPos(IWorld world, BlockPos pos) {
        while (!world.func_180495_p(pos).func_224755_d((IBlockReader)world, pos, Direction.DOWN) && pos.func_177956_o() < 255) {
            pos = pos.func_177984_a();
        }
        return pos;
    }

    public boolean func_213380_a(IWorld worldIn, SpawnReason spawnReasonIn) {
        return AMEntityRegistry.rollSpawn(AMConfig.dropbearSpawnRolls, this.func_70681_au(), spawnReasonIn);
    }

    protected SoundEvent func_184639_G() {
        return AMSoundRegistry.DROPBEAR_IDLE;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return AMSoundRegistry.DROPBEAR_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return AMSoundRegistry.DROPBEAR_HURT;
    }

    public boolean func_70652_k(Entity entityIn) {
        if (this.getAnimation() == NO_ANIMATION) {
            this.setAnimation(this.field_70146_Z.nextBoolean() ? ANIMATION_BITE : (this.field_70146_Z.nextBoolean() ? ANIMATION_SWIPE_L : ANIMATION_SWIPE_R));
        }
        return true;
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new AIDropMelee());
        this.field_70714_bg.func_75776_a(2, (Goal)new AIUpsideDownWander());
        this.field_70714_bg.func_75776_a(6, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookAtGoal((MobEntity)this, LivingEntity.class, 30.0f));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[]{EntityDropBear.class}));
        this.field_70715_bh.func_75776_a(2, (Goal)new EntityAINearestTarget3D((MobEntity)this, PlayerEntity.class, true){

            @Override
            protected AxisAlignedBB func_188511_a(double targetDistance) {
                AxisAlignedBB bb = this.field_75299_d.func_174813_aQ().func_72314_b(targetDistance, targetDistance, targetDistance);
                return new AxisAlignedBB(bb.field_72340_a, 0.0, bb.field_72339_c, bb.field_72336_d, 256.0, bb.field_72334_f);
            }
        });
        this.field_70715_bh.func_75776_a(2, (Goal)new EntityAINearestTarget3D((MobEntity)this, AbstractVillagerEntity.class, true){

            @Override
            protected AxisAlignedBB func_188511_a(double targetDistance) {
                AxisAlignedBB bb = this.field_75299_d.func_174813_aQ().func_72314_b(targetDistance, targetDistance, targetDistance);
                return new AxisAlignedBB(bb.field_72340_a, 0.0, bb.field_72339_c, bb.field_72336_d, 256.0, bb.field_72334_f);
            }
        });
    }

    public boolean func_180431_b(DamageSource source) {
        return super.func_180431_b(source) || source == DamageSource.field_76379_h || source == DamageSource.field_76368_d;
    }

    protected void func_184231_a(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
        super.func_184231_a(y, onGroundIn, state, pos);
    }

    protected void func_226295_cZ_() {
        this.onLand();
        super.func_226295_cZ_();
    }

    private void switchNavigator(boolean rightsideUp) {
        if (rightsideUp) {
            this.field_70765_h = new MovementController((MobEntity)this);
            this.field_70699_by = new GroundPathNavigatorWide((MobEntity)this, this.field_70170_p);
            this.isUpsideDownNavigator = false;
        } else {
            this.field_70765_h = new FlightMoveController((MobEntity)this, 1.1f, false);
            this.field_70699_by = new DirectPathNavigator((MobEntity)this, this.field_70170_p);
            this.isUpsideDownNavigator = true;
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
        this.prevUpsideDownProgress = this.upsideDownProgress;
        if (this.isUpsideDown() && this.upsideDownProgress < 5.0f) {
            this.upsideDownProgress += 1.0f;
        }
        if (!this.isUpsideDown() && this.upsideDownProgress > 0.0f) {
            this.upsideDownProgress -= 1.0f;
        }
        if (!this.field_70170_p.field_72995_K) {
            BlockPos abovePos = this.getPositionAbove();
            BlockState aboveState = this.field_70170_p.func_180495_p(abovePos);
            BlockState belowState = this.field_70170_p.func_180495_p(this.func_226270_aj_());
            BlockPos worldHeight = this.field_70170_p.func_205770_a(Heightmap.Type.MOTION_BLOCKING, this.func_233580_cy_());
            boolean validAboveState = aboveState.func_224755_d((IBlockReader)this.field_70170_p, abovePos, Direction.DOWN);
            boolean validBelowState = belowState.func_224755_d((IBlockReader)this.field_70170_p, this.func_226270_aj_(), Direction.UP);
            LivingEntity attackTarget = this.func_70638_az();
            if (attackTarget != null && this.func_70032_d((Entity)attackTarget) < attackTarget.func_213311_cf() + this.func_213311_cf() + 1.0f && this.func_70685_l((Entity)attackTarget)) {
                float rot;
                if (this.getAnimation() == ANIMATION_BITE && this.getAnimationTick() == 6) {
                    attackTarget.func_233627_a_(0.5f, (double)MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)))));
                    this.func_70638_az().func_70097_a(DamageSource.func_76358_a((LivingEntity)this), (float)this.func_110148_a(Attributes.field_233823_f_).func_111125_b());
                }
                if (this.getAnimation() == ANIMATION_SWIPE_L && this.getAnimationTick() == 9) {
                    rot = this.field_70177_z + 90.0f;
                    attackTarget.func_233627_a_(0.5f, (double)MathHelper.func_76126_a((float)(rot * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(rot * ((float)Math.PI / 180)))));
                    this.func_70638_az().func_70097_a(DamageSource.func_76358_a((LivingEntity)this), (float)this.func_110148_a(Attributes.field_233823_f_).func_111125_b());
                }
                if (this.getAnimation() == ANIMATION_SWIPE_R && this.getAnimationTick() == 9) {
                    rot = this.field_70177_z - 90.0f;
                    attackTarget.func_233627_a_(0.5f, (double)MathHelper.func_76126_a((float)(rot * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(rot * ((float)Math.PI / 180)))));
                    this.func_70638_az().func_70097_a(DamageSource.func_76358_a((LivingEntity)this), (float)this.func_110148_a(Attributes.field_233823_f_).func_111125_b());
                }
            }
            if ((attackTarget == null || attackTarget != null && !attackTarget.func_70089_S()) && this.field_70146_Z.nextInt(300) == 0 && this.field_70122_E && !this.isUpsideDown() && this.func_226278_cu_() + 2.0 < (double)worldHeight.func_177956_o() && this.getAnimation() == NO_ANIMATION) {
                this.setAnimation(ANIMATION_JUMPUP);
            }
            if (this.jumpingUp && this.func_226278_cu_() > (double)worldHeight.func_177956_o()) {
                this.jumpingUp = false;
            }
            if (this.field_70122_E && this.getAnimation() == ANIMATION_JUMPUP && this.getAnimationTick() > 10 || this.jumpingUp && this.getAnimation() == NO_ANIMATION) {
                this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, 2.0, 0.0));
                this.jumpingUp = true;
            }
            if (this.isUpsideDown()) {
                this.jumpingUp = false;
                this.func_189654_d(!this.field_70122_E);
                float f = 0.91f;
                this.func_213317_d(this.func_213322_ci().func_216372_d((double)f, 1.0, (double)f));
                if (!this.field_70124_G) {
                    if (this.field_70122_E || validBelowState || this.upwardsFallingTicks > 5) {
                        this.setUpsideDown(false);
                        this.upwardsFallingTicks = 0;
                    } else {
                        if (!validAboveState) {
                            ++this.upwardsFallingTicks;
                        }
                        this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, (double)0.2f, 0.0));
                    }
                } else {
                    this.upwardsFallingTicks = 0;
                }
                if (this.field_70123_F) {
                    this.upwardsFallingTicks = 0;
                    this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, (double)-0.3f, 0.0));
                }
                if (this.func_70094_T()) {
                    this.func_70107_b(this.func_226277_ct_(), this.func_226278_cu_() - 1.0, this.func_226281_cx_());
                }
            } else {
                this.func_189654_d(false);
                if (validAboveState) {
                    this.setUpsideDown(true);
                }
            }
            if (this.isUpsideDown() && !this.isUpsideDownNavigator) {
                this.switchNavigator(false);
            }
            if (!this.isUpsideDown() && this.isUpsideDownNavigator) {
                this.switchNavigator(true);
            }
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(UPSIDE_DOWN, (Object)false);
    }

    public boolean isUpsideDown() {
        return (Boolean)this.field_70180_af.func_187225_a(UPSIDE_DOWN);
    }

    public void setUpsideDown(boolean upsideDown) {
        this.field_70180_af.func_187227_b(UPSIDE_DOWN, (Object)upsideDown);
    }

    protected BlockPos getPositionAbove() {
        return new BlockPos(this.func_213303_ch().field_72450_a, this.func_174813_aQ().field_72337_e + 0.5000001, this.func_213303_ch().field_72449_c);
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int i) {
        this.animationTick = i;
    }

    public Animation getAnimation() {
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        this.currentAnimation = animation;
    }

    public Animation[] getAnimations() {
        return new Animation[]{ANIMATION_BITE, ANIMATION_SWIPE_L, ANIMATION_SWIPE_R, ANIMATION_JUMPUP};
    }

    private boolean canSeeBlock(BlockPos destinationBlock) {
        Vector3d Vector3d2 = new Vector3d(this.func_226277_ct_(), this.func_226280_cw_(), this.func_226281_cx_());
        Vector3d blockVec = Vector3d.func_237489_a_((Vector3i)destinationBlock);
        BlockRayTraceResult result = this.field_70170_p.func_217299_a(new RayTraceContext(Vector3d2, blockVec, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)this));
        return result.func_216350_a().equals((Object)destinationBlock);
    }

    private void doInitialPosing(IWorld world) {
        BlockPos upperPos = this.getPositionAbove().func_177984_a();
        BlockPos highest = EntityDropBear.getLowestPos(world, upperPos);
        this.func_70107_b((float)highest.func_177958_n() + 0.5f, highest.func_177956_o(), (float)highest.func_177952_p() + 0.5f);
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        if (reason == SpawnReason.NATURAL) {
            this.doInitialPosing((IWorld)worldIn);
        }
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    private void onLand() {
        if (!this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_72960_a((Entity)this, (byte)39);
            for (Entity entity : this.field_70170_p.func_175647_a(LivingEntity.class, this.func_174813_aQ().func_186662_g(2.5), null)) {
                if (this.func_184191_r(entity) || entity instanceof EntityDropBear || entity == this) continue;
                entity.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), 2.0f + this.field_70146_Z.nextFloat() * 5.0f);
                this.launch(entity, true);
            }
        }
    }

    private void launch(Entity e, boolean huge) {
        if (e.func_233570_aj_()) {
            double d0 = e.func_226277_ct_() - this.func_226277_ct_();
            double d1 = e.func_226281_cx_() - this.func_226281_cx_();
            double d2 = Math.max(d0 * d0 + d1 * d1, 0.001);
            float f = 0.5f;
            e.func_70024_g(d0 / d2 * (double)f, huge ? 0.5 : (double)0.2f, d1 / d2 * (double)f);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 39) {
            this.spawnGroundEffects();
        } else {
            super.func_70103_a(id);
        }
    }

    public void spawnGroundEffects() {
        float radius = 2.3f;
        if (this.field_70170_p.field_72995_K) {
            for (int i1 = 0; i1 < 20 + this.field_70146_Z.nextInt(12); ++i1) {
                double motionX = this.func_70681_au().nextGaussian() * 0.07;
                double motionY = this.func_70681_au().nextGaussian() * 0.07;
                double motionZ = this.func_70681_au().nextGaussian() * 0.07;
                float angle = (float)Math.PI / 180 * this.field_70761_aq + (float)i1;
                double extraX = radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)));
                double extraY = 0.8f;
                double extraZ = radius * MathHelper.func_76134_b((float)angle);
                BlockPos ground = this.getGroundPosition(new BlockPos((double)MathHelper.func_76128_c((double)(this.func_226277_ct_() + extraX)), this.func_226278_cu_(), (double)MathHelper.func_76128_c((double)(this.func_226281_cx_() + extraZ))));
                BlockState BlockState2 = this.field_70170_p.func_180495_p(ground);
                if (BlockState2.func_185904_a() == Material.field_151579_a) continue;
                this.field_70170_p.func_195590_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, BlockState2), true, this.func_226277_ct_() + extraX, (double)ground.func_177956_o() + extraY, this.func_226281_cx_() + extraZ, motionX, motionY, motionZ);
            }
        }
    }

    private BlockPos getGroundPosition(BlockPos in) {
        BlockPos position = new BlockPos((double)in.func_177958_n(), this.func_226278_cu_(), (double)in.func_177952_p());
        while (position.func_177956_o() > 2 && this.field_70170_p.func_175623_d(position) && this.field_70170_p.func_204610_c(position).func_206888_e()) {
            position = position.func_177977_b();
        }
        return position;
    }

    private class AIDropMelee
    extends Goal {
        private boolean prevOnGround = false;

        public AIDropMelee() {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean func_75250_a() {
            return EntityDropBear.this.func_70638_az() != null;
        }

        public void func_75246_d() {
            LivingEntity target = EntityDropBear.this.func_70638_az();
            if (target != null) {
                double dist = EntityDropBear.this.func_70032_d((Entity)target);
                if (EntityDropBear.this.isUpsideDown()) {
                    double d0 = EntityDropBear.this.func_226277_ct_() - target.func_226277_ct_();
                    double d2 = EntityDropBear.this.func_226281_cx_() - target.func_226281_cx_();
                    double xzDistSqr = d0 * d0 + d2 * d2;
                    BlockPos ceilingPos = new BlockPos(target.func_226277_ct_(), EntityDropBear.this.func_226278_cu_() - 3.0 - (double)EntityDropBear.this.field_70146_Z.nextInt(3), target.func_226281_cx_());
                    BlockPos lowestPos = EntityDropBear.getLowestPos((IWorld)EntityDropBear.this.field_70170_p, ceilingPos);
                    EntityDropBear.this.func_70605_aq().func_75642_a((double)((float)lowestPos.func_177958_n() + 0.5f), (double)ceilingPos.func_177956_o(), (double)((float)lowestPos.func_177952_p() + 0.5f), 1.1);
                    if (xzDistSqr < 2.5) {
                        EntityDropBear.this.setUpsideDown(false);
                    }
                } else if (EntityDropBear.this.field_70122_E) {
                    EntityDropBear.this.func_70661_as().func_75497_a((Entity)target, 1.2);
                }
                if (dist < 3.0) {
                    EntityDropBear.this.func_70652_k((Entity)target);
                }
            }
        }
    }

    class AIUpsideDownWander
    extends RandomWalkingGoal {
        public AIUpsideDownWander() {
            super((CreatureEntity)EntityDropBear.this, 1.0, 50);
        }

        @Nullable
        protected Vector3d func_190864_f() {
            if (EntityDropBear.this.isUpsideDown()) {
                for (int i = 0; i < 15; ++i) {
                    Random rand = new Random();
                    BlockPos randPos = EntityDropBear.this.func_233580_cy_().func_177982_a(rand.nextInt(16) - 8, -2, rand.nextInt(16) - 8);
                    BlockPos lowestPos = EntityDropBear.getLowestPos((IWorld)EntityDropBear.this.field_70170_p, randPos);
                    if (!EntityDropBear.this.field_70170_p.func_180495_p(lowestPos).func_224755_d((IBlockReader)EntityDropBear.this.field_70170_p, lowestPos, Direction.DOWN)) continue;
                    return Vector3d.func_237489_a_((Vector3i)lowestPos);
                }
                return null;
            }
            return super.func_190864_f();
        }

        public boolean func_75250_a() {
            return super.func_75250_a();
        }

        public boolean func_75253_b() {
            if (EntityDropBear.this.isUpsideDown()) {
                double d2;
                double d0 = EntityDropBear.this.func_226277_ct_() - this.field_75455_b;
                double d4 = d0 * d0 + (d2 = EntityDropBear.this.func_226281_cx_() - this.field_75453_d) * d2;
                return d4 > 4.0;
            }
            return super.func_75253_b();
        }

        public void func_75251_c() {
            super.func_75251_c();
            this.field_75455_b = 0.0;
            this.field_75456_c = 0.0;
            this.field_75453_d = 0.0;
        }

        public void func_75249_e() {
            if (EntityDropBear.this.isUpsideDown()) {
                this.field_75457_a.func_70605_aq().func_75642_a(this.field_75455_b, this.field_75456_c, this.field_75453_d, this.field_75454_e * (double)0.7f);
            } else {
                this.field_75457_a.func_70661_as().func_75492_a(this.field_75455_b, this.field_75456_c, this.field_75453_d, this.field_75454_e);
            }
        }
    }
}

