/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity;

import com.github.alexthe666.alexsmobs.config.AMConfig;
import com.github.alexthe666.alexsmobs.entity.AMEntityRegistry;
import com.github.alexthe666.alexsmobs.entity.EntityMimicOctopus;
import com.github.alexthe666.alexsmobs.entity.ai.AquaticMoveController;
import com.github.alexthe666.alexsmobs.entity.ai.EntityAINearestTarget3D;
import com.github.alexthe666.alexsmobs.entity.ai.SemiAquaticPathNavigator;
import com.github.alexthe666.alexsmobs.item.AMItemRegistry;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.FindWaterGoal;
import net.minecraft.entity.ai.goal.FollowBoatGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.entity.monster.GuardianEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.SquidEntity;
import net.minecraft.entity.passive.WaterMobEntity;
import net.minecraft.entity.passive.fish.AbstractGroupFishEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biomes;

public class EntityHammerheadShark
extends WaterMobEntity {
    private static final Predicate<LivingEntity> INJURED_PREDICATE = mob -> (double)mob.func_110143_aJ() <= (double)mob.func_110138_aP() / 2.0;

    protected EntityHammerheadShark(EntityType type, World worldIn) {
        super(type, worldIn);
        this.field_70765_h = new AquaticMoveController((CreatureEntity)this, 1.0f);
    }

    public boolean func_213380_a(IWorld worldIn, SpawnReason spawnReasonIn) {
        return AMEntityRegistry.rollSpawn(AMConfig.hammerheadSharkSpawnRolls, this.func_70681_au(), spawnReasonIn);
    }

    protected PathNavigator func_175447_b(World worldIn) {
        return new SemiAquaticPathNavigator((MobEntity)this, worldIn);
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_203816_ay;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_203813_aA;
    }

    public void func_213352_e(Vector3d travelVector) {
        if (this.func_70613_aW() && this.func_70090_H()) {
            this.func_213309_a(this.func_70689_ay(), travelVector);
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
            this.func_213317_d(this.func_213322_ci().func_186678_a(0.9));
            if (this.func_70638_az() == null) {
                this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, -0.005, 0.0));
            }
        } else {
            super.func_213352_e(travelVector);
        }
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new FindWaterGoal((CreatureEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new CirclePreyGoal(this, 1.0f));
        this.field_70714_bg.func_75776_a(4, (Goal)new RandomSwimmingGoal((CreatureEntity)this, (double)0.6f, 7));
        this.field_70714_bg.func_75776_a(4, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(8, (Goal)new FollowBoatGoal((CreatureEntity)this));
        this.field_70714_bg.func_75776_a(9, (Goal)new AvoidEntityGoal((CreatureEntity)this, GuardianEntity.class, 8.0f, 1.0, 1.0));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(2, new EntityAINearestTarget3D<LivingEntity>((MobEntity)this, LivingEntity.class, 50, false, true, INJURED_PREDICATE));
        this.field_70715_bh.func_75776_a(2, new EntityAINearestTarget3D<SquidEntity>((MobEntity)this, SquidEntity.class, 50, false, true, null));
        this.field_70715_bh.func_75776_a(2, new EntityAINearestTarget3D<EntityMimicOctopus>((MobEntity)this, EntityMimicOctopus.class, 80, false, true, null));
        this.field_70715_bh.func_75776_a(3, new EntityAINearestTarget3D<AbstractGroupFishEntity>((MobEntity)this, AbstractGroupFishEntity.class, 70, false, true, null));
    }

    public boolean isTargetBlocked(Vector3d target) {
        Vector3d Vector3d2 = new Vector3d(this.func_226277_ct_(), this.func_226280_cw_(), this.func_226281_cx_());
        return this.field_70170_p.func_217299_a(new RayTraceContext(Vector3d2, target, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)this)).func_216346_c() == RayTraceResult.Type.BLOCK;
    }

    public static AttributeModifierMap.MutableAttribute bakeAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, 30.0).func_233815_a_(Attributes.field_233826_i_, 0.0).func_233815_a_(Attributes.field_233823_f_, 5.0).func_233815_a_(Attributes.field_233821_d_, 0.5);
    }

    public static <T extends MobEntity> boolean canHammerheadSharkSpawn(EntityType<EntityHammerheadShark> p_223364_0_, IWorld p_223364_1_, SpawnReason reason, BlockPos p_223364_3_, Random p_223364_4_) {
        if (p_223364_3_.func_177956_o() > 45 && p_223364_3_.func_177956_o() < p_223364_1_.func_181545_F()) {
            Optional optional = p_223364_1_.func_242406_i(p_223364_3_);
            return (!Objects.equals(optional, Optional.of(Biomes.field_76771_b)) || !Objects.equals(optional, Optional.of(Biomes.field_150575_M))) && p_223364_1_.func_204610_c(p_223364_3_).func_206884_a((ITag)FluidTags.field_206959_a);
        }
        return false;
    }

    private static class CirclePreyGoal
    extends Goal {
        EntityHammerheadShark shark;
        float speed;
        float circlingTime = 0.0f;
        float circleDistance = 5.0f;
        float maxCirclingTime = 80.0f;
        boolean clockwise = false;

        public CirclePreyGoal(EntityHammerheadShark shark, float speed) {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
            this.shark = shark;
            this.speed = speed;
        }

        public boolean func_75250_a() {
            return this.shark.func_70638_az() != null;
        }

        public boolean func_75253_b() {
            return this.shark.func_70638_az() != null;
        }

        public void func_75249_e() {
            this.circlingTime = 0.0f;
            this.maxCirclingTime = 360 + this.shark.field_70146_Z.nextInt(80);
            this.circleDistance = 5.0f + this.shark.field_70146_Z.nextFloat() * 5.0f;
            this.clockwise = this.shark.field_70146_Z.nextBoolean();
        }

        public void func_75251_c() {
            this.circlingTime = 0.0f;
            this.maxCirclingTime = 360 + this.shark.field_70146_Z.nextInt(80);
            this.circleDistance = 5.0f + this.shark.field_70146_Z.nextFloat() * 5.0f;
            this.clockwise = this.shark.field_70146_Z.nextBoolean();
        }

        public void func_75246_d() {
            LivingEntity prey = this.shark.func_70638_az();
            if (prey != null) {
                double dist = this.shark.func_70032_d((Entity)prey);
                if (this.circlingTime >= this.maxCirclingTime) {
                    this.shark.func_70625_a((Entity)prey, 30.0f, 30.0f);
                    this.shark.func_70661_as().func_75497_a((Entity)prey, 1.5);
                    if (dist < 2.0) {
                        this.shark.func_70652_k((Entity)prey);
                        if (this.shark.field_70146_Z.nextFloat() < 0.3f) {
                            this.shark.func_199701_a_(new ItemStack((IItemProvider)AMItemRegistry.SHARK_TOOTH));
                        }
                        this.func_75251_c();
                    }
                } else if (dist <= 25.0) {
                    this.circlingTime += 1.0f;
                    BlockPos circlePos = this.getSharkCirclePos(prey);
                    if (circlePos != null) {
                        this.shark.func_70661_as().func_75492_a((double)circlePos.func_177958_n() + 0.5, (double)circlePos.func_177956_o() + 0.5, (double)circlePos.func_177952_p() + 0.5, 0.6);
                    }
                } else {
                    this.shark.func_70625_a((Entity)prey, 30.0f, 30.0f);
                    this.shark.func_70661_as().func_75497_a((Entity)prey, 0.8);
                }
            }
        }

        public BlockPos getSharkCirclePos(LivingEntity target) {
            float angle = (float)Math.PI / 180 * (this.clockwise ? -this.circlingTime : this.circlingTime);
            double extraX = this.circleDistance * MathHelper.func_76126_a((float)angle);
            double extraZ = this.circleDistance * MathHelper.func_76134_b((float)angle);
            BlockPos ground = new BlockPos(target.func_226277_ct_() + 0.5 + extraX, this.shark.func_226278_cu_(), target.func_226281_cx_() + 0.5 + extraZ);
            if (this.shark.field_70170_p.func_204610_c(ground).func_206884_a((ITag)FluidTags.field_206959_a)) {
                return ground;
            }
            return null;
        }
    }
}

