/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity;

import com.github.alexthe666.alexsmobs.config.AMConfig;
import com.github.alexthe666.alexsmobs.entity.AMEntityRegistry;
import com.github.alexthe666.alexsmobs.entity.EntityOrca;
import com.github.alexthe666.alexsmobs.entity.ai.AnimalAIHurtByTargetNotBaby;
import com.github.alexthe666.alexsmobs.entity.ai.AnimalAIPanicBaby;
import com.github.alexthe666.alexsmobs.entity.ai.AnimalAIWanderRanged;
import com.github.alexthe666.alexsmobs.entity.ai.MooseAIJostle;
import com.github.alexthe666.alexsmobs.item.AMItemRegistry;
import com.github.alexthe666.alexsmobs.misc.AMSoundRegistry;
import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.animation.AnimationHandler;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.FollowParentGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.TemptGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.WolfEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;

public class EntityMoose
extends AnimalEntity
implements IAnimatedEntity {
    public static final Animation ANIMATION_EAT_GRASS = Animation.create((int)30);
    public static final Animation ANIMATION_ATTACK = Animation.create((int)15);
    private static final int DAY = 24000;
    private static final DataParameter<Boolean> ANTLERED = EntityDataManager.func_187226_a(EntityMoose.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> JOSTLING = EntityDataManager.func_187226_a(EntityMoose.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Float> JOSTLE_ANGLE = EntityDataManager.func_187226_a(EntityMoose.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Optional<UUID>> JOSTLER_UUID = EntityDataManager.func_187226_a(EntityMoose.class, (IDataSerializer)DataSerializers.field_187203_m);
    public float prevJostleAngle;
    public float prevJostleProgress;
    public float jostleProgress;
    public boolean jostleDirection;
    public int jostleTimer = 0;
    public boolean instantlyTriggerJostleAI = false;
    public int jostleCooldown = 100 + this.field_70146_Z.nextInt(40);
    public int timeUntilAntlerDrop = 168000 + this.field_70146_Z.nextInt(3) * 24000;
    private int animationTick;
    private Animation currentAnimation;

    protected EntityMoose(EntityType type, World worldIn) {
        super(type, worldIn);
    }

    public static boolean canMooseSpawn(EntityType<? extends MobEntity> typeIn, IServerWorld worldIn, SpawnReason reason, BlockPos pos, Random randomIn) {
        BlockState blockstate = worldIn.func_180495_p(pos.func_177977_b());
        return blockstate.func_203425_a(Blocks.field_196658_i) || blockstate.func_203425_a(Blocks.field_150433_aE) || blockstate.func_203425_a(Blocks.field_196604_cC) && worldIn.func_226659_b_(pos, 0) > 8;
    }

    public static AttributeModifierMap.MutableAttribute bakeAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, 55.0).func_233815_a_(Attributes.field_233823_f_, 7.5).func_233815_a_(Attributes.field_233821_d_, 0.25).func_233815_a_(Attributes.field_233820_c_, 0.5);
    }

    public boolean func_213380_a(IWorld worldIn, SpawnReason spawnReasonIn) {
        return AMEntityRegistry.rollSpawn(AMConfig.mooseSpawnRolls, this.func_70681_au(), spawnReasonIn);
    }

    protected float func_189749_co() {
        return 0.98f;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new MooseAIJostle(this));
        this.field_70714_bg.func_75776_a(3, (Goal)new AnimalAIPanicBaby(this, 1.25));
        this.field_70714_bg.func_75776_a(4, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.1, true));
        this.field_70714_bg.func_75776_a(5, (Goal)new BreedGoal((AnimalEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (Goal)new FollowParentGoal((AnimalEntity)this, 1.1));
        this.field_70714_bg.func_75776_a(7, (Goal)new TemptGoal((CreatureEntity)this, 1.1, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221619_aU}), false));
        this.field_70714_bg.func_75776_a(7, (Goal)new AnimalAIWanderRanged((CreatureEntity)this, 120, 1.0, 14, 7));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 15.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new AnimalAIHurtByTargetNotBaby(this, new Class[0]));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 6) {
            for (int lvt_3_1_ = 0; lvt_3_1_ < 7; ++lvt_3_1_) {
                double lvt_4_1_ = this.field_70146_Z.nextGaussian() * 0.02;
                double lvt_6_1_ = this.field_70146_Z.nextGaussian() * 0.02;
                double lvt_8_1_ = this.field_70146_Z.nextGaussian() * 0.02;
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197601_L, this.func_226282_d_(1.0), this.func_226279_cv_() + 0.5, this.func_226287_g_(1.0), lvt_4_1_, lvt_6_1_, lvt_8_1_);
            }
        } else {
            super.func_70103_a(id);
        }
    }

    public boolean func_70877_b(ItemStack stack) {
        if (stack.func_77973_b() == Items.field_221619_aU && !this.func_70880_s() && this.func_70874_b() == 0) {
            if (this.func_70681_au().nextInt(5) == 0) {
                return true;
            }
            this.field_70170_p.func_72960_a((Entity)this, (byte)6);
            return false;
        }
        return false;
    }

    public void func_70624_b(@Nullable LivingEntity entitylivingbaseIn) {
        if (!this.func_70631_g_()) {
            super.func_70624_b(entitylivingbaseIn);
        }
    }

    public boolean func_70652_k(Entity entityIn) {
        if (this.getAnimation() == NO_ANIMATION) {
            this.setAnimation(ANIMATION_ATTACK);
        }
        return true;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ANTLERED, (Object)true);
        this.field_70180_af.func_187214_a(JOSTLING, (Object)false);
        this.field_70180_af.func_187214_a(JOSTLE_ANGLE, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(JOSTLER_UUID, Optional.empty());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("AntlerTime")) {
            this.timeUntilAntlerDrop = compound.func_74762_e("AntlerTime");
        }
        this.setAntlered(compound.func_74767_n("Antlered"));
        this.jostleCooldown = compound.func_74762_e("JostlingCooldown");
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("AntlerTime", this.timeUntilAntlerDrop);
        compound.func_74757_a("Antlered", this.isAntlered());
        compound.func_74768_a("JostlingCooldown", this.jostleCooldown);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.prevJostleProgress = this.jostleProgress;
        this.prevJostleAngle = this.getJostleAngle();
        if (this.isJostling() && this.jostleProgress < 5.0f) {
            this.jostleProgress += 1.0f;
        }
        if (!this.isJostling() && this.jostleProgress > 0.0f) {
            this.jostleProgress -= 1.0f;
        }
        if (this.jostleCooldown > 0) {
            --this.jostleCooldown;
        }
        if (!(this.field_70170_p.field_72995_K || this.getAnimation() != NO_ANIMATION || this.func_70681_au().nextInt(120) != 0 || this.func_70638_az() != null && this.func_70638_az().func_70089_S() || this.isJostling() || this.getJostlingPartnerUUID() != null || !this.field_70170_p.func_180495_p(this.func_233580_cy_().func_177977_b()).func_203425_a(Blocks.field_196658_i) || this.func_70681_au().nextInt(3) != 0)) {
            this.setAnimation(ANIMATION_EAT_GRASS);
        }
        if (this.timeUntilAntlerDrop > 0) {
            --this.timeUntilAntlerDrop;
        }
        if (this.timeUntilAntlerDrop == 0) {
            if (this.isAntlered()) {
                this.setAntlered(false);
                this.func_199701_a_(new ItemStack((IItemProvider)AMItemRegistry.MOOSE_ANTLER));
                this.timeUntilAntlerDrop = 48000 + this.field_70146_Z.nextInt(3) * 24000;
            } else {
                this.setAntlered(true);
                this.timeUntilAntlerDrop = 168000 + this.field_70146_Z.nextInt(3) * 24000;
            }
        }
        if (this.func_70638_az() != null && this.func_70638_az().func_70089_S()) {
            if (this.isJostling()) {
                this.setJostling(false);
            }
            if (!this.field_70170_p.field_72995_K && this.getAnimation() == ANIMATION_ATTACK && this.getAnimationTick() == 8) {
                float dmg = (float)this.func_110148_a(Attributes.field_233823_f_).func_111125_b();
                if (!this.isAntlered()) {
                    dmg = 3.0f;
                }
                if (this.func_70638_az() instanceof WolfEntity || this.func_70638_az() instanceof EntityOrca) {
                    dmg = 2.0f;
                }
                this.func_70638_az().func_233627_a_(1.0f, this.func_70638_az().func_226277_ct_() - this.func_226277_ct_(), this.func_70638_az().func_226281_cx_() - this.func_226281_cx_());
                this.func_70638_az().func_70097_a(DamageSource.func_76358_a((LivingEntity)this), dmg);
            }
        }
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        Entity entity = source.func_76346_g();
        if (entity instanceof EntityOrca || entity instanceof WolfEntity) {
            amount = (amount + 1.0f) * 3.0f;
        }
        return super.func_70097_a(source, amount);
    }

    protected SoundEvent func_184639_G() {
        return AMSoundRegistry.MOOSE_IDLE;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return AMSoundRegistry.MOOSE_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return AMSoundRegistry.MOOSE_HURT;
    }

    public boolean isAntlered() {
        return (Boolean)this.field_70180_af.func_187225_a(ANTLERED);
    }

    public void setAntlered(boolean anters) {
        this.field_70180_af.func_187227_b(ANTLERED, (Object)anters);
    }

    public boolean isJostling() {
        return (Boolean)this.field_70180_af.func_187225_a(JOSTLING);
    }

    public void setJostling(boolean jostle) {
        this.field_70180_af.func_187227_b(JOSTLING, (Object)jostle);
    }

    public float getJostleAngle() {
        return ((Float)this.field_70180_af.func_187225_a(JOSTLE_ANGLE)).floatValue();
    }

    public void setJostleAngle(float scale) {
        this.field_70180_af.func_187227_b(JOSTLE_ANGLE, (Object)Float.valueOf(scale));
    }

    @Nullable
    public UUID getJostlingPartnerUUID() {
        return ((Optional)this.field_70180_af.func_187225_a(JOSTLER_UUID)).orElse(null);
    }

    public void setJostlingPartnerUUID(@Nullable UUID uniqueId) {
        this.field_70180_af.func_187227_b(JOSTLER_UUID, Optional.ofNullable(uniqueId));
    }

    @Nullable
    public Entity getJostlingPartner() {
        UUID id = this.getJostlingPartnerUUID();
        if (id != null && !this.field_70170_p.field_72995_K) {
            return ((ServerWorld)this.field_70170_p).func_217461_a(id);
        }
        return null;
    }

    public void setJostlingPartner(@Nullable Entity jostlingPartner) {
        if (jostlingPartner == null) {
            this.setJostlingPartnerUUID(null);
        } else {
            this.setJostlingPartnerUUID(jostlingPartner.func_110124_au());
        }
    }

    public void pushBackJostling(EntityMoose entityMoose, float strength) {
        this.applyKnockbackFromMoose(strength, entityMoose.func_226277_ct_() - this.func_226277_ct_(), entityMoose.func_226281_cx_() - this.func_226281_cx_());
    }

    private void applyKnockbackFromMoose(float strength, double ratioX, double ratioZ) {
        LivingKnockBackEvent event = ForgeHooks.onLivingKnockBack((LivingEntity)this, (float)strength, (double)ratioX, (double)ratioZ);
        if (event.isCanceled()) {
            return;
        }
        strength = event.getStrength();
        ratioX = event.getRatioX();
        ratioZ = event.getRatioZ();
        if (!(strength <= 0.0f)) {
            this.field_70160_al = true;
            Vector3d vector3d = this.func_213322_ci();
            Vector3d vector3d1 = new Vector3d(ratioX, 0.0, ratioZ).func_72432_b().func_186678_a((double)strength);
            this.func_213293_j(vector3d.field_72450_a / 2.0 - vector3d1.field_72450_a, 0.3f, vector3d.field_72449_c / 2.0 - vector3d1.field_72449_c);
        }
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int i) {
        this.animationTick = i;
    }

    public Animation getAnimation() {
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        this.currentAnimation = animation;
    }

    public Animation[] getAnimations() {
        return new Animation[]{ANIMATION_ATTACK, ANIMATION_EAT_GRASS};
    }

    @Nullable
    public AgeableEntity func_241840_a(ServerWorld serverWorld, AgeableEntity ageableEntity) {
        return (AgeableEntity)AMEntityRegistry.MOOSE.func_200721_a((World)serverWorld);
    }

    public boolean canJostleWith(EntityMoose moose) {
        return !moose.isJostling() && moose.isAntlered() && moose.getAnimation() == NO_ANIMATION && !moose.func_70631_g_() && moose.getJostlingPartnerUUID() == null && moose.jostleCooldown == 0;
    }

    public void playJostleSound() {
        this.func_184185_a(AMSoundRegistry.MOOSE_JOSTLE, this.func_70647_i(), this.func_70599_aP());
    }
}

