/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.common;

import dan200.computercraft.shared.common.IColouredItem;
import dan200.computercraft.shared.util.ColourTracker;
import dan200.computercraft.shared.util.ColourUtils;
import javax.annotation.Nonnull;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.SpecialRecipe;
import net.minecraft.item.crafting.SpecialRecipeSerializer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public final class ColourableRecipe
extends SpecialRecipe {
    public static final IRecipeSerializer<?> SERIALIZER = new SpecialRecipeSerializer(ColourableRecipe::new);

    private ColourableRecipe(ResourceLocation id) {
        super(id);
    }

    public boolean matches(@Nonnull CraftingInventory inv, @Nonnull World world) {
        boolean hasColourable = false;
        boolean hasDye = false;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            if (stack.func_77973_b() instanceof IColouredItem) {
                if (hasColourable) {
                    return false;
                }
                hasColourable = true;
                continue;
            }
            if (ColourUtils.getStackColour(stack) != null) {
                hasDye = true;
                continue;
            }
            return false;
        }
        return hasColourable && hasDye;
    }

    @Nonnull
    public ItemStack assemble(@Nonnull CraftingInventory inv) {
        ItemStack colourable = ItemStack.field_190927_a;
        ColourTracker tracker = new ColourTracker();
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            if (stack.func_77973_b() instanceof IColouredItem) {
                colourable = stack;
                continue;
            }
            DyeColor dye = ColourUtils.getStackColour(stack);
            if (dye == null) continue;
            tracker.addColour(dye);
        }
        if (colourable.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        ItemStack stack = ((IColouredItem)colourable.func_77973_b()).withColour(colourable, tracker.getColour());
        stack.func_190920_e(1);
        return stack;
    }

    public boolean func_194133_a(int x, int y) {
        return x >= 2 && y >= 2;
    }

    @Nonnull
    public IRecipeSerializer<?> func_199559_b() {
        return SERIALIZER;
    }
}

