/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.computer.inventory;

import dan200.computercraft.ComputerCraft;
import dan200.computercraft.core.filesystem.FileSystem;
import dan200.computercraft.core.filesystem.FileSystemException;
import dan200.computercraft.core.filesystem.FileSystemWrapper;
import dan200.computercraft.shared.computer.core.ClientComputer;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.core.IComputer;
import dan200.computercraft.shared.computer.core.IContainerComputer;
import dan200.computercraft.shared.computer.core.InputState;
import dan200.computercraft.shared.computer.core.ServerComputer;
import dan200.computercraft.shared.computer.upload.FileUpload;
import dan200.computercraft.shared.computer.upload.UploadResult;
import dan200.computercraft.shared.network.NetworkHandler;
import dan200.computercraft.shared.network.client.UploadResultMessage;
import dan200.computercraft.shared.network.container.ComputerContainerData;
import java.io.IOException;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.StringJoiner;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class ContainerComputerBase
extends Container
implements IContainerComputer {
    private static final String LIST_PREFIX = "\n \u2022 ";
    private final Predicate<PlayerEntity> canUse;
    private final IComputer computer;
    private final ComputerFamily family;
    private final InputState input = new InputState(this);
    private List<FileUpload> toUpload;

    protected ContainerComputerBase(ContainerType<? extends ContainerComputerBase> type, int id, Predicate<PlayerEntity> canUse, IComputer computer, ComputerFamily family) {
        super(type, id);
        this.canUse = canUse;
        this.computer = computer;
        this.family = family;
    }

    protected ContainerComputerBase(ContainerType<? extends ContainerComputerBase> type, int id, PlayerInventory player, ComputerContainerData data) {
        this(type, id, x -> true, ContainerComputerBase.getComputer(player, data), data.getFamily());
    }

    protected static IComputer getComputer(PlayerInventory player, ComputerContainerData data) {
        int id = data.getInstanceId();
        if (!player.field_70458_d.field_70170_p.field_72995_K) {
            return ComputerCraft.serverComputerRegistry.get(id);
        }
        ClientComputer computer = (ClientComputer)ComputerCraft.clientComputerRegistry.get(id);
        if (computer == null) {
            computer = new ClientComputer(id);
            ComputerCraft.clientComputerRegistry.add(id, computer);
        }
        return computer;
    }

    public boolean func_75145_c(@Nonnull PlayerEntity player) {
        return this.canUse.test(player);
    }

    @Nonnull
    public ComputerFamily getFamily() {
        return this.family;
    }

    @Override
    @Nullable
    public IComputer getComputer() {
        return this.computer;
    }

    @Override
    @Nonnull
    public InputState getInput() {
        return this.input;
    }

    @Override
    public void upload(@Nonnull ServerPlayerEntity uploader, @Nonnull List<FileUpload> files) {
        UploadResultMessage message = this.upload(files, false);
        NetworkHandler.sendToPlayer((PlayerEntity)uploader, message);
    }

    @Override
    public void continueUpload(@Nonnull ServerPlayerEntity uploader, boolean overwrite) {
        List<FileUpload> files = this.toUpload;
        this.toUpload = null;
        if (files == null || files.isEmpty() || !overwrite) {
            return;
        }
        UploadResultMessage message = this.upload(files, true);
        NetworkHandler.sendToPlayer((PlayerEntity)uploader, message);
    }

    @Nonnull
    private UploadResultMessage upload(@Nonnull List<FileUpload> files, boolean forceOverwrite) {
        ServerComputer computer = (ServerComputer)this.getComputer();
        if (computer == null) {
            return UploadResultMessage.COMPUTER_OFF;
        }
        FileSystem fs = computer.getComputer().getEnvironment().getFileSystem();
        if (fs == null) {
            return UploadResultMessage.COMPUTER_OFF;
        }
        try {
            ArrayList<String> overwrite = new ArrayList<String>();
            for (FileUpload upload : files) {
                if (!fs.exists(upload.getName())) continue;
                if (fs.isDir(upload.getName())) {
                    return new UploadResultMessage(UploadResult.ERROR, (ITextComponent)new TranslationTextComponent("gui.computercraft.upload.failed.overwrite_dir", new Object[]{upload.getName()}));
                }
                overwrite.add(upload.getName());
            }
            if (!overwrite.isEmpty() && !forceOverwrite) {
                StringJoiner joiner = new StringJoiner(LIST_PREFIX, LIST_PREFIX, "");
                for (String value : overwrite) {
                    joiner.add(value);
                }
                this.toUpload = files;
                return new UploadResultMessage(UploadResult.CONFIRM_OVERWRITE, (ITextComponent)new TranslationTextComponent("gui.computercraft.upload.overwrite.detail", new Object[]{joiner.toString()}));
            }
            long availableSpace = fs.getFreeSpace("/");
            long neededSpace = 0L;
            for (FileUpload upload : files) {
                neededSpace += (long)Math.max(512, upload.getBytes().remaining());
            }
            if (neededSpace > availableSpace) {
                return UploadResultMessage.OUT_OF_SPACE;
            }
            for (FileUpload file : files) {
                FileSystemWrapper channel = fs.openForWrite(file.getName(), false, Function.identity());
                Throwable throwable = null;
                try {
                    ((WritableByteChannel)channel.get()).write(file.getBytes());
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (channel == null) continue;
                    if (throwable != null) {
                        try {
                            channel.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    channel.close();
                }
            }
            return new UploadResultMessage(UploadResult.SUCCESS, (ITextComponent)new TranslationTextComponent("gui.computercraft.upload.success.msg", new Object[]{files.size()}));
        }
        catch (FileSystemException | IOException e) {
            ComputerCraft.log.error("Error uploading files", (Throwable)e);
            return new UploadResultMessage(UploadResult.ERROR, (ITextComponent)new TranslationTextComponent("computercraft.gui.upload.failed.generic", new Object[]{e.getMessage()}));
        }
    }

    public void func_75134_a(@Nonnull PlayerEntity player) {
        super.func_75134_a(player);
        this.input.close();
    }
}

