/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.cobalt.lib;

import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.squiddev.cobalt.Constants;
import org.squiddev.cobalt.ErrorFactory;
import org.squiddev.cobalt.LuaError;
import org.squiddev.cobalt.LuaState;
import org.squiddev.cobalt.LuaString;
import org.squiddev.cobalt.LuaTable;
import org.squiddev.cobalt.LuaValue;
import org.squiddev.cobalt.ValueFactory;
import org.squiddev.cobalt.Varargs;
import org.squiddev.cobalt.function.LibFunction;
import org.squiddev.cobalt.function.VarArgFunction;
import org.squiddev.cobalt.lib.LuaLibrary;

public abstract class IoLib
implements LuaLibrary {
    private File infile = null;
    private File outfile = null;
    private File errfile = null;
    private static final LuaValue STDIN = ValueFactory.valueOf("stdin");
    private static final LuaValue STDOUT = ValueFactory.valueOf("stdout");
    private static final LuaValue STDERR = ValueFactory.valueOf("stderr");
    private static final LuaValue FILE = ValueFactory.valueOf("file");
    private static final LuaValue CLOSED_FILE = ValueFactory.valueOf("closed file");
    private static final int IO_CLOSE = 0;
    private static final int IO_FLUSH = 1;
    private static final int IO_INPUT = 2;
    private static final int IO_LINES = 3;
    private static final int IO_OPEN = 4;
    private static final int IO_OUTPUT = 5;
    private static final int IO_POPEN = 6;
    private static final int IO_READ = 7;
    private static final int IO_TMPFILE = 8;
    private static final int IO_TYPE = 9;
    private static final int IO_WRITE = 10;
    private static final int FILE_CLOSE = 11;
    private static final int FILE_FLUSH = 12;
    private static final int FILE_LINES = 13;
    private static final int FILE_READ = 14;
    private static final int FILE_SEEK = 15;
    private static final int FILE_SETVBUF = 16;
    private static final int FILE_WRITE = 17;
    public static final String[] IO_NAMES = new String[]{"close", "flush", "input", "lines", "open", "output", "popen", "read", "tmpfile", "type", "write"};
    public static final String[] FILE_NAMES = new String[]{"close", "flush", "lines", "read", "seek", "setvbuf", "write"};
    private LuaTable filemethods;

    protected abstract File wrapStandardStream(InputStream var1) throws IOException;

    protected abstract File wrapStandardStream(OutputStream var1) throws IOException;

    protected abstract File openFile(String var1, boolean var2, boolean var3, boolean var4, boolean var5) throws IOException;

    protected abstract File tmpFile() throws IOException;

    protected abstract File openProgram(String var1, String var2) throws IOException;

    @Override
    public LuaValue add(LuaState state, LuaTable env) {
        LuaTable t = new LuaTable();
        LibFunction.bind(t, () -> new IoLibV(this), IO_NAMES);
        try {
            t.rawset(STDIN, (LuaValue)this.input(state));
            t.rawset(STDOUT, (LuaValue)this.output(state));
            t.rawset(STDERR, (LuaValue)this.errput(state));
        }
        catch (LuaError e) {
            throw new IllegalStateException(e);
        }
        this.filemethods = new LuaTable();
        LibFunction.bind(this.filemethods, () -> new IoLibV(this), FILE_NAMES, 11);
        this.filemethods.rawset("__index", (LuaValue)this.filemethods);
        env.rawset("io", (LuaValue)t);
        state.loadedPackages.rawset("io", (LuaValue)t);
        return t;
    }

    private File input(LuaState state) throws LuaError {
        return this.infile != null ? this.infile : (this.infile = this.ioopenfile(state, "-", "r"));
    }

    public Varargs _io_flush(LuaState state) throws IOException, LuaError {
        IoLib.checkopen(this.output(state));
        this.outfile.flush();
        return Constants.TRUE;
    }

    public Varargs _io_tmpfile() throws IOException {
        return this.tmpFile();
    }

    public Varargs _io_close(LuaState state, LuaValue file) throws IOException, LuaError {
        File f = file.isNil() ? this.output(state) : IoLib.checkfile(file);
        IoLib.checkopen(f);
        return IoLib.ioclose(f);
    }

    public Varargs _io_input(LuaState state, LuaValue file) throws LuaError {
        if (file.isNil()) {
            return this.input(state);
        }
        this.infile = file.isString() ? this.ioopenfile(state, file.checkString(), "r") : IoLib.checkfile(file);
        return this.infile;
    }

    public Varargs _io_output(LuaState state, LuaValue filename) throws LuaError {
        if (filename.isNil()) {
            return this.output(state);
        }
        this.outfile = filename.isString() ? this.ioopenfile(state, filename.checkString(), "w") : IoLib.checkfile(filename);
        return this.outfile;
    }

    public Varargs _io_type(LuaValue obj) {
        File f = IoLib.optfile(obj);
        return f != null ? (f.isclosed() ? CLOSED_FILE : FILE) : Constants.NIL;
    }

    public Varargs _io_popen(String prog, String mode) throws IOException {
        return this.openProgram(prog, mode);
    }

    public Varargs _io_open(LuaState state, String filename, String mode) throws IOException {
        return this.rawopenfile(state, filename, mode);
    }

    public Varargs _io_lines(LuaState state, String filename) throws LuaError {
        if (filename == null) {
            File file = this.input(state);
            IoLib.checkopen(file);
            return this.lines(file, false);
        }
        File file = this.ioopenfile(state, filename, "r");
        IoLib.checkopen(file);
        return this.lines(file, true);
    }

    public Varargs _io_read(LuaState state, Varargs args) throws IOException, LuaError {
        IoLib.checkopen(this.input(state));
        return this.ioread(this.infile, args);
    }

    public Varargs _io_write(LuaState state, Varargs args) throws IOException, LuaError {
        IoLib.checkopen(this.output(state));
        return IoLib.iowrite(this.outfile, args);
    }

    public Varargs _file_close(LuaValue file) throws IOException, LuaError {
        return IoLib.ioclose(IoLib.checkfile(file));
    }

    public Varargs _file_flush(LuaValue file) throws IOException, LuaError {
        IoLib.checkfile(file).flush();
        return Constants.TRUE;
    }

    public Varargs _file_setvbuf(LuaValue file, String mode, int size) throws LuaError {
        IoLib.checkfile(file).setvbuf(mode, size);
        return Constants.TRUE;
    }

    public Varargs _file_lines(LuaValue file) throws LuaError {
        return this.lines(IoLib.checkfile(file), false);
    }

    public Varargs _file_read(LuaValue file, Varargs subargs) throws IOException, LuaError {
        return this.ioread(IoLib.checkfile(file), subargs);
    }

    public Varargs _file_seek(LuaValue file, String whence, int offset) throws IOException, LuaError {
        return ValueFactory.valueOf(IoLib.checkfile(file).seek(whence, offset));
    }

    public Varargs _file_write(LuaValue file, Varargs subargs) throws IOException, LuaError {
        return IoLib.iowrite(IoLib.checkfile(file), subargs);
    }

    private File output(LuaState state) throws LuaError {
        return this.outfile != null ? this.outfile : (this.outfile = this.ioopenfile(state, "-", "w"));
    }

    private File errput(LuaState state) throws LuaError {
        return this.errfile != null ? this.errfile : (this.errfile = this.ioopenfile(state, "-", "w"));
    }

    private File ioopenfile(LuaState state, String filename, String mode) throws LuaError {
        try {
            return this.rawopenfile(state, filename, mode);
        }
        catch (Exception e) {
            throw new LuaError("io error: " + e.getMessage());
        }
    }

    private static Varargs ioclose(File f) throws IOException {
        if (f.isstdfile()) {
            return IoLib.errorresult("cannot close standard file");
        }
        f.close();
        return IoLib.successresult();
    }

    private static Varargs successresult() {
        return Constants.TRUE;
    }

    private static Varargs errorresult(Exception ioe) {
        String s = ioe.getMessage();
        return IoLib.errorresult("io error: " + (s != null ? s : ioe.toString()));
    }

    private static Varargs errorresult(String errortext) {
        return ValueFactory.varargsOf(Constants.NIL, (LuaValue)ValueFactory.valueOf(errortext), (Varargs)Constants.ZERO);
    }

    private Varargs lines(final File f, final boolean autoClose) {
        return new VarArgFunction(){

            @Override
            public Varargs invoke(LuaState state, Varargs args) throws LuaError {
                IoLib.checkopen(f);
                try {
                    LuaValue result = IoLib.freadline(f);
                    if (autoClose && result == Constants.NIL) {
                        IoLib.ioclose(f);
                    }
                    return result;
                }
                catch (IOException e) {
                    return IoLib.errorresult(e);
                }
            }
        };
    }

    private static Varargs iowrite(File f, Varargs args) throws IOException, LuaError {
        int n = args.count();
        for (int i = 1; i <= n; ++i) {
            f.write(args.arg(i).checkLuaString());
        }
        return Constants.TRUE;
    }

    private Varargs ioread(File f, Varargs args) throws IOException, LuaError {
        int n = args.count();
        if (n == 0) {
            return IoLib.freadline(f);
        }
        LuaValue[] v = new LuaValue[n];
        int i = 0;
        while (i < n) {
            LuaValue vi;
            LuaValue ai = args.arg(i + 1);
            block0 : switch (ai.type()) {
                case 3: {
                    vi = IoLib.freadbytes(f, ai.toInteger());
                    break;
                }
                case 4: {
                    LuaString fmt = ai.checkLuaString();
                    if (fmt.length >= 2 && fmt.bytes[fmt.offset] == 42) {
                        switch (fmt.bytes[fmt.offset + 1]) {
                            case 110: {
                                vi = IoLib.freadnumber(f);
                                break block0;
                            }
                            case 108: {
                                vi = IoLib.freadline(f);
                                break block0;
                            }
                            case 97: {
                                vi = IoLib.freadall(f);
                                break block0;
                            }
                        }
                    }
                }
                default: {
                    throw ErrorFactory.argError(i + 1, "(invalid format)");
                }
            }
            if (!(v[i++] = vi).isNil()) continue;
        }
        return i == 0 ? Constants.NIL : ValueFactory.varargsOf(v, 0, i);
    }

    private static File checkfile(LuaValue val) throws LuaError {
        File f = IoLib.optfile(val);
        if (f == null) {
            throw ErrorFactory.argError(1, "file");
        }
        IoLib.checkopen(f);
        return f;
    }

    private static File optfile(LuaValue val) {
        return val instanceof File ? (File)val : null;
    }

    private static File checkopen(File file) throws LuaError {
        if (file.isclosed()) {
            throw new LuaError("attempt to use a closed file");
        }
        return file;
    }

    private File rawopenfile(LuaState state, String filename, String mode) throws IOException {
        boolean isstdfile = "-".equals(filename);
        boolean isreadmode = mode.startsWith("r");
        if (isstdfile) {
            return isreadmode ? this.wrapStandardStream(state.stdin) : this.wrapStandardStream(state.stdout);
        }
        boolean isappend = mode.startsWith("a");
        boolean isupdate = mode.indexOf("+") > 0;
        boolean isbinary = mode.endsWith("b");
        return this.openFile(filename, isreadmode, isappend, isupdate, isbinary);
    }

    public static LuaValue freadbytes(File f, int count) throws IOException {
        byte[] b = new byte[count];
        int r = f.read(b, 0, b.length);
        if (r < 0) {
            return Constants.NIL;
        }
        return LuaString.valueOf(b, 0, r);
    }

    public static LuaValue freaduntil(File f, boolean lineonly) throws IOException {
        int c;
        ByteArrayOutputStream baos;
        block9: {
            baos = new ByteArrayOutputStream();
            try {
                if (lineonly) {
                    while ((c = f.read()) >= 0) {
                        switch (c) {
                            case 13: {
                                break;
                            }
                            case 10: {
                                break block9;
                            }
                            default: {
                                baos.write(c);
                                break;
                            }
                        }
                    }
                    break block9;
                }
                while ((c = f.read()) >= 0) {
                    baos.write(c);
                }
            }
            catch (EOFException e) {
                c = -1;
            }
        }
        return c < 0 && baos.size() == 0 ? Constants.NIL : LuaString.valueOf(baos.toByteArray());
    }

    public static LuaValue freadline(File f) throws IOException {
        return IoLib.freaduntil(f, true);
    }

    public static LuaValue freadall(File f) throws IOException {
        int n = f.remaining();
        if (n >= 0) {
            return IoLib.freadbytes(f, n);
        }
        return IoLib.freaduntil(f, false);
    }

    public static LuaValue freadnumber(File f) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        IoLib.freadchars(f, " \t\r\n", null);
        IoLib.freadchars(f, "-+", baos);
        IoLib.freadchars(f, "0123456789", baos);
        IoLib.freadchars(f, ".", baos);
        IoLib.freadchars(f, "0123456789", baos);
        IoLib.freadchars(f, "eEfFgG", baos);
        IoLib.freadchars(f, "+-", baos);
        IoLib.freadchars(f, "0123456789", baos);
        String s = baos.toString();
        return s.length() > 0 ? ValueFactory.valueOf(Double.parseDouble(s)) : Constants.NIL;
    }

    private static void freadchars(File f, String chars, ByteArrayOutputStream baos) throws IOException {
        int c;
        while (chars.indexOf(c = f.peek()) >= 0) {
            f.read();
            if (baos == null) continue;
            baos.write(c);
        }
        return;
    }

    private static final class IoLibV
    extends VarArgFunction {
        private final IoLib iolib;

        public IoLibV(IoLib iolib) {
            this.iolib = iolib;
        }

        @Override
        public Varargs invoke(LuaState state, Varargs args) throws LuaError {
            try {
                switch (this.opcode) {
                    case 1: {
                        return this.iolib._io_flush(state);
                    }
                    case 8: {
                        return this.iolib._io_tmpfile();
                    }
                    case 0: {
                        return this.iolib._io_close(state, args.first());
                    }
                    case 2: {
                        return this.iolib._io_input(state, args.first());
                    }
                    case 5: {
                        return this.iolib._io_output(state, args.first());
                    }
                    case 9: {
                        return this.iolib._io_type(args.first());
                    }
                    case 6: {
                        return this.iolib._io_popen(args.arg(1).checkString(), args.arg(2).optString("r"));
                    }
                    case 4: {
                        return this.iolib._io_open(state, args.arg(1).checkString(), args.arg(2).optString("r"));
                    }
                    case 3: {
                        return this.iolib._io_lines(state, args.exists(1) ? args.arg(1).checkString() : null);
                    }
                    case 7: {
                        return this.iolib._io_read(state, args);
                    }
                    case 10: {
                        return this.iolib._io_write(state, args);
                    }
                    case 11: {
                        return this.iolib._file_close(args.first());
                    }
                    case 12: {
                        return this.iolib._file_flush(args.first());
                    }
                    case 16: {
                        return this.iolib._file_setvbuf(args.first(), args.arg(2).checkString(), args.arg(3).optInteger(1024));
                    }
                    case 13: {
                        return this.iolib._file_lines(args.first());
                    }
                    case 14: {
                        return this.iolib._file_read(args.first(), args.subargs(2));
                    }
                    case 15: {
                        return this.iolib._file_seek(args.first(), args.arg(2).optString("cur"), args.arg(3).optInteger(0));
                    }
                    case 17: {
                        return this.iolib._file_write(args.first(), args.subargs(2));
                    }
                }
            }
            catch (IOException ioe) {
                return IoLib.errorresult(ioe);
            }
            return Constants.NONE;
        }
    }

    protected abstract class File
    extends LuaValue {
        private LuaTable metatable;

        protected File() {
            super(7);
            this.metatable = IoLib.this.filemethods;
        }

        public abstract void write(LuaString var1) throws IOException;

        public abstract void flush() throws IOException;

        public abstract boolean isstdfile();

        public abstract void close() throws IOException;

        public abstract boolean isclosed();

        public abstract int seek(String var1, int var2) throws IOException;

        public abstract void setvbuf(String var1, int var2);

        public abstract int remaining() throws IOException;

        public abstract int peek() throws IOException;

        public abstract int read() throws IOException;

        public abstract int read(byte[] var1, int var2, int var3) throws IOException;

        @Override
        public LuaTable getMetatable(LuaState state) {
            return this.metatable;
        }

        @Override
        public void setMetatable(LuaState state, LuaTable metatable) {
            this.metatable = metatable;
        }

        @Override
        public String toString() {
            return "file (" + (this.isclosed() ? "closed" : Integer.toHexString(this.hashCode())) + ")";
        }
    }
}

