/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.network.message;

import com.mrcrayfish.furniture.common.mail.PostOffice;
import com.mrcrayfish.furniture.network.message.IMessage;
import com.mrcrayfish.furniture.tileentity.MailBoxTileEntity;
import com.mrcrayfish.furniture.util.TileEntityUtil;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkHooks;

public class MessageSetMailBoxName
implements IMessage<MessageSetMailBoxName> {
    private String name;
    private BlockPos pos;

    public MessageSetMailBoxName() {
    }

    public MessageSetMailBoxName(String name, BlockPos pos) {
        this.name = name;
        this.pos = pos;
    }

    @Override
    public void encode(MessageSetMailBoxName message, PacketBuffer buffer) {
        buffer.func_211400_a(message.name, 32);
        buffer.func_179255_a(message.pos);
    }

    @Override
    public MessageSetMailBoxName decode(PacketBuffer buffer) {
        return new MessageSetMailBoxName(buffer.func_150789_c(32), buffer.func_179259_c());
    }

    @Override
    public void handle(MessageSetMailBoxName message, Supplier<NetworkEvent.Context> supplier) {
        supplier.get().enqueueWork(() -> {
            ServerPlayerEntity entity = ((NetworkEvent.Context)supplier.get()).getSender();
            if (entity == null) {
                return;
            }
            if (!entity.field_70170_p.isAreaLoaded(message.pos, 0)) {
                return;
            }
            TileEntity tileEntity = entity.field_70170_p.func_175625_s(message.pos);
            if (tileEntity instanceof MailBoxTileEntity) {
                MailBoxTileEntity mailBox = (MailBoxTileEntity)tileEntity;
                if (!entity.func_110124_au().equals(mailBox.getOwnerId())) {
                    return;
                }
                if (!((MailBoxTileEntity)tileEntity).func_70300_a((PlayerEntity)entity)) {
                    return;
                }
                if (!PostOffice.setMailBoxName(entity.func_110124_au(), mailBox.getId(), message.name)) {
                    return;
                }
                TileEntityUtil.sendUpdatePacket(tileEntity);
                NetworkHooks.openGui((ServerPlayerEntity)entity, (INamedContainerProvider)((INamedContainerProvider)tileEntity), (BlockPos)message.pos);
            }
        });
        supplier.get().setPacketHandled(true);
    }
}

