/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.betteranimalsplus.imdlib.entity.interfaces;

import dev.itsmeow.betteranimalsplus.imdlib.entity.interfaces.IContainerEntity;
import dev.itsmeow.betteranimalsplus.imdlib.entity.util.variant.IVariant;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IWorld;

public interface IVariantTypes<T extends MobEntity>
extends IContainerEntity<T> {
    default public void registerTypeKey() {
        this.getImplementation().func_184212_Q().func_187214_a(this.getContainer().getVariantDataKey(), (Object)"");
    }

    default public String getVariantString() {
        return (String)this.getImplementation().func_184212_Q().func_187225_a(this.getContainer().getVariantDataKey());
    }

    default public IVariantTypes<T> setType(String variantKey) {
        if (this.getContainer().getVariantForName(variantKey) == null) {
            variantKey = this.getRandomType().getName();
        }
        this.getImplementation().func_184212_Q().func_187227_b(this.getContainer().getVariantDataKey(), (Object)variantKey);
        return this;
    }

    default public IVariantTypes<T> setType(IVariant variant) {
        this.getImplementation().func_184212_Q().func_187227_b(this.getContainer().getVariantDataKey(), (Object)variant.getName());
        return this;
    }

    default public void writeType(CompoundNBT compound) {
        compound.func_74778_a("VariantId", this.getVariantNameOrEmpty());
    }

    default public void readType(CompoundNBT compound) {
        this.setType(compound.func_74779_i("VariantId"));
    }

    default public IVariant getOffspringType(IVariantTypes<?> parent1, IVariantTypes<?> parent2) {
        if (parent1 == null || parent2 == null) {
            if (parent1 == null && parent2 != null) {
                return parent2.getVariant().orElseGet(this::getRandomType);
            }
            if (parent1 != null) {
                return parent1.getVariant().orElseGet(this::getRandomType);
            }
            return this.getRandomType();
        }
        return this.getImplementation().func_70681_au().nextBoolean() ? parent1.getVariant().orElseGet(() -> parent2.getVariant().orElseGet(this::getRandomType)) : parent2.getVariant().orElseGet(() -> parent1.getVariant().orElseGet(this::getRandomType));
    }

    default public IVariant getRandomType() {
        return (IVariant)this.getContainer().getVariants().get(this.getImplementation().func_70681_au().nextInt(this.getContainer().getVariantMax()));
    }

    @Nullable
    default public ILivingEntityData initData(IWorld world, SpawnReason reason, ILivingEntityData livingdata) {
        return this.dataFromVariant(this.getRandomType(), livingdata);
    }

    @Nullable
    default public ILivingEntityData initAgeableData(IWorld world, SpawnReason reason, ILivingEntityData livingdata) {
        return this.ageableDataFromVariant(this.getRandomType(), livingdata);
    }

    default public Optional<IVariant> getVariant() {
        return Optional.ofNullable(this.getContainer().getVariantForName(this.getVariantString()));
    }

    @Nullable
    default public ResourceLocation getVariantTextureOrNull() {
        return this.getVariant().map(v -> v.getTexture((Entity)this.getImplementation())).orElse(null);
    }

    default public String getVariantNameOrEmpty() {
        Optional<IVariant> variant = this.getVariant();
        return variant.isPresent() ? variant.get().getName() : "";
    }

    default public ILivingEntityData ageableDataFromVariant(IVariant variant, ILivingEntityData livingdata) {
        if (livingdata instanceof AgeableTypeData) {
            variant = ((AgeableTypeData)((Object)livingdata)).typeData;
        } else {
            livingdata = livingdata instanceof AgeableEntity.AgeableData ? new AgeableTypeData((AgeableEntity.AgeableData)livingdata, variant) : new AgeableTypeData(variant);
        }
        this.setType(variant);
        return livingdata;
    }

    default public ILivingEntityData dataFromVariant(IVariant variant, ILivingEntityData livingdata) {
        if (livingdata instanceof TypeData) {
            variant = ((TypeData)livingdata).typeData;
        } else {
            livingdata = new TypeData(variant);
        }
        this.setType(variant);
        return livingdata;
    }

    public static class AgeableTypeData
    extends AgeableEntity.AgeableData {
        public IVariant typeData;
        private int indexInGroup = 0;
        private boolean canBabySpawn = true;
        private float babySpawnProbability = 0.05f;

        public AgeableTypeData(IVariant type) {
            super(false);
            this.typeData = type;
        }

        public AgeableTypeData(AgeableEntity.AgeableData data, IVariant type) {
            super(false);
            this.typeData = type;
            this.indexInGroup = data.func_226257_a_();
            this.canBabySpawn = data.func_226261_c_();
            this.babySpawnProbability = data.func_226262_d_();
        }

        public int func_226257_a_() {
            return this.indexInGroup;
        }

        public void func_226260_b_() {
            ++this.indexInGroup;
        }

        public boolean func_226261_c_() {
            return this.canBabySpawn;
        }

        public float func_226262_d_() {
            return this.babySpawnProbability;
        }
    }

    public static class TypeData
    implements ILivingEntityData {
        public IVariant typeData;

        public TypeData(IVariant type) {
            this.typeData = type;
        }
    }
}

