/*
 * Decompiled with CFR 0.152.
 */
package its_meow.betteranimalsplus.common.entity;

import dev.itsmeow.betteranimalsplus.imdlib.entity.util.variant.EntityVariant;
import dev.itsmeow.betteranimalsplus.imdlib.entity.util.variant.IVariant;
import its_meow.betteranimalsplus.common.entity.EntityGoat;
import its_meow.betteranimalsplus.common.entity.ai.HungerNearestAttackableTargetGoal;
import its_meow.betteranimalsplus.common.entity.ai.HungerNonTamedTargetGoal;
import its_meow.betteranimalsplus.common.entity.util.EntityTypeContainerBAPTameable;
import its_meow.betteranimalsplus.common.entity.util.EntityUtil;
import its_meow.betteranimalsplus.common.entity.util.IDropHead;
import its_meow.betteranimalsplus.common.entity.util.IHaveHunger;
import its_meow.betteranimalsplus.common.entity.util.abstracts.EntityTameableBetterAnimalsPlus;
import its_meow.betteranimalsplus.common.entity.util.abstracts.EntityTameableWithSelectiveTypes;
import its_meow.betteranimalsplus.init.ModEntities;
import its_meow.betteranimalsplus.init.ModItems;
import its_meow.betteranimalsplus.init.ModResources;
import java.util.Set;
import net.minecraft.block.BlockState;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NonTamedTargetGoal;
import net.minecraft.entity.ai.goal.OwnerHurtByTargetGoal;
import net.minecraft.entity.ai.goal.OwnerHurtTargetGoal;
import net.minecraft.entity.ai.goal.SitGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.monster.AbstractIllagerEntity;
import net.minecraft.entity.monster.AbstractSkeletonEntity;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.monster.GhastEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.ChickenEntity;
import net.minecraft.entity.passive.RabbitEntity;
import net.minecraft.entity.passive.SheepEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Food;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.event.ForgeEventFactory;

public class EntityFeralWolf
extends EntityTameableWithSelectiveTypes
implements IDropHead<EntityTameableBetterAnimalsPlus>,
IHaveHunger<EntityTameableBetterAnimalsPlus> {
    public static final double TAMED_HEALTH = 30.0;
    public static final double UNTAMED_HEALTH = 10.0;
    protected static final DataParameter<Float> DATA_HEALTH_ID = EntityDataManager.func_187226_a(EntityFeralWolf.class, (IDataSerializer)DataSerializers.field_187193_c);
    private int hunger;

    public EntityFeralWolf(EntityType<? extends EntityFeralWolf> entityType, World worldIn) {
        super((EntityType<? extends EntityTameableWithSelectiveTypes>)entityType, worldIn);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new SitGoal((TameableEntity)this));
        this.field_70714_bg.func_75776_a(3, (Goal)new BreedGoal((AnimalEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(4, (Goal)new LeapAtTargetGoal((MobEntity)this, 0.4f));
        this.field_70714_bg.func_75776_a(5, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.0, true));
        this.field_70714_bg.func_75776_a(6, (Goal)new FollowOwnerGoal((TameableEntity)this, 1.0, 10.0f, 2.0f, false));
        this.field_70714_bg.func_75776_a(8, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(10, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70715_bh.func_75776_a(1, (Goal)new OwnerHurtByTargetGoal((TameableEntity)this));
        this.field_70715_bh.func_75776_a(2, (Goal)new OwnerHurtTargetGoal((TameableEntity)this));
        this.field_70715_bh.func_75776_a(3, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(4, (Goal)new NonTamedTargetGoal((TameableEntity)this, PlayerEntity.class, false, e -> e.field_70170_p.func_175659_aa() != Difficulty.PEACEFUL));
        this.field_70715_bh.func_75776_a(4, new HungerNonTamedTargetGoal<AnimalEntity, EntityFeralWolf>(this, AnimalEntity.class, false, e -> e instanceof SheepEntity || e instanceof RabbitEntity));
        this.field_70715_bh.func_75776_a(4, new HungerNonTamedTargetGoal<VillagerEntity, EntityFeralWolf>(this, VillagerEntity.class, false, e -> true));
        this.field_70715_bh.func_75776_a(4, new HungerNonTamedTargetGoal<AbstractIllagerEntity, EntityFeralWolf>(this, AbstractIllagerEntity.class, false, e -> true));
        this.field_70715_bh.func_75776_a(4, new HungerNonTamedTargetGoal<ChickenEntity, EntityFeralWolf>(this, ChickenEntity.class, false, e -> true));
        this.field_70715_bh.func_75776_a(4, new HungerNonTamedTargetGoal<EntityGoat, EntityFeralWolf>(this, EntityGoat.class, false, e -> true));
        this.field_70715_bh.func_75776_a(5, new HungerNearestAttackableTargetGoal<AbstractSkeletonEntity, EntityFeralWolf>(this, AbstractSkeletonEntity.class, false));
    }

    @Override
    public int getHunger() {
        return this.hunger;
    }

    @Override
    public void setHunger(int hunger) {
        this.hunger = hunger;
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        this.writeHunger(compound);
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.readHunger(compound);
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        this.doHeadDrop();
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        this.field_70180_af.func_187227_b(DATA_HEALTH_ID, (Object)Float.valueOf(this.func_110143_aJ()));
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DATA_HEALTH_ID, (Object)Float.valueOf(this.func_110143_aJ()));
    }

    protected void func_180429_a(BlockPos pos, BlockState blockStateIn) {
        this.func_184185_a(SoundEvents.field_187869_gK, 0.15f, 1.0f);
    }

    protected SoundEvent func_184639_G() {
        if (!this.func_70909_n() || this.func_70638_az() != null) {
            return SoundEvents.field_187861_gG;
        }
        if (this.field_70146_Z.nextInt(3) == 0) {
            return this.func_70909_n() && (double)((Float)this.field_70180_af.func_187225_a(DATA_HEALTH_ID)).floatValue() < 15.0 ? SoundEvents.field_187871_gL : SoundEvents.field_187865_gI;
        }
        return SoundEvents.field_187857_gE;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187863_gH;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187859_gF;
    }

    protected float func_70599_aP() {
        return 0.4f;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70173_aa % 20 == 0) {
            this.incrementHunger();
        }
    }

    public int func_70646_bf() {
        return this.func_233684_eK_() ? 20 : super.func_70646_bf();
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        Entity entity = source.func_76346_g();
        if (this.func_233684_eK_()) {
            this.func_233687_w_(false);
        }
        if (entity != null && !(entity instanceof PlayerEntity) && !(entity instanceof AbstractArrowEntity)) {
            amount = (amount + 1.0f) / 2.0f;
        }
        return super.func_70097_a(source, amount);
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean flag = entityIn.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), (float)((int)this.func_110148_a(Attributes.field_233823_f_).func_111126_e()));
        if (flag) {
            this.func_174815_a((LivingEntity)this, entityIn);
        }
        return flag;
    }

    public void func_70903_f(boolean tamed) {
        super.func_70903_f(tamed);
        if (tamed) {
            this.func_110148_a(Attributes.field_233818_a_).func_111128_a(30.0);
        } else {
            this.func_110148_a(Attributes.field_233818_a_).func_111128_a(10.0);
        }
    }

    public ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        if (this.func_70909_n()) {
            Food food;
            if (!itemstack.func_190926_b() && itemstack.func_77973_b().func_219971_r() && (food = itemstack.func_77973_b().func_219967_s()).func_221467_c() && (double)((Float)this.field_70180_af.func_187225_a(DATA_HEALTH_ID)).floatValue() < 30.0) {
                if (!player.func_184812_l_()) {
                    itemstack.func_190918_g(1);
                }
                this.func_70691_i(food.func_221466_a());
                return ActionResultType.SUCCESS;
            }
            if (!(!this.func_152114_e((LivingEntity)player) || this.field_70170_p.field_72995_K || this.func_70877_b(itemstack) || itemstack.func_77973_b().func_219971_r() && itemstack.func_77973_b().func_219967_s().func_221467_c())) {
                this.func_233687_w_(!this.func_233684_eK_());
                this.field_70703_bu = false;
                this.field_70699_by.func_75499_g();
                this.func_70624_b(null);
            }
        } else if (this.isTamingItem(itemstack.func_77973_b())) {
            ItemStack stack = player.func_184582_a(EquipmentSlotType.HEAD);
            if (stack.func_77973_b().func_206844_a(ModResources.Tags.Items.FERAL_WOLF_TAME_ARMOR)) {
                if (!player.func_184812_l_()) {
                    itemstack.func_190918_g(1);
                }
                if (!this.field_70170_p.field_72995_K) {
                    if (this.field_70146_Z.nextInt(100) <= 14 && !ForgeEventFactory.onAnimalTame((AnimalEntity)this, (PlayerEntity)player)) {
                        this.func_193101_c(player);
                        this.field_70699_by.func_75499_g();
                        this.func_70624_b(null);
                        this.func_233687_w_(true);
                        this.func_70606_j(30.0f);
                        this.field_70170_p.func_72960_a((Entity)this, (byte)7);
                    } else {
                        this.field_70170_p.func_72960_a((Entity)this, (byte)6);
                    }
                }
                return ActionResultType.SUCCESS;
            }
            if (!this.field_70170_p.field_72995_K) {
                player.func_145747_a((ITextComponent)new TranslationTextComponent("entity.betteranimalsplus.feralwolf.message.wear_head"), Util.field_240973_b_);
            }
        }
        return super.func_230254_b_(player, hand);
    }

    public boolean func_213743_em() {
        return this.func_70909_n() && super.func_213743_em();
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getTailRotation() {
        if (!this.func_70909_n()) {
            return -0.15f;
        }
        return this.func_70909_n() ? 0.25f - (this.func_110138_aP() - ((Float)this.field_70180_af.func_187225_a(DATA_HEALTH_ID)).floatValue()) * 0.04f : -0.85f;
    }

    public boolean func_70877_b(ItemStack stack) {
        return stack.func_77973_b() == ModItems.ANTLER.get();
    }

    public int func_70641_bl() {
        return 8;
    }

    public boolean func_142018_a(LivingEntity target, LivingEntity owner) {
        if (!(target instanceof CreeperEntity) && !(target instanceof GhastEntity)) {
            EntityFeralWolf entityferalwolf;
            if (target instanceof EntityFeralWolf && (entityferalwolf = (EntityFeralWolf)target).func_70909_n() && entityferalwolf.func_70902_q() == owner) {
                return false;
            }
            if (target instanceof PlayerEntity && owner instanceof PlayerEntity && !((PlayerEntity)owner).func_96122_a((PlayerEntity)target)) {
                return false;
            }
            return !(target instanceof AbstractHorseEntity) || !((AbstractHorseEntity)target).func_110248_bS();
        }
        return false;
    }

    public boolean func_184652_a(PlayerEntity player) {
        return this.func_70909_n() && super.func_184652_a(player);
    }

    @Override
    protected EntityFeralWolf getBaseChild() {
        EntityFeralWolf wolf = (EntityFeralWolf)this.getContainer().getEntityType().func_200721_a(this.field_70170_p);
        if (this.func_70909_n()) {
            wolf.func_70903_f(true);
            wolf.func_184754_b(this.func_184753_b());
        }
        return wolf;
    }

    @Override
    public String[] getTypesFor(RegistryKey<Biome> biomeKey, Biome biome, Set<BiomeDictionary.Type> types, SpawnReason reason) {
        if (types.contains(BiomeDictionary.Type.FOREST) && !types.contains(BiomeDictionary.Type.CONIFEROUS)) {
            return new String[]{"timber", "red"};
        }
        if (types.contains(BiomeDictionary.Type.CONIFEROUS) && !types.contains(BiomeDictionary.Type.SNOWY)) {
            return new String[]{"black", "timber", "red"};
        }
        if (types.contains(BiomeDictionary.Type.CONIFEROUS) && types.contains(BiomeDictionary.Type.SNOWY)) {
            return new String[]{"snowy", "timber"};
        }
        if (types.contains(BiomeDictionary.Type.SNOWY) && !types.contains(BiomeDictionary.Type.FOREST)) {
            return new String[]{"snowy", "arctic"};
        }
        if (types.contains(BiomeDictionary.Type.FOREST) && types.contains(BiomeDictionary.Type.CONIFEROUS) && !types.contains(BiomeDictionary.Type.SNOWY)) {
            return new String[]{"brown", "red", "timber", "black"};
        }
        return new String[]{"black", "snowy", "timber", "arctic", "brown", "red"};
    }

    @Override
    public ILivingEntityData func_213386_a(IServerWorld world, DifficultyInstance difficulty, SpawnReason reason, ILivingEntityData livingdata, CompoundNBT compound) {
        this.setInitialHunger();
        return EntityUtil.childChance((AgeableEntity)this, reason, super.func_213386_a(world, difficulty, reason, livingdata, compound), 0.25f);
    }

    protected ResourceLocation func_184647_J() {
        IVariant variant;
        if (this.getVariant().isPresent() && (variant = (IVariant)this.getVariant().get()) instanceof WolfVariant) {
            return ((WolfVariant)variant).getLootTable();
        }
        return null;
    }

    @Override
    public EntityTypeContainerBAPTameable<? extends EntityFeralWolf> getContainer() {
        return ModEntities.FERAL_WOLF;
    }

    public static class WolfVariant
    extends EntityVariant {
        private final ResourceLocation neutralTexture;
        private final ResourceLocation lootTable;

        public WolfVariant(String nameTexture) {
            super("betteranimalsplus", nameTexture, "feralwolf_" + nameTexture);
            this.neutralTexture = new ResourceLocation("betteranimalsplus", "textures/entity/feralwolf_" + nameTexture + "_neutral.png");
            this.lootTable = new ResourceLocation("betteranimalsplus", "feralwolf_" + nameTexture);
        }

        @Override
        public ResourceLocation getTexture(Entity entity) {
            if (entity instanceof EntityFeralWolf && ((EntityFeralWolf)entity).func_70909_n()) {
                return this.neutralTexture;
            }
            return super.getTexture(entity);
        }

        public ResourceLocation getLootTable() {
            return this.lootTable;
        }
    }
}

