/*
 * Decompiled with CFR 0.152.
 */
package its_meow.betteranimalsplus.compat.curios;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import its_meow.betteranimalsplus.common.item.ItemCape;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICurio;

public class CurioCape
implements ICurio {
    protected static final Map<String, BipedModel<LivingEntity>> models = new HashMap<String, BipedModel<LivingEntity>>();
    protected final ItemStack stack;
    protected final String modelKey;

    public CurioCape(String modelKey, ItemStack stack) {
        this.stack = stack;
        this.modelKey = modelKey;
    }

    public boolean canEquip(String identifier, LivingEntity livingEntity) {
        ItemStack chest = livingEntity.func_184582_a(EquipmentSlotType.CHEST);
        return chest.func_190926_b() || !(chest.func_77973_b() instanceof ItemCape) && !CuriosApi.getCuriosHelper().findEquippedCurio(stack -> stack.func_77973_b() instanceof ItemCape, livingEntity).isPresent();
    }

    public boolean canRender(String identifier, int index, LivingEntity livingEntity) {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void render(String identifier, int index, MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, int light, LivingEntity livingEntity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (this.stack.func_77973_b() instanceof ArmorItem) {
            BipedModel model;
            if (!models.containsKey(this.modelKey)) {
                model = this.stack.func_77973_b().getArmorModel(livingEntity, this.stack, EquipmentSlotType.CHEST, null);
                models.put(this.modelKey, (BipedModel<LivingEntity>)model);
            } else {
                model = models.get(this.modelKey);
            }
            ICurio.RenderHelper.translateIfSneaking((MatrixStack)matrixStack, (LivingEntity)livingEntity);
            ICurio.RenderHelper.rotateIfSneaking((MatrixStack)matrixStack, (LivingEntity)livingEntity);
            ICurio.RenderHelper.followBodyRotations((LivingEntity)livingEntity, (BipedModel[])new BipedModel[]{model});
            String texture = ((ArmorItem)this.stack.func_77973_b()).func_200880_d().func_200897_d();
            String domain = "minecraft";
            int idx = texture.indexOf(58);
            if (idx != -1) {
                domain = texture.substring(0, idx);
                texture = texture.substring(idx + 1);
            }
            String tex = String.format("%s:textures/models/armor/%s_layer_%d.png", domain, texture, 1);
            IVertexBuilder ivertexbuilder = renderTypeBuffer.getBuffer(RenderType.func_228644_e_((ResourceLocation)new ResourceLocation(tex)));
            model.func_225597_a_(livingEntity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            model.func_225598_a_(matrixStack, ivertexbuilder, light, LivingRenderer.func_229117_c_((LivingEntity)livingEntity, (float)0.0f), 1.0f, 1.0f, 1.0f, 1.0f);
        }
    }
}

