/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.tweaks.client.item;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vazkii.arl.util.ItemNBTHelper;

public class ClockTimeGetter {
    private static final String TAG_CALCULATED = "quark:clock_calculated";

    public static void tickClock(ItemStack stack) {
        boolean calculated = ClockTimeGetter.isCalculated(stack);
        if (!calculated) {
            ItemNBTHelper.setBoolean((ItemStack)stack, (String)TAG_CALCULATED, (boolean)true);
        }
    }

    static boolean isCalculated(ItemStack stack) {
        return stack.func_77942_o() && ItemNBTHelper.getBoolean((ItemStack)stack, (String)TAG_CALCULATED, (boolean)false);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Impl
    implements IItemPropertyGetter {
        private double rotation;
        private double rota;
        private long lastUpdateTick;

        @OnlyIn(value=Dist.CLIENT)
        public float call(@Nonnull ItemStack stack, @Nullable ClientWorld worldIn, @Nullable LivingEntity entityIn) {
            LivingEntity entity;
            if (!ClockTimeGetter.isCalculated(stack)) {
                return 0.0f;
            }
            boolean carried = entityIn != null;
            Object object = entity = carried ? entityIn : stack.func_82836_z();
            if (worldIn == null && entity != null && entity.field_70170_p instanceof ClientWorld) {
                worldIn = (ClientWorld)entity.field_70170_p;
            }
            if (worldIn == null) {
                return 0.0f;
            }
            double angle = worldIn.func_230315_m_().func_236043_f_() ? (double)worldIn.func_242415_f(1.0f) : Math.random();
            angle = this.wobble((World)worldIn, angle);
            return (float)angle;
        }

        private double wobble(World world, double time) {
            long gameTime = world.func_82737_E();
            if (gameTime != this.lastUpdateTick) {
                this.lastUpdateTick = gameTime;
                double d0 = time - this.rotation;
                d0 = MathHelper.func_191273_b((double)(d0 + 0.5), (double)1.0) - 0.5;
                this.rota += d0 * 0.1;
                this.rota *= 0.9;
                this.rotation = MathHelper.func_191273_b((double)(this.rotation + this.rota), (double)1.0);
            }
            return this.rotation;
        }
    }
}

