/*
 * Decompiled with CFR 0.152.
 */
package com.tm.playingcards.util;

import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.extensions.IForgeBlockState;

public class Location {
    public final World world;
    public final int x;
    public final int y;
    public final int z;
    private final BlockPos blockPos;

    public Location(World world, BlockPos pos) {
        this(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public Location(World world, int x, int y, int z) {
        this.world = world;
        this.x = x;
        this.y = y;
        this.z = z;
        this.blockPos = new BlockPos(x, y, z);
    }

    public Location(TileEntity tileEntity) {
        this(tileEntity.func_145831_w(), tileEntity.func_174877_v().func_177958_n(), tileEntity.func_174877_v().func_177956_o(), tileEntity.func_174877_v().func_177952_p());
    }

    public Location(Entity entity) {
        this(entity.field_70170_p, entity.func_233580_cy_().func_177958_n(), entity.func_233580_cy_().func_177956_o(), entity.func_233580_cy_().func_177952_p());
    }

    public BlockPos getBlockPos() {
        return this.blockPos;
    }

    public IForgeBlockState getForgeBlockState() {
        if (this.getBlockPos() == null) {
            return null;
        }
        return this.world.func_180495_p(this.getBlockPos());
    }

    public BlockState getBlockState() {
        if (this.getForgeBlockState() == null) {
            return null;
        }
        return this.getForgeBlockState().getBlockState();
    }

    public Block getBlock() {
        if (this.getBlockState() == null) {
            return null;
        }
        return this.getBlockState().func_177230_c();
    }

    public TileEntity getTileEntity() {
        return this.world.func_175625_s(this.getBlockPos());
    }

    public boolean equals(Object obj) {
        if (obj instanceof Location) {
            Location newLoc = (Location)obj;
            return this.world == newLoc.world && this.x == newLoc.x && this.y == newLoc.y && this.z == newLoc.z;
        }
        return super.equals(obj);
    }

    public String toString() {
        return "[" + this.x + ", " + this.y + ", " + this.z + "]";
    }
}

