/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.utils;

import java.util.EnumMap;
import java.util.Map;
import net.minecraft.util.Direction;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public final class FluidCuboid {
    public static final Map<Direction, FluidFace> DEFAULT_FACES = new EnumMap<Direction, FluidFace>(Direction.class);
    private final Vector3f from;
    private final Vector3f to;
    private Map<Direction, FluidFace> faces;
    private Vector3f fromScaled;
    private Vector3f toScaled;

    public FluidCuboid(Vector3f from, Vector3f to, Map<Direction, FluidFace> faces) {
        this.from = from;
        this.to = to;
        this.faces = faces;
    }

    public FluidFace getFace(Direction face) {
        return this.faces.get(face);
    }

    public Vector3f getFromScaled() {
        if (this.fromScaled == null) {
            this.fromScaled = this.from.func_229195_e_();
            this.fromScaled.func_195898_a(0.0625f);
        }
        return this.fromScaled;
    }

    public Vector3f getToScaled() {
        if (this.toScaled == null) {
            this.toScaled = this.to.func_229195_e_();
            this.toScaled.func_195898_a(0.0625f);
        }
        return this.toScaled;
    }

    static {
        for (Direction direction : Direction.values()) {
            DEFAULT_FACES.put(direction, FluidFace.NORMAL);
        }
    }

    public static class FluidFace {
        public static final FluidFace NORMAL = new FluidFace(false, 0);
        private final boolean isFlowing;
        private final int rotation;

        public FluidFace(boolean isFlowing, int rotation) {
            this.isFlowing = isFlowing;
            this.rotation = rotation;
        }

        public boolean isFlowing() {
            return this.isFlowing;
        }

        public int rotation() {
            return this.rotation;
        }
    }
}

