/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.loading;

import com.google.common.graph.GraphBuilder;
import com.google.common.graph.MutableGraph;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraftforge.fml.loading.EarlyLoadingException;
import net.minecraftforge.fml.loading.Java9BackportUtils;
import net.minecraftforge.fml.loading.LoadingModList;
import net.minecraftforge.fml.loading.LogMarkers;
import net.minecraftforge.fml.loading.VersionSupportMatrix;
import net.minecraftforge.fml.loading.moddiscovery.ModFile;
import net.minecraftforge.fml.loading.moddiscovery.ModFileInfo;
import net.minecraftforge.fml.loading.moddiscovery.ModInfo;
import net.minecraftforge.fml.loading.toposort.CyclePresentException;
import net.minecraftforge.fml.loading.toposort.TopologicalSort;
import net.minecraftforge.forgespi.language.IModInfo;
import net.minecraftforge.forgespi.locating.IModFile;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;

public class ModSorter {
    private static final Logger LOGGER = LogManager.getLogger();
    private List<ModFile> modFiles;
    private List<ModInfo> sortedList;
    private Map<String, ModInfo> modIdNameLookup;
    private List<ModFile> forgeAndMC;

    private ModSorter(List<ModFile> modFiles) {
        this.modFiles = modFiles;
    }

    public static LoadingModList sort(List<ModFile> mods) {
        ModSorter ms = new ModSorter(mods);
        try {
            ms.buildUniqueList();
        }
        catch (EarlyLoadingException e) {
            return LoadingModList.of(ms.forgeAndMC, ms.forgeAndMC.stream().map(mf -> (ModInfo)mf.getModInfos().get(0)).collect(Collectors.toList()), e);
        }
        List<EarlyLoadingException.ExceptionData> missingLangs = ms.findLanguages();
        List<EarlyLoadingException.ExceptionData> missingDeps = ms.verifyDependencyVersions();
        List<EarlyLoadingException.ExceptionData> failedList = Stream.concat(missingLangs.stream(), missingDeps.stream()).collect(Collectors.toList());
        if (!failedList.isEmpty()) {
            return LoadingModList.of(ms.forgeAndMC, ms.forgeAndMC.stream().map(mf -> (ModInfo)mf.getModInfos().get(0)).collect(Collectors.toList()), new EarlyLoadingException("failure to validate mod list", null, failedList));
        }
        EarlyLoadingException earlyLoadingException = null;
        try {
            ms.sort();
        }
        catch (EarlyLoadingException e) {
            earlyLoadingException = e;
        }
        return LoadingModList.of(ms.modFiles, ms.sortedList, earlyLoadingException);
    }

    private List<EarlyLoadingException.ExceptionData> findLanguages() {
        ArrayList<EarlyLoadingException.ExceptionData> errorData = new ArrayList<EarlyLoadingException.ExceptionData>();
        this.modFiles.forEach(modFile -> {
            try {
                modFile.identifyLanguage();
            }
            catch (EarlyLoadingException e) {
                errorData.addAll(e.getAllData());
            }
        });
        return errorData;
    }

    private void sort() {
        List<ModFileInfo> sorted;
        MutableGraph graph = GraphBuilder.directed().build();
        AtomicInteger counter = new AtomicInteger();
        Map infos = this.modFiles.stream().map(ModFile::getModFileInfo).collect(Collectors.toMap(Function.identity(), e -> counter.incrementAndGet()));
        infos.keySet().forEach(i -> graph.addNode((Object)((ModFileInfo)i)));
        this.modFiles.stream().map(ModFile::getModInfos).flatMap(Collection::stream).map(IModInfo::getDependencies).flatMap(Collection::stream).forEach(dep -> this.addDependency((MutableGraph<ModFileInfo>)graph, (IModInfo.ModVersion)dep));
        try {
            sorted = TopologicalSort.topologicalSort(graph, Comparator.comparing(infos::get));
        }
        catch (CyclePresentException e2) {
            Set cycles = e2.getCycles();
            LOGGER.error(LogMarkers.LOADING, () -> buffer -> {
                buffer.append("Mod Sorting failed.\n");
                buffer.append("Detected Cycles: ");
                buffer.append(cycles);
                buffer.append('\n');
            });
            List<EarlyLoadingException.ExceptionData> dataList = cycles.stream().map(Collection::stream).map(stream -> stream.flatMap(modFileInfo -> modFileInfo.getMods().stream().map(IModInfo::getModId)).collect(Collectors.toList())).map(list -> new EarlyLoadingException.ExceptionData("fml.modloading.cycle", list)).collect(Collectors.toList());
            throw new EarlyLoadingException("Sorting error", e2, dataList);
        }
        this.sortedList = sorted.stream().map(ModFileInfo::getMods).flatMap(Collection::stream).map(ModInfo.class::cast).collect(Collectors.toList());
        this.modFiles = sorted.stream().map(ModFileInfo::getFile).collect(Collectors.toList());
    }

    private void addDependency(MutableGraph<ModFileInfo> topoGraph, IModInfo.ModVersion dep) {
        ModFileInfo self = (ModFileInfo)dep.getOwner().getOwningFile();
        ModInfo targetModInfo = this.modIdNameLookup.get(dep.getModId());
        if (targetModInfo == null) {
            return;
        }
        ModFileInfo target = targetModInfo.getOwningFile();
        if (self == target) {
            return;
        }
        switch (dep.getOrdering()) {
            case BEFORE: {
                topoGraph.putEdge((Object)self, (Object)target);
                break;
            }
            case AFTER: {
                topoGraph.putEdge((Object)target, (Object)self);
                break;
            }
        }
    }

    private void buildUniqueList() {
        Map<String, List<IModFile>> modFilesByFirstId = this.modFiles.stream().collect(Collectors.groupingBy(mf -> ((IModInfo)mf.getModInfos().get(0)).getModId()));
        this.forgeAndMC = new ArrayList<ModFile>();
        this.forgeAndMC.add((ModFile)modFilesByFirstId.get("minecraft").get(0));
        this.forgeAndMC.add((ModFile)modFilesByFirstId.get("forge").get(0));
        this.modFiles = modFilesByFirstId.entrySet().stream().map(this::selectNewestModInfo).map(Map.Entry::getValue).map(ModFile.class::cast).collect(Collectors.toList());
        Map<String, List<ModInfo>> modIds = this.modFiles.stream().map(ModFile::getModInfos).flatMap(Collection::stream).map(ModInfo.class::cast).collect(Collectors.groupingBy(IModInfo::getModId));
        List dupedMods = modIds.entrySet().stream().filter(e -> ((List)e.getValue()).size() > 1).collect(Collectors.toList());
        if (!dupedMods.isEmpty()) {
            List<EarlyLoadingException.ExceptionData> duplicateModErrors = dupedMods.stream().map(dm -> new EarlyLoadingException.ExceptionData("fml.modloading.dupedmod", (IModInfo)((List)dm.getValue()).get(0), new Object[]{Objects.toString(((List)dm.getValue()).get(0))})).collect(Collectors.toList());
            throw new EarlyLoadingException("Duplicate mods found", null, duplicateModErrors);
        }
        this.modIdNameLookup = modIds.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> (ModInfo)((List)e.getValue()).get(0)));
    }

    private Map.Entry<String, IModFile> selectNewestModInfo(Map.Entry<String, List<IModFile>> fullList) {
        List<IModFile> modInfoList = fullList.getValue();
        if (modInfoList.size() > 1) {
            LOGGER.debug("Found {} mods for first modid {}, selecting most recent based on version data", (Object)modInfoList.size(), (Object)fullList.getKey());
            modInfoList.sort(Comparator.comparing(mf -> ((IModInfo)mf.getModInfos().get(0)).getVersion()).reversed());
            LOGGER.debug("Selected file {} for modid {} with version {}", (Object)modInfoList.get(0).getFileName(), (Object)fullList.getKey(), (Object)((IModInfo)modInfoList.get(0).getModInfos().get(0)).getVersion());
        }
        return new AbstractMap.SimpleImmutableEntry<String, IModFile>(fullList.getKey(), modInfoList.get(0));
    }

    private List<EarlyLoadingException.ExceptionData> verifyDependencyVersions() {
        Map<String, ArtifactVersion> modVersions = this.modFiles.stream().map(ModFile::getModInfos).flatMap(Collection::stream).collect(Collectors.toMap(IModInfo::getModId, IModInfo::getVersion));
        Map modVersionDependencies = this.modFiles.stream().map(ModFile::getModInfos).flatMap(Collection::stream).collect(Collectors.groupingBy(Function.identity(), Java9BackportUtils.flatMapping(e -> e.getDependencies().stream(), Collectors.toList())));
        Set modRequirements = modVersionDependencies.values().stream().flatMap(Collection::stream).filter(mv -> mv.getSide().isCorrectSide()).collect(Collectors.toSet());
        long mandatoryRequired = modRequirements.stream().filter(IModInfo.ModVersion::isMandatory).count();
        LOGGER.debug(LogMarkers.LOADING, "Found {} mod requirements ({} mandatory, {} optional)", (Object)modRequirements.size(), (Object)mandatoryRequired, (Object)((long)modRequirements.size() - mandatoryRequired));
        Set missingVersions = modRequirements.stream().filter(mv -> (mv.isMandatory() || modVersions.containsKey(mv.getModId())) && this.modVersionNotContained((IModInfo.ModVersion)mv, modVersions)).collect(Collectors.toSet());
        long mandatoryMissing = missingVersions.stream().filter(IModInfo.ModVersion::isMandatory).count();
        LOGGER.debug(LogMarkers.LOADING, "Found {} mod requirements missing ({} mandatory, {} optional)", (Object)missingVersions.size(), (Object)mandatoryMissing, (Object)((long)missingVersions.size() - mandatoryMissing));
        if (!missingVersions.isEmpty()) {
            return missingVersions.stream().map(mv -> new EarlyLoadingException.ExceptionData(mv.isMandatory() ? "fml.modloading.missingdependency" : "fml.modloading.missingdependency.optional", mv.getOwner(), new Object[]{mv.getModId(), mv.getOwner().getModId(), mv.getVersionRange(), modVersions.getOrDefault(mv.getModId(), (ArtifactVersion)new DefaultArtifactVersion("null"))})).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private boolean modVersionNotContained(IModInfo.ModVersion mv, Map<String, ArtifactVersion> modVersions) {
        return !VersionSupportMatrix.testVersionSupportMatrix(mv.getVersionRange(), mv.getModId(), "mod", (modId, range) -> modVersions.containsKey(modId) && (range.containsVersion((ArtifactVersion)modVersions.get(modId)) || ((ArtifactVersion)modVersions.get(modId)).toString().equals("NONE")));
    }
}

