/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbessentials.util;

import com.mojang.authlib.GameProfile;
import dev.ftb.mods.ftbessentials.config.FTBEConfig;
import dev.ftb.mods.ftbessentials.net.UpdateTabNamePacket;
import dev.ftb.mods.ftbessentials.util.CooldownTeleporter;
import dev.ftb.mods.ftbessentials.util.FTBEWorldData;
import dev.ftb.mods.ftbessentials.util.TeleportPos;
import dev.ftb.mods.ftblibrary.snbt.SNBT;
import dev.ftb.mods.ftblibrary.snbt.SNBTCompoundTag;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class FTBEPlayerData {
    public static final Map<UUID, FTBEPlayerData> MAP = new HashMap<UUID, FTBEPlayerData>();
    public final UUID uuid;
    public String name;
    private boolean save;
    public boolean muted;
    public boolean fly;
    public boolean god;
    public String nick;
    public TeleportPos lastSeen;
    public final LinkedHashMap<String, TeleportPos> homes;
    public int recording;
    public final CooldownTeleporter backTeleporter;
    public final CooldownTeleporter spawnTeleporter;
    public final CooldownTeleporter warpTeleporter;
    public final CooldownTeleporter homeTeleporter;
    public final CooldownTeleporter tpaTeleporter;
    public final CooldownTeleporter rtpTeleporter;
    public final LinkedList<TeleportPos> teleportHistory;

    public static FTBEPlayerData get(GameProfile profile) {
        FTBEPlayerData data = MAP.get(profile.getId());
        if (data == null) {
            data = new FTBEPlayerData(profile.getId());
            if (profile.getName() != null && !profile.getName().isEmpty()) {
                data.name = profile.getName();
            }
            MAP.put(profile.getId(), data);
        }
        return data;
    }

    public static FTBEPlayerData get(PlayerEntity player) {
        return FTBEPlayerData.get(player.func_146103_bH());
    }

    public static void addTeleportHistory(ServerPlayerEntity player, RegistryKey<World> dimension, BlockPos pos) {
        FTBEPlayerData.get((PlayerEntity)player).addTeleportHistory(player, new TeleportPos(dimension, pos));
    }

    public static void addTeleportHistory(ServerPlayerEntity player) {
        FTBEPlayerData.addTeleportHistory(player, (RegistryKey<World>)player.field_70170_p.func_234923_W_(), player.func_233580_cy_());
    }

    public FTBEPlayerData(UUID u) {
        this.uuid = u;
        this.name = "Unknown";
        this.save = false;
        this.muted = false;
        this.fly = false;
        this.god = false;
        this.nick = "";
        this.lastSeen = new TeleportPos((RegistryKey<World>)World.field_234918_g_, BlockPos.field_177992_a);
        this.homes = new LinkedHashMap();
        this.recording = 0;
        this.backTeleporter = new CooldownTeleporter(this, FTBEConfig.BACK.cooldown::get);
        this.spawnTeleporter = new CooldownTeleporter(this, FTBEConfig.SPAWN.cooldown::get);
        this.warpTeleporter = new CooldownTeleporter(this, FTBEConfig.WARP.cooldown::get);
        this.homeTeleporter = new CooldownTeleporter(this, FTBEConfig.HOME.cooldown::get);
        this.tpaTeleporter = new CooldownTeleporter(this, FTBEConfig.TPA.cooldown::get);
        this.rtpTeleporter = new CooldownTeleporter(this, FTBEConfig.RTP.cooldown::get);
        this.teleportHistory = new LinkedList();
    }

    public void save() {
        this.save = true;
    }

    public SNBTCompoundTag write() {
        SNBTCompoundTag json = new SNBTCompoundTag();
        json.func_74757_a("muted", this.muted);
        json.func_74757_a("fly", this.fly);
        json.func_74757_a("god", this.god);
        json.func_74778_a("nick", this.nick);
        json.func_218657_a("last_seen", (INBT)this.lastSeen.write());
        json.func_74768_a("recording", this.recording);
        ListNBT tph = new ListNBT();
        for (TeleportPos pos : this.teleportHistory) {
            tph.add((Object)pos.write());
        }
        json.func_218657_a("teleport_history", (INBT)tph);
        SNBTCompoundTag hm = new SNBTCompoundTag();
        for (Map.Entry<String, TeleportPos> h : this.homes.entrySet()) {
            hm.func_218657_a(h.getKey(), (INBT)h.getValue().write());
        }
        json.func_218657_a("homes", (INBT)hm);
        return json;
    }

    public void read(CompoundNBT tag) {
        this.muted = tag.func_74767_n("muted");
        this.fly = tag.func_74767_n("fly");
        this.god = tag.func_74767_n("god");
        this.nick = tag.func_74779_i("nick");
        this.recording = tag.func_74762_e("recording");
        this.lastSeen = tag.func_74764_b("last_seen") ? new TeleportPos(tag.func_74775_l("last_seen")) : null;
        this.teleportHistory.clear();
        ListNBT th = tag.func_150295_c("teleport_history", 10);
        for (int i = 0; i < th.size(); ++i) {
            this.teleportHistory.add(new TeleportPos(th.func_150305_b(i)));
        }
        this.homes.clear();
        CompoundNBT h = tag.func_74775_l("homes");
        for (String key : h.func_150296_c()) {
            this.homes.put(key, new TeleportPos(h.func_74775_l(key)));
        }
    }

    public void addTeleportHistory(ServerPlayerEntity player, TeleportPos pos) {
        this.teleportHistory.add(pos);
        while (this.teleportHistory.size() > FTBEConfig.MAX_BACK.get(player)) {
            this.teleportHistory.removeFirst();
        }
        this.save();
    }

    public void load() {
        SNBTCompoundTag tag = SNBT.read((Path)FTBEWorldData.instance.mkdirs("playerdata").resolve(this.uuid + ".snbt"));
        if (tag != null) {
            this.read((CompoundNBT)tag);
        }
    }

    public void saveNow() {
        if (this.save && SNBT.write((Path)FTBEWorldData.instance.mkdirs("playerdata").resolve(this.uuid + ".snbt"), (CompoundNBT)this.write())) {
            this.save = false;
        }
    }

    public void sendTabName(MinecraftServer server) {
        new UpdateTabNamePacket(this.uuid, this.name, this.nick, this.recording, false).sendToAll(server);
    }

    public void sendTabName(ServerPlayerEntity to) {
        new UpdateTabNamePacket(this.uuid, this.name, this.nick, this.recording, false).sendTo(to);
    }
}

