/*
 * Decompiled with CFR 0.152.
 */
package onelemonyboi.lemonlib.rewards;

import com.google.gson.Gson;
import com.google.gson.stream.JsonReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class PatreonJSON {
    protected static Map<String, String> REWARD_MAP = new HashMap<String, String>();

    private static void load() {
        Thread thread = new Thread(() -> {
            Gson jsonParser = new Gson();
            try {
                URL url = new URL("https://raw.githubusercontent.com/OneLemonyBoi/LemonLib/main/supporters.json");
                try (JsonReader reader = new JsonReader((Reader)new InputStreamReader(url.openStream()));){
                    Supporter[] supportersList;
                    for (Supporter supporter : supportersList = (Supporter[])jsonParser.fromJson(reader, Supporter[].class)) {
                        REWARD_MAP.put(supporter.name, supporter.color);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        thread.setName("lemonlib_supporter_downloader");
        thread.start();
    }

    static {
        PatreonJSON.load();
    }

    private static class Supporter {
        public String name;
        public String color;

        private Supporter() {
        }
    }
}

