/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbranks.impl;

import com.mojang.authlib.GameProfile;
import dev.ftb.mods.ftbranks.api.PermissionValue;
import dev.ftb.mods.ftbranks.api.Rank;
import dev.ftb.mods.ftbranks.api.RankCondition;
import dev.ftb.mods.ftbranks.api.RankManager;
import dev.ftb.mods.ftbranks.impl.PlayerRankData;
import dev.ftb.mods.ftbranks.impl.RankManagerImpl;
import dev.ftb.mods.ftbranks.impl.condition.DefaultCondition;
import java.time.Instant;
import java.util.LinkedHashMap;
import java.util.Map;

public class RankImpl
implements Rank,
Comparable<RankImpl> {
    public final RankManagerImpl manager;
    public final String id;
    public final Map<String, PermissionValue> permissions;
    public String name;
    public int power;
    public RankCondition condition;

    public RankImpl(RankManagerImpl m, String s) {
        this.manager = m;
        this.id = s;
        this.permissions = new LinkedHashMap<String, PermissionValue>();
        this.name = "";
        this.power = 50;
        this.condition = new DefaultCondition(this);
    }

    public String toString() {
        return this.id;
    }

    public boolean equals(Object o) {
        return o == this || o instanceof Rank && this.id.equals(((Rank)o).getId());
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    @Override
    public RankManager getManager() {
        return this.manager;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getPower() {
        return this.power;
    }

    @Override
    public void setPermission(String node, PermissionValue value) {
        this.permissions.put(node, value);
        this.manager.saveRanks();
    }

    @Override
    public PermissionValue getPermission(String node) {
        return this.permissions.getOrDefault(node, PermissionValue.DEFAULT);
    }

    @Override
    public RankCondition getCondition() {
        return this.condition;
    }

    @Override
    public boolean add(GameProfile profile) {
        PlayerRankData data = this.manager.getPlayerData(profile);
        if (!data.added.containsKey(this)) {
            data.added.put(this, Instant.now());
            this.manager.savePlayers();
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(GameProfile profile) {
        PlayerRankData data = this.manager.getPlayerData(profile);
        if (data.added.remove(this) != null) {
            this.manager.savePlayers();
            return true;
        }
        return false;
    }

    @Override
    public int compareTo(RankImpl o) {
        return o.getPower() - this.getPower();
    }
}

