/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.core.tracking;

import dan200.computercraft.core.computer.Computer;
import dan200.computercraft.core.tracking.Tracker;
import dan200.computercraft.core.tracking.TrackingContext;
import dan200.computercraft.core.tracking.TrackingField;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;

public final class Tracking {
    static final AtomicInteger tracking = new AtomicInteger(0);
    private static final Object lock = new Object();
    private static final HashMap<UUID, TrackingContext> contexts = new HashMap();
    private static final List<Tracker> trackers = new ArrayList<Tracker>();

    private Tracking() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TrackingContext getContext(UUID uuid) {
        Object object = lock;
        synchronized (object) {
            TrackingContext context = contexts.get(uuid);
            if (context == null) {
                context = new TrackingContext();
                contexts.put(uuid, context);
            }
            return context;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void add(Tracker tracker) {
        Object object = lock;
        synchronized (object) {
            trackers.add(tracker);
            tracking.incrementAndGet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addTaskTiming(Computer computer, long time) {
        if (tracking.get() == 0) {
            return;
        }
        HashMap<UUID, TrackingContext> hashMap = contexts;
        synchronized (hashMap) {
            for (TrackingContext context : contexts.values()) {
                context.addTaskTiming(computer, time);
            }
            for (Tracker tracker : trackers) {
                tracker.addTaskTiming(computer, time);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addServerTiming(Computer computer, long time) {
        if (tracking.get() == 0) {
            return;
        }
        HashMap<UUID, TrackingContext> hashMap = contexts;
        synchronized (hashMap) {
            for (TrackingContext context : contexts.values()) {
                context.addServerTiming(computer, time);
            }
            for (Tracker tracker : trackers) {
                tracker.addServerTiming(computer, time);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addValue(Computer computer, TrackingField field, long change) {
        if (tracking.get() == 0) {
            return;
        }
        Object object = lock;
        synchronized (object) {
            for (TrackingContext context : contexts.values()) {
                context.addValue(computer, field, change);
            }
            for (Tracker tracker : trackers) {
                tracker.addValue(computer, field, change);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reset() {
        Object object = lock;
        synchronized (object) {
            contexts.clear();
            trackers.clear();
            tracking.set(0);
        }
    }
}

