/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.data;

import dan200.computercraft.shared.Registry;
import dan200.computercraft.shared.computer.blocks.BlockComputer;
import dan200.computercraft.shared.computer.core.ComputerState;
import dan200.computercraft.shared.peripheral.monitor.BlockMonitor;
import dan200.computercraft.shared.peripheral.monitor.MonitorEdgeState;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.data.DataGenerator;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.VariantBlockStateBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;

public class BlockModelProvider
extends BlockStateProvider {
    private ModelFile monitorBase;
    private ModelFile orientable;

    public BlockModelProvider(DataGenerator generator, ExistingFileHelper existingFileHelper) {
        super(generator, "computercraft", existingFileHelper);
    }

    @Nonnull
    public String func_200397_b() {
        return "Block states and models";
    }

    protected void registerStatesAndModels() {
        this.monitorBase = this.models().getExistingFile(new ResourceLocation("computercraft", "block/monitor_base"));
        this.orientable = this.models().getExistingFile(new ResourceLocation("block/orientable"));
        this.registerMonitors((BlockMonitor)Registry.ModBlocks.MONITOR_NORMAL.get());
        this.registerMonitors((BlockMonitor)Registry.ModBlocks.MONITOR_ADVANCED.get());
        this.registerComputer((BlockComputer)Registry.ModBlocks.COMPUTER_NORMAL.get());
        this.registerComputer((BlockComputer)Registry.ModBlocks.COMPUTER_ADVANCED.get());
        this.registerComputer((BlockComputer)Registry.ModBlocks.COMPUTER_COMMAND.get());
    }

    private void registerComputer(BlockComputer block) {
        VariantBlockStateBuilder builder = this.getVariantBuilder(block);
        for (ComputerState state : BlockComputer.STATE.func_177700_c()) {
            BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(BlockModelProvider.suffix(block, "_" + (Object)((Object)state)))).parent(this.orientable)).texture("top", BlockModelProvider.suffix(block, "_top"))).texture("side", BlockModelProvider.suffix(block, "_side"))).texture("front", BlockModelProvider.suffix(block, "_front" + BlockModelProvider.toSuffix(state)));
            for (Direction facing : BlockComputer.FACING.func_177700_c()) {
                builder.partialState().with(BlockComputer.STATE, (Comparable)((Object)state)).with((Property)BlockComputer.FACING, (Comparable)facing).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)model, 0, BlockModelProvider.toYAngle(facing), false)});
            }
        }
    }

    private void registerMonitors(BlockMonitor block) {
        String name = block.getRegistryName().func_110623_a();
        this.registerMonitorModel(name, "", 16, 4, 0, 32);
        this.registerMonitorModel(name, "_d", 20, 7, 0, 36);
        this.registerMonitorModel(name, "_l", 19, 4, 1, 33);
        this.registerMonitorModel(name, "_ld", 31, 7, 1, 45);
        this.registerMonitorModel(name, "_lr", 18, 4, 2, 34);
        this.registerMonitorModel(name, "_lrd", 30, 7, 2, 46);
        this.registerMonitorModel(name, "_lru", 24, 5, 2, 40);
        this.registerMonitorModel(name, "_lrud", 27, 6, 2, 43);
        this.registerMonitorModel(name, "_lu", 25, 5, 1, 39);
        this.registerMonitorModel(name, "_lud", 28, 6, 1, 42);
        this.registerMonitorModel(name, "_r", 17, 4, 3, 35);
        this.registerMonitorModel(name, "_rd", 29, 7, 3, 47);
        this.registerMonitorModel(name, "_ru", 23, 5, 3, 41);
        this.registerMonitorModel(name, "_rud", 26, 6, 3, 44);
        this.registerMonitorModel(name, "_u", 22, 5, 0, 38);
        this.registerMonitorModel(name, "_ud", 21, 6, 0, 37);
        VariantBlockStateBuilder builder = this.getVariantBuilder(block);
        for (MonitorEdgeState edge : BlockMonitor.STATE.func_177700_c()) {
            String suffix = edge == MonitorEdgeState.NONE ? "" : "_" + edge.func_176610_l();
            ModelBuilder model = this.models().getBuilder(BlockModelProvider.suffix(block, suffix));
            for (Direction facing : BlockMonitor.FACING.func_177700_c()) {
                for (Direction orientation : BlockMonitor.ORIENTATION.func_177700_c()) {
                    builder.partialState().with(BlockMonitor.STATE, (Comparable)((Object)edge)).with((Property)BlockMonitor.FACING, (Comparable)facing).with((Property)BlockMonitor.ORIENTATION, (Comparable)orientation).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)model, BlockModelProvider.toXAngle(orientation), BlockModelProvider.toYAngle(facing), false)});
                }
            }
        }
    }

    private void registerMonitorModel(String prefix, String corners, int front, int side, int top, int back) {
        String texturePrefix = "computercraft:block/" + prefix + "_";
        ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(prefix + corners)).parent(this.monitorBase)).texture("front", texturePrefix + front)).texture("side", texturePrefix + side)).texture("top", texturePrefix + top)).texture("back", texturePrefix + back);
    }

    private static int toXAngle(Direction direction) {
        switch (direction) {
            default: {
                return 0;
            }
            case UP: {
                return 270;
            }
            case DOWN: 
        }
        return 90;
    }

    private static int toYAngle(Direction direction) {
        return ((int)direction.func_185119_l() + 180) % 360;
    }

    private static String toSuffix(ComputerState state) {
        switch (state) {
            default: {
                return "";
            }
            case ON: {
                return "_on";
            }
            case BLINKING: 
        }
        return "_blink";
    }

    private static String suffix(Block block, String suffix) {
        ResourceLocation id = block.getRegistryName();
        return new ResourceLocation(id.func_110624_b(), "block/" + id.func_110623_a() + suffix).toString();
    }
}

