/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.cobalt.lib;

import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.squiddev.cobalt.Buffer;
import org.squiddev.cobalt.Constants;
import org.squiddev.cobalt.ErrorFactory;
import org.squiddev.cobalt.LuaError;
import org.squiddev.cobalt.LuaState;
import org.squiddev.cobalt.LuaString;
import org.squiddev.cobalt.LuaTable;
import org.squiddev.cobalt.LuaValue;
import org.squiddev.cobalt.ValueFactory;
import org.squiddev.cobalt.Varargs;
import org.squiddev.cobalt.function.LibFunction;
import org.squiddev.cobalt.function.VarArgFunction;
import org.squiddev.cobalt.lib.FormatDesc;
import org.squiddev.cobalt.lib.LuaLibrary;

public class OsLib
extends VarArgFunction
implements LuaLibrary {
    private static final int CLOCK = 0;
    private static final int DATE = 1;
    private static final int DIFFTIME = 2;
    private static final int EXECUTE = 3;
    private static final int EXIT = 4;
    private static final int GETENV = 5;
    private static final int REMOVE = 6;
    private static final int RENAME = 7;
    private static final int SETLOCALE = 8;
    private static final int TIME = 9;
    private static final int TMPNAME = 10;
    private static final LuaString DATE_FORMAT = ValueFactory.valueOf("%c");
    private static final LuaString DATE_TABLE = ValueFactory.valueOf("*t");
    private static final String[] NAMES = new String[]{"clock", "date", "difftime", "execute", "exit", "getenv", "remove", "rename", "setlocale", "time", "tmpname"};
    private static final long t0 = System.currentTimeMillis();
    private static final String[] WEEKDAY_NAME_ABBREV = new String[]{"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};
    private static final String[] WEEKDAY_NAME = new String[]{"Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"};
    private static final String[] MONTH_NAME_ABBREV = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
    private static final String[] MONTH_NAME = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};
    private static final LuaString FORMAT_C = ValueFactory.valueOf("%a %b %e %H:%M:%S %Y");
    private static final LuaString FORMAT_DATE_D = ValueFactory.valueOf("%m/%d/%y");
    private static final LuaString FORMAT_DATE_F = ValueFactory.valueOf("%Y-%m-%d");
    private static final LuaString FORMAT_TIME_UPPER_R = ValueFactory.valueOf("%I:%M:%S %p");
    private static final LuaString FORMAT_TIME_LOWER_R = ValueFactory.valueOf("%H:%M");
    private static final LuaString FORMAT_TIME_T = ValueFactory.valueOf("%H:%M:%S");
    private static final FormatDesc ZERO_TWO = FormatDesc.ofUnsafe("02d");
    private static final FormatDesc ZERO_THREE = FormatDesc.ofUnsafe("03d");
    private static final FormatDesc SPACE_TWO = FormatDesc.ofUnsafe("2d");

    @Override
    public LuaValue add(LuaState state, LuaTable env) {
        LuaTable t = new LuaTable();
        LibFunction.bind(t, OsLib::new, NAMES);
        env.rawset("os", (LuaValue)t);
        state.loadedPackages.rawset("os", (LuaValue)t);
        return t;
    }

    @Override
    public Varargs invoke(LuaState state, Varargs args) throws LuaError {
        try {
            switch (this.opcode) {
                case 0: {
                    return ValueFactory.valueOf((System.currentTimeMillis() - t0) / 1000L);
                }
                case 1: {
                    LuaString format = args.arg(1).optLuaString(DATE_FORMAT);
                    long time = args.arg(2).optLong(this.time(state, null));
                    Calendar d = Calendar.getInstance(state.timezone, Locale.ROOT);
                    d.setTime(new Date(time * 1000L));
                    if (format.startsWith(33)) {
                        d.setTime(new Date((time -= (long)this.timeZoneOffset(d)) * 1000L));
                        format = format.substring(1);
                    }
                    if (format.equals(DATE_TABLE)) {
                        LuaTable tbl = ValueFactory.tableOf();
                        tbl.rawset("year", (LuaValue)ValueFactory.valueOf(d.get(1)));
                        tbl.rawset("month", (LuaValue)ValueFactory.valueOf(d.get(2) + 1));
                        tbl.rawset("day", (LuaValue)ValueFactory.valueOf(d.get(5)));
                        tbl.rawset("hour", (LuaValue)ValueFactory.valueOf(d.get(11)));
                        tbl.rawset("min", (LuaValue)ValueFactory.valueOf(d.get(12)));
                        tbl.rawset("sec", (LuaValue)ValueFactory.valueOf(d.get(13)));
                        tbl.rawset("wday", (LuaValue)ValueFactory.valueOf(d.get(7)));
                        tbl.rawset("yday", (LuaValue)ValueFactory.valueOf(d.get(6)));
                        tbl.rawset("isdst", (LuaValue)ValueFactory.valueOf(this.isDaylightSavingsTime(d)));
                        return tbl;
                    }
                    Buffer buffer = new Buffer(format.length);
                    this.date(state, buffer, d, format);
                    return buffer.toLuaString();
                }
                case 2: {
                    return ValueFactory.valueOf(args.arg(1).checkLong() - args.arg(2).checkLong());
                }
                case 3: {
                    return ValueFactory.valueOf(state.resourceManipulator.execute(args.arg(1).optString(null)));
                }
                case 4: {
                    System.exit(args.arg(1).optInteger(0));
                    return Constants.NONE;
                }
                case 5: {
                    String val = System.getenv(args.arg(1).checkString());
                    return val != null ? ValueFactory.valueOf(val) : Constants.NIL;
                }
                case 6: {
                    state.resourceManipulator.remove(args.arg(1).checkString());
                    return Constants.TRUE;
                }
                case 7: {
                    state.resourceManipulator.rename(args.arg(1).checkString(), args.arg(2).checkString());
                    return Constants.TRUE;
                }
                case 8: {
                    String locale = args.arg(1).optString(null);
                    args.arg(2).optString("all");
                    return locale == null || locale.equals("C") ? ValueFactory.valueOf("C") : Constants.NIL;
                }
                case 9: {
                    return ValueFactory.valueOf(this.time(state, args.first().isNil() ? null : args.arg(1).checkTable()));
                }
                case 10: {
                    return ValueFactory.valueOf(state.resourceManipulator.tmpName());
                }
            }
            return Constants.NONE;
        }
        catch (IOException e) {
            return ValueFactory.varargsOf(Constants.NIL, (Varargs)ValueFactory.valueOf(e.getMessage()));
        }
    }

    private Calendar beginningOfYear(LuaState state, Calendar d) {
        Calendar y0 = Calendar.getInstance(state.timezone, Locale.ROOT);
        y0.setTime(d.getTime());
        y0.set(2, 0);
        y0.set(5, 1);
        y0.set(11, 0);
        y0.set(12, 0);
        y0.set(13, 0);
        y0.set(14, 0);
        return y0;
    }

    private int weekNumber(LuaState state, Calendar d, int startDay) {
        Calendar y0 = this.beginningOfYear(state, d);
        y0.set(5, 1 + (startDay + 8 - y0.get(7)) % 7);
        if (y0.after(d)) {
            y0.set(1, y0.get(1) - 1);
            y0.set(5, 1 + (startDay + 8 - y0.get(7)) % 7);
        }
        long dt = d.getTime().getTime() - y0.getTime().getTime();
        return 1 + (int)(dt / 604800000L);
    }

    private int timeZoneOffset(Calendar d) {
        int localStandardTimeMillis = 1000 * (d.get(11) * 3600 + d.get(12) * 60 + d.get(13));
        return d.getTimeZone().getOffset(1, d.get(1), d.get(2), d.get(5), d.get(7), localStandardTimeMillis) / 1000;
    }

    private boolean isDaylightSavingsTime(Calendar d) {
        return this.timeZoneOffset(d) != d.getTimeZone().getRawOffset() / 1000;
    }

    private void date(LuaState state, Buffer result, Calendar date, LuaString format) throws LuaError {
        byte[] fmt = format.bytes;
        int n = format.length + format.offset;
        int i = format.offset;
        block40: while (i < n) {
            byte c = fmt[i++];
            switch (c) {
                case 10: {
                    result.append("\n");
                    continue block40;
                }
                default: {
                    result.append(c);
                    continue block40;
                }
                case 37: 
            }
            if (i >= n) continue;
            c = fmt[i++];
            switch (c) {
                default: {
                    throw ErrorFactory.argError(1, "invalid conversion specifier '%" + (char)c + "'");
                }
                case 37: {
                    result.append((byte)37);
                    continue block40;
                }
                case 97: {
                    result.append(WEEKDAY_NAME_ABBREV[date.get(7) - 1]);
                    continue block40;
                }
                case 65: {
                    result.append(WEEKDAY_NAME[date.get(7) - 1]);
                    continue block40;
                }
                case 98: 
                case 104: {
                    result.append(MONTH_NAME_ABBREV[date.get(2)]);
                    continue block40;
                }
                case 66: {
                    result.append(MONTH_NAME[date.get(2)]);
                    continue block40;
                }
                case 99: {
                    this.date(state, result, date, FORMAT_C);
                    continue block40;
                }
                case 67: {
                    ZERO_TWO.format(result, date.get(1) / 100 % 100);
                    continue block40;
                }
                case 100: {
                    ZERO_TWO.format(result, date.get(5));
                    continue block40;
                }
                case 68: 
                case 120: {
                    this.date(state, result, date, FORMAT_DATE_D);
                    continue block40;
                }
                case 101: {
                    SPACE_TWO.format(result, date.get(5));
                    continue block40;
                }
                case 70: {
                    this.date(state, result, date, FORMAT_DATE_F);
                    continue block40;
                }
                case 103: {
                    ZERO_TWO.format(result, date.isWeekDateSupported() ? (long)(date.getWeekYear() % 100) : 0L);
                    continue block40;
                }
                case 71: {
                    result.append(Integer.toString(date.isWeekDateSupported() ? date.getWeekYear() : 0));
                    continue block40;
                }
                case 72: {
                    ZERO_TWO.format(result, date.get(11));
                    continue block40;
                }
                case 73: {
                    ZERO_TWO.format(result, date.get(11) % 12);
                    continue block40;
                }
                case 106: {
                    ZERO_THREE.format(result, date.get(6));
                    continue block40;
                }
                case 109: {
                    ZERO_TWO.format(result, date.get(2) + 1);
                    continue block40;
                }
                case 77: {
                    ZERO_TWO.format(result, date.get(12));
                    continue block40;
                }
                case 110: {
                    result.append('\n');
                    continue block40;
                }
                case 112: {
                    result.append(date.get(11) < 12 ? "AM" : "PM");
                    continue block40;
                }
                case 114: {
                    this.date(state, result, date, FORMAT_TIME_UPPER_R);
                    continue block40;
                }
                case 82: {
                    this.date(state, result, date, FORMAT_TIME_LOWER_R);
                    continue block40;
                }
                case 83: {
                    ZERO_TWO.format(result, date.get(13));
                    continue block40;
                }
                case 116: {
                    result.append('\t');
                    continue block40;
                }
                case 84: 
                case 88: {
                    this.date(state, result, date, FORMAT_TIME_T);
                    continue block40;
                }
                case 117: {
                    int day = date.get(7);
                    result.append(day == 1 ? "7" : Integer.toString(day - 1));
                    continue block40;
                }
                case 85: {
                    ZERO_TWO.format(result, this.weekNumber(state, date, 0));
                    continue block40;
                }
                case 86: {
                    ZERO_TWO.format(result, this.weekNumber(state, date, 1));
                    continue block40;
                }
                case 119: {
                    result.append(Integer.toString((date.get(7) + 6) % 7));
                    continue block40;
                }
                case 87: {
                    ZERO_TWO.format(result, this.weekNumber(state, date, 1));
                    continue block40;
                }
                case 121: {
                    ZERO_TWO.format(result, date.get(1) % 100);
                    continue block40;
                }
                case 89: {
                    result.append(Integer.toString(date.get(1)));
                    continue block40;
                }
                case 122: {
                    int tzo = this.timeZoneOffset(date) / 60;
                    int a = Math.abs(tzo);
                    result.append(tzo >= 0 ? (char)'+' : '-');
                    ZERO_TWO.format(result, a / 60);
                    ZERO_TWO.format(result, a % 60);
                    continue block40;
                }
                case 90: 
            }
            result.append(date.getTimeZone().getID());
        }
    }

    private long time(LuaState state, LuaTable table) throws LuaError {
        if (table == null) {
            return System.currentTimeMillis() / 1000L;
        }
        Calendar c = Calendar.getInstance(state.timezone, Locale.ROOT);
        c.set(1, OsLib.getField(table, "year", -1));
        c.set(2, OsLib.getField(table, "month", -1) - 1);
        c.set(5, OsLib.getField(table, "day", -1));
        c.set(11, OsLib.getField(table, "hour", 12));
        c.set(12, OsLib.getField(table, "min", 0));
        c.set(13, OsLib.getField(table, "sec", 0));
        c.set(14, 0);
        return c.getTimeInMillis() / 1000L;
    }

    private static int getField(LuaTable table, String field, int def) throws LuaError {
        LuaValue value = table.rawget(field);
        if (value.isNumber()) {
            return value.toInteger();
        }
        if (def < 0) {
            throw new LuaError("field \"" + field + "\" missing in date table");
        }
        return def;
    }
}

