/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.util;

import dev.ftb.mods.ftblibrary.FTBLibrary;
import dev.ftb.mods.ftblibrary.core.DisplayInfoFTBL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.advancements.Advancement;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.server.ServerWorld;

public class KnownServerRegistries {
    public static KnownServerRegistries client;
    public static KnownServerRegistries server;
    public final List<ResourceLocation> dimensions;
    public final Map<ResourceLocation, AdvancementInfo> advancements;

    public KnownServerRegistries(PacketBuffer buffer) {
        int i;
        int s = buffer.func_150792_a();
        this.dimensions = new ArrayList<ResourceLocation>(s);
        for (i = 0; i < s; ++i) {
            this.dimensions.add(buffer.func_192575_l());
        }
        s = buffer.func_150792_a();
        this.advancements = new LinkedHashMap<ResourceLocation, AdvancementInfo>(s);
        for (i = 0; i < s; ++i) {
            AdvancementInfo info = new AdvancementInfo();
            info.id = buffer.func_192575_l();
            info.name = buffer.func_179258_d();
            info.icon = buffer.func_150791_c();
            this.advancements.put(info.id, info);
        }
        FTBLibrary.LOGGER.debug("Received server registries");
    }

    public KnownServerRegistries(MinecraftServer server) {
        this.dimensions = new ArrayList<ResourceLocation>();
        for (ServerWorld level : server.func_212370_w()) {
            this.dimensions.add(level.func_234923_W_().func_240901_a_());
        }
        this.dimensions.sort(null);
        ArrayList<AdvancementInfo> advancementList = new ArrayList<AdvancementInfo>();
        for (Advancement advancement : server.func_191949_aK().func_195438_b()) {
            if (!(advancement.func_192068_c() instanceof DisplayInfoFTBL)) continue;
            AdvancementInfo info = new AdvancementInfo();
            info.id = advancement.func_192067_g();
            info.name = advancement.func_192068_c().func_192297_a();
            info.icon = ((DisplayInfoFTBL)advancement.func_192068_c()).getIconStackFTBL();
            advancementList.add(info);
        }
        advancementList.sort(Comparator.comparing(o -> o.id));
        this.advancements = new LinkedHashMap<ResourceLocation, AdvancementInfo>(advancementList.size());
        for (AdvancementInfo info : advancementList) {
            this.advancements.put(info.id, info);
        }
    }

    public void write(PacketBuffer buffer) {
        buffer.func_150787_b(this.dimensions.size());
        for (ResourceLocation id : this.dimensions) {
            buffer.func_192572_a(id);
        }
        buffer.func_150787_b(this.advancements.size());
        for (AdvancementInfo info : this.advancements.values()) {
            buffer.func_192572_a(info.id);
            buffer.func_179256_a(info.name);
            buffer.func_150788_a(info.icon);
        }
    }

    public static class AdvancementInfo {
        public ResourceLocation id;
        public ITextComponent name;
        public ItemStack icon;
    }
}

