/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.crafting;

import java.util.Random;
import mod.chiselsandbits.api.APIExceptions;
import mod.chiselsandbits.api.IBitAccess;
import mod.chiselsandbits.api.IBitBag;
import mod.chiselsandbits.api.IBitBrush;
import mod.chiselsandbits.api.IBitVisitor;
import mod.chiselsandbits.api.ItemType;
import mod.chiselsandbits.chiseledblock.ItemBlockChiseled;
import mod.chiselsandbits.core.ChiselsAndBits;
import mod.chiselsandbits.helpers.ModUtil;
import mod.chiselsandbits.items.ItemBitBag;
import mod.chiselsandbits.items.ItemChisel;
import mod.chiselsandbits.registry.ModRecipeSerializers;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.SpecialRecipe;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class ChiselBlockCrafting
extends SpecialRecipe {
    public ChiselBlockCrafting(ResourceLocation name) {
        super(name);
    }

    private ChiselBlockInfo getInfo(CraftingInventory inv) {
        ChiselBlockInfo i = new ChiselBlockInfo();
        boolean noDuplicates = true;
        boolean noStrangeitems = true;
        for (int x = 0; x < inv.func_70302_i_(); ++x) {
            ItemStack is = inv.func_70301_a(x);
            if (ModUtil.isEmpty(is)) continue;
            if (is.func_77973_b() instanceof ItemBitBag) {
                if (i.bag_slot != -1) {
                    noDuplicates = false;
                }
                i.bag = is;
                i.bag_slot = x;
                continue;
            }
            if (is.func_77973_b() instanceof ItemChisel) {
                if (i.chisel_slot != -1) {
                    noDuplicates = false;
                }
                i.chisel = is;
                i.chisel_slot = x;
                continue;
            }
            if (is.func_77973_b() instanceof BlockItem) {
                BlockState actingState;
                if (i.block_slot != -1) {
                    noDuplicates = false;
                }
                if ((actingState = ModUtil.getStateFromItem(is)).func_177230_c() != Blocks.field_150350_a) {
                    try {
                        final IBitBrush state = ChiselsAndBits.getApi().createBrushFromState(actingState);
                        IBitAccess item = ChiselsAndBits.getApi().createBitItem(ModUtil.getEmptyStack());
                        assert (item != null);
                        item.visitBits(new IBitVisitor(){

                            @Override
                            public IBitBrush visitBit(int x, int y, int z, IBitBrush currentValue) {
                                return state;
                            }
                        });
                        i.block = item.getBitsAsItem(Direction.EAST, ItemType.CHISLED_BLOCK, false);
                        if (i.block != null) {
                            ModUtil.setStackSize(i.block, ModUtil.getStackSize(is));
                            i.block_slot = x;
                            continue;
                        }
                    }
                    catch (APIExceptions.InvalidBitItem invalidBitItem) {
                        // empty catch block
                    }
                }
            }
            if (is.func_77973_b() instanceof ItemBlockChiseled) {
                if (i.block_slot != -1) {
                    noDuplicates = false;
                }
                i.block = is;
                i.block_slot = x;
                continue;
            }
            noStrangeitems = false;
        }
        i.isValid = i.chisel_slot != -1 && i.bag_slot != -1 && i.block_slot != -1 && noDuplicates && noStrangeitems;
        return i;
    }

    public boolean matches(CraftingInventory inv, World worldIn) {
        return this.getInfo((CraftingInventory)inv).isValid;
    }

    public ItemStack getCraftingResult(CraftingInventory inv) {
        ChiselBlockInfo cbc = this.getInfo(inv);
        cbc.doLogic();
        if (cbc.isValid && cbc.modified) {
            return cbc.bag;
        }
        return ModUtil.getEmptyStack();
    }

    public boolean func_194133_a(int width, int height) {
        return width * height > 3;
    }

    public ItemStack func_77571_b() {
        return ModUtil.getEmptyStack();
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInventory inv) {
        NonNullList list = NonNullList.func_191196_a();
        ChiselBlockInfo cbc = this.getInfo(inv);
        cbc.doLogic();
        boolean damageTools = (Boolean)ChiselsAndBits.getConfig().getServer().damageTools.get();
        for (int x = 0; x < inv.func_70302_i_(); ++x) {
            if (!(!cbc.isValid || x != cbc.chisel_slot || ModUtil.isEmpty(cbc.chisel) || damageTools && cbc.chisel.func_77952_i() >= cbc.chisel.func_77958_k())) {
                list.add((Object)cbc.chisel);
                continue;
            }
            if (cbc.isValid && x == cbc.block_slot && !ModUtil.isEmpty(cbc.block)) {
                ItemStack block = ModUtil.copy(cbc.block);
                ModUtil.setStackSize(block, 1);
                list.add((Object)block);
                continue;
            }
            list.add((Object)ModUtil.getEmptyStack());
        }
        return list;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)ModRecipeSerializers.CHISEL_BLOCK_CRAFTING.get();
    }

    private static class ChiselBlockInfo {
        public ItemStack chisel = ModUtil.getEmptyStack();
        public int chisel_slot = -1;
        public ItemStack bag = ModUtil.getEmptyStack();
        public int bag_slot = -1;
        public ItemStack block = ModUtil.getEmptyStack();
        public int block_slot = -1;
        public boolean isValid;
        public boolean modified = false;

        private ChiselBlockInfo() {
        }

        public void doLogic() {
            this.bag = ModUtil.copy(this.bag);
            this.block = ModUtil.copy(this.block);
            this.chisel = ModUtil.copy(this.chisel);
            try {
                IBitAccess ba = ChiselsAndBits.getApi().createBitItem(this.block);
                Chiseler c = new Chiseler(this.chisel, ChiselsAndBits.getApi().getBitbag(this.bag));
                if (ba == null) {
                    return;
                }
                ba.visitBits(c);
                this.modified = c.modified;
                this.block = !c.isAir ? ba.getBitsAsItem(Direction.NORTH, ItemType.CHISLED_BLOCK, false) : ModUtil.getEmptyStack();
            }
            catch (APIExceptions.InvalidBitItem invalidBitItem) {
                // empty catch block
            }
        }

        private static class Chiseler
        implements IBitVisitor {
            private final ItemStack chisel;
            private final IBitBag bbag;
            private final Random r = new Random();
            final IBitBrush airBrush = ChiselsAndBits.getApi().createBrushFromState(null);
            public boolean isAir = true;
            public boolean modified = false;

            public Chiseler(ItemStack chisel, IBitBag bag) throws APIExceptions.InvalidBitItem {
                this.chisel = chisel;
                this.bbag = bag;
                this.r.setSeed(0L);
            }

            @Override
            public IBitBrush visitBit(int x, int y, int z, IBitBrush currentValue) {
                if (currentValue.isAir()) {
                    return currentValue;
                }
                boolean damageTools = (Boolean)ChiselsAndBits.getConfig().getServer().damageTools.get();
                if (this.chisel.func_77952_i() < this.chisel.func_77958_k() || !damageTools) {
                    ItemStack is;
                    if (damageTools) {
                        ModUtil.damageItem(this.chisel, this.r);
                    }
                    if ((is = currentValue.getItemStack(1)) != null) {
                        for (int idx = 0; idx < this.bbag.getSlots(); ++idx) {
                            if (!ModUtil.isEmpty(this.bbag.insertItem(idx, is, false))) continue;
                            this.modified = true;
                            return this.airBrush;
                        }
                    }
                }
                this.isAir = false;
                return currentValue;
            }
        }
    }
}

