/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.data.tags;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.ldtteam.datagenerators.tags.TagJson;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import mod.chiselsandbits.utils.Constants;
import net.minecraft.block.Block;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraftforge.registries.ForgeRegistryEntry;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractChiselableTagGenerator
implements IDataProvider {
    private final DataGenerator generator;
    private final Mode mode;
    private final List<Block> blocks;

    protected AbstractChiselableTagGenerator(DataGenerator generator, Mode mode, List<Block> blocks) {
        this.generator = generator;
        this.mode = mode;
        this.blocks = blocks;
    }

    public void func_200398_a(DirectoryCache cache) throws IOException {
        TagJson json = new TagJson();
        json.setValues(this.blocks.stream().map(ForgeRegistryEntry::getRegistryName).filter(Objects::nonNull).map(Object::toString).collect(Collectors.toList()));
        Path tagFolder = this.generator.func_200391_b().resolve("data/chiselsandbits/tags/blocks/");
        Path chiselableTagPath = tagFolder.resolve("chiselable/" + this.mode.toString().toLowerCase() + ".json");
        IDataProvider.func_218426_a((Gson)Constants.DataGenerator.GSON, (DirectoryCache)cache, (JsonElement)json.serialize(), (Path)chiselableTagPath);
    }

    public String func_200397_b() {
        return StringUtils.capitalize((String)this.mode.toString()) + " chiselable tag generator";
    }

    public static enum Mode {
        FORCED,
        BLOCKED;

    }
}

