/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.render.helpers;

import mod.chiselsandbits.render.helpers.ModelLightMapReader;
import mod.chiselsandbits.render.helpers.ModelUVReader;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;

public class ModelQuadLayer {
    public float[] uvs;
    public TextureAtlasSprite sprite;
    public int light;
    public int color;
    public int tint;

    public static class ModelQuadLayerBuilder {
        public final ModelQuadLayer cache = new ModelQuadLayer();
        public final ModelLightMapReader lv;
        public ModelUVReader uvr;

        public ModelQuadLayerBuilder(TextureAtlasSprite sprite, int uCoord, int vCoord) {
            this.cache.sprite = sprite;
            this.lv = new ModelLightMapReader();
            this.uvr = new ModelUVReader(sprite, uCoord, vCoord);
        }

        public ModelQuadLayer build(int stateid, int color, int lightValue) {
            this.cache.light = Math.max(lightValue, this.lv.lv);
            this.cache.uvs = this.uvr.quadUVs;
            int n = this.cache.color = this.cache.tint != -1 ? color : -1;
            if (0 <= this.cache.tint && this.cache.tint <= 255) {
                this.cache.color = -1;
                this.cache.tint = stateid << 8 | this.cache.tint;
            } else {
                this.cache.tint = -1;
            }
            return this.cache;
        }
    }
}

