/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedpipes.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.Direction;

public class CubeBuilder {
    public static final CubeBuilder INSTANCE = new CubeBuilder();
    private final byte[] uvRotations = new byte[Direction.values().length];

    private CubeBuilder() {
    }

    public void putCube(MatrixStack matrixStack, IVertexBuilder builder, float x1, float y1, float z1, float x2, float y2, float z2, int r, int g, int b, int a, int light, TextureAtlasSprite sprite) {
        this.putCube(matrixStack, builder, x1, y1, z1, x2, y2, z2, r, g, b, a, light, sprite, null);
    }

    public void putCube(MatrixStack matrixStack, IVertexBuilder builder, float x1, float y1, float z1, float x2, float y2, float z2, int r, int g, int b, int a, int light, TextureAtlasSprite sprite, @Nullable Direction exclude) {
        matrixStack.func_227860_a_();
        for (Direction face : Direction.values()) {
            if (face == exclude) continue;
            this.putFace(matrixStack, builder, x1, y1, z1, x2, y2, z2, r, g, b, a, light, sprite, face);
        }
        matrixStack.func_227865_b_();
    }

    public void putFace(MatrixStack matrixStack, IVertexBuilder builder, float x1, float y1, float z1, float x2, float y2, float z2, int r, int g, int b, int a, int light, TextureAtlasSprite sprite, Direction face) {
        UvVector uv = this.getDefaultUv(face, sprite, x1, y1, z1, x2, y2, z2);
        switch (face) {
            case DOWN: {
                this.putVertexTR(builder, matrixStack, face, r, g, b, a, light, x2, y1, z1, uv);
                this.putVertexBR(builder, matrixStack, face, r, g, b, a, light, x2, y1, z2, uv);
                this.putVertexBL(builder, matrixStack, face, r, g, b, a, light, x1, y1, z2, uv);
                this.putVertexTL(builder, matrixStack, face, r, g, b, a, light, x1, y1, z1, uv);
                break;
            }
            case UP: {
                this.putVertexTL(builder, matrixStack, face, r, g, b, a, light, x1, y2, z1, uv);
                this.putVertexBL(builder, matrixStack, face, r, g, b, a, light, x1, y2, z2, uv);
                this.putVertexBR(builder, matrixStack, face, r, g, b, a, light, x2, y2, z2, uv);
                this.putVertexTR(builder, matrixStack, face, r, g, b, a, light, x2, y2, z1, uv);
                break;
            }
            case NORTH: {
                this.putVertexBR(builder, matrixStack, face, r, g, b, a, light, x2, y2, z1, uv);
                this.putVertexTR(builder, matrixStack, face, r, g, b, a, light, x2, y1, z1, uv);
                this.putVertexTL(builder, matrixStack, face, r, g, b, a, light, x1, y1, z1, uv);
                this.putVertexBL(builder, matrixStack, face, r, g, b, a, light, x1, y2, z1, uv);
                break;
            }
            case SOUTH: {
                this.putVertexBL(builder, matrixStack, face, r, g, b, a, light, x1, y2, z2, uv);
                this.putVertexTL(builder, matrixStack, face, r, g, b, a, light, x1, y1, z2, uv);
                this.putVertexTR(builder, matrixStack, face, r, g, b, a, light, x2, y1, z2, uv);
                this.putVertexBR(builder, matrixStack, face, r, g, b, a, light, x2, y2, z2, uv);
                break;
            }
            case WEST: {
                this.putVertexTL(builder, matrixStack, face, r, g, b, a, light, x1, y1, z1, uv);
                this.putVertexTR(builder, matrixStack, face, r, g, b, a, light, x1, y1, z2, uv);
                this.putVertexBR(builder, matrixStack, face, r, g, b, a, light, x1, y2, z2, uv);
                this.putVertexBL(builder, matrixStack, face, r, g, b, a, light, x1, y2, z1, uv);
                break;
            }
            case EAST: {
                this.putVertexBR(builder, matrixStack, face, r, g, b, a, light, x2, y2, z1, uv);
                this.putVertexBL(builder, matrixStack, face, r, g, b, a, light, x2, y2, z2, uv);
                this.putVertexTL(builder, matrixStack, face, r, g, b, a, light, x2, y1, z2, uv);
                this.putVertexTR(builder, matrixStack, face, r, g, b, a, light, x2, y1, z1, uv);
            }
        }
    }

    private UvVector getDefaultUv(Direction face, TextureAtlasSprite texture, float x1, float y1, float z1, float x2, float y2, float z2) {
        UvVector uv = new UvVector();
        switch (face) {
            case DOWN: {
                uv.u1 = texture.func_94214_a((double)(x1 * 16.0f));
                uv.v1 = texture.func_94207_b((double)(z1 * 16.0f));
                uv.u2 = texture.func_94214_a((double)(x2 * 16.0f));
                uv.v2 = texture.func_94207_b((double)(z2 * 16.0f));
                break;
            }
            case UP: {
                uv.u1 = texture.func_94214_a((double)(x1 * 16.0f));
                uv.v1 = texture.func_94207_b((double)(z1 * 16.0f));
                uv.u2 = texture.func_94214_a((double)(x2 * 16.0f));
                uv.v2 = texture.func_94207_b((double)(z2 * 16.0f));
                break;
            }
            case NORTH: {
                uv.u1 = texture.func_94214_a((double)(x1 * 16.0f));
                uv.v1 = texture.func_94207_b((double)(16.0f - y1 * 16.0f));
                uv.u2 = texture.func_94214_a((double)(x2 * 16.0f));
                uv.v2 = texture.func_94207_b((double)(16.0f - y2 * 16.0f));
                break;
            }
            case SOUTH: {
                uv.u1 = texture.func_94214_a((double)(x1 * 16.0f));
                uv.v1 = texture.func_94207_b((double)(16.0f - y1 * 16.0f));
                uv.u2 = texture.func_94214_a((double)(x2 * 16.0f));
                uv.v2 = texture.func_94207_b((double)(16.0f - y2 * 16.0f));
                break;
            }
            case WEST: {
                uv.u1 = texture.func_94214_a((double)(z1 * 16.0f));
                uv.v1 = texture.func_94207_b((double)(16.0f - y1 * 16.0f));
                uv.u2 = texture.func_94214_a((double)(z2 * 16.0f));
                uv.v2 = texture.func_94207_b((double)(16.0f - y2 * 16.0f));
                break;
            }
            case EAST: {
                uv.u1 = texture.func_94214_a((double)(z2 * 16.0f));
                uv.v1 = texture.func_94207_b((double)(16.0f - y1 * 16.0f));
                uv.u2 = texture.func_94214_a((double)(z1 * 16.0f));
                uv.v2 = texture.func_94207_b((double)(16.0f - y2 * 16.0f));
            }
        }
        return uv;
    }

    private void putVertexTL(IVertexBuilder builder, MatrixStack matrixStack, Direction face, int r, int g, int b, int a, int light, float x, float y, float z, UvVector uv) {
        float v;
        float u;
        switch (this.uvRotations[face.ordinal()]) {
            default: {
                u = uv.u1;
                v = uv.v1;
                break;
            }
            case 1: {
                u = uv.u1;
                v = uv.v2;
                break;
            }
            case 2: {
                u = uv.u2;
                v = uv.v2;
                break;
            }
            case 3: {
                u = uv.u2;
                v = uv.v1;
            }
        }
        this.putVertex(builder, matrixStack, r, g, b, a, light, x, y, z, u, v);
    }

    private void putVertexTR(IVertexBuilder builder, MatrixStack matrixStack, Direction face, int r, int g, int b, int a, int light, float x, float y, float z, UvVector uv) {
        float v;
        float u;
        switch (this.uvRotations[face.ordinal()]) {
            default: {
                u = uv.u2;
                v = uv.v1;
                break;
            }
            case 1: {
                u = uv.u1;
                v = uv.v1;
                break;
            }
            case 2: {
                u = uv.u1;
                v = uv.v2;
                break;
            }
            case 3: {
                u = uv.u2;
                v = uv.v2;
            }
        }
        this.putVertex(builder, matrixStack, r, g, b, a, light, x, y, z, u, v);
    }

    private void putVertexBR(IVertexBuilder builder, MatrixStack matrixStack, Direction face, int r, int g, int b, int a, int light, float x, float y, float z, UvVector uv) {
        float v;
        float u;
        switch (this.uvRotations[face.ordinal()]) {
            default: {
                u = uv.u2;
                v = uv.v2;
                break;
            }
            case 1: {
                u = uv.u2;
                v = uv.v1;
                break;
            }
            case 2: {
                u = uv.u1;
                v = uv.v1;
                break;
            }
            case 3: {
                u = uv.u1;
                v = uv.v2;
            }
        }
        this.putVertex(builder, matrixStack, r, g, b, a, light, x, y, z, u, v);
    }

    private void putVertexBL(IVertexBuilder builder, MatrixStack matrixStack, Direction face, int r, int g, int b, int a, int light, float x, float y, float z, UvVector uv) {
        float v;
        float u;
        switch (this.uvRotations[face.ordinal()]) {
            default: {
                u = uv.u1;
                v = uv.v2;
                break;
            }
            case 1: {
                u = uv.u2;
                v = uv.v2;
                break;
            }
            case 2: {
                u = uv.u2;
                v = uv.v1;
                break;
            }
            case 3: {
                u = uv.u1;
                v = uv.v1;
            }
        }
        this.putVertex(builder, matrixStack, r, g, b, a, light, x, y, z, u, v);
    }

    private void putVertex(IVertexBuilder builder, MatrixStack matrixStack, int r, int g, int b, int a, int light, float x, float y, float z, float u, float v) {
        builder.func_227888_a_(matrixStack.func_227866_c_().func_227870_a_(), x, y, z).func_225586_a_(r, g, b, a).func_225583_a_(u, v).func_227886_a_(light).func_181675_d();
    }

    private static final class UvVector {
        float u1;
        float u2;
        float v1;
        float v2;

        private UvVector() {
        }
    }
}

