/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedpipes.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.refinedmods.refinedpipes.container.ExtractorAttachmentContainer;
import com.refinedmods.refinedpipes.network.pipe.attachment.extractor.BlacklistWhitelist;
import com.refinedmods.refinedpipes.network.pipe.attachment.extractor.RedstoneMode;
import com.refinedmods.refinedpipes.network.pipe.attachment.extractor.RoutingMode;
import com.refinedmods.refinedpipes.screen.BaseScreen;
import com.refinedmods.refinedpipes.screen.widget.IconButton;
import com.refinedmods.refinedpipes.screen.widget.IconButtonPreset;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.client.gui.GuiUtils;

public class ExtractorAttachmentScreen
extends BaseScreen<ExtractorAttachmentContainer> {
    private static final ResourceLocation RESOURCE = new ResourceLocation("refinedpipes", "textures/gui/extractor_attachment.png");
    private final List<ITextComponent> tooltip = new ArrayList<ITextComponent>();
    private Button redstoneModeButton;
    private Button blacklistWhitelistButton;
    @Nullable
    private Button routingModeButton;
    @Nullable
    private Button exactModeButton;
    @Nullable
    private Button plusButton;
    @Nullable
    private Button minusButton;

    public ExtractorAttachmentScreen(ExtractorAttachmentContainer container, PlayerInventory inv, ITextComponent title) {
        super(container, inv, title);
        this.field_146999_f = 176;
        this.field_147000_g = 193;
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        this.redstoneModeButton = (Button)this.func_230480_a_((Widget)new IconButton(this.field_147003_i + 32, this.field_147009_r + 76, IconButtonPreset.NORMAL, this.getRedstoneModeX(((ExtractorAttachmentContainer)this.field_147002_h).getRedstoneMode()), 61, (ITextComponent)this.getRedstoneModeText(((ExtractorAttachmentContainer)this.field_147002_h).getRedstoneMode()), btn -> this.setRedstoneMode((IconButton)btn, ((ExtractorAttachmentContainer)this.field_147002_h).getRedstoneMode().next())));
        this.redstoneModeButton.field_230693_o_ = ((ExtractorAttachmentContainer)this.field_147002_h).getExtractorAttachmentType().getCanSetRedstoneMode();
        this.blacklistWhitelistButton = (Button)this.func_230480_a_((Widget)new IconButton(this.field_147003_i + 55, this.field_147009_r + 76, IconButtonPreset.NORMAL, this.getBlacklistWhitelistX(((ExtractorAttachmentContainer)this.field_147002_h).getBlacklistWhitelist()), 82, (ITextComponent)this.getBlacklistWhitelistText(((ExtractorAttachmentContainer)this.field_147002_h).getBlacklistWhitelist()), btn -> this.setBlacklistWhitelist((IconButton)btn, ((ExtractorAttachmentContainer)this.field_147002_h).getBlacklistWhitelist().next())));
        this.blacklistWhitelistButton.field_230693_o_ = ((ExtractorAttachmentContainer)this.field_147002_h).getExtractorAttachmentType().getCanSetWhitelistBlacklist();
        this.exactModeButton = (Button)this.func_230480_a_((Widget)new IconButton(this.field_147003_i + 78, this.field_147009_r + 76, IconButtonPreset.NORMAL, this.getExactModeX(((ExtractorAttachmentContainer)this.field_147002_h).isExactMode()), 103, (ITextComponent)this.getExactModeText(((ExtractorAttachmentContainer)this.field_147002_h).isExactMode()), btn -> this.setExactMode((IconButton)btn, !((ExtractorAttachmentContainer)this.field_147002_h).isExactMode())));
        this.exactModeButton.field_230693_o_ = ((ExtractorAttachmentContainer)this.field_147002_h).getExtractorAttachmentType().getCanSetExactMode();
        if (!((ExtractorAttachmentContainer)this.field_147002_h).isFluidMode()) {
            this.routingModeButton = (Button)this.func_230480_a_((Widget)new IconButton(this.field_147003_i + 101, this.field_147009_r + 76, IconButtonPreset.NORMAL, this.getRoutingModeX(((ExtractorAttachmentContainer)this.field_147002_h).getRoutingMode()), 194, (ITextComponent)this.getRoutingModeText(((ExtractorAttachmentContainer)this.field_147002_h).getRoutingMode()), btn -> this.setRoutingMode((IconButton)btn, ((ExtractorAttachmentContainer)this.field_147002_h).getRoutingMode().next())));
            this.routingModeButton.field_230693_o_ = ((ExtractorAttachmentContainer)this.field_147002_h).getExtractorAttachmentType().getCanSetWhitelistBlacklist();
            this.plusButton = (Button)this.func_230480_a_((Widget)new IconButton(this.field_147003_i + 125, this.field_147009_r + 76 - 3, IconButtonPreset.SMALL, 198, 19, (ITextComponent)new StringTextComponent("+"), btn -> this.updateStackSize(1)));
            this.minusButton = (Button)this.func_230480_a_((Widget)new IconButton(this.field_147003_i + 125, this.field_147009_r + 76 + 14 - 3, IconButtonPreset.SMALL, 198, 34, (ITextComponent)new StringTextComponent("-"), btn -> this.updateStackSize(-1)));
            this.minusButton.field_230693_o_ = ((ExtractorAttachmentContainer)this.field_147002_h).getStackSize() > 0;
            this.plusButton.field_230693_o_ = ((ExtractorAttachmentContainer)this.field_147002_h).getStackSize() < ((ExtractorAttachmentContainer)this.field_147002_h).getExtractorAttachmentType().getItemsToExtract();
        }
    }

    private void updateStackSize(int amount) {
        int newAmount;
        if (ExtractorAttachmentScreen.func_231173_s_()) {
            amount *= 4;
        }
        if ((newAmount = ((ExtractorAttachmentContainer)this.field_147002_h).getStackSize() + amount) < 0) {
            newAmount = 0;
        }
        if (newAmount > ((ExtractorAttachmentContainer)this.field_147002_h).getExtractorAttachmentType().getItemsToExtract()) {
            newAmount = ((ExtractorAttachmentContainer)this.field_147002_h).getExtractorAttachmentType().getItemsToExtract();
        }
        this.minusButton.field_230693_o_ = newAmount > 0;
        this.plusButton.field_230693_o_ = newAmount < ((ExtractorAttachmentContainer)this.field_147002_h).getExtractorAttachmentType().getItemsToExtract();
        ((ExtractorAttachmentContainer)this.field_147002_h).setStackSize(newAmount);
    }

    private int getRedstoneModeX(RedstoneMode redstoneMode) {
        switch (redstoneMode) {
            case IGNORED: {
                return 219;
            }
            case HIGH: {
                return 177;
            }
            case LOW: {
                return 198;
            }
        }
        return 0;
    }

    private IFormattableTextComponent getRedstoneModeText(RedstoneMode redstoneMode) {
        return new TranslationTextComponent("misc.refinedpipes.redstone_mode." + redstoneMode.toString().toLowerCase());
    }

    private void setRedstoneMode(IconButton button, RedstoneMode redstoneMode) {
        button.func_238482_a_((ITextComponent)this.getRedstoneModeText(redstoneMode));
        button.setOverlayTexX(this.getRedstoneModeX(redstoneMode));
        ((ExtractorAttachmentContainer)this.field_147002_h).setRedstoneMode(redstoneMode);
    }

    private int getBlacklistWhitelistX(BlacklistWhitelist blacklistWhitelist) {
        switch (blacklistWhitelist) {
            case BLACKLIST: {
                return 198;
            }
            case WHITELIST: {
                return 177;
            }
        }
        return 0;
    }

    private IFormattableTextComponent getBlacklistWhitelistText(BlacklistWhitelist blacklistWhitelist) {
        return new TranslationTextComponent("misc.refinedpipes.mode." + blacklistWhitelist.toString().toLowerCase());
    }

    private void setBlacklistWhitelist(IconButton button, BlacklistWhitelist blacklistWhitelist) {
        button.func_238482_a_((ITextComponent)this.getBlacklistWhitelistText(blacklistWhitelist));
        button.setOverlayTexX(this.getBlacklistWhitelistX(blacklistWhitelist));
        ((ExtractorAttachmentContainer)this.field_147002_h).setBlacklistWhitelist(blacklistWhitelist);
    }

    private int getRoutingModeX(RoutingMode routingMode) {
        switch (routingMode) {
            case NEAREST: {
                return 0;
            }
            case FURTHEST: {
                return 21;
            }
            case RANDOM: {
                return 42;
            }
            case ROUND_ROBIN: {
                return 63;
            }
        }
        return 0;
    }

    private IFormattableTextComponent getRoutingModeText(RoutingMode routingMode) {
        return new TranslationTextComponent("misc.refinedpipes.routing_mode." + routingMode.toString().toLowerCase());
    }

    private void setRoutingMode(IconButton button, RoutingMode routingMode) {
        button.func_238482_a_((ITextComponent)this.getRoutingModeText(routingMode));
        button.setOverlayTexX(this.getRoutingModeX(routingMode));
        ((ExtractorAttachmentContainer)this.field_147002_h).setRoutingMode(routingMode);
    }

    private int getExactModeX(boolean exactMode) {
        return exactMode ? 177 : 198;
    }

    private IFormattableTextComponent getExactModeText(boolean exactMode) {
        return new TranslationTextComponent("misc.refinedpipes.exact_mode." + (exactMode ? "on" : "off"));
    }

    private void setExactMode(IconButton button, boolean exactMode) {
        button.func_238482_a_((ITextComponent)this.getExactModeText(exactMode));
        button.setOverlayTexX(this.getExactModeX(exactMode));
        ((ExtractorAttachmentContainer)this.field_147002_h).setExactMode(exactMode);
    }

    @Override
    protected void func_230451_b_(MatrixStack matrixStack, int mouseX, int mouseY) {
        this.field_230712_o_.func_238421_b_(matrixStack, this.field_230704_d_.getString(), 7.0f, 7.0f, 0x404040);
        this.field_230712_o_.func_238421_b_(matrixStack, I18n.func_135052_a((String)"container.inventory", (Object[])new Object[0]), 7.0f, 99.0f, 0x404040);
        if (!((ExtractorAttachmentContainer)this.field_147002_h).isFluidMode()) {
            this.field_230712_o_.func_238421_b_(matrixStack, "" + ((ExtractorAttachmentContainer)this.field_147002_h).getStackSize(), 143.0f, 83.0f, 0x404040);
        }
        this.func_230459_a_(matrixStack, mouseX - this.field_147003_i, mouseY - this.field_147009_r);
        this.tooltip.clear();
        if (this.blacklistWhitelistButton.func_230449_g_()) {
            this.tooltip.add((ITextComponent)new TranslationTextComponent("misc.refinedpipes.mode"));
            this.tooltip.add((ITextComponent)this.getBlacklistWhitelistText(((ExtractorAttachmentContainer)this.field_147002_h).getBlacklistWhitelist()).func_240699_a_(TextFormatting.GRAY));
        } else if (this.redstoneModeButton.func_230449_g_()) {
            this.tooltip.add((ITextComponent)new TranslationTextComponent("misc.refinedpipes.redstone_mode"));
            this.tooltip.add((ITextComponent)this.getRedstoneModeText(((ExtractorAttachmentContainer)this.field_147002_h).getRedstoneMode()).func_240699_a_(TextFormatting.GRAY));
        } else if (this.routingModeButton != null && this.routingModeButton.func_230449_g_()) {
            this.tooltip.add((ITextComponent)new TranslationTextComponent("misc.refinedpipes.routing_mode"));
            this.tooltip.add((ITextComponent)this.getRoutingModeText(((ExtractorAttachmentContainer)this.field_147002_h).getRoutingMode()).func_240699_a_(TextFormatting.GRAY));
        } else if (this.exactModeButton.func_230449_g_()) {
            this.tooltip.add((ITextComponent)new TranslationTextComponent("misc.refinedpipes.exact_mode"));
            this.tooltip.add((ITextComponent)this.getExactModeText(((ExtractorAttachmentContainer)this.field_147002_h).isExactMode()).func_240699_a_(TextFormatting.GRAY));
        }
        if (!this.tooltip.isEmpty()) {
            GuiUtils.drawHoveringText((MatrixStack)matrixStack, this.tooltip, (int)(mouseX - this.field_147003_i), (int)(mouseY - this.field_147009_r), (int)this.field_230708_k_, (int)this.field_230709_l_, (int)-1, (FontRenderer)Minecraft.func_71410_x().field_71466_p);
        }
        super.func_230451_b_(matrixStack, mouseX, mouseY);
    }

    @Override
    protected void func_230450_a_(MatrixStack matrixStack, float partialTicks, int mouseX, int mouseY) {
        this.func_230446_a_(matrixStack);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_230706_i_.func_110434_K().func_110577_a(RESOURCE);
        int i = (this.field_230708_k_ - this.field_146999_f) / 2;
        int j = (this.field_230709_l_ - this.field_147000_g) / 2;
        this.func_238474_b_(matrixStack, i, j, 0, 0, this.field_146999_f, this.field_147000_g);
        int x = 43;
        int y = 18;
        for (int filterSlotId = 1; filterSlotId <= 15; ++filterSlotId) {
            if (filterSlotId > ((ExtractorAttachmentContainer)this.field_147002_h).getExtractorAttachmentType().getFilterSlots()) {
                this.func_238474_b_(matrixStack, i + x, j + y, 198, 0, 18, 18);
            }
            if (filterSlotId % 5 == 0) {
                x = 43;
                y += 18;
                continue;
            }
            x += 18;
        }
        super.func_230450_a_(matrixStack, partialTicks, mouseX, mouseY);
    }
}

