/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mrcrayfish.furniture.block.FurnitureWaterloggedBlock;
import com.mrcrayfish.furniture.block.UpgradedGateBlock;
import com.mrcrayfish.furniture.common.ModTags;
import com.mrcrayfish.furniture.util.VoxelShapeHelper;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.MobEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.DoorHingeSide;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;

public class UpgradedFenceBlock
extends FurnitureWaterloggedBlock {
    public static final BooleanProperty NORTH = BooleanProperty.func_177716_a((String)"north");
    public static final BooleanProperty EAST = BooleanProperty.func_177716_a((String)"east");
    public static final BooleanProperty SOUTH = BooleanProperty.func_177716_a((String)"south");
    public static final BooleanProperty WEST = BooleanProperty.func_177716_a((String)"west");
    public final ImmutableMap<BlockState, VoxelShape> SHAPES;
    public final ImmutableMap<BlockState, VoxelShape> COLLISION_SHAPES;

    public UpgradedFenceBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((Property)NORTH, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)EAST, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)SOUTH, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)WEST, (Comparable)Boolean.valueOf(false)));
        this.SHAPES = this.generateShapes((ImmutableList<BlockState>)this.func_176194_O().func_177619_a(), false);
        this.COLLISION_SHAPES = this.generateShapes((ImmutableList<BlockState>)this.func_176194_O().func_177619_a(), true);
    }

    private ImmutableMap<BlockState, VoxelShape> generateShapes(ImmutableList<BlockState> states, boolean collision) {
        VoxelShape FENCE_POST = Block.func_208617_a((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)17.0, (double)10.0);
        VoxelShape[] POST_SIDE = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.func_208617_a((double)0.75, (double)0.0, (double)6.5, (double)4.75, (double)16.0, (double)9.5), Direction.WEST));
        VoxelShape[] POST_MIDDLE = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.func_208617_a((double)6.01, (double)0.0, (double)6.5, (double)8.0, (double)16.0, (double)9.5), Direction.WEST));
        VoxelShape[] FRAME_BOTTOM = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.func_208617_a((double)0.0, (double)2.5, (double)7.0, (double)6.0, (double)5.5, (double)9.0), Direction.WEST));
        VoxelShape[] FRAME_TOP = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.func_208617_a((double)0.0, (double)10.5, (double)7.0, (double)6.01, (double)13.5, (double)9.0), Direction.WEST));
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (BlockState state : states) {
            boolean north = (Boolean)state.func_177229_b((Property)NORTH);
            boolean east = (Boolean)state.func_177229_b((Property)EAST);
            boolean south = (Boolean)state.func_177229_b((Property)SOUTH);
            boolean west = (Boolean)state.func_177229_b((Property)WEST);
            boolean post = !(north && !east && south && !west || !north && east && !south && west);
            ArrayList<VoxelShape> shapes = new ArrayList<VoxelShape>();
            if (post) {
                shapes.add(this.applyCollision(FENCE_POST, collision));
            }
            if (north) {
                shapes.add(this.applyCollision(POST_SIDE[Direction.NORTH.func_176736_b()], collision));
                shapes.add(this.applyCollision(POST_MIDDLE[Direction.NORTH.func_176736_b()], collision));
                shapes.add(FRAME_BOTTOM[Direction.NORTH.func_176736_b()]);
                shapes.add(FRAME_TOP[Direction.NORTH.func_176736_b()]);
            }
            if (east) {
                shapes.add(this.applyCollision(POST_SIDE[Direction.EAST.func_176736_b()], collision));
                shapes.add(this.applyCollision(POST_MIDDLE[Direction.EAST.func_176736_b()], collision));
                shapes.add(FRAME_BOTTOM[Direction.EAST.func_176736_b()]);
                shapes.add(FRAME_TOP[Direction.EAST.func_176736_b()]);
            }
            if (south) {
                shapes.add(this.applyCollision(POST_SIDE[Direction.SOUTH.func_176736_b()], collision));
                shapes.add(this.applyCollision(POST_MIDDLE[Direction.SOUTH.func_176736_b()], collision));
                shapes.add(FRAME_BOTTOM[Direction.SOUTH.func_176736_b()]);
                shapes.add(FRAME_TOP[Direction.SOUTH.func_176736_b()]);
            }
            if (west) {
                shapes.add(this.applyCollision(POST_SIDE[Direction.WEST.func_176736_b()], collision));
                shapes.add(this.applyCollision(POST_MIDDLE[Direction.WEST.func_176736_b()], collision));
                shapes.add(FRAME_BOTTOM[Direction.WEST.func_176736_b()]);
                shapes.add(FRAME_TOP[Direction.WEST.func_176736_b()]);
            }
            builder.put((Object)state, (Object)VoxelShapeHelper.combineAll(shapes));
        }
        return builder.build();
    }

    private VoxelShape applyCollision(VoxelShape shape, boolean collision) {
        if (collision) {
            shape = VoxelShapeHelper.setMaxHeight(shape, 1.5);
            shape = VoxelShapeHelper.limitHorizontal(shape);
        }
        return shape;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader reader, BlockPos pos, ISelectionContext context) {
        return (VoxelShape)this.SHAPES.get((Object)state);
    }

    public VoxelShape func_196247_c(BlockState state, IBlockReader reader, BlockPos pos) {
        return (VoxelShape)this.SHAPES.get((Object)state);
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader reader, BlockPos pos, ISelectionContext context) {
        return (VoxelShape)this.COLLISION_SHAPES.get((Object)state);
    }

    @Override
    public BlockState func_196258_a(BlockItemUseContext context) {
        return this.getFenceState(super.func_196258_a(context), (IWorld)context.func_195991_k(), context.func_195995_a());
    }

    public BlockState func_196271_a(BlockState state, Direction direction, BlockState newState, IWorld world, BlockPos pos, BlockPos newPos) {
        return this.getFenceState(state, world, pos);
    }

    private BlockState getFenceState(BlockState state, IWorld world, BlockPos pos) {
        boolean north = this.canConnectToBlock(world, pos, Direction.NORTH);
        boolean east = this.canConnectToBlock(world, pos, Direction.EAST);
        boolean south = this.canConnectToBlock(world, pos, Direction.SOUTH);
        boolean west = this.canConnectToBlock(world, pos, Direction.WEST);
        return (BlockState)((BlockState)((BlockState)((BlockState)state.func_206870_a((Property)NORTH, (Comparable)Boolean.valueOf(north))).func_206870_a((Property)EAST, (Comparable)Boolean.valueOf(east))).func_206870_a((Property)SOUTH, (Comparable)Boolean.valueOf(south))).func_206870_a((Property)WEST, (Comparable)Boolean.valueOf(west));
    }

    private boolean canConnectToBlock(IWorld world, BlockPos pos, Direction direction) {
        Block block;
        BlockPos offsetPos = pos.func_177972_a(direction);
        BlockState offsetState = world.func_180495_p(offsetPos);
        boolean flag1 = false;
        if (offsetState.func_177230_c() instanceof UpgradedGateBlock) {
            Direction gateDirection = (Direction)offsetState.func_177229_b((Property)UpgradedGateBlock.DIRECTION);
            DoorHingeSide hingeSide = (DoorHingeSide)offsetState.func_177229_b(UpgradedGateBlock.HINGE);
            Direction hingeFace = hingeSide == DoorHingeSide.LEFT ? gateDirection.func_176735_f() : gateDirection.func_176746_e();
            flag1 = direction == hingeFace.func_176734_d() || (Boolean)offsetState.func_177229_b((Property)UpgradedGateBlock.DOUBLE) == false && direction.func_176740_k() != gateDirection.func_176740_k();
        }
        boolean flag = (block = offsetState.func_177230_c()).func_203417_a(ModTags.Blocks.UPGRADED_FENCES) && block.func_203417_a(ModTags.Blocks.PICKET_FENCES) == this.func_176223_P().func_235714_a_(ModTags.Blocks.PICKET_FENCES);
        return !UpgradedFenceBlock.func_220073_a((Block)block) && offsetState.func_224755_d((IBlockReader)world, offsetPos, direction.func_176734_d()) || flag || flag1;
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{NORTH});
        builder.func_206894_a(new Property[]{EAST});
        builder.func_206894_a(new Property[]{SOUTH});
        builder.func_206894_a(new Property[]{WEST});
    }

    @Nullable
    public PathNodeType getAiPathNodeType(BlockState state, IBlockReader world, BlockPos pos, @Nullable MobEntity entity) {
        return PathNodeType.FENCE;
    }
}

