/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.events;

import com.mojang.blaze3d.matrix.MatrixStack;
import de.maxhenkel.car.Main;
import de.maxhenkel.car.corelib.math.MathUtils;
import de.maxhenkel.car.entity.car.base.EntityGenericCar;
import de.maxhenkel.car.entity.car.base.EntityVehicleBase;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@OnlyIn(value=Dist.CLIENT)
public class RenderEvents {
    private Minecraft mc = Minecraft.func_71410_x();

    @SubscribeEvent
    public void onRender(EntityViewRenderEvent.CameraSetup evt) {
        if (this.getCar() != null && !this.mc.field_71474_y.func_243230_g().func_243192_a()) {
            evt.getInfo().func_216782_a(-evt.getInfo().func_216779_a((Double)Main.CLIENT_CONFIG.carZoom.get() - 4.0), 0.0, 0.0);
        }
    }

    @SubscribeEvent
    public void onRender(InputEvent.MouseScrollEvent evt) {
        if (this.getCar() != null && !this.mc.field_71474_y.func_243230_g().func_243192_a()) {
            Main.CLIENT_CONFIG.carZoom.set((Object)Math.max(1.0, Math.min(20.0, (Double)Main.CLIENT_CONFIG.carZoom.get() - evt.getScrollDelta())));
            Main.CLIENT_CONFIG.carZoom.save();
            evt.setCanceled(true);
        }
    }

    private EntityGenericCar getCar() {
        Entity e = this.mc.field_71439_g.func_184187_bx();
        if (e instanceof EntityGenericCar) {
            return (EntityGenericCar)e;
        }
        return null;
    }

    @SubscribeEvent
    public void onRender(RenderGameOverlayEvent evt) {
        if (!evt.getType().equals((Object)RenderGameOverlayEvent.ElementType.EXPERIENCE)) {
            return;
        }
        ClientPlayerEntity player = this.mc.field_71439_g;
        EntityGenericCar car = this.getCar();
        if (car == null) {
            return;
        }
        if (player.equals((Object)car.getDriver())) {
            evt.setCanceled(true);
            this.renderFuelBar(evt.getMatrixStack(), (float)car.getFuelAmount() / (float)car.getMaxFuel());
            this.renderSpeed(evt.getMatrixStack(), car.getKilometerPerHour());
        }
    }

    public void renderFuelBar(MatrixStack matrixStack, float percent) {
        percent = MathHelper.func_76131_a((float)percent, (float)0.0f, (float)1.0f);
        int x = this.mc.func_228018_at_().func_198107_o() / 2 - 91;
        this.mc.func_110434_K().func_110577_a(AbstractGui.field_230665_h_);
        int k = this.mc.func_228018_at_().func_198087_p() - 32 + 3;
        this.mc.field_71456_v.func_238474_b_(matrixStack, x, k, 0, 64, 182, 5);
        int j = (int)(percent * 182.0f);
        if (j > 0) {
            this.mc.field_71456_v.func_238474_b_(matrixStack, x, k, 0, 69, j, 5);
        }
    }

    public void renderSpeed(MatrixStack matrixStack, float speed) {
        String s = String.valueOf(MathUtils.round(Math.abs(speed), 2));
        int i1 = (this.mc.func_228018_at_().func_198107_o() - this.mc.field_71456_v.func_175179_f().func_78256_a(s)) / 2;
        int j1 = this.mc.func_228018_at_().func_198087_p() - 31 - 4;
        this.mc.field_71456_v.func_175179_f().func_238421_b_(matrixStack, s, (float)(i1 + 1), (float)j1, 0);
        this.mc.field_71456_v.func_175179_f().func_238421_b_(matrixStack, s, (float)(i1 - 1), (float)j1, 0);
        this.mc.field_71456_v.func_175179_f().func_238421_b_(matrixStack, s, (float)i1, (float)(j1 + 1), 0);
        this.mc.field_71456_v.func_175179_f().func_238421_b_(matrixStack, s, (float)i1, (float)(j1 - 1), 0);
        this.mc.field_71456_v.func_175179_f().func_238421_b_(matrixStack, s, (float)i1, (float)j1, 8453920);
    }

    @SubscribeEvent
    public void renderToolTip(RenderTooltipEvent.Pre event) {
        ItemStack stack = event.getStack();
        if (!stack.func_77942_o()) {
            return;
        }
        CompoundNBT compound = stack.func_77978_p();
        if (!compound.func_74764_b("trading_item") && !compound.func_74767_n("trading_item")) {
            return;
        }
        event.setCanceled(true);
    }

    @SubscribeEvent
    public void renderPlayerPre(RenderPlayerEvent.Pre event) {
        EntityGenericCar car = this.getCar();
        if (car != null) {
            event.getMatrixStack().func_227860_a_();
            event.getMatrixStack().func_227862_a_(EntityVehicleBase.SCALE_FACTOR, EntityVehicleBase.SCALE_FACTOR, EntityVehicleBase.SCALE_FACTOR);
            event.getMatrixStack().func_227861_a_(0.0, (double)(event.getPlayer().func_213302_cg() - event.getPlayer().func_213302_cg() * EntityVehicleBase.SCALE_FACTOR) / 1.5 + car.getPlayerYOffset(), 0.0);
        }
    }

    @SubscribeEvent
    public void renderPlayerPost(RenderPlayerEvent.Post event) {
        if (this.getCar() != null) {
            event.getMatrixStack().func_227865_b_();
        }
    }
}

