/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity;

import com.github.alexthe666.alexsmobs.block.AMBlockRegistry;
import com.github.alexthe666.alexsmobs.block.BlockCrocodileEgg;
import com.github.alexthe666.alexsmobs.config.AMConfig;
import com.github.alexthe666.alexsmobs.entity.AMEntityRegistry;
import com.github.alexthe666.alexsmobs.entity.ISemiAquatic;
import com.github.alexthe666.alexsmobs.entity.ai.AnimalAIFindWater;
import com.github.alexthe666.alexsmobs.entity.ai.AnimalAIHurtByTargetNotBaby;
import com.github.alexthe666.alexsmobs.entity.ai.AnimalAILeaveWater;
import com.github.alexthe666.alexsmobs.entity.ai.AquaticMoveController;
import com.github.alexthe666.alexsmobs.entity.ai.CrocodileAIMelee;
import com.github.alexthe666.alexsmobs.entity.ai.CrocodileAIRandomSwimming;
import com.github.alexthe666.alexsmobs.entity.ai.EntityAINearestTarget3D;
import com.github.alexthe666.alexsmobs.entity.ai.GroundPathNavigatorWide;
import com.github.alexthe666.alexsmobs.entity.ai.SemiAquaticPathNavigator;
import com.github.alexthe666.alexsmobs.item.AMItemRegistry;
import com.github.alexthe666.alexsmobs.misc.AMSoundRegistry;
import com.github.alexthe666.alexsmobs.misc.AMTagRegistry;
import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.animation.AnimationHandler;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.BlockState;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.BreatheAirGoal;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.entity.ai.goal.OwnerHurtByTargetGoal;
import net.minecraft.entity.ai.goal.OwnerHurtTargetGoal;
import net.minecraft.entity.ai.goal.SitGoal;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.state.Property;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.GameRules;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.BiomeDictionary;

public class EntityCrocodile
extends TameableEntity
implements IAnimatedEntity,
ISemiAquatic {
    public static final Animation ANIMATION_LUNGE = Animation.create((int)23);
    public static final Animation ANIMATION_DEATHROLL = Animation.create((int)40);
    public static final Predicate<Entity> NOT_CREEPER = entity -> entity.func_70089_S() && !(entity instanceof CreeperEntity);
    private static final DataParameter<Byte> CLIMBING = EntityDataManager.func_187226_a(EntityCrocodile.class, (IDataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Boolean> SITTING = EntityDataManager.func_187226_a(EntityCrocodile.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> DESERT = EntityDataManager.func_187226_a(EntityCrocodile.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> HAS_EGG = EntityDataManager.func_187226_a(EntityCrocodile.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> IS_DIGGING = EntityDataManager.func_187226_a(EntityCrocodile.class, (IDataSerializer)DataSerializers.field_187198_h);
    public float groundProgress = 0.0f;
    public float prevGroundProgress = 0.0f;
    public float swimProgress = 0.0f;
    public float prevSwimProgress = 0.0f;
    public float baskingProgress = 0.0f;
    public float prevBaskingProgress = 0.0f;
    public float grabProgress = 0.0f;
    public float prevGrabProgress = 0.0f;
    public int baskingType = 0;
    public boolean forcedSit = false;
    private int baskingTimer = 0;
    private int swimTimer = -1000;
    private int ticksSinceInWater = 0;
    private int passengerTimer = 0;
    private boolean isLandNavigator;
    private boolean hasSpedUp = false;
    private int animationTick;
    private Animation currentAnimation;

    protected EntityCrocodile(EntityType type, World worldIn) {
        super(type, worldIn);
        this.func_184644_a(PathNodeType.WATER, 0.0f);
        this.func_184644_a(PathNodeType.WATER_BORDER, 0.0f);
        this.switchNavigator(false);
        this.baskingType = this.field_70146_Z.nextInt(1);
    }

    public static boolean canCrocodileSpawn(EntityType type, IWorld worldIn, SpawnReason reason, BlockPos pos, Random randomIn) {
        boolean spawnBlock = BlockTags.func_199896_a().func_199910_a(AMTagRegistry.CROCODILE_SPAWNS).func_230235_a_((Object)worldIn.func_180495_p(pos.func_177977_b()).func_177230_c());
        return spawnBlock && pos.func_177956_o() < worldIn.func_181545_F() + 4;
    }

    public boolean func_213380_a(IWorld worldIn, SpawnReason spawnReasonIn) {
        return AMEntityRegistry.rollSpawn(AMConfig.crocSpawnRolls, this.func_70681_au(), spawnReasonIn);
    }

    public static AttributeModifierMap.MutableAttribute bakeAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, 30.0).func_233815_a_(Attributes.field_233819_b_, 20.0).func_233815_a_(Attributes.field_233826_i_, 8.0).func_233815_a_(Attributes.field_233823_f_, 10.0).func_233815_a_(Attributes.field_233820_c_, (double)0.4f).func_233815_a_(Attributes.field_233821_d_, 0.25);
    }

    public int func_70641_bl() {
        return 2;
    }

    public boolean func_204209_c(int sizeIn) {
        return false;
    }

    protected void func_175500_n() {
        super.func_175500_n();
        if (!this.func_70631_g_() && this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223602_e)) {
            this.func_70099_a(new ItemStack((IItemProvider)AMItemRegistry.CROCODILE_SCUTE, this.field_70146_Z.nextInt(1) + 1), 1.0f);
        }
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        this.setDesert(this.isBiomeDesert((IWorld)worldIn, this.func_233580_cy_()));
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    private boolean isBiomeDesert(IWorld worldIn, BlockPos position) {
        RegistryKey biomeKey = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)worldIn.func_226691_t_(position).getRegistryName());
        boolean sand = BiomeDictionary.hasType((RegistryKey)biomeKey, (BiomeDictionary.Type)BiomeDictionary.Type.SANDY);
        return sand;
    }

    protected SoundEvent func_184639_G() {
        return this.func_70631_g_() ? AMSoundRegistry.CROCODILE_BABY : AMSoundRegistry.CROCODILE_IDLE;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return AMSoundRegistry.CROCODILE_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return AMSoundRegistry.CROCODILE_HURT;
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("CrocodileSitting", this.isSitting());
        compound.func_74757_a("Desert", this.isDesert());
        compound.func_74757_a("ForcedToSit", this.forcedSit);
        compound.func_74768_a("BaskingStyle", this.baskingType);
        compound.func_74768_a("BaskingTimer", this.baskingTimer);
        compound.func_74768_a("SwimTimer", this.swimTimer);
        compound.func_74757_a("HasEgg", this.hasEgg());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.func_233687_w_(compound.func_74767_n("CrocodileSitting"));
        this.setDesert(compound.func_74767_n("Desert"));
        this.forcedSit = compound.func_74767_n("ForcedToSit");
        this.baskingType = compound.func_74762_e("BaskingStyle");
        this.baskingTimer = compound.func_74762_e("BaskingTimer");
        this.swimTimer = compound.func_74762_e("SwimTimer");
        this.setHasEgg(compound.func_74767_n("HasEgg"));
    }

    private void switchNavigator(boolean onLand) {
        if (onLand) {
            this.field_70765_h = new MovementController((MobEntity)this);
            PathNavigator prevNav = this.field_70699_by;
            this.field_70699_by = new GroundPathNavigatorWide((MobEntity)this, this.field_70170_p);
            this.isLandNavigator = true;
        } else {
            this.field_70765_h = new AquaticMoveController((CreatureEntity)this, 1.0f);
            PathNavigator prevNav = this.field_70699_by;
            this.field_70699_by = new SemiAquaticPathNavigator((MobEntity)this, this.field_70170_p);
            this.isLandNavigator = false;
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SITTING, (Object)false);
        this.field_70180_af.func_187214_a(DESERT, (Object)false);
        this.field_70180_af.func_187214_a(HAS_EGG, (Object)false);
        this.field_70180_af.func_187214_a(IS_DIGGING, (Object)false);
        this.field_70180_af.func_187214_a(CLIMBING, (Object)0);
    }

    public boolean isBesideClimbableBlock() {
        return ((Byte)this.field_70180_af.func_187225_a(CLIMBING) & 1) != 0;
    }

    public void setBesideClimbableBlock(boolean climbing) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(CLIMBING);
        b0 = climbing ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE);
        this.field_70180_af.func_187227_b(CLIMBING, (Object)b0);
    }

    public void func_70071_h_() {
        boolean grabbing;
        super.func_70071_h_();
        this.prevGroundProgress = this.groundProgress;
        this.prevSwimProgress = this.swimProgress;
        this.prevBaskingProgress = this.baskingProgress;
        this.prevGrabProgress = this.grabProgress;
        boolean ground = !this.func_70090_H();
        boolean groundAnimate = !this.func_70090_H();
        boolean basking = groundAnimate && this.isSitting();
        boolean bl = grabbing = !this.func_184188_bt().isEmpty();
        if (!ground && this.isLandNavigator) {
            this.switchNavigator(false);
        }
        if (ground && !this.isLandNavigator) {
            this.switchNavigator(true);
        }
        if (groundAnimate && this.groundProgress < 10.0f) {
            this.groundProgress += 1.0f;
        }
        if (!groundAnimate && this.groundProgress > 0.0f) {
            this.groundProgress -= 1.0f;
        }
        if (!groundAnimate && this.swimProgress < 10.0f) {
            this.swimProgress += 1.0f;
        }
        if (groundAnimate && this.swimProgress > 0.0f) {
            this.swimProgress -= 1.0f;
        }
        if (basking && this.baskingProgress < 10.0f) {
            this.baskingProgress += 1.0f;
        }
        if (!basking && this.baskingProgress > 0.0f) {
            this.baskingProgress -= 1.0f;
        }
        if (grabbing && this.grabProgress < 10.0f) {
            this.grabProgress += 1.0f;
        }
        if (!grabbing && this.grabProgress > 0.0f) {
            this.grabProgress -= 1.0f;
        }
        if (this.func_70638_az() != null && !this.hasSpedUp) {
            this.hasSpedUp = true;
            this.func_110148_a(Attributes.field_233821_d_).func_111128_a((double)0.28f);
        }
        if (this.func_70638_az() == null && this.hasSpedUp) {
            this.hasSpedUp = false;
            this.func_110148_a(Attributes.field_233821_d_).func_111128_a(0.25);
        }
        if (!this.field_70170_p.field_72995_K) {
            this.setBesideClimbableBlock(this.field_70123_F);
        }
        if (this.baskingTimer < 0) {
            ++this.baskingTimer;
        }
        if (this.passengerTimer > 0 && this.func_184188_bt().isEmpty()) {
            this.passengerTimer = 0;
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.func_70090_H()) {
                ++this.swimTimer;
                this.ticksSinceInWater = 0;
            } else {
                ++this.ticksSinceInWater;
                --this.swimTimer;
            }
        }
        if (!this.field_70170_p.field_72995_K && !this.func_70090_H() && this.func_233570_aj_() && !this.func_70909_n()) {
            if (!this.isSitting() && this.baskingTimer == 0 && this.func_70638_az() == null && this.func_70661_as().func_75500_f()) {
                this.func_233687_w_(true);
                this.baskingTimer = 1000 + this.field_70146_Z.nextInt(750);
            }
            if (this.isSitting() && (this.baskingTimer <= 0 || this.func_70638_az() != null || this.swimTimer < -1000)) {
                this.func_233687_w_(false);
                this.baskingTimer = -2000 - this.field_70146_Z.nextInt(750);
            }
            if (this.isSitting() && this.baskingTimer > 0) {
                --this.baskingTimer;
            }
        }
        if (!this.field_70170_p.field_72995_K && this.func_70089_S() && this.func_70638_az() != null && this.getAnimation() == ANIMATION_LUNGE && this.getAnimationTick() > 5 && this.getAnimationTick() < 9) {
            float f1 = this.field_70177_z * ((float)Math.PI / 180);
            this.func_213317_d(this.func_213322_ci().func_72441_c((double)(-MathHelper.func_76126_a((float)f1) * 0.02f), 0.0, (double)(MathHelper.func_76134_b((float)f1) * 0.02f)));
            if (this.func_70032_d((Entity)this.func_70638_az()) < 3.5f && this.func_70685_l((Entity)this.func_70638_az())) {
                if (this.func_70638_az().func_213311_cf() < this.func_213311_cf() && this.func_184188_bt().isEmpty() && !this.func_70638_az().func_184585_cz()) {
                    this.func_70638_az().func_184205_a((Entity)this, true);
                }
                this.func_70638_az().func_70097_a(DamageSource.func_76358_a((LivingEntity)this), (float)this.func_110148_a(Attributes.field_233823_f_).func_111125_b());
                this.func_184185_a(AMSoundRegistry.CROCODILE_BITE, this.func_70599_aP(), this.func_70647_i());
            }
        }
        if (!this.field_70170_p.field_72995_K && this.func_70089_S() && this.func_70638_az() != null && this.func_70090_H() && this.func_70638_az().func_184187_bx() != null && this.func_70638_az().func_184187_bx() == this) {
            if (this.getAnimation() == NO_ANIMATION) {
                this.setAnimation(ANIMATION_DEATHROLL);
            }
            if (this.getAnimation() == ANIMATION_DEATHROLL && this.getAnimationTick() % 10 == 0 && (double)this.func_70032_d((Entity)this.func_70638_az()) < 5.0) {
                this.func_70638_az().func_70097_a(DamageSource.func_76358_a((LivingEntity)this), 2.0f);
            }
        }
        if (this.getAnimation() == ANIMATION_DEATHROLL) {
            this.func_70661_as().func_75499_g();
        }
        if (this.func_70880_s() && this.func_70638_az() != null) {
            this.func_70624_b(null);
        }
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
    }

    public boolean canRiderInteract() {
        return true;
    }

    public boolean shouldRiderSit() {
        return false;
    }

    public boolean func_184191_r(Entity entityIn) {
        if (this.func_70909_n()) {
            LivingEntity livingentity = this.func_70902_q();
            if (entityIn == livingentity) {
                return true;
            }
            if (entityIn instanceof TameableEntity) {
                return ((TameableEntity)entityIn).func_152114_e(livingentity);
            }
            if (livingentity != null) {
                return livingentity.func_184191_r(entityIn);
            }
        }
        return super.func_184191_r(entityIn);
    }

    public void func_184232_k(Entity passenger) {
        if (!this.func_184188_bt().isEmpty()) {
            this.field_70761_aq = MathHelper.func_76142_g((float)(this.field_70177_z - 180.0f));
        }
        if (this.func_184196_w(passenger)) {
            float radius = 2.0f;
            float angle = (float)Math.PI / 180 * this.field_70761_aq;
            double extraX = radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)));
            double extraZ = radius * MathHelper.func_76134_b((float)angle);
            passenger.func_70107_b(this.func_226277_ct_() + extraX, this.func_226278_cu_() + (double)0.1f, this.func_226281_cx_() + extraZ);
            ++this.passengerTimer;
            if (this.func_70089_S() && this.passengerTimer > 0 && this.passengerTimer % 40 == 0) {
                passenger.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), 2.0f);
            }
        }
    }

    public boolean func_70617_f_() {
        return this.func_70090_H() && this.isBesideClimbableBlock();
    }

    public boolean func_96092_aw() {
        return false;
    }

    public boolean func_205019_a(IWorldReader worldIn) {
        return worldIn.func_226668_i_((Entity)this);
    }

    public boolean func_70652_k(Entity entityIn) {
        if (this.getAnimation() == NO_ANIMATION && this.func_184188_bt().isEmpty()) {
            this.setAnimation(ANIMATION_LUNGE);
        }
        return true;
    }

    public void func_213352_e(Vector3d travelVector) {
        if (this.func_70613_aW() && this.func_70090_H()) {
            this.func_213309_a(this.func_70689_ay(), travelVector);
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
            this.func_213317_d(this.func_213322_ci().func_186678_a(0.9));
            if (this.func_70638_az() == null) {
                this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, -0.005, 0.0));
            }
        } else {
            super.func_213352_e(travelVector);
        }
    }

    public boolean func_180431_b(DamageSource source) {
        return source == DamageSource.field_76369_e || source == DamageSource.field_76368_d || source == DamageSource.field_82729_p || super.func_180431_b(source);
    }

    public boolean func_70648_aU() {
        return true;
    }

    public float func_205022_a(BlockPos pos, IWorldReader worldIn) {
        return super.func_205022_a(pos, worldIn);
    }

    @Override
    public boolean shouldLeaveWater() {
        if (!this.func_184188_bt().isEmpty()) {
            return false;
        }
        if (this.func_70638_az() != null && !this.func_70638_az().func_70090_H()) {
            return true;
        }
        return this.swimTimer > 600;
    }

    @Override
    public boolean shouldStopMoving() {
        return this.getAnimation() == ANIMATION_DEATHROLL;
    }

    @Override
    public int getWaterSearchRange() {
        return this.func_184188_bt().isEmpty() ? 15 : 45;
    }

    public boolean isSitting() {
        return (Boolean)this.field_70180_af.func_187225_a(SITTING);
    }

    public void func_233687_w_(boolean sit) {
        this.field_70180_af.func_187227_b(SITTING, (Object)sit);
    }

    public boolean isDesert() {
        return (Boolean)this.field_70180_af.func_187225_a(DESERT);
    }

    public void setDesert(boolean desert) {
        this.field_70180_af.func_187227_b(DESERT, (Object)desert);
    }

    public boolean hasEgg() {
        return (Boolean)this.field_70180_af.func_187225_a(HAS_EGG);
    }

    private void setHasEgg(boolean hasEgg) {
        this.field_70180_af.func_187227_b(HAS_EGG, (Object)hasEgg);
    }

    public boolean isDigging() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_DIGGING);
    }

    private void setDigging(boolean isDigging) {
        this.field_70180_af.func_187227_b(IS_DIGGING, (Object)isDigging);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SitGoal((TameableEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new MateGoal(this, 1.0));
        this.field_70714_bg.func_75776_a(1, (Goal)new LayEggGoal(this, 1.0));
        this.field_70714_bg.func_75776_a(2, (Goal)new BreatheAirGoal((CreatureEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new AnimalAIFindWater((CreatureEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new AnimalAILeaveWater((CreatureEntity)this));
        this.field_70714_bg.func_75776_a(4, (Goal)new CrocodileAIMelee(this, 1.0, true));
        this.field_70714_bg.func_75776_a(5, (Goal)new CrocodileAIRandomSwimming((CreatureEntity)this, 1.0, 7));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70715_bh.func_75776_a(1, (Goal)new AnimalAIHurtByTargetNotBaby((AnimalEntity)this, new Class[0]).func_220794_a(new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new OwnerHurtByTargetGoal((TameableEntity)this));
        this.field_70715_bh.func_75776_a(3, (Goal)new OwnerHurtTargetGoal((TameableEntity)this));
        this.field_70715_bh.func_75776_a(4, (Goal)new EntityAINearestTarget3D((MobEntity)this, PlayerEntity.class, 80, false, true, null){

            public boolean func_75250_a() {
                return !EntityCrocodile.this.func_70631_g_() && !EntityCrocodile.this.func_70909_n() && super.func_75250_a();
            }
        });
        this.field_70715_bh.func_75776_a(5, (Goal)new EntityAINearestTarget3D((MobEntity)this, LivingEntity.class, 180, false, true, AMEntityRegistry.buildPredicateFromTag(EntityTypeTags.func_219762_a().func_199910_a(AMTagRegistry.CROCODILE_TARGETS))){

            public boolean func_75250_a() {
                return !EntityCrocodile.this.func_70631_g_() && !EntityCrocodile.this.func_70909_n() && super.func_75250_a();
            }
        });
        this.field_70715_bh.func_75776_a(6, (Goal)new EntityAINearestTarget3D((MobEntity)this, MonsterEntity.class, 180, false, true, NOT_CREEPER){

            public boolean func_75250_a() {
                return !EntityCrocodile.this.func_70631_g_() && EntityCrocodile.this.func_70909_n() && super.func_75250_a();
            }
        });
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        Entity entity = source.func_76346_g();
        this.func_233687_w_(false);
        if (entity != null && this.func_70909_n() && !(entity instanceof PlayerEntity) && !(entity instanceof AbstractArrowEntity)) {
            amount = (amount + 1.0f) / 3.0f;
        }
        return super.func_70097_a(source, amount);
    }

    @Nullable
    public AgeableEntity func_241840_a(ServerWorld p_241840_1_, AgeableEntity p_241840_2_) {
        return (AgeableEntity)AMEntityRegistry.CROCODILE.func_200721_a((World)p_241840_1_);
    }

    public ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        Item item = itemstack.func_77973_b();
        if (itemstack.func_77973_b() == Items.field_151057_cb) {
            return super.func_230254_b_(player, hand);
        }
        if (this.func_70909_n() && item.func_219971_r() && item.func_219967_s() != null && item.func_219967_s().func_221467_c() && this.func_110143_aJ() < this.func_110138_aP()) {
            this.func_175505_a(player, itemstack);
            this.func_70691_i(10.0f);
            this.func_184185_a(SoundEvents.field_187537_bA, this.func_70599_aP(), this.func_70647_i());
            return ActionResultType.SUCCESS;
        }
        ActionResultType type = super.func_230254_b_(player, hand);
        if (type != ActionResultType.SUCCESS && this.func_70909_n() && this.func_152114_e((LivingEntity)player) && !this.func_70877_b(itemstack)) {
            if (this.isSitting()) {
                this.forcedSit = false;
                this.func_233687_w_(false);
                return ActionResultType.SUCCESS;
            }
            this.forcedSit = true;
            this.func_233687_w_(true);
            return ActionResultType.SUCCESS;
        }
        return type;
    }

    public void func_70624_b(@Nullable LivingEntity entitylivingbaseIn) {
        if (!this.func_70631_g_()) {
            super.func_70624_b(entitylivingbaseIn);
        }
    }

    public boolean func_70877_b(ItemStack stack) {
        return stack.func_77973_b() == Items.field_151078_bh;
    }

    @Override
    public boolean shouldEnterWater() {
        if (!this.func_184188_bt().isEmpty()) {
            return true;
        }
        return this.func_70638_az() == null && !this.isSitting() && this.baskingTimer <= 0 && !this.shouldLeaveWater() && this.swimTimer <= -1000;
    }

    public Animation getAnimation() {
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        this.currentAnimation = animation;
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    public Animation[] getAnimations() {
        return new Animation[]{ANIMATION_LUNGE, ANIMATION_DEATHROLL};
    }

    static class LayEggGoal
    extends MoveToBlockGoal {
        private final EntityCrocodile turtle;
        private int digTime;

        LayEggGoal(EntityCrocodile turtle, double speedIn) {
            super((CreatureEntity)turtle, speedIn, 16);
            this.turtle = turtle;
        }

        public void func_75251_c() {
            this.digTime = 0;
        }

        public boolean func_75250_a() {
            return this.turtle.hasEgg() && super.func_75250_a();
        }

        public boolean func_75253_b() {
            return super.func_75253_b() && this.turtle.hasEgg();
        }

        public void func_75246_d() {
            super.func_75246_d();
            BlockPos blockpos = this.turtle.func_233580_cy_();
            this.turtle.func_233687_w_(false);
            this.turtle.baskingTimer = -100;
            if (!this.turtle.func_70090_H() && this.func_179487_f()) {
                World world = this.turtle.field_70170_p;
                world.func_184133_a(null, blockpos, SoundEvents.field_203278_iw, SoundCategory.BLOCKS, 0.3f, 0.9f + world.field_73012_v.nextFloat() * 0.2f);
                world.func_180501_a(this.field_179494_b.func_177984_a(), (BlockState)AMBlockRegistry.CROCODILE_EGG.func_176223_P().func_206870_a((Property)BlockCrocodileEgg.EGGS, (Comparable)Integer.valueOf(this.turtle.field_70146_Z.nextInt(1) + 1)), 3);
                this.turtle.setHasEgg(false);
                this.turtle.setDigging(false);
                this.turtle.func_204700_e(600);
            }
        }

        protected boolean func_179488_a(IWorldReader worldIn, BlockPos pos) {
            return worldIn.func_175623_d(pos.func_177984_a()) && BlockCrocodileEgg.isProperHabitat((IBlockReader)worldIn, pos);
        }
    }

    static class MateGoal
    extends BreedGoal {
        private final EntityCrocodile turtle;

        MateGoal(EntityCrocodile turtle, double speedIn) {
            super((AnimalEntity)turtle, speedIn);
            this.turtle = turtle;
        }

        public boolean func_75250_a() {
            return super.func_75250_a() && !this.turtle.hasEgg();
        }

        protected void func_75388_i() {
            ServerPlayerEntity serverplayerentity = this.field_75390_d.func_191993_do();
            if (serverplayerentity == null && this.field_75391_e.func_191993_do() != null) {
                serverplayerentity = this.field_75391_e.func_191993_do();
            }
            if (serverplayerentity != null) {
                serverplayerentity.func_195066_a(Stats.field_151186_x);
                CriteriaTriggers.field_192134_n.func_192168_a(serverplayerentity, this.field_75390_d, this.field_75391_e, (AgeableEntity)this.field_75390_d);
            }
            this.turtle.setHasEgg(true);
            this.field_75390_d.func_70875_t();
            this.field_75391_e.func_70875_t();
            Random random = this.field_75390_d.func_70681_au();
            if (this.field_75394_a.func_82736_K().func_223586_b(GameRules.field_223602_e)) {
                this.field_75394_a.func_217376_c((Entity)new ExperienceOrbEntity(this.field_75394_a, this.field_75390_d.func_226277_ct_(), this.field_75390_d.func_226278_cu_(), this.field_75390_d.func_226281_cx_(), random.nextInt(7) + 1));
            }
        }
    }
}

