/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity;

import com.github.alexthe666.alexsmobs.client.particle.AMParticleRegistry;
import com.github.alexthe666.alexsmobs.config.AMConfig;
import com.github.alexthe666.alexsmobs.entity.AMEntityRegistry;
import com.github.alexthe666.alexsmobs.entity.IFollower;
import com.github.alexthe666.alexsmobs.entity.ISemiAquatic;
import com.github.alexthe666.alexsmobs.entity.ai.AnimalAIFindWater;
import com.github.alexthe666.alexsmobs.entity.ai.AnimalAILeaveWater;
import com.github.alexthe666.alexsmobs.entity.ai.AnimalSwimMoveControllerSink;
import com.github.alexthe666.alexsmobs.entity.ai.GroundPathNavigatorWide;
import com.github.alexthe666.alexsmobs.entity.ai.SemiAquaticAIRandomSwimming;
import com.github.alexthe666.alexsmobs.entity.ai.SemiAquaticPathNavigator;
import com.github.alexthe666.alexsmobs.item.AMItemRegistry;
import com.github.alexthe666.alexsmobs.misc.AMSoundRegistry;
import com.github.alexthe666.alexsmobs.misc.AMTagRegistry;
import com.google.common.base.Predicate;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.LeavesBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.OwnerHurtByTargetGoal;
import net.minecraft.entity.ai.goal.OwnerHurtTargetGoal;
import net.minecraft.entity.ai.goal.SitGoal;
import net.minecraft.entity.ai.goal.TemptGoal;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.monster.GuardianEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.passive.fish.PufferfishEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ItemParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.WalkNodeProcessor;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class EntityMimicOctopus
extends TameableEntity
implements ISemiAquatic,
IFollower {
    private static final DataParameter<Boolean> STOP_CHANGE = EntityDataManager.func_187226_a(EntityMimicOctopus.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> FROM_BUCKET = EntityDataManager.func_187226_a(EntityMimicOctopus.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> UPGRADED = EntityDataManager.func_187226_a(EntityMimicOctopus.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> MIMIC_ORDINAL = EntityDataManager.func_187226_a(EntityMimicOctopus.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> PREV_MIMIC_ORDINAL = EntityDataManager.func_187226_a(EntityMimicOctopus.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> MOISTNESS = EntityDataManager.func_187226_a(EntityMimicOctopus.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> COMMAND = EntityDataManager.func_187226_a(EntityMimicOctopus.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Optional<BlockState>> MIMICKED_BLOCK = EntityDataManager.func_187226_a(EntityMimicOctopus.class, (IDataSerializer)DataSerializers.field_187197_g);
    private static final DataParameter<Optional<BlockState>> PREV_MIMICKED_BLOCK = EntityDataManager.func_187226_a(EntityMimicOctopus.class, (IDataSerializer)DataSerializers.field_187197_g);
    private static final DataParameter<Boolean> SITTING = EntityDataManager.func_187226_a(EntityMimicOctopus.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> LAST_SCARED_MOB_ID = EntityDataManager.func_187226_a(EntityMimicOctopus.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> UPGRADED_LASER_ENTITY_ID = EntityDataManager.func_187226_a(EntityMimicOctopus.class, (IDataSerializer)DataSerializers.field_187192_b);
    public MimicState localMimicState = MimicState.OVERLAY;
    public float transProgress = 0.0f;
    public float prevTransProgress = 0.0f;
    public float colorShiftProgress = 0.0f;
    public float prevColorShiftProgress = 0.0f;
    public float groundProgress = 5.0f;
    public float prevGroundProgress = 0.0f;
    public float sitProgress = 0.0f;
    public float prevSitProgress = 0.0f;
    private boolean isLandNavigator;
    private int moistureAttackTime = 0;
    private int camoCooldown = 120 + this.field_70146_Z.nextInt(1200);
    private int mimicCooldown = 0;
    private int stopMimicCooldown = -1;
    private int fishFeedings;
    private int mimicreamFeedings;
    private int exclaimTime = 0;
    private BlockState localMimic;
    private LivingEntity laserTargetEntity;
    private int guardianLaserTime;

    protected EntityMimicOctopus(EntityType type, World worldIn) {
        super(type, worldIn);
        this.func_184644_a(PathNodeType.WATER, 0.0f);
        this.func_184644_a(PathNodeType.WATER_BORDER, 0.0f);
        this.switchNavigator(false);
    }

    public static AttributeModifierMap.MutableAttribute bakeAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, 16.0).func_233815_a_(Attributes.field_233826_i_, 0.0).func_233815_a_(Attributes.field_233823_f_, 2.0).func_233815_a_(Attributes.field_233821_d_, (double)0.2f);
    }

    public static boolean canMimicOctopusSpawn(EntityType<? extends AnimalEntity> animal, IWorld worldIn, SpawnReason reason, BlockPos pos, Random random) {
        BlockPos downPos = pos;
        while (downPos.func_177956_o() > 1 && !worldIn.func_204610_c(downPos).func_206888_e()) {
            downPos = downPos.func_177977_b();
        }
        boolean spawnBlock = BlockTags.func_199896_a().func_199910_a(AMTagRegistry.MIMIC_OCTOPUS_SPAWNS).func_230235_a_((Object)worldIn.func_180495_p(downPos).func_177230_c());
        return spawnBlock && downPos.func_177956_o() < worldIn.func_181545_F() + 1;
    }

    public static MimicState getStateForItem(ItemStack stack) {
        if (ItemTags.func_199903_a().func_199910_a(AMTagRegistry.MIMIC_OCTOPUS_CREEPER_ITEMS).func_230235_a_((Object)stack.func_77973_b())) {
            return MimicState.CREEPER;
        }
        if (ItemTags.func_199903_a().func_199910_a(AMTagRegistry.MIMIC_OCTOPUS_GUARDIAN_ITEMS).func_230235_a_((Object)stack.func_77973_b())) {
            return MimicState.GUARDIAN;
        }
        if (ItemTags.func_199903_a().func_199910_a(AMTagRegistry.MIMIC_OCTOPUS_PUFFERFISH_ITEMS).func_230235_a_((Object)stack.func_77973_b())) {
            return MimicState.PUFFERFISH;
        }
        return null;
    }

    protected SoundEvent func_184639_G() {
        return AMSoundRegistry.MIMIC_OCTOPUS_IDLE;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return AMSoundRegistry.MIMIC_OCTOPUS_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return AMSoundRegistry.MIMIC_OCTOPUS_HURT;
    }

    public boolean func_205019_a(IWorldReader worldIn) {
        return worldIn.func_226668_i_((Entity)this);
    }

    public boolean func_213380_a(IWorld worldIn, SpawnReason spawnReasonIn) {
        return AMEntityRegistry.rollSpawn(AMConfig.mimicOctopusSpawnRolls, this.func_70681_au(), spawnReasonIn);
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        this.field_70180_af.func_187227_b(PREV_MIMIC_ORDINAL, (Object)0);
        this.setMimickedBlock(null);
        this.setMimicState(MimicState.OVERLAY);
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.field_70180_af.func_187227_b(MIMIC_ORDINAL, (Object)compound.func_74762_e("MimicState"));
        this.setUpgraded(compound.func_74767_n("Upgraded"));
        this.func_233687_w_(compound.func_74767_n("Sitting"));
        this.setStopChange(compound.func_74767_n("StopChange"));
        this.setCommand(compound.func_74762_e("OctoCommand"));
        this.setMoistness(compound.func_74762_e("Moistness"));
        this.setFromBucket(compound.func_74767_n("FromBucket"));
        BlockState blockstate = null;
        if (compound.func_150297_b("MimickedBlockState", 10) && (blockstate = NBTUtil.func_190008_d((CompoundNBT)compound.func_74775_l("MimickedBlockState"))).func_196958_f()) {
            blockstate = null;
        }
        this.setMimickedBlock(blockstate);
        this.camoCooldown = compound.func_74762_e("CamoCooldown");
        this.mimicCooldown = compound.func_74762_e("MimicCooldown");
        this.stopMimicCooldown = compound.func_74762_e("StopMimicCooldown");
        this.fishFeedings = compound.func_74762_e("FishFeedings");
        this.mimicreamFeedings = compound.func_74762_e("MimicreamFeedings");
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("MimicState", this.getMimicState().ordinal());
        compound.func_74757_a("Upgraded", this.isUpgraded());
        compound.func_74757_a("Sitting", this.isSitting());
        compound.func_74768_a("OctoCommand", this.getCommand());
        compound.func_74768_a("Moistness", this.getMoistness());
        compound.func_74757_a("FromBucket", this.isFromBucket());
        compound.func_74757_a("StopChange", this.isStopChange());
        BlockState blockstate = this.getMimickedBlock();
        if (blockstate != null) {
            compound.func_218657_a("MimickedBlockState", (INBT)NBTUtil.func_190009_a((BlockState)blockstate));
        }
        compound.func_74768_a("CamoCooldown", this.camoCooldown);
        compound.func_74768_a("MimicCooldown", this.mimicCooldown);
        compound.func_74768_a("StopMimicCooldown", this.stopMimicCooldown);
        compound.func_74768_a("FishFeedings", this.fishFeedings);
        compound.func_74768_a("MimicreamFeedings", this.mimicreamFeedings);
    }

    protected ItemStack getFishBucket() {
        ItemStack stack = new ItemStack((IItemProvider)AMItemRegistry.MIMIC_OCTOPUS_BUCKET);
        CompoundNBT platTag = new CompoundNBT();
        this.func_213281_b(platTag);
        stack.func_196082_o().func_218657_a("MimicOctopusData", (INBT)platTag);
        if (this.func_145818_k_()) {
            stack.func_200302_a(this.func_200201_e());
        }
        return stack;
    }

    protected float func_175134_bD() {
        return super.func_175134_bD() * (this.func_203005_aq() ? 1.3f : 1.0f);
    }

    @Override
    public boolean shouldFollow() {
        return this.getCommand() == 1;
    }

    public boolean func_184191_r(Entity entityIn) {
        if (this.func_70909_n()) {
            LivingEntity livingentity = this.func_70902_q();
            if (entityIn == livingentity) {
                return true;
            }
            if (entityIn instanceof TameableEntity) {
                return ((TameableEntity)entityIn).func_152114_e(livingentity);
            }
            if (livingentity != null) {
                return livingentity.func_184191_r(entityIn);
            }
        }
        return super.func_184191_r(entityIn);
    }

    public boolean func_96092_aw() {
        return false;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new AIAttack());
        this.field_70714_bg.func_75776_a(1, (Goal)new SitGoal((TameableEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new FollowOwner(this, 1.3, 4.0f, 2.0f, false));
        this.field_70714_bg.func_75776_a(3, (Goal)new AnimalAIFindWater((CreatureEntity)this));
        this.field_70714_bg.func_75776_a(3, (Goal)new AnimalAILeaveWater((CreatureEntity)this));
        this.field_70714_bg.func_75776_a(4, (Goal)new TemptGoal((CreatureEntity)this, 1.0, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{AMItemRegistry.LOBSTER_TAIL, AMItemRegistry.COOKED_LOBSTER_TAIL, Items.field_196088_aY}), false){

            public void func_75246_d() {
                EntityMimicOctopus.this.setMimickedBlock(null);
                super.func_75246_d();
                EntityMimicOctopus.this.camoCooldown = 40;
                EntityMimicOctopus.this.stopMimicCooldown = 40;
            }
        });
        this.field_70714_bg.func_75776_a(5, (Goal)new AIFlee());
        this.field_70714_bg.func_75776_a(7, (Goal)new BreedGoal((AnimalEntity)this, 0.8));
        this.field_70714_bg.func_75776_a(8, (Goal)new AIMimicNearbyMobs());
        this.field_70714_bg.func_75776_a(9, (Goal)new BreedGoal((AnimalEntity)this, 0.8));
        this.field_70714_bg.func_75776_a(10, (Goal)new AISwim());
        this.field_70714_bg.func_75776_a(11, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(11, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70715_bh.func_75776_a(1, (Goal)new OwnerHurtByTargetGoal((TameableEntity)this));
        this.field_70715_bh.func_75776_a(2, (Goal)new OwnerHurtTargetGoal((TameableEntity)this));
        this.field_70715_bh.func_75776_a(3, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]){

            public boolean func_75250_a() {
                return EntityMimicOctopus.this.func_70909_n() && super.func_75250_a();
            }
        });
    }

    public boolean func_70877_b(ItemStack stack) {
        Item item = stack.func_77973_b();
        return this.func_70909_n() && item == Items.field_196088_aY;
    }

    public boolean isActiveCamo() {
        return this.getMimicState() == MimicState.OVERLAY && this.getMimickedBlock() != null;
    }

    public double func_213340_A(@Nullable Entity lookingEntity) {
        if (this.isActiveCamo()) {
            return super.func_213340_A(lookingEntity) * (double)0.1f;
        }
        return super.func_213340_A(lookingEntity);
    }

    public ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        Item item = itemstack.func_77973_b();
        MimicState readState = EntityMimicOctopus.getStateForItem(itemstack);
        ActionResultType type = super.func_230254_b_(player, hand);
        if (readState != null && this.func_70909_n()) {
            if (this.mimicCooldown == 0) {
                this.setMimicState(readState);
                this.mimicCooldown = 20;
                this.camoCooldown = this.stopMimicCooldown = this.isUpgraded() ? 120 : 1200;
                this.setMimickedBlock(null);
            }
            return ActionResultType.SUCCESS;
        }
        if (this.func_70909_n() && item == Items.field_196136_br) {
            this.setStopChange(!this.isStopChange());
            if (this.isStopChange()) {
                this.makeEatingParticles(itemstack);
            } else {
                this.field_70170_p.func_72960_a((Entity)this, (byte)6);
                this.mimicEnvironment();
            }
            return ActionResultType.SUCCESS;
        }
        if (!(this.func_70909_n() || item != AMItemRegistry.LOBSTER_TAIL && item != AMItemRegistry.COOKED_LOBSTER_TAIL)) {
            this.func_175505_a(player, itemstack);
            this.func_184185_a(SoundEvents.field_205207_aX, this.func_70599_aP(), this.func_70647_i());
            ++this.fishFeedings;
            if (this.getMimicState() == MimicState.OVERLAY && this.getMimickedBlock() == null) {
                if (this.fishFeedings > 5 && this.func_70681_au().nextInt(2) == 0 || this.fishFeedings > 8) {
                    this.func_193101_c(player);
                    this.field_70170_p.func_72960_a((Entity)this, (byte)7);
                } else {
                    this.field_70170_p.func_72960_a((Entity)this, (byte)6);
                }
            }
            return ActionResultType.SUCCESS;
        }
        if (this.func_70909_n() && (item == AMItemRegistry.LOBSTER_TAIL || item == AMItemRegistry.COOKED_LOBSTER_TAIL)) {
            if (this.func_110143_aJ() < this.func_110138_aP()) {
                this.func_175505_a(player, itemstack);
                this.func_184185_a(SoundEvents.field_205207_aX, this.func_70599_aP(), this.func_70647_i());
                this.func_70691_i(5.0f);
                return ActionResultType.SUCCESS;
            }
            return ActionResultType.PASS;
        }
        if (this.func_70909_n() && itemstack.func_77973_b() == Items.field_151131_as && this.func_70089_S()) {
            this.func_184185_a(SoundEvents.field_203814_aa, 1.0f, 1.0f);
            itemstack.func_190918_g(1);
            ItemStack itemstack1 = this.getFishBucket();
            if (!this.field_70170_p.field_72995_K) {
                CriteriaTriggers.field_204813_j.func_204817_a((ServerPlayerEntity)player, itemstack1);
            }
            if (itemstack.func_190926_b()) {
                player.func_184611_a(hand, itemstack1);
            } else if (!player.field_71071_by.func_70441_a(itemstack1)) {
                player.func_71019_a(itemstack1, false);
            }
            this.func_70106_y();
            return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
        }
        if (this.func_70909_n() && item == Items.field_151123_aH && this.getMoistness() < 24000) {
            this.setMoistness(48000);
            this.makeEatingParticles(itemstack);
            this.func_175505_a(player, itemstack);
            return ActionResultType.SUCCESS;
        }
        if (this.func_70909_n() && !this.isUpgraded() && item == AMItemRegistry.MIMICREAM) {
            ++this.mimicreamFeedings;
            if (this.mimicreamFeedings > 5 || this.mimicreamFeedings > 2 && this.field_70146_Z.nextInt(2) == 0) {
                this.field_70170_p.func_72960_a((Entity)this, (byte)46);
                this.setUpgraded(true);
                this.setMimicState(MimicState.MIMICUBE);
                this.setStopChange(false);
                this.setMimickedBlock(null);
                this.stopMimicCooldown = 40;
            }
            this.makeEatingParticles(itemstack);
            this.func_175505_a(player, itemstack);
            return ActionResultType.SUCCESS;
        }
        if (type != ActionResultType.SUCCESS && this.func_70909_n() && this.func_152114_e((LivingEntity)player)) {
            if (player.func_225608_bj_()) {
                if (this.func_184614_ca().func_190926_b()) {
                    ItemStack cop = itemstack.func_77946_l();
                    cop.func_190920_e(1);
                    this.func_184611_a(Hand.MAIN_HAND, cop);
                    itemstack.func_190918_g(1);
                    return ActionResultType.SUCCESS;
                }
                this.func_199701_a_(this.func_184614_ca().func_77946_l());
                this.func_184611_a(Hand.MAIN_HAND, ItemStack.field_190927_a);
                return ActionResultType.SUCCESS;
            }
            if (!this.func_70877_b(itemstack)) {
                boolean sit;
                this.setCommand(this.getCommand() + 1);
                if (this.getCommand() == 3) {
                    this.setCommand(0);
                }
                player.func_146105_b((ITextComponent)new TranslationTextComponent("entity.alexsmobs.all.command_" + this.getCommand(), new Object[]{this.func_200200_C_()}), true);
                boolean bl = sit = this.getCommand() == 2;
                if (sit) {
                    this.func_233687_w_(true);
                    return ActionResultType.SUCCESS;
                }
                this.func_233687_w_(false);
                return ActionResultType.SUCCESS;
            }
        }
        return type;
    }

    public int getCommand() {
        return (Integer)this.field_70180_af.func_187225_a(COMMAND);
    }

    public void setCommand(int command) {
        this.field_70180_af.func_187227_b(COMMAND, (Object)command);
    }

    private void makeEatingParticles(ItemStack item) {
        for (int i = 0; i < 6 + this.field_70146_Z.nextInt(3); ++i) {
            double d2 = this.field_70146_Z.nextGaussian() * 0.02;
            double d0 = this.field_70146_Z.nextGaussian() * 0.02;
            double d1 = this.field_70146_Z.nextGaussian() * 0.02;
            this.field_70170_p.func_195594_a((IParticleData)new ItemParticleData(ParticleTypes.field_197591_B, item), this.func_226277_ct_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf()) - (double)this.func_213311_cf() * 0.5, this.func_226278_cu_() + (double)(this.func_213302_cg() * 0.5f) + (double)(this.field_70146_Z.nextFloat() * this.func_213302_cg() * 0.5f), this.func_226281_cx_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf()) - (double)this.func_213311_cf() * 0.5, d0, d1, d2);
        }
    }

    public void func_233629_a_(LivingEntity p_233629_1_, boolean p_233629_2_) {
        double d2;
        double d1;
        p_233629_1_.field_184618_aE = p_233629_1_.field_70721_aZ;
        double d0 = p_233629_1_.func_226277_ct_() - p_233629_1_.field_70169_q;
        float f = MathHelper.func_76133_a((double)(d0 * d0 + (d1 = p_233629_1_.func_226278_cu_() - p_233629_1_.field_70167_r) * d1 + (d2 = p_233629_1_.func_226281_cx_() - p_233629_1_.field_70166_s) * d2)) * (this.groundProgress < 2.5f ? 4.0f : 8.0f);
        if (f > 1.0f) {
            f = 1.0f;
        }
        p_233629_1_.field_70721_aZ += (f - p_233629_1_.field_70721_aZ) * 0.4f;
        p_233629_1_.field_184619_aG += p_233629_1_.field_70721_aZ;
    }

    public boolean func_70648_aU() {
        return true;
    }

    private void switchNavigator(boolean onLand) {
        if (onLand) {
            this.field_70765_h = new MovementController((MobEntity)this);
            this.field_70699_by = new GroundPathNavigatorWide((MobEntity)this, this.field_70170_p);
            this.isLandNavigator = true;
        } else {
            this.field_70765_h = new AnimalSwimMoveControllerSink((CreatureEntity)this, 1.3f, 1.0f);
            this.field_70699_by = new SemiAquaticPathNavigator((MobEntity)this, this.field_70170_p);
            this.isLandNavigator = false;
        }
    }

    public void func_70071_h_() {
        double d1;
        double d0;
        BlockPos pos;
        super.func_70071_h_();
        if (this.localMimic != this.getPrevMimickedBlock()) {
            this.localMimic = this.getPrevMimickedBlock();
            this.colorShiftProgress = 0.0f;
        }
        if (this.localMimicState != this.getPrevMimicState()) {
            this.localMimicState = this.getPrevMimicState();
            this.transProgress = 0.0f;
        }
        if (this.func_70090_H() && this.isLandNavigator) {
            this.switchNavigator(false);
        }
        if (!this.func_70090_H() && !this.isLandNavigator) {
            this.switchNavigator(true);
        }
        boolean ground = this.field_70170_p.func_180495_p(pos = new BlockPos(this.func_226277_ct_(), this.func_226280_cw_() - 1.0, this.func_226281_cx_())).func_224755_d((IBlockReader)this.field_70170_p, pos, Direction.UP) && this.getMimicState() != MimicState.GUARDIAN || !this.func_203005_aq() || this.isSitting();
        this.prevTransProgress = this.transProgress;
        this.prevColorShiftProgress = this.colorShiftProgress;
        this.prevGroundProgress = this.groundProgress;
        this.prevSitProgress = this.sitProgress;
        if (this.getPrevMimicState() != this.getMimicState() && this.transProgress < 5.0f) {
            this.transProgress += 0.25f;
        }
        if (this.getPrevMimicState() == this.getMimicState() && this.transProgress > 0.0f) {
            this.transProgress -= 0.25f;
        }
        if (this.getPrevMimickedBlock() != this.getMimickedBlock() && this.colorShiftProgress < 5.0f) {
            this.colorShiftProgress += 0.25f;
        }
        if (this.getPrevMimickedBlock() == this.getMimickedBlock() && this.colorShiftProgress > 0.0f) {
            this.colorShiftProgress -= 0.25f;
        }
        if (ground && this.groundProgress < 5.0f) {
            this.groundProgress += 0.5f;
        }
        if (!ground && this.groundProgress > 0.0f) {
            this.groundProgress -= 0.5f;
        }
        if (this.isSitting() && this.sitProgress < 5.0f) {
            this.sitProgress += 0.5f;
        }
        if (!this.isSitting() && this.sitProgress > 0.0f) {
            this.sitProgress -= 0.5f;
        }
        if (this.func_203005_aq()) {
            float f2;
            this.field_70125_A = f2 = (float)(-((double)((float)this.func_213322_ci().field_72448_b * 3.0f) * 57.2957763671875));
        }
        if (this.camoCooldown > 0) {
            --this.camoCooldown;
        }
        if (this.mimicCooldown > 0) {
            --this.mimicCooldown;
        }
        if (this.stopMimicCooldown > 0) {
            --this.stopMimicCooldown;
        }
        if (this.func_175446_cd()) {
            this.func_70050_g(this.func_205010_bg());
        } else if (this.func_203008_ap() || this.func_184614_ca().func_77973_b() == Items.field_151131_as) {
            this.setMoistness(60000);
        } else {
            this.setMoistness(this.getMoistness() - 1);
            if (this.getMoistness() <= 0 && this.moistureAttackTime-- <= 0) {
                this.func_233687_w_(false);
                this.func_70097_a(DamageSource.field_205132_u, this.field_70146_Z.nextInt(2) == 0 ? 1.0f : 0.0f);
                this.moistureAttackTime = 20;
            }
        }
        if (this.camoCooldown <= 0 && this.field_70146_Z.nextInt(300) == 0) {
            this.mimicEnvironment();
            this.camoCooldown = this.func_70681_au().nextInt(2200) + 200;
        }
        if (!(this.getMimicState() == MimicState.OVERLAY && this.getMimickedBlock() == null || this.stopMimicCooldown != 0 || this.isStopChange())) {
            this.setMimicState(MimicState.OVERLAY);
            this.setMimickedBlock(null);
            this.stopMimicCooldown = -1;
        }
        if (this.field_70170_p.field_72995_K && this.exclaimTime > 0) {
            Entity e;
            --this.exclaimTime;
            if (this.exclaimTime == 0 && (e = this.field_70170_p.func_73045_a(((Integer)this.field_70180_af.func_187225_a(LAST_SCARED_MOB_ID)).intValue())) != null && this.transProgress >= 5.0f) {
                double d2 = this.field_70146_Z.nextGaussian() * 0.1;
                d0 = this.field_70146_Z.nextGaussian() * 0.1;
                d1 = this.field_70146_Z.nextGaussian() * 0.1;
                this.field_70170_p.func_195594_a((IParticleData)AMParticleRegistry.SHOCKED, e.func_226277_ct_(), e.func_226280_cw_() + (double)(e.func_213302_cg() * 0.15f) + (double)(this.field_70146_Z.nextFloat() * e.func_213302_cg() * 0.15f), e.func_226281_cx_(), d0, d1, d2);
            }
        }
        if (this.hasGuardianLaser()) {
            LivingEntity livingentity;
            if (this.guardianLaserTime < 30) {
                ++this.guardianLaserTime;
            }
            if ((livingentity = this.getGuardianLaser()) != null && this.func_203005_aq()) {
                this.func_70671_ap().func_75651_a((Entity)livingentity, 90.0f, 90.0f);
                this.func_70671_ap().func_75649_a();
                double d5 = this.getLaserAttackAnimationScale(0.0f);
                d0 = livingentity.func_226277_ct_() - this.func_226277_ct_();
                d1 = livingentity.func_226283_e_(0.5) - this.func_226280_cw_();
                double d2 = livingentity.func_226281_cx_() - this.func_226281_cx_();
                double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                d0 /= d3;
                d1 /= d3;
                d2 /= d3;
                double d4 = this.field_70146_Z.nextDouble();
                while (d4 < d3) {
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197612_e, this.func_226277_ct_() + d0 * (d4 += 1.8 - d5 + this.field_70146_Z.nextDouble() * (1.7 - d5)), this.func_226280_cw_() + d1 * d4, this.func_226281_cx_() + d2 * d4, 0.0, 0.0, 0.0);
                }
                if (this.guardianLaserTime == 30) {
                    livingentity.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), 5.0f);
                    this.guardianLaserTime = 0;
                    this.field_70180_af.func_187227_b(UPGRADED_LASER_ENTITY_ID, (Object)-1);
                }
            }
        }
        if (!this.field_70170_p.field_72995_K && this.field_70173_aa % 40 == 0) {
            this.func_70691_i(2.0f);
        }
    }

    public float getLaserAttackAnimationScale(float p_175477_1_) {
        return ((float)this.guardianLaserTime + p_175477_1_) / 30.0f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 68) {
            if (this.exclaimTime == 0) {
                this.exclaimTime = 20;
            }
        } else if (id == 69) {
            this.creeperExplode();
        } else {
            super.func_70103_a(id);
        }
    }

    public void mimicEnvironment() {
        if (!this.isStopChange()) {
            BlockPos down = this.getPositionDown();
            if (!this.field_70170_p.func_175623_d(down)) {
                this.setMimicState(MimicState.OVERLAY);
                this.setMimickedBlock(this.field_70170_p.func_180495_p(down));
            }
            this.stopMimicCooldown = this.func_70681_au().nextInt(2200);
        }
    }

    public int getMoistness() {
        return (Integer)this.field_70180_af.func_187225_a(MOISTNESS);
    }

    public void setMoistness(int p_211137_1_) {
        this.field_70180_af.func_187227_b(MOISTNESS, (Object)p_211137_1_);
    }

    private BlockPos getPositionDown() {
        BlockPos pos = new BlockPos(this.func_226277_ct_(), this.func_226280_cw_(), this.func_226281_cx_());
        while (pos.func_177956_o() > 1 && (this.field_70170_p.func_175623_d(pos) || this.field_70170_p.func_180495_p(pos).func_185904_a() == Material.field_151586_h)) {
            pos = pos.func_177977_b();
        }
        return pos;
    }

    public void func_213352_e(Vector3d travelVector) {
        if (this.isSitting()) {
            if (this.func_70661_as().func_75505_d() != null) {
                this.func_70661_as().func_75499_g();
            }
            travelVector = Vector3d.field_186680_a;
            super.func_213352_e(travelVector);
            return;
        }
        if (this.func_70613_aW() && this.func_70090_H()) {
            this.func_213309_a(this.func_70689_ay(), travelVector);
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
            this.func_213317_d(this.func_213322_ci().func_186678_a(0.9));
        } else {
            super.func_213352_e(travelVector);
        }
    }

    public boolean isSitting() {
        return (Boolean)this.field_70180_af.func_187225_a(SITTING);
    }

    public void func_233687_w_(boolean sit) {
        this.field_70180_af.func_187227_b(SITTING, (Object)sit);
    }

    public boolean isFromBucket() {
        return (Boolean)this.field_70180_af.func_187225_a(FROM_BUCKET);
    }

    public void setFromBucket(boolean sit) {
        this.field_70180_af.func_187227_b(FROM_BUCKET, (Object)sit);
    }

    public boolean isUpgraded() {
        return (Boolean)this.field_70180_af.func_187225_a(FROM_BUCKET);
    }

    public void setUpgraded(boolean sit) {
        this.field_70180_af.func_187227_b(FROM_BUCKET, (Object)sit);
    }

    public boolean isStopChange() {
        return (Boolean)this.field_70180_af.func_187225_a(STOP_CHANGE);
    }

    public void setStopChange(boolean sit) {
        this.field_70180_af.func_187227_b(STOP_CHANGE, (Object)sit);
    }

    public boolean hasGuardianLaser() {
        return (Integer)this.field_70180_af.func_187225_a(UPGRADED_LASER_ENTITY_ID) != -1 && this.isUpgraded() && this.func_203005_aq();
    }

    @Nullable
    public LivingEntity getGuardianLaser() {
        if (!this.hasGuardianLaser()) {
            return null;
        }
        if (this.field_70170_p.field_72995_K) {
            if (this.laserTargetEntity != null) {
                return this.laserTargetEntity;
            }
            Entity lvt_1_1_ = this.field_70170_p.func_73045_a(((Integer)this.field_70180_af.func_187225_a(UPGRADED_LASER_ENTITY_ID)).intValue());
            if (lvt_1_1_ instanceof LivingEntity) {
                this.laserTargetEntity = (LivingEntity)lvt_1_1_;
                return this.laserTargetEntity;
            }
            return null;
        }
        return this.func_70638_az();
    }

    @Nullable
    public AgeableEntity func_241840_a(ServerWorld serverWorld, AgeableEntity ageableEntity) {
        return (AgeableEntity)AMEntityRegistry.MIMIC_OCTOPUS.func_200721_a((World)serverWorld);
    }

    public boolean func_213397_c(double distanceToClosestPlayer) {
        return !this.func_70909_n() && !this.isFromBucket();
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(MIMIC_ORDINAL, (Object)0);
        this.field_70180_af.func_187214_a(PREV_MIMIC_ORDINAL, (Object)-1);
        this.field_70180_af.func_187214_a(MOISTNESS, (Object)60000);
        this.field_70180_af.func_187214_a(MIMICKED_BLOCK, Optional.empty());
        this.field_70180_af.func_187214_a(PREV_MIMICKED_BLOCK, Optional.empty());
        this.field_70180_af.func_187214_a(SITTING, (Object)false);
        this.field_70180_af.func_187214_a(COMMAND, (Object)0);
        this.field_70180_af.func_187214_a(LAST_SCARED_MOB_ID, (Object)-1);
        this.field_70180_af.func_187214_a(FROM_BUCKET, (Object)false);
        this.field_70180_af.func_187214_a(UPGRADED, (Object)false);
        this.field_70180_af.func_187214_a(STOP_CHANGE, (Object)false);
        this.field_70180_af.func_187214_a(UPGRADED_LASER_ENTITY_ID, (Object)-1);
    }

    public MimicState getMimicState() {
        return MimicState.values()[MathHelper.func_76125_a((int)((Integer)this.field_70180_af.func_187225_a(MIMIC_ORDINAL)), (int)0, (int)4)];
    }

    public void setMimicState(MimicState state) {
        if (this.getMimicState() != state) {
            this.field_70180_af.func_187227_b(PREV_MIMIC_ORDINAL, this.field_70180_af.func_187225_a(MIMIC_ORDINAL));
        }
        this.field_70180_af.func_187227_b(MIMIC_ORDINAL, (Object)state.ordinal());
    }

    public MimicState getPrevMimicState() {
        if ((Integer)this.field_70180_af.func_187225_a(PREV_MIMIC_ORDINAL) == -1) {
            return null;
        }
        return MimicState.values()[MathHelper.func_76125_a((int)((Integer)this.field_70180_af.func_187225_a(PREV_MIMIC_ORDINAL)), (int)0, (int)4)];
    }

    @Nullable
    public BlockState getMimickedBlock() {
        return ((Optional)this.field_70180_af.func_187225_a(MIMICKED_BLOCK)).orElse(null);
    }

    public void setMimickedBlock(@Nullable BlockState state) {
        if (this.getMimickedBlock() != state) {
            this.field_70180_af.func_187227_b(PREV_MIMICKED_BLOCK, Optional.ofNullable(this.getMimickedBlock()));
        }
        this.field_70180_af.func_187227_b(MIMICKED_BLOCK, Optional.ofNullable(state));
    }

    @Nullable
    public BlockState getPrevMimickedBlock() {
        return ((Optional)this.field_70180_af.func_187225_a(PREV_MIMICKED_BLOCK)).orElse(null);
    }

    protected void updateAir(int p_209207_1_) {
        if (this.func_70089_S() && !this.func_203005_aq()) {
            this.func_70050_g(p_209207_1_ - 1);
            if (this.func_70086_ai() == -20) {
                this.func_70050_g(0);
                this.func_70097_a(DamageSource.field_76369_e, 2.0f);
            }
        } else {
            this.func_70050_g(1200);
        }
    }

    @Override
    public boolean shouldEnterWater() {
        return !this.isSitting() && (this.func_70638_az() == null || this.func_70638_az().func_203005_aq());
    }

    @Override
    public boolean shouldLeaveWater() {
        return this.func_70638_az() != null && !this.func_70638_az().func_203005_aq();
    }

    @Override
    public boolean shouldStopMoving() {
        return this.isSitting();
    }

    @Override
    public int getWaterSearchRange() {
        return 16;
    }

    public boolean isTargetBlocked(Vector3d target) {
        Vector3d Vector3d2 = new Vector3d(this.func_226277_ct_(), this.func_226280_cw_(), this.func_226281_cx_());
        return this.field_70170_p.func_217299_a(new RayTraceContext(Vector3d2, target, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)this)).func_216346_c() != RayTraceResult.Type.MISS;
    }

    public Vector3d getBlockInViewAway(Vector3d fleePos, float radiusAdd) {
        float radius = -9.45f - (float)this.func_70681_au().nextInt(24) - radiusAdd;
        float neg = this.func_70681_au().nextBoolean() ? 1.0f : -1.0f;
        float renderYawOffset = this.field_70761_aq;
        float angle = (float)Math.PI / 180 * renderYawOffset + 3.15f + this.func_70681_au().nextFloat() * neg;
        double extraX = radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)));
        double extraZ = radius * MathHelper.func_76134_b((float)angle);
        BlockPos radialPos = new BlockPos(fleePos.func_82615_a() + extraX, 0.0, fleePos.func_82616_c() + extraZ);
        BlockPos ground = this.getOctopusGround(radialPos);
        return ground != null ? Vector3d.func_237489_a_((Vector3i)ground) : null;
    }

    private BlockPos getOctopusGround(BlockPos in) {
        BlockPos position = new BlockPos((double)in.func_177958_n(), this.func_226278_cu_(), (double)in.func_177952_p());
        while (position.func_177956_o() > 2 && this.field_70170_p.func_204610_c(position).func_206884_a((ITag)FluidTags.field_206959_a)) {
            position = position.func_177977_b();
        }
        return position;
    }

    public void func_184206_a(DataParameter<?> key) {
        super.func_184206_a(key);
        if (UPGRADED_LASER_ENTITY_ID.equals(key)) {
            this.guardianLaserTime = 0;
            this.laserTargetEntity = null;
        }
    }

    private void creeperExplode() {
        Explosion explosion = new Explosion(this.field_70170_p, (Entity)this, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 1.0f + this.field_70146_Z.nextFloat(), false, Explosion.Mode.NONE);
        explosion.func_77278_a();
        explosion.func_77279_a(true);
    }

    private class AIAttack
    extends Goal {
        private int executionCooldown = 0;
        private int scareMobTime = 0;
        private Vector3d fleePosition = null;

        public AIAttack() {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean func_75250_a() {
            if (this.executionCooldown > 0) {
                EntityMimicOctopus.this.field_70180_af.func_187227_b(UPGRADED_LASER_ENTITY_ID, (Object)-1);
                --this.executionCooldown;
            }
            if (EntityMimicOctopus.this.isStopChange() && EntityMimicOctopus.this.getMimicState() == MimicState.OVERLAY) {
                return false;
            }
            return this.executionCooldown == 0 && EntityMimicOctopus.this.func_70909_n() && EntityMimicOctopus.this.func_70638_az() != null && EntityMimicOctopus.this.func_70638_az().func_70089_S();
        }

        public void func_75251_c() {
            this.fleePosition = null;
            this.scareMobTime = 0;
            this.executionCooldown = 100 + EntityMimicOctopus.this.field_70146_Z.nextInt(200);
            if (EntityMimicOctopus.this.isUpgraded()) {
                this.executionCooldown = 30;
            } else {
                EntityMimicOctopus.this.func_70604_c(null);
                EntityMimicOctopus.this.func_70624_b(null);
            }
            if (EntityMimicOctopus.this.stopMimicCooldown <= 0) {
                EntityMimicOctopus.this.mimicEnvironment();
            }
            EntityMimicOctopus.this.field_70180_af.func_187227_b(UPGRADED_LASER_ENTITY_ID, (Object)-1);
        }

        public Vector3d generateFleePosition(LivingEntity fleer) {
            for (int i = 0; i < 15; ++i) {
                BlockPos pos = fleer.func_233580_cy_().func_177982_a(EntityMimicOctopus.this.field_70146_Z.nextInt(32) - 16, EntityMimicOctopus.this.field_70146_Z.nextInt(16), EntityMimicOctopus.this.field_70146_Z.nextInt(32) - 16);
                while (fleer.field_70170_p.func_175623_d(pos) && pos.func_177956_o() > 1) {
                    pos = pos.func_177977_b();
                }
                if (fleer instanceof CreatureEntity) {
                    if (!(((CreatureEntity)fleer).func_180484_a(pos) >= 0.0f)) continue;
                    return Vector3d.func_237489_a_((Vector3i)pos);
                }
                return Vector3d.func_237489_a_((Vector3i)pos);
            }
            return null;
        }

        public void func_75246_d() {
            LivingEntity target = EntityMimicOctopus.this.func_70638_az();
            if (target != null) {
                if (this.scareMobTime > 0) {
                    if (this.fleePosition == null || target.func_195048_a(this.fleePosition) < (double)(target.func_213311_cf() * target.func_213311_cf() * 2.0f)) {
                        this.fleePosition = this.generateFleePosition(target);
                    }
                    if (target instanceof MobEntity && this.fleePosition != null) {
                        ((MobEntity)target).func_70661_as().func_75492_a(this.fleePosition.field_72450_a, this.fleePosition.field_72448_b, this.fleePosition.field_72449_c, 1.5);
                        ((MobEntity)target).func_70605_aq().func_75642_a(this.fleePosition.field_72450_a, this.fleePosition.field_72448_b, this.fleePosition.field_72449_c, 1.5);
                        ((MobEntity)target).func_70624_b(null);
                    }
                    EntityMimicOctopus.this.camoCooldown = Math.max(EntityMimicOctopus.this.camoCooldown, 20);
                    EntityMimicOctopus.this.stopMimicCooldown = Math.max(EntityMimicOctopus.this.stopMimicCooldown, 20);
                    --this.scareMobTime;
                    if (this.scareMobTime == 0) {
                        this.func_75251_c();
                        return;
                    }
                }
                double dist = EntityMimicOctopus.this.func_70032_d((Entity)target);
                boolean move = true;
                if (dist < 7.0 && EntityMimicOctopus.this.func_70685_l((Entity)target) && EntityMimicOctopus.this.getMimicState() == MimicState.GUARDIAN && EntityMimicOctopus.this.isUpgraded()) {
                    EntityMimicOctopus.this.field_70180_af.func_187227_b(UPGRADED_LASER_ENTITY_ID, (Object)target.func_145782_y());
                    move = false;
                }
                if (dist < 3.0) {
                    EntityMimicOctopus.this.field_70180_af.func_187227_b(LAST_SCARED_MOB_ID, (Object)target.func_145782_y());
                    if (move) {
                        move = EntityMimicOctopus.this.isUpgraded() && dist > 2.0;
                    }
                    EntityMimicOctopus.this.func_70661_as().func_75499_g();
                    if (!EntityMimicOctopus.this.isStopChange()) {
                        EntityMimicOctopus.this.setMimickedBlock(null);
                        MimicState prev = EntityMimicOctopus.this.getMimicState();
                        if (EntityMimicOctopus.this.func_203005_aq()) {
                            if (prev != MimicState.GUARDIAN && prev != MimicState.PUFFERFISH) {
                                if (EntityMimicOctopus.this.field_70146_Z.nextBoolean()) {
                                    EntityMimicOctopus.this.setMimicState(MimicState.GUARDIAN);
                                } else {
                                    EntityMimicOctopus.this.setMimicState(MimicState.PUFFERFISH);
                                }
                            }
                        } else {
                            EntityMimicOctopus.this.setMimicState(MimicState.CREEPER);
                        }
                    }
                    if (EntityMimicOctopus.this.getMimicState() != MimicState.OVERLAY) {
                        EntityMimicOctopus.this.mimicCooldown = 40;
                        EntityMimicOctopus.this.stopMimicCooldown = Math.max(EntityMimicOctopus.this.stopMimicCooldown, 60);
                    }
                    if (EntityMimicOctopus.this.isUpgraded() && EntityMimicOctopus.this.transProgress >= 5.0f) {
                        if (EntityMimicOctopus.this.getMimicState() == MimicState.PUFFERFISH && EntityMimicOctopus.this.func_174813_aQ().func_72321_a(2.0, 1.3, 2.0).func_72326_a(target.func_174813_aQ())) {
                            target.func_70097_a(DamageSource.func_76358_a((LivingEntity)EntityMimicOctopus.this), 4.0f);
                            target.func_195064_c(new EffectInstance(Effects.field_76436_u, 400, 2));
                        }
                        if (EntityMimicOctopus.this.getMimicState() == MimicState.GUARDIAN) {
                            if (EntityMimicOctopus.this.func_174813_aQ().func_72321_a(1.0, 1.0, 1.0).func_72326_a(target.func_174813_aQ())) {
                                target.func_70097_a(DamageSource.func_76358_a((LivingEntity)EntityMimicOctopus.this), 1.0f);
                            }
                            EntityMimicOctopus.this.field_70180_af.func_187227_b(UPGRADED_LASER_ENTITY_ID, (Object)target.func_145782_y());
                        }
                        if (EntityMimicOctopus.this.getMimicState() == MimicState.CREEPER) {
                            EntityMimicOctopus.this.creeperExplode();
                            EntityMimicOctopus.this.field_70170_p.func_72960_a((Entity)EntityMimicOctopus.this, (byte)69);
                            this.executionCooldown = 300;
                        }
                    }
                    if (this.scareMobTime == 0) {
                        EntityMimicOctopus.this.field_70170_p.func_72960_a((Entity)EntityMimicOctopus.this, (byte)68);
                        this.scareMobTime = 60 + EntityMimicOctopus.this.field_70146_Z.nextInt(60);
                    }
                }
                if (move) {
                    EntityMimicOctopus.this.func_70625_a((Entity)target, 30.0f, 30.0f);
                    EntityMimicOctopus.this.func_70661_as().func_75497_a((Entity)target, (double)1.2f);
                }
            }
        }
    }

    private class AIMimicNearbyMobs
    extends Goal {
        protected final EntitySorter theNearestAttackableTargetSorter;
        protected final Predicate<? super Entity> targetEntitySelector;
        protected int executionChance = 30;
        protected boolean mustUpdate;
        private Entity targetEntity;
        private Vector3d flightTarget = null;
        private int cooldown = 0;

        AIMimicNearbyMobs() {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
            this.theNearestAttackableTargetSorter = new EntitySorter((Entity)EntityMimicOctopus.this);
            this.targetEntitySelector = new Predicate<Entity>(){

                public boolean apply(@Nullable Entity e) {
                    return e.func_70089_S() && (e instanceof CreeperEntity || e instanceof GuardianEntity || e instanceof PufferfishEntity);
                }
            };
        }

        public boolean func_75250_a() {
            List list;
            if (EntityMimicOctopus.this.func_184218_aH() || EntityMimicOctopus.this.func_184207_aI() || EntityMimicOctopus.this.getMimicState() != MimicState.OVERLAY || EntityMimicOctopus.this.mimicCooldown > 0) {
                return false;
            }
            if (!this.mustUpdate) {
                long worldTime = EntityMimicOctopus.this.field_70170_p.func_82737_E() % 10L;
                if (EntityMimicOctopus.this.func_70654_ax() >= 100 && worldTime != 0L) {
                    return false;
                }
                if (EntityMimicOctopus.this.func_70681_au().nextInt(this.executionChance) != 0 && worldTime != 0L) {
                    return false;
                }
            }
            if ((list = EntityMimicOctopus.this.field_70170_p.func_175647_a(Entity.class, this.getTargetableArea(this.getTargetDistance()), this.targetEntitySelector)).isEmpty()) {
                return false;
            }
            Collections.sort(list, this.theNearestAttackableTargetSorter);
            this.targetEntity = (Entity)list.get(0);
            this.mustUpdate = false;
            return true;
        }

        public boolean func_75253_b() {
            return this.targetEntity != null && EntityMimicOctopus.this.func_70032_d(this.targetEntity) < 10.0f && EntityMimicOctopus.this.getMimicState() == MimicState.OVERLAY;
        }

        public void func_75251_c() {
            EntityMimicOctopus.this.func_70661_as().func_75499_g();
            this.flightTarget = null;
            this.targetEntity = null;
        }

        public void func_75246_d() {
            if (this.cooldown > 0) {
                --this.cooldown;
            }
            if (this.targetEntity != null) {
                EntityMimicOctopus.this.func_70661_as().func_75497_a(this.targetEntity, (double)1.2f);
                if (EntityMimicOctopus.this.func_70032_d(this.targetEntity) > 20.0f) {
                    this.func_75251_c();
                    EntityMimicOctopus.this.setMimicState(MimicState.OVERLAY);
                    EntityMimicOctopus.this.setMimickedBlock(null);
                } else if (EntityMimicOctopus.this.func_70032_d(this.targetEntity) < 5.0f && EntityMimicOctopus.this.func_70685_l(this.targetEntity)) {
                    int i = 1200;
                    EntityMimicOctopus.this.stopMimicCooldown = i;
                    EntityMimicOctopus.this.camoCooldown = i + 40;
                    EntityMimicOctopus.this.mimicCooldown = 40;
                    if (this.targetEntity instanceof CreeperEntity) {
                        EntityMimicOctopus.this.setMimicState(MimicState.CREEPER);
                    } else if (this.targetEntity instanceof GuardianEntity) {
                        EntityMimicOctopus.this.setMimicState(MimicState.GUARDIAN);
                    } else if (this.targetEntity instanceof PufferfishEntity) {
                        EntityMimicOctopus.this.setMimicState(MimicState.PUFFERFISH);
                    } else {
                        EntityMimicOctopus.this.setMimicState(MimicState.OVERLAY);
                        EntityMimicOctopus.this.setMimickedBlock(null);
                    }
                    this.func_75251_c();
                }
            }
        }

        protected double getTargetDistance() {
            return 10.0;
        }

        protected AxisAlignedBB getTargetableArea(double targetDistance) {
            Vector3d renderCenter = new Vector3d(EntityMimicOctopus.this.func_226277_ct_(), EntityMimicOctopus.this.func_226278_cu_() + 0.5, EntityMimicOctopus.this.func_226281_cx_());
            AxisAlignedBB aabb = new AxisAlignedBB(-targetDistance, -targetDistance, -targetDistance, targetDistance, targetDistance, targetDistance);
            return aabb.func_191194_a(renderCenter);
        }
    }

    public class FollowOwner
    extends Goal {
        private final EntityMimicOctopus tameable;
        private final IWorldReader world;
        private final double followSpeed;
        private final float maxDist;
        private final float minDist;
        private final boolean teleportToLeaves;
        private LivingEntity owner;
        private int timeToRecalcPath;
        private float oldWaterCost;

        public FollowOwner(EntityMimicOctopus p_i225711_1_, double p_i225711_2_, float p_i225711_4_, float p_i225711_5_, boolean p_i225711_6_) {
            this.tameable = p_i225711_1_;
            this.world = p_i225711_1_.field_70170_p;
            this.followSpeed = p_i225711_2_;
            this.minDist = p_i225711_4_;
            this.maxDist = p_i225711_5_;
            this.teleportToLeaves = p_i225711_6_;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean func_75250_a() {
            LivingEntity lvt_1_1_ = this.tameable.func_70902_q();
            if (lvt_1_1_ == null) {
                return false;
            }
            if (lvt_1_1_.func_175149_v()) {
                return false;
            }
            if (this.tameable.isSitting() || this.tameable.getCommand() != 1) {
                return false;
            }
            if (this.tameable.func_70068_e((Entity)lvt_1_1_) < (double)(this.minDist * this.minDist)) {
                return false;
            }
            if (this.tameable.func_70638_az() != null && this.tameable.func_70638_az().func_70089_S()) {
                return false;
            }
            this.owner = lvt_1_1_;
            return true;
        }

        public boolean func_75253_b() {
            if (this.tameable.func_70661_as().func_75500_f()) {
                return false;
            }
            if (this.tameable.isSitting() || this.tameable.getCommand() != 1) {
                return false;
            }
            if (this.tameable.func_70638_az() != null && this.tameable.func_70638_az().func_70089_S()) {
                return false;
            }
            return this.tameable.func_70068_e((Entity)this.owner) > (double)(this.maxDist * this.maxDist);
        }

        public void func_75249_e() {
            this.timeToRecalcPath = 0;
            this.oldWaterCost = this.tameable.func_184643_a(PathNodeType.WATER);
            this.tameable.func_184644_a(PathNodeType.WATER, 0.0f);
        }

        public void func_75251_c() {
            this.owner = null;
            this.tameable.func_70661_as().func_75499_g();
            this.tameable.func_184644_a(PathNodeType.WATER, this.oldWaterCost);
        }

        public void func_75246_d() {
            this.tameable.func_70671_ap().func_75651_a((Entity)this.owner, 10.0f, (float)this.tameable.func_70646_bf());
            if (--this.timeToRecalcPath <= 0) {
                this.timeToRecalcPath = 10;
                if (!this.tameable.func_110167_bD() && !this.tameable.func_184218_aH()) {
                    if (this.tameable.func_70068_e((Entity)this.owner) >= 144.0) {
                        this.tryToTeleportNearEntity();
                    } else {
                        this.tameable.func_70661_as().func_75497_a((Entity)this.owner, this.followSpeed);
                    }
                }
            }
        }

        private void tryToTeleportNearEntity() {
            BlockPos lvt_1_1_ = this.owner.func_233580_cy_();
            for (int lvt_2_1_ = 0; lvt_2_1_ < 10; ++lvt_2_1_) {
                int lvt_3_1_ = this.getRandomNumber(-3, 3);
                int lvt_4_1_ = this.getRandomNumber(-1, 1);
                int lvt_5_1_ = this.getRandomNumber(-3, 3);
                boolean lvt_6_1_ = this.tryToTeleportToLocation(lvt_1_1_.func_177958_n() + lvt_3_1_, lvt_1_1_.func_177956_o() + lvt_4_1_, lvt_1_1_.func_177952_p() + lvt_5_1_);
                if (!lvt_6_1_) continue;
                return;
            }
        }

        private boolean tryToTeleportToLocation(int p_226328_1_, int p_226328_2_, int p_226328_3_) {
            if (Math.abs((double)p_226328_1_ - this.owner.func_226277_ct_()) < 2.0 && Math.abs((double)p_226328_3_ - this.owner.func_226281_cx_()) < 2.0) {
                return false;
            }
            if (!this.isTeleportFriendlyBlock(new BlockPos(p_226328_1_, p_226328_2_, p_226328_3_))) {
                return false;
            }
            this.tameable.func_70012_b((double)p_226328_1_ + 0.5, p_226328_2_, (double)p_226328_3_ + 0.5, this.tameable.field_70177_z, this.tameable.field_70125_A);
            this.tameable.func_70661_as().func_75499_g();
            return true;
        }

        private boolean isTeleportFriendlyBlock(BlockPos p_226329_1_) {
            PathNodeType lvt_2_1_ = WalkNodeProcessor.func_237231_a_((IBlockReader)this.world, (BlockPos.Mutable)p_226329_1_.func_239590_i_());
            if (this.world.func_204610_c(p_226329_1_).func_206884_a((ITag)FluidTags.field_206959_a) || !this.world.func_204610_c(p_226329_1_).func_206884_a((ITag)FluidTags.field_206959_a) && this.world.func_204610_c(p_226329_1_.func_177977_b()).func_206884_a((ITag)FluidTags.field_206959_a)) {
                return true;
            }
            if (lvt_2_1_ != PathNodeType.WALKABLE || this.tameable.getMoistness() < 2000) {
                return false;
            }
            BlockState lvt_3_1_ = this.world.func_180495_p(p_226329_1_.func_177977_b());
            if (!this.teleportToLeaves && lvt_3_1_.func_177230_c() instanceof LeavesBlock) {
                return false;
            }
            BlockPos lvt_4_1_ = p_226329_1_.func_177973_b((Vector3i)this.tameable.func_233580_cy_());
            return this.world.func_226665_a__((Entity)this.tameable, this.tameable.func_174813_aQ().func_186670_a(lvt_4_1_));
        }

        private int getRandomNumber(int p_226327_1_, int p_226327_2_) {
            return this.tameable.func_70681_au().nextInt(p_226327_2_ - p_226327_1_ + 1) + p_226327_1_;
        }
    }

    public class EntitySorter
    implements Comparator<Entity> {
        private final Entity theEntity;

        public EntitySorter(Entity theEntityIn) {
            this.theEntity = theEntityIn;
        }

        @Override
        public int compare(Entity p_compare_1_, Entity p_compare_2_) {
            double d1;
            double d0 = this.theEntity.func_70068_e(p_compare_1_);
            return d0 < (d1 = this.theEntity.func_70068_e(p_compare_2_)) ? -1 : (d0 > d1 ? 1 : 0);
        }
    }

    private class AIFlee
    extends Goal {
        protected final EntitySorter theNearestAttackableTargetSorter;
        protected final Predicate<? super Entity> targetEntitySelector;
        protected int executionChance = 8;
        protected boolean mustUpdate;
        private Entity targetEntity;
        private Vector3d flightTarget = null;
        private int cooldown = 0;
        private ITag tag;

        AIFlee() {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
            this.tag = EntityTypeTags.func_219762_a().func_199910_a(AMTagRegistry.MIMIC_OCTOPUS_FEARS);
            this.theNearestAttackableTargetSorter = new EntitySorter((Entity)EntityMimicOctopus.this);
            this.targetEntitySelector = new Predicate<Entity>(){

                public boolean apply(@Nullable Entity e) {
                    return e.func_70089_S() && e.func_200600_R().func_220341_a(AIFlee.this.tag) || e instanceof PlayerEntity && !((PlayerEntity)e).func_184812_l_();
                }
            };
        }

        public boolean func_75250_a() {
            List list;
            if (EntityMimicOctopus.this.func_184218_aH() || EntityMimicOctopus.this.func_184207_aI() || EntityMimicOctopus.this.func_70909_n()) {
                return false;
            }
            if (!this.mustUpdate) {
                long worldTime = EntityMimicOctopus.this.field_70170_p.func_82737_E() % 10L;
                if (EntityMimicOctopus.this.func_70654_ax() >= 100 && worldTime != 0L) {
                    return false;
                }
                if (EntityMimicOctopus.this.func_70681_au().nextInt(this.executionChance) != 0 && worldTime != 0L) {
                    return false;
                }
            }
            if ((list = EntityMimicOctopus.this.field_70170_p.func_175647_a(Entity.class, this.getTargetableArea(this.getTargetDistance()), this.targetEntitySelector)).isEmpty()) {
                return false;
            }
            Collections.sort(list, this.theNearestAttackableTargetSorter);
            this.targetEntity = (Entity)list.get(0);
            this.mustUpdate = false;
            return true;
        }

        public boolean func_75253_b() {
            return this.targetEntity != null && !EntityMimicOctopus.this.func_70909_n() && EntityMimicOctopus.this.func_70032_d(this.targetEntity) < 20.0f;
        }

        public void func_75251_c() {
            this.flightTarget = null;
            this.targetEntity = null;
            EntityMimicOctopus.this.setMimicState(MimicState.OVERLAY);
            EntityMimicOctopus.this.setMimickedBlock(null);
        }

        public void func_75246_d() {
            if (this.cooldown > 0) {
                --this.cooldown;
            }
            if (!EntityMimicOctopus.this.isActiveCamo()) {
                EntityMimicOctopus.this.mimicEnvironment();
            }
            if (this.flightTarget != null) {
                EntityMimicOctopus.this.func_70661_as().func_75492_a(this.flightTarget.field_72450_a, this.flightTarget.field_72448_b, this.flightTarget.field_72449_c, (double)1.2f);
                if (this.cooldown == 0 && EntityMimicOctopus.this.isTargetBlocked(this.flightTarget)) {
                    this.cooldown = 30;
                    this.flightTarget = null;
                }
            }
            if (this.targetEntity != null) {
                Vector3d vec;
                if ((this.flightTarget == null || this.flightTarget != null && EntityMimicOctopus.this.func_195048_a(this.flightTarget) < 6.0) && (vec = RandomPositionGenerator.func_75461_b((CreatureEntity)EntityMimicOctopus.this, (int)16, (int)7, (Vector3d)this.targetEntity.func_213303_ch())) != null) {
                    this.flightTarget = vec;
                }
                if (EntityMimicOctopus.this.func_70032_d(this.targetEntity) > 20.0f) {
                    this.func_75251_c();
                }
            }
        }

        protected double getTargetDistance() {
            return 10.0;
        }

        protected AxisAlignedBB getTargetableArea(double targetDistance) {
            Vector3d renderCenter = new Vector3d(EntityMimicOctopus.this.func_226277_ct_(), EntityMimicOctopus.this.func_226278_cu_() + 0.5, EntityMimicOctopus.this.func_226281_cx_());
            AxisAlignedBB aabb = new AxisAlignedBB(-targetDistance, -targetDistance, -targetDistance, targetDistance, targetDistance, targetDistance);
            return aabb.func_191194_a(renderCenter);
        }
    }

    private class AISwim
    extends SemiAquaticAIRandomSwimming {
        public AISwim() {
            super((AnimalEntity)EntityMimicOctopus.this, 1.0, 35);
        }

        @Override
        protected Vector3d findSurfaceTarget(CreatureEntity creature, int i, int i1) {
            if (creature.func_70681_au().nextInt(5) == 0) {
                return super.findSurfaceTarget(creature, i, i1);
            }
            BlockPos downPos = creature.func_233580_cy_();
            while (creature.field_70170_p.func_204610_c(downPos).func_206884_a((ITag)FluidTags.field_206959_a) || creature.field_70170_p.func_204610_c(downPos).func_206884_a((ITag)FluidTags.field_206960_b)) {
                downPos = downPos.func_177977_b();
            }
            if (EntityMimicOctopus.this.field_70170_p.func_180495_p(downPos).func_200132_m() && EntityMimicOctopus.this.field_70170_p.func_180495_p(downPos).func_177230_c() != Blocks.field_196814_hQ) {
                return new Vector3d((double)((float)downPos.func_177958_n() + 0.5f), (double)downPos.func_177956_o(), (double)((float)downPos.func_177952_p() + 0.5f));
            }
            return null;
        }
    }

    public static enum MimicState {
        OVERLAY,
        CREEPER,
        GUARDIAN,
        PUFFERFISH,
        MIMICUBE;

    }
}

