/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity;

import com.github.alexthe666.alexsmobs.client.particle.AMParticleRegistry;
import com.github.alexthe666.alexsmobs.entity.AMEntityRegistry;
import com.github.alexthe666.alexsmobs.entity.EntityVoidWorm;
import com.github.alexthe666.alexsmobs.entity.EntityVoidWormPart;
import com.github.alexthe666.alexsmobs.event.ServerEvents;
import com.github.alexthe666.alexsmobs.misc.AMSoundRegistry;
import com.mojang.serialization.DynamicOps;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.NBTDynamicOps;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.Direction;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;
import org.antlr.v4.runtime.misc.Triple;
import org.apache.logging.log4j.Logger;

public class EntityVoidPortal
extends Entity {
    protected static final DataParameter<Direction> ATTACHED_FACE = EntityDataManager.func_187226_a(EntityVoidPortal.class, (IDataSerializer)DataSerializers.field_187202_l);
    protected static final DataParameter<Integer> LIFESPAN = EntityDataManager.func_187226_a(EntityVoidPortal.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Optional<BlockPos>> DESTINATION = EntityDataManager.func_187226_a(EntityVoidPortal.class, (IDataSerializer)DataSerializers.field_187201_k);
    private static final DataParameter<Optional<UUID>> SISTER_UUID = EntityDataManager.func_187226_a(EntityVoidWorm.class, (IDataSerializer)DataSerializers.field_187203_m);
    public RegistryKey<World> exitDimension;
    private boolean madeOpenNoise = false;
    private boolean madeCloseNoise = false;
    private boolean isDummy = false;

    public EntityVoidPortal(EntityType<?> entityTypeIn, World worldIn) {
        super(entityTypeIn, worldIn);
    }

    public EntityVoidPortal(FMLPlayMessages.SpawnEntity spawnEntity, World world) {
        this(AMEntityRegistry.VOID_PORTAL, world);
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70173_aa == 1 && this.getLifespan() == 0) {
            this.setLifespan(100);
        }
        if (!this.madeOpenNoise) {
            this.func_184185_a(AMSoundRegistry.VOID_PORTAL_OPEN, 1.0f, 1.0f + this.field_70146_Z.nextFloat() * 0.2f);
            this.madeOpenNoise = true;
        }
        Direction direction2 = this.getAttachmentFacing().func_176734_d();
        float minX = -0.15f;
        float minY = -0.15f;
        float minZ = -0.15f;
        float maxX = 0.15f;
        float maxY = 0.15f;
        float maxZ = 0.15f;
        switch (direction2) {
            case NORTH: 
            case SOUTH: {
                minX = -1.5f;
                maxX = 1.5f;
                minY = -1.5f;
                maxY = 1.5f;
                break;
            }
            case EAST: 
            case WEST: {
                minZ = -1.5f;
                maxZ = 1.5f;
                minY = -1.5f;
                maxY = 1.5f;
                break;
            }
            case UP: 
            case DOWN: {
                minX = -1.5f;
                maxX = 1.5f;
                minZ = -1.5f;
                maxZ = 1.5f;
            }
        }
        AxisAlignedBB bb = new AxisAlignedBB(this.func_226277_ct_() + (double)minX, this.func_226278_cu_() + (double)minY, this.func_226281_cx_() + (double)minZ, this.func_226277_ct_() + (double)maxX, this.func_226278_cu_() + (double)maxY, this.func_226281_cx_() + (double)maxZ);
        this.func_174826_a(bb);
        if (this.field_70146_Z.nextFloat() < 0.5f && this.field_70170_p.field_72995_K && Math.min(this.field_70173_aa, this.getLifespan()) >= 20) {
            double particleX = this.func_174813_aQ().field_72340_a + (double)this.field_70146_Z.nextFloat() * (this.func_174813_aQ().field_72336_d - this.func_174813_aQ().field_72340_a);
            double particleY = this.func_174813_aQ().field_72338_b + (double)this.field_70146_Z.nextFloat() * (this.func_174813_aQ().field_72337_e - this.func_174813_aQ().field_72338_b);
            double particleZ = this.func_174813_aQ().field_72339_c + (double)this.field_70146_Z.nextFloat() * (this.func_174813_aQ().field_72334_f - this.func_174813_aQ().field_72339_c);
            this.field_70170_p.func_195594_a((IParticleData)AMParticleRegistry.WORM_PORTAL, particleX, particleY, particleZ, 0.1 * this.field_70146_Z.nextGaussian(), 0.1 * this.field_70146_Z.nextGaussian(), 0.1 * this.field_70146_Z.nextGaussian());
        }
        List entities = this.field_70170_p.func_72839_b((Entity)this, bb.func_186664_h((double)0.2f));
        if (!this.field_70170_p.field_72995_K) {
            MinecraftServer server = this.field_70170_p.func_73046_m();
            if (this.getDestination() != null && this.getLifespan() > 20 && this.field_70173_aa > 20) {
                BlockPos offsetPos = this.getDestination().func_177967_a(this.getAttachmentFacing().func_176734_d(), 2);
                for (Entity e : entities) {
                    ServerWorld dimWorld;
                    if (e.func_242280_ah() || e.func_225608_bj_() || e instanceof EntityVoidPortal) continue;
                    if (e instanceof EntityVoidWormPart) {
                        if (this.getLifespan() >= 22) continue;
                        this.setLifespan(this.getLifespan() + 1);
                        continue;
                    }
                    if (e instanceof EntityVoidWorm) {
                        ((EntityVoidWorm)e).teleportTo(Vector3d.func_237489_a_((Vector3i)this.getDestination()));
                        e.func_242279_ag();
                        ((EntityVoidWorm)e).resetPortalLogic();
                        continue;
                    }
                    boolean flag = true;
                    if (this.exitDimension != null && (dimWorld = server.func_71218_a(this.exitDimension)) != null && this.field_70170_p.func_234923_W_() != this.exitDimension) {
                        this.teleportEntityFromDimension(e, dimWorld, offsetPos, true);
                        flag = false;
                    }
                    if (!flag) continue;
                    e.func_223102_j((double)((float)offsetPos.func_177958_n() + 0.5f), (double)((float)offsetPos.func_177956_o() + 0.5f), (double)((float)offsetPos.func_177952_p() + 0.5f));
                    e.func_242279_ag();
                }
            }
        }
        this.setLifespan(this.getLifespan() - 1);
        if (this.getLifespan() <= 20 && !this.madeCloseNoise) {
            this.func_184185_a(AMSoundRegistry.VOID_PORTAL_CLOSE, 1.0f, 1.0f + this.field_70146_Z.nextFloat() * 0.2f);
            this.madeCloseNoise = true;
        }
        if (this.getLifespan() <= 0) {
            this.func_70106_y();
        }
    }

    private void teleportEntityFromDimension(Entity entity, ServerWorld endpointWorld, BlockPos endpoint, boolean b) {
        if (entity instanceof ServerPlayerEntity) {
            ServerEvents.teleportPlayers.add((Triple<ServerPlayerEntity, ServerWorld, BlockPos>)new Triple((Object)((ServerPlayerEntity)entity), (Object)endpointWorld, (Object)endpoint));
            if (this.getSisterId() == null) {
                this.createAndSetSister((World)endpointWorld, Direction.DOWN);
            }
        } else {
            entity.func_213319_R();
            entity.func_70029_a((World)endpointWorld);
            Entity teleportedEntity = entity.func_200600_R().func_200721_a((World)endpointWorld);
            if (teleportedEntity != null) {
                teleportedEntity.func_180432_n(entity);
                teleportedEntity.func_70012_b((double)endpoint.func_177958_n() + 0.5, (double)endpoint.func_177956_o() + 0.5, (double)endpoint.func_177952_p() + 0.5, entity.field_70177_z, entity.field_70125_A);
                teleportedEntity.func_70034_d(entity.field_70177_z);
                teleportedEntity.func_242279_ag();
                endpointWorld.func_217460_e(teleportedEntity);
            }
        }
    }

    public Direction getAttachmentFacing() {
        return (Direction)this.field_70180_af.func_187225_a(ATTACHED_FACE);
    }

    public void setAttachmentFacing(Direction facing) {
        this.field_70180_af.func_187227_b(ATTACHED_FACE, (Object)facing);
    }

    public int getLifespan() {
        return (Integer)this.field_70180_af.func_187225_a(LIFESPAN);
    }

    public void setLifespan(int i) {
        this.field_70180_af.func_187227_b(LIFESPAN, (Object)i);
    }

    public BlockPos getDestination() {
        return ((Optional)this.field_70180_af.func_187225_a(DESTINATION)).orElse(null);
    }

    public void setDestination(BlockPos destination) {
        this.field_70180_af.func_187227_b(DESTINATION, Optional.ofNullable(destination));
        if (this.getSisterId() == null && (this.exitDimension == null || this.exitDimension == this.field_70170_p.func_234923_W_())) {
            this.createAndSetSister(this.field_70170_p, null);
        }
    }

    public void createAndSetSister(World world, Direction dir) {
        EntityVoidPortal portal = (EntityVoidPortal)AMEntityRegistry.VOID_PORTAL.func_200721_a(world);
        portal.setAttachmentFacing(dir != null ? dir : this.getAttachmentFacing().func_176734_d());
        portal.func_223102_j((float)this.getDestination().func_177958_n() + 0.5f, (float)this.getDestination().func_177956_o() + 0.5f, (float)this.getDestination().func_177952_p() + 0.5f);
        portal.link(this);
        portal.exitDimension = this.field_70170_p.func_234923_W_();
        world.func_217376_c((Entity)portal);
    }

    public void setDestination(BlockPos destination, Direction dir) {
        this.field_70180_af.func_187227_b(DESTINATION, Optional.ofNullable(destination));
        if (this.getSisterId() == null && (this.exitDimension == null || this.exitDimension == this.field_70170_p.func_234923_W_())) {
            this.createAndSetSister(this.field_70170_p, dir);
        }
    }

    public void link(EntityVoidPortal portal) {
        this.setSisterId(portal.func_110124_au());
        portal.setSisterId(this.func_110124_au());
        portal.setLifespan(this.getLifespan());
        this.setDestination(portal.func_233580_cy_());
        portal.setDestination(this.func_233580_cy_());
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(ATTACHED_FACE, (Object)Direction.DOWN);
        this.field_70180_af.func_187214_a(LIFESPAN, (Object)300);
        this.field_70180_af.func_187214_a(SISTER_UUID, Optional.empty());
        this.field_70180_af.func_187214_a(DESTINATION, Optional.empty());
    }

    protected void func_70037_a(CompoundNBT compound) {
        this.field_70180_af.func_187227_b(ATTACHED_FACE, (Object)Direction.func_82600_a((int)compound.func_74771_c("AttachFace")));
        this.setLifespan(compound.func_74762_e("Lifespan"));
        if (compound.func_74764_b("DX")) {
            int i = compound.func_74762_e("DX");
            int j = compound.func_74762_e("DY");
            int k = compound.func_74762_e("DZ");
            this.field_70180_af.func_187227_b(DESTINATION, Optional.of(new BlockPos(i, j, k)));
        } else {
            this.field_70180_af.func_187227_b(DESTINATION, Optional.empty());
        }
        if (compound.func_186855_b("SisterUUID")) {
            this.setSisterId(compound.func_186857_a("SisterUUID"));
        }
        if (compound.func_74764_b("ExitDimension")) {
            this.exitDimension = World.field_234917_f_.parse((DynamicOps)NBTDynamicOps.field_210820_a, (Object)compound.func_74781_a("ExitDimension")).resultOrPartial(arg_0 -> ((Logger)field_184243_a).error(arg_0)).orElse(World.field_234918_g_);
        }
    }

    protected void func_213281_b(CompoundNBT compound) {
        compound.func_74774_a("AttachFace", (byte)((Direction)this.field_70180_af.func_187225_a(ATTACHED_FACE)).func_176745_a());
        compound.func_74768_a("Lifespan", this.getLifespan());
        BlockPos blockpos = this.getDestination();
        if (blockpos != null) {
            compound.func_74768_a("DX", blockpos.func_177958_n());
            compound.func_74768_a("DY", blockpos.func_177956_o());
            compound.func_74768_a("DZ", blockpos.func_177952_p());
        }
        if (this.getSisterId() != null) {
            compound.func_186854_a("SisterUUID", this.getSisterId());
        }
        if (this.exitDimension != null) {
            ResourceLocation.field_240908_a_.encodeStart((DynamicOps)NBTDynamicOps.field_210820_a, (Object)this.exitDimension.func_240901_a_()).resultOrPartial(arg_0 -> ((Logger)field_184243_a).error(arg_0)).ifPresent(p_241148_1_ -> compound.func_218657_a("ExitDimension", p_241148_1_));
        }
    }

    public Entity getSister() {
        UUID id = this.getSisterId();
        if (id != null && !this.field_70170_p.field_72995_K) {
            return ((ServerWorld)this.field_70170_p).func_217461_a(id);
        }
        return null;
    }

    @Nullable
    public UUID getSisterId() {
        return ((Optional)this.field_70180_af.func_187225_a(SISTER_UUID)).orElse(null);
    }

    public void setSisterId(@Nullable UUID uniqueId) {
        this.field_70180_af.func_187227_b(SISTER_UUID, Optional.ofNullable(uniqueId));
    }
}

