/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity.ai;

import com.github.alexthe666.alexsmobs.entity.EntitySeal;
import com.github.alexthe666.alexsmobs.misc.AMTagRegistry;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.LootTable;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class SealAIDiveForItems
extends Goal {
    private EntitySeal seal;
    private PlayerEntity thrower;
    private BlockPos digPos;
    private boolean returnToPlayer = false;
    private int digTime = 0;
    public static final ResourceLocation SEAL_REWARD = new ResourceLocation("alexsmobs", "gameplay/seal_reward");

    public SealAIDiveForItems(EntitySeal seal) {
        this.seal = seal;
    }

    private static List<ItemStack> getItemStacks(EntitySeal seal) {
        LootTable loottable = seal.field_70170_p.func_73046_m().func_200249_aQ().func_186521_a(SEAL_REWARD);
        return loottable.func_216113_a(new LootContext.Builder((ServerWorld)seal.field_70170_p).func_216015_a(LootParameters.field_216281_a, (Object)seal).func_216023_a(seal.field_70170_p.field_73012_v).func_216022_a(LootParameterSets.field_237453_h_));
    }

    public boolean func_75250_a() {
        if (this.seal.feederUUID == null || this.seal.field_70170_p.func_217371_b(this.seal.feederUUID) == null || this.seal.revengeCooldown > 0) {
            return false;
        }
        this.thrower = this.seal.field_70170_p.func_217371_b(this.seal.feederUUID);
        this.digPos = this.genDigPos();
        return this.thrower != null && this.digPos != null;
    }

    public boolean func_75253_b() {
        return this.seal.func_70638_az() == null && this.seal.revengeCooldown == 0 && this.seal.func_70643_av() == null && this.thrower != null && this.seal.feederUUID != null && this.digPos != null && this.seal.field_70170_p.func_204610_c(this.digPos.func_177984_a()).func_206884_a((ITag)FluidTags.field_206959_a);
    }

    public void func_75246_d() {
        this.seal.setBasking(false);
        if (this.returnToPlayer) {
            this.seal.func_70661_as().func_75497_a((Entity)this.thrower, 1.0);
            if ((double)this.seal.func_70032_d((Entity)this.thrower) < 2.0) {
                ItemStack stack = this.seal.func_184614_ca().func_77946_l();
                this.seal.func_184611_a(Hand.MAIN_HAND, ItemStack.field_190927_a);
                ItemEntity item = this.seal.func_199701_a_(stack);
                if (item != null) {
                    double d0 = this.thrower.func_226277_ct_() - this.seal.func_226277_ct_();
                    double d1 = this.thrower.func_226280_cw_() - this.seal.func_226280_cw_();
                    double d2 = this.thrower.func_226281_cx_() - this.seal.func_226281_cx_();
                    double lvt_7_1_ = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
                    float pitch = (float)(-(MathHelper.func_181159_b((double)d1, (double)lvt_7_1_) * 57.2957763671875));
                    float yaw = (float)(MathHelper.func_181159_b((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                    float f8 = MathHelper.func_76126_a((float)(pitch * ((float)Math.PI / 180)));
                    float f2 = MathHelper.func_76134_b((float)(pitch * ((float)Math.PI / 180)));
                    float f3 = MathHelper.func_76126_a((float)(yaw * ((float)Math.PI / 180)));
                    float f4 = MathHelper.func_76134_b((float)(yaw * ((float)Math.PI / 180)));
                    float f5 = this.seal.func_70681_au().nextFloat() * ((float)Math.PI * 2);
                    float f6 = 0.02f * this.seal.func_70681_au().nextFloat();
                    item.func_213293_j((double)(-f3 * f2 * 0.5f) + Math.cos(f5) * (double)f6, (double)(-f8 * 0.2f + 0.1f + (this.seal.func_70681_au().nextFloat() - this.seal.func_70681_au().nextFloat()) * 0.1f), (double)(f4 * f2 * 0.5f) + Math.sin(f5) * (double)f6);
                }
                this.seal.feederUUID = null;
                this.func_75251_c();
            }
        } else {
            double dist = this.seal.func_195048_a(Vector3d.func_237489_a_((Vector3i)this.digPos.func_177984_a()));
            double d0 = (double)this.digPos.func_177958_n() + 0.5 - this.seal.func_226277_ct_();
            double d1 = (double)this.digPos.func_177956_o() + 0.5 - this.seal.func_226280_cw_();
            double d2 = (double)this.digPos.func_177952_p() + 0.5 - this.seal.func_226281_cx_();
            float f = (float)(MathHelper.func_181159_b((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
            if (dist < 2.0) {
                this.seal.func_70661_as().func_75499_g();
                ++this.digTime;
                if (this.digTime % 5 == 0) {
                    SoundEvent sound = this.seal.field_70170_p.func_180495_p(this.digPos).func_215695_r().func_185846_f();
                    this.seal.func_184185_a(sound, 1.0f, 0.5f + this.seal.func_70681_au().nextFloat() * 0.5f);
                }
                if (this.digTime >= 100) {
                    List<ItemStack> lootList = SealAIDiveForItems.getItemStacks(this.seal);
                    if (lootList.size() > 0) {
                        ItemStack copy = lootList.remove(0);
                        copy = copy.func_77946_l();
                        this.seal.func_184611_a(Hand.MAIN_HAND, copy);
                        for (ItemStack stack : lootList) {
                            this.seal.func_199701_a_(stack.func_77946_l());
                        }
                        this.returnToPlayer = true;
                    }
                    this.seal.setDigging(false);
                    this.digTime = 0;
                } else {
                    this.seal.setDigging(true);
                }
            } else {
                this.seal.setDigging(false);
                this.seal.func_70661_as().func_75492_a((double)this.digPos.func_177958_n(), (double)this.digPos.func_177956_o(), (double)this.digPos.func_177952_p(), 1.0);
                this.seal.field_70177_z = f;
            }
        }
    }

    public void func_75251_c() {
        this.seal.setDigging(false);
        this.digPos = null;
        this.thrower = null;
        this.digTime = 0;
        this.returnToPlayer = false;
        this.seal.fishFeedings = 0;
        if (!this.seal.func_184614_ca().func_190926_b()) {
            this.seal.func_199701_a_(this.seal.func_184614_ca().func_77946_l());
            this.seal.func_184611_a(Hand.MAIN_HAND, ItemStack.field_190927_a);
        }
    }

    private BlockPos genSeafloorPos(BlockPos parent) {
        World world = this.seal.field_70170_p;
        Random random = new Random();
        int range = 15;
        for (int i = 0; i < 15; ++i) {
            BlockPos seafloor = parent.func_177982_a(random.nextInt(range) - range / 2, 0, random.nextInt(range) - range / 2);
            while (world.func_204610_c(seafloor).func_206884_a((ITag)FluidTags.field_206959_a) && seafloor.func_177956_o() > 1) {
                seafloor = seafloor.func_177977_b();
            }
            BlockState state = world.func_180495_p(seafloor);
            if (!BlockTags.func_199896_a().func_199910_a(AMTagRegistry.SEAL_DIGABLES).func_230235_a_((Object)state.func_177230_c())) continue;
            return seafloor;
        }
        return null;
    }

    private BlockPos genDigPos() {
        Random random = new Random();
        int range = 15;
        if (this.seal.func_70090_H()) {
            return this.genSeafloorPos(this.seal.func_233580_cy_());
        }
        for (int i = 0; i < 15; ++i) {
            BlockPos pos3;
            BlockPos blockpos1 = this.seal.func_233580_cy_().func_177982_a(random.nextInt(range) - range / 2, 3, random.nextInt(range) - range / 2);
            while (this.seal.field_70170_p.func_175623_d(blockpos1) && blockpos1.func_177956_o() > 1) {
                blockpos1 = blockpos1.func_177977_b();
            }
            if (!this.seal.field_70170_p.func_204610_c(blockpos1).func_206884_a((ITag)FluidTags.field_206959_a) || (pos3 = this.genSeafloorPos(blockpos1)) == null) continue;
            return pos3;
        }
        return null;
    }
}

