/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.morefurniture;

import biomesoplenty.api.block.BOPBlocks;
import com.minecraftabnormals.atmospheric.core.registry.AtmosphericBlocks;
import com.minecraftabnormals.autumnity.core.registry.AutumnityBlocks;
import com.minecraftabnormals.endergetic.core.registry.EEBlocks;
import com.minecraftabnormals.environmental.core.registry.EnvironmentalBlocks;
import com.minecraftabnormals.upgrade_aquatic.core.registry.UABlocks;
import com.teamaurora.abundance.core.registry.AbundanceBlocks;
import com.teamaurora.bayou_blues.core.registry.BayouBluesBlocks;
import corgiaoc.byg.core.BYGBlocks;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.resources.I18n;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.text.WordUtils;

public class Generator {
    public static final FurnitureType TABLE = new FurnitureType("table", "TableBlock", new String[]{"Block.Properties.from(Blocks.OAK_PLANKS)"});
    public static final FurnitureType CHAIR = new FurnitureType("chair", "ChairBlock", new String[]{"Block.Properties.from(Blocks.OAK_PLANKS)"});
    public static final FurnitureType COFFEE_TABLE = new FurnitureType("coffee_table", "CoffeeTableBlock", new String[]{"Block.Properties.from(Blocks.OAK_PLANKS)"});
    public static final FurnitureType CABINET = new FurnitureType("cabinet", "CabinetBlock", new String[]{"Block.Properties.from(Blocks.OAK_PLANKS)"});
    public static final FurnitureType BEDSIDE_CABINET = new FurnitureType("bedside_cabinet", "BedsideCabinetBlock", new String[]{"Block.Properties.from(Blocks.OAK_PLANKS)"});
    public static final FurnitureType DESK = new FurnitureType("desk", "DeskBlock", new String[]{"Block.Properties.from(Blocks.OAK_PLANKS)", "DeskBlock.MaterialType.OAK"});
    public static final FurnitureType DESK_CABINET = new FurnitureType("desk_cabinet", "DeskCabinetBlock", new String[]{"Block.Properties.from(Blocks.OAK_PLANKS)", "DeskBlock.MaterialType.OAK"});
    public static final FurnitureType BLINDS = new FurnitureType("blinds", "BlindsBlock", new String[]{"Block.Properties.from(Blocks.OAK_PLANKS)"});
    public static final FurnitureType UPGRADED_FENCE = new FurnitureType("upgraded_fence", "UpgradedFenceBlock", new String[]{"Block.Properties.from(Blocks.OAK_PLANKS)"});
    public static final FurnitureType UPGRADED_GATE = new FurnitureType("upgraded_gate", "UpgradedGateBlock", new String[]{"Block.Properties.from(Blocks.OAK_PLANKS)"});
    public static final FurnitureType CRATE = new FurnitureType("crate", "CrateBlock", new String[]{"Block.Properties.from(Blocks.CHESTS)"});
    public static final FurnitureType PARK_BENCH = new FurnitureType("park_bench", "ParkBenchBlock", new String[]{"Block.Properties.from(Blocks.OAK_PLANKS)"});
    public static final FurnitureType MAIL_BOX = new FurnitureType("mail_box", "MailBoxBlock", new String[]{"Block.Properties.from(Blocks.OAK_PLANKS)"});
    public static final FurnitureType KITCHEN_COUNTER = new FurnitureType("kitchen_counter", "KitchenCounterBlock", new String[]{"Block.Properties.from(Blocks.OAK_PLANKS)"});
    public static final FurnitureType KITCHEN_DRAWER = new FurnitureType("kitchen_drawer", "KitchenDrawerBlock", new String[]{"Block.Properties.from(Blocks.OAK_PLANKS)"});
    public static final FurnitureType KITCHEN_SINK_LIGHT = new FurnitureType("kitchen_sink_light", "KitchenSinkBlock", new String[]{"Block.Properties.from(Blocks.OAK_PLANKS)", "true"});
    public static final FurnitureType KITCHEN_SINK_DARK = new FurnitureType("kitchen_sink_dark", "KitchenSinkBlock", new String[]{"Block.Properties.from(Blocks.OAK_PLANKS)", "true"});
    public static final FurnitureType[] FURNITURE_TYPES = new FurnitureType[]{TABLE, CHAIR, COFFEE_TABLE, CABINET, BEDSIDE_CABINET, DESK, DESK_CABINET, BLINDS, UPGRADED_FENCE, UPGRADED_GATE, CRATE, PARK_BENCH, MAIL_BOX, KITCHEN_COUNTER, KITCHEN_DRAWER, KITCHEN_SINK_LIGHT, KITCHEN_SINK_DARK};
    private List<Variant> registeredVariants = new ArrayList<Variant>();

    public Generator() {
        this.registerVariant("maple", (Block)AutumnityBlocks.MAPLE_LOG.get(), (Block)AutumnityBlocks.MAPLE_PLANKS.get(), (Block)AutumnityBlocks.STRIPPED_MAPLE_LOG.get());
        this.registerVariant("willow", (Block)EnvironmentalBlocks.WILLOW_LOG.get(), (Block)EnvironmentalBlocks.WILLOW_PLANKS.get(), (Block)EnvironmentalBlocks.STRIPPED_WILLOW_LOG.get());
        this.registerVariant("cherry", (Block)EnvironmentalBlocks.CHERRY_LOG.get(), (Block)EnvironmentalBlocks.CHERRY_PLANKS.get(), (Block)EnvironmentalBlocks.STRIPPED_CHERRY_LOG.get());
        this.registerVariant("wisteria", (Block)EnvironmentalBlocks.WISTERIA_LOG.get(), (Block)EnvironmentalBlocks.WISTERIA_PLANKS.get(), (Block)EnvironmentalBlocks.STRIPPED_WISTERIA_LOG.get());
        this.registerVariant("rosewood", (Block)AtmosphericBlocks.ROSEWOOD_LOG.get(), (Block)AtmosphericBlocks.ROSEWOOD_PLANKS.get(), (Block)AtmosphericBlocks.STRIPPED_ROSEWOOD_LOG.get());
        this.registerVariant("morado", (Block)AtmosphericBlocks.MORADO_LOG.get(), (Block)AtmosphericBlocks.MORADO_PLANKS.get(), (Block)AtmosphericBlocks.STRIPPED_MORADO_LOG.get());
        this.registerVariant("yucca", (Block)AtmosphericBlocks.YUCCA_LOG.get(), (Block)AtmosphericBlocks.YUCCA_PLANKS.get(), (Block)AtmosphericBlocks.STRIPPED_YUCCA_LOG.get());
        this.registerVariant("kousa", (Block)AtmosphericBlocks.KOUSA_LOG.get(), (Block)AtmosphericBlocks.KOUSA_PLANKS.get(), (Block)AtmosphericBlocks.STRIPPED_KOUSA_LOG.get());
        this.registerVariant("aspen", (Block)AtmosphericBlocks.ASPEN_LOG.get(), (Block)AtmosphericBlocks.ASPEN_PLANKS.get(), (Block)AtmosphericBlocks.STRIPPED_ASPEN_LOG.get());
        this.registerVariant("grimwood", (Block)AtmosphericBlocks.GRIMWOOD_LOG.get(), (Block)AtmosphericBlocks.GRIMWOOD_PLANKS.get(), (Block)AtmosphericBlocks.STRIPPED_GRIMWOOD_LOG.get());
        this.registerVariant("driftwood", (Block)UABlocks.DRIFTWOOD_LOG.get(), (Block)UABlocks.DRIFTWOOD_PLANKS.get(), (Block)UABlocks.STRIPPED_DRIFTWOOD_LOG.get());
        this.registerVariant("river", (Block)UABlocks.RIVER_LOG.get(), (Block)UABlocks.RIVER_PLANKS.get(), (Block)UABlocks.STRIPPED_RIVER_LOG.get());
        this.registerVariant("poise", (Block)EEBlocks.POISE_STEM.get(), (Block)EEBlocks.POISE_PLANKS.get(), (Block)EEBlocks.STRIPPED_POISE_STEM.get(), true);
        this.registerVariant("fir", BOPBlocks.fir_log, BOPBlocks.fir_planks, BOPBlocks.stripped_fir_log);
        this.registerVariant("redwood", BOPBlocks.redwood_log, BOPBlocks.redwood_planks, BOPBlocks.stripped_redwood_log);
        this.registerVariant("cherry", BOPBlocks.cherry_log, BOPBlocks.cherry_planks, BOPBlocks.stripped_cherry_log);
        this.registerVariant("mahogany", BOPBlocks.mahogany_log, BOPBlocks.mahogany_planks, BOPBlocks.stripped_mahogany_log);
        this.registerVariant("jacaranda", BOPBlocks.jacaranda_log, BOPBlocks.jacaranda_planks, BOPBlocks.stripped_jacaranda_log);
        this.registerVariant("palm", BOPBlocks.palm_log, BOPBlocks.palm_planks, BOPBlocks.stripped_palm_log);
        this.registerVariant("willow", BOPBlocks.willow_log, BOPBlocks.willow_planks, BOPBlocks.stripped_willow_log);
        this.registerVariant("dead", BOPBlocks.dead_log, BOPBlocks.dead_planks, BOPBlocks.stripped_dead_log);
        this.registerVariant("magic", BOPBlocks.magic_log, BOPBlocks.magic_planks, BOPBlocks.stripped_magic_log);
        this.registerVariant("umbran", BOPBlocks.umbran_log, BOPBlocks.umbran_planks, BOPBlocks.stripped_umbran_log);
        this.registerVariant("hellbark", BOPBlocks.hellbark_log, BOPBlocks.hellbark_planks, BOPBlocks.stripped_hellbark_log);
        this.registerVariant("aspen", BYGBlocks.ASPEN_LOG, BYGBlocks.ASPEN_PLANKS, BYGBlocks.STRIPPED_ASPEN_LOG);
        this.registerVariant("baobab", BYGBlocks.BAOBAB_LOG, BYGBlocks.BAOBAB_PLANKS, BYGBlocks.STRIPPED_BAOBAB_LOG);
        this.registerVariant("blue_enchanted", BYGBlocks.BLUE_ENCHANTED_LOG, BYGBlocks.BLUE_ENCHANTED_PLANKS, BYGBlocks.STRIPPED_BLUE_ENCHANTED_LOG);
        this.registerVariant("cherry", BYGBlocks.CHERRY_LOG, BYGBlocks.CHERRY_PLANKS, BYGBlocks.STRIPPED_CHERRY_LOG);
        this.registerVariant("cika", BYGBlocks.CIKA_LOG, BYGBlocks.CIKA_PLANKS, BYGBlocks.STRIPPED_CIKA_LOG);
        this.registerVariant("cypress", BYGBlocks.CYPRESS_LOG, BYGBlocks.CYPRESS_PLANKS, BYGBlocks.STRIPPED_CYPRESS_LOG);
        this.registerVariant("ebony", BYGBlocks.EBONY_LOG, BYGBlocks.EBONY_PLANKS, BYGBlocks.STRIPPED_EBONY_LOG);
        this.registerVariant("fir", BYGBlocks.FIR_LOG, BYGBlocks.FIR_PLANKS, BYGBlocks.STRIPPED_FIR_LOG);
        this.registerVariant("green_enchanted", BYGBlocks.GREEN_ENCHANTED_LOG, BYGBlocks.GREEN_ENCHANTED_PLANKS, BYGBlocks.STRIPPED_GREEN_ENCHANTED_LOG);
        this.registerVariant("holly", BYGBlocks.HOLLY_LOG, BYGBlocks.HOLLY_PLANKS, BYGBlocks.STRIPPED_HOLLY_LOG);
        this.registerVariant("jacaranda", BYGBlocks.JACARANDA_LOG, BYGBlocks.JACARANDA_PLANKS, BYGBlocks.STRIPPED_JACARANDA_LOG);
        this.registerVariant("mahogany", BYGBlocks.MAHOGANY_LOG, BYGBlocks.MAHOGANY_PLANKS, BYGBlocks.STRIPPED_MAHOGANY_LOG);
        this.registerVariant("mangrove", BYGBlocks.MANGROVE_LOG, BYGBlocks.MANGROVE_PLANKS, BYGBlocks.STRIPPED_MANGROVE_LOG);
        this.registerVariant("maple", BYGBlocks.MAPLE_LOG, BYGBlocks.MAPLE_PLANKS, BYGBlocks.STRIPPED_MAPLE_LOG);
        this.registerVariant("pine", BYGBlocks.PINE_LOG, BYGBlocks.PINE_PLANKS, BYGBlocks.STRIPPED_PINE_LOG);
        this.registerVariant("rainbow_eucalyptus", BYGBlocks.RAINBOW_EUCALYPTUS_LOG, BYGBlocks.RAINBOW_EUCALYPTUS_PLANKS, BYGBlocks.STRIPPED_RAINBOW_EUCALYPTUS_LOG);
        this.registerVariant("redwood", BYGBlocks.REDWOOD_LOG, BYGBlocks.REDWOOD_PLANKS, BYGBlocks.STRIPPED_REDWOOD_LOG);
        this.registerVariant("skyris", BYGBlocks.SKYRIS_LOG, BYGBlocks.SKYRIS_PLANKS, BYGBlocks.STRIPPED_SKYRIS_LOG);
        this.registerVariant("willow", BYGBlocks.WILLOW_LOG, BYGBlocks.WILLOW_PLANKS, BYGBlocks.STRIPPED_WILLOW_LOG);
        this.registerVariant("witch_hazel", BYGBlocks.WITCH_HAZEL_LOG, BYGBlocks.WITCH_HAZEL_PLANKS, BYGBlocks.STRIPPED_WITCH_HAZEL_LOG);
        this.registerVariant("zelkova", BYGBlocks.ZELKOVA_LOG, BYGBlocks.ZELKOVA_PLANKS, BYGBlocks.STRIPPED_ZELKOVA_LOG);
        this.registerVariant("palm", BYGBlocks.PALM_LOG, BYGBlocks.PALM_PLANKS, BYGBlocks.STRIPPED_PALM_LOG);
        this.registerVariant("lament", BYGBlocks.LAMENT_LOG, BYGBlocks.LAMENT_PLANKS, BYGBlocks.STRIPPED_LAMENT_LOG);
        this.registerVariant("nightshade", BYGBlocks.NIGHTSHADE_LOG, BYGBlocks.NIGHTSHADE_PLANKS, BYGBlocks.STRIPPED_NIGHTSHADE_LOG);
        this.registerVariant("ether", BYGBlocks.ETHER_LOG, BYGBlocks.ETHER_PLANKS, BYGBlocks.STRIPPED_ETHER_LOG);
        this.registerVariant("sythian", BYGBlocks.SYTHIAN_STEM, BYGBlocks.SYTHIAN_PLANKS, BYGBlocks.STRIPPED_SYTHIAN_STEM, true);
        this.registerVariant("bulbis", BYGBlocks.BULBIS_STEM, BYGBlocks.BULBIS_PLANKS, null, true);
        this.registerVariant("imparius", BYGBlocks.IMPARIUS_STEM, BYGBlocks.IMPARIUS_PLANKS, null, true);
        this.registerVariant("cypress", (Block)BayouBluesBlocks.CYPRESS_LOG.get(), (Block)BayouBluesBlocks.CYPRESS_PLANKS.get(), (Block)BayouBluesBlocks.STRIPPED_CYPRESS_LOG.get());
        this.registerVariant("jacaranda", (Block)AbundanceBlocks.JACARANDA_LOG.get(), (Block)AbundanceBlocks.JACARANDA_PLANKS.get(), (Block)AbundanceBlocks.STRIPPED_JACARANDA_LOG.get());
        this.registerVariant("redbud", (Block)AbundanceBlocks.REDBUD_LOG.get(), (Block)AbundanceBlocks.REDBUD_PLANKS.get(), (Block)AbundanceBlocks.STRIPPED_REDBUD_LOG.get());
    }

    public void registerVariant(String id, Block log, Block planks, @Nullable Block strippedLog) {
        this.registeredVariants.add(new Variant(id, log, planks, strippedLog));
    }

    public void registerVariant(String id, Block log, Block planks, @Nullable Block strippedLog, boolean stem) {
        this.registeredVariants.add(new Variant(id, log, planks, strippedLog, stem));
    }

    public List<Variant> getRegisteredVariants() {
        return this.registeredVariants;
    }

    /*
     * WARNING - void declaration
     */
    public void generate() {
        String blockRegistryObject;
        Throwable throwable;
        BufferedWriter writer;
        try {
            writer = IOUtils.buffer((Writer)new FileWriter("ModBlocks.txt"));
            throwable = null;
            try {
                for (FurnitureType furnitureType : FURNITURE_TYPES) {
                    String blockArgs;
                    for (Variant variant : this.registeredVariants) {
                        blockArgs = String.join((CharSequence)",", furnitureType.args);
                        blockRegistryObject = String.format("public static final RegistryObject<Block> %1$s_%2$s_%3$s = registerOptional(\"%9$s\", \"%4$s_%5$s_%6$s\", new %7$s(%8$s));", variant.log.getRegistryName().func_110624_b().toUpperCase(), furnitureType.id.toUpperCase(), variant.id.toUpperCase(), variant.log.getRegistryName().func_110624_b(), variant.id, furnitureType.id, furnitureType.className, blockArgs, variant.log.getRegistryName().func_110624_b());
                        writer.write(blockRegistryObject);
                        writer.write("\n");
                    }
                    for (Variant variant : this.registeredVariants) {
                        if (variant.strippedLog == null) continue;
                        blockArgs = String.join((CharSequence)",", furnitureType.args);
                        blockRegistryObject = String.format("public static final RegistryObject<Block> %1$s_%2$s_STRIPPED_%3$s = registerOptional(\"%9$s\", \"%4$s_stripped_%5$s_%6$s\", new %7$s(%8$s));", variant.log.getRegistryName().func_110624_b().toUpperCase(), furnitureType.id.toUpperCase(), variant.id.toUpperCase(), variant.log.getRegistryName().func_110624_b(), variant.id, furnitureType.id, furnitureType.className, blockArgs, variant.log.getRegistryName().func_110624_b());
                        writer.write(blockRegistryObject);
                        writer.write("\n");
                    }
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (writer != null) {
                    if (throwable != null) {
                        try {
                            writer.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        writer.close();
                    }
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            writer = IOUtils.buffer((Writer)new FileWriter("InjectValidBlocks.txt"));
            throwable = null;
            try {
                ArrayList<TileEntityTypeData> typeDataList = new ArrayList<TileEntityTypeData>();
                class TileEntityTypeData {
                    FurnitureType type;
                    String fieldName;
                    String localSetName;

                    TileEntityTypeData(FurnitureType type, String fieldName, String localSetName) {
                        this.type = type;
                        this.fieldName = fieldName;
                        this.localSetName = localSetName;
                    }
                }
                typeDataList.add(new TileEntityTypeData(CABINET, "CABINET", "cabinetBlocks"));
                typeDataList.add(new TileEntityTypeData(BEDSIDE_CABINET, "BEDSIDE_CABINET", "bedsideCabinetBlocks"));
                typeDataList.add(new TileEntityTypeData(DESK_CABINET, "DESK_CABINET", "deskCabinetBlocks"));
                typeDataList.add(new TileEntityTypeData(CRATE, "CRATE", "crateBlocks"));
                typeDataList.add(new TileEntityTypeData(MAIL_BOX, "MAIL_BOX", "mailBoxBlocks"));
                typeDataList.add(new TileEntityTypeData(KITCHEN_DRAWER, "KITCHEN_DRAWER", "kitchenDrawerBlocks"));
                typeDataList.add(new TileEntityTypeData(KITCHEN_SINK_LIGHT, "KITCHEN_SINK", "kitchenSinkLightBlocks"));
                typeDataList.add(new TileEntityTypeData(KITCHEN_SINK_DARK, "KITCHEN_SINK", "kitchenSinkDarkBlocks"));
                for (TileEntityTypeData data : typeDataList) {
                    writer.write(String.format("Set<Block> %s = new HashSet<>();", data.localSetName));
                    writer.newLine();
                    for (Variant variant : this.registeredVariants) {
                        String blockRegistryObject2 = String.format("addNonnullBlockSupplierIntoSet(ModBlocks.%s_%s_%s, %s);", variant.log.getRegistryName().func_110624_b().toUpperCase(), data.type.id.toUpperCase(), variant.id.toUpperCase(), data.localSetName);
                        writer.write(blockRegistryObject2);
                        writer.newLine();
                    }
                    for (Variant variant : this.registeredVariants) {
                        if (variant.getStrippedLog() == null) continue;
                        String blockRegistryObject2 = String.format("addNonnullBlockSupplierIntoSet(ModBlocks.%s_%s_STRIPPED_%s, %s);", variant.log.getRegistryName().func_110624_b().toUpperCase(), data.type.id.toUpperCase(), variant.id.toUpperCase(), data.localSetName);
                        writer.write(blockRegistryObject2);
                        writer.newLine();
                    }
                    writer.write(String.format("addBlocksToTileEntityType(ModTileEntities.%s.get(), %s);", data.fieldName, data.localSetName));
                    writer.newLine();
                    writer.newLine();
                }
            }
            catch (Throwable typeDataList) {
                throwable = typeDataList;
                throw typeDataList;
            }
            finally {
                if (writer != null) {
                    if (throwable != null) {
                        try {
                            writer.close();
                        }
                        catch (Throwable typeDataList) {
                            throwable.addSuppressed(typeDataList);
                        }
                    } else {
                        writer.close();
                    }
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            writer = IOUtils.buffer((Writer)new FileWriter("Colors.txt"));
            throwable = null;
            try {
                void var6_34;
                FurnitureType type;
                void var6_32;
                FurnitureType[] types = new FurnitureType[]{CRATE, KITCHEN_COUNTER, KITCHEN_SINK_LIGHT, KITCHEN_SINK_DARK};
                Object object = types;
                int data = ((FurnitureType[])object).length;
                boolean bl = false;
                while (var6_32 < data) {
                    type = object[var6_32];
                    for (Variant variant : this.registeredVariants) {
                        if (variant.getStrippedLog() == null) continue;
                        blockRegistryObject = String.format("registerStrippedColorsOne(ModBlocks.%s_%s_STRIPPED_%s);", variant.log.getRegistryName().func_110624_b().toUpperCase(), type.id.toUpperCase(), variant.id.toUpperCase());
                        writer.write(blockRegistryObject);
                        writer.newLine();
                    }
                    ++var6_32;
                }
                object = types;
                data = ((FurnitureType[])object).length;
                boolean bl2 = false;
                while (var6_34 < data) {
                    type = object[var6_34];
                    for (Variant variant : this.registeredVariants) {
                        if (variant.getStrippedLog() == null) continue;
                        blockRegistryObject = String.format("registerStrippedColorsOne(ModBlocks.%s_%s_STRIPPED_%s);", variant.log.getRegistryName().func_110624_b().toUpperCase(), type.id.toUpperCase(), variant.id.toUpperCase());
                        writer.write(blockRegistryObject);
                        writer.write("\n");
                    }
                    ++var6_34;
                }
                for (Variant variant : this.registeredVariants) {
                    if (variant.getStrippedLog() == null) continue;
                    String string = String.format("registerStrippedColorsTwo(ModBlocks.%s_%s_STRIPPED_%s);", variant.log.getRegistryName().func_110624_b().toUpperCase(), PARK_BENCH.id.toUpperCase(), variant.id.toUpperCase());
                    writer.write(string);
                    writer.write("\n");
                }
                for (Variant variant : this.registeredVariants) {
                    if (variant.getStrippedLog() == null) continue;
                    String string = String.format("registerStrippedColorsTwo(ModBlocks.%s_%s_STRIPPED_%s);", variant.log.getRegistryName().func_110624_b().toUpperCase(), PARK_BENCH.id.toUpperCase(), variant.id.toUpperCase());
                    writer.write(string);
                    writer.write("\n");
                }
            }
            catch (Throwable types) {
                throwable = types;
                throw types;
            }
            finally {
                if (writer != null) {
                    if (throwable != null) {
                        try {
                            writer.close();
                        }
                        catch (Throwable types) {
                            throwable.addSuppressed(types);
                        }
                    } else {
                        writer.close();
                    }
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            writer = IOUtils.buffer((Writer)new FileWriter("en_us.json"));
            throwable = null;
            try {
                writer.write("{\n");
                for (FurnitureType furnitureType : FURNITURE_TYPES) {
                    String furnitureName;
                    String variantName;
                    for (Variant variant : this.registeredVariants) {
                        variantName = I18n.func_135052_a((String)variant.log.func_149739_a(), (Object[])new Object[0]).split("\\s++")[0];
                        furnitureName = variantName + " " + WordUtils.capitalize((String)furnitureType.id.replace("_", " "));
                        writer.write(String.format("    \"block.%1$s.%2$s_%3$s_%4$s\": \"%5$s\",", "morecfm", variant.log.getRegistryName().func_110624_b(), variant.id, furnitureType.id, furnitureName));
                        writer.write("\n");
                    }
                    for (Variant variant : this.registeredVariants) {
                        if (variant.strippedLog == null) continue;
                        variantName = I18n.func_135052_a((String)variant.log.func_149739_a(), (Object[])new Object[0]).split("\\s++")[0];
                        furnitureName = "Stripped " + variantName + " " + WordUtils.capitalize((String)furnitureType.id.replace("_", " "));
                        writer.write(String.format("    \"block.%1$s.%2$s_stripped_%3$s_%4$s\": \"%5$s\",", "morecfm", variant.log.getRegistryName().func_110624_b(), variant.id, furnitureType.id, furnitureName));
                        writer.write("\n");
                    }
                }
                writer.write("}");
            }
            catch (Throwable types) {
                throwable = types;
                throw types;
            }
            finally {
                if (writer != null) {
                    if (throwable != null) {
                        try {
                            writer.close();
                        }
                        catch (Throwable types) {
                            throwable.addSuppressed(types);
                        }
                    } else {
                        writer.close();
                    }
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.clearGeneratedFiles(new File("resources/output/"));
        for (Variant variant : this.registeredVariants) {
            String modId = variant.getLog().getRegistryName().func_110624_b();
            String variantId = variant.id;
            boolean stripped = variant.getStrippedLog() != null;
            boolean bl = variant.isStem();
            this.generateFiles("blockstates", modId, variantId, stripped, bl);
            this.generateFiles("models/block", modId, variantId, stripped, bl);
            this.generateFiles("models/item", modId, variantId, stripped, bl);
        }
    }

    private void clearGeneratedFiles(File folder) {
        for (File file : Objects.requireNonNull(folder.listFiles())) {
            if (file.isDirectory()) {
                this.clearGeneratedFiles(file);
                continue;
            }
            file.delete();
        }
    }

    private void generateFiles(String folder, String modId, String variant, boolean stripped, boolean stem) {
        try {
            File[] inputFiles;
            File input = new File("resources/input/" + folder);
            File output = new File("resources/output/" + folder);
            if (input.isDirectory() && output.isDirectory() && (inputFiles = input.listFiles()) != null) {
                for (File file : inputFiles) {
                    if (file.isDirectory() || file.getName().contains("stripped") && !stripped) continue;
                    String contents = new String(Files.readAllBytes(Paths.get(file.toURI())));
                    String newFileName = file.getName().replace("{color}", variant).replace("{modid}", modId);
                    String newContents = contents;
                    if (stem) {
                        if (!stripped) {
                            newContents = newContents.replace("stripped_{color}_log", "{color}_planks");
                        }
                        newContents = newContents.replace("_log", "_stem");
                    }
                    newContents = newContents.replace("{color}", variant).replace("{modid}", modId);
                    if (modId.equals("endergetic")) {
                        newContents = newContents.replace("block/stripped_poise_stem", "block/poise_stem_stripped");
                    }
                    Files.write(Paths.get(new File(output, newFileName).toURI()), newContents.getBytes(), StandardOpenOption.CREATE);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static class FurnitureType {
        private String id;
        private String className;
        private String[] args;

        public FurnitureType(String id, String className, String[] args) {
            this.id = id;
            this.className = className;
            this.args = args;
        }

        public String getId() {
            return this.id;
        }

        public String getClassName() {
            return this.className;
        }

        public String[] getArgs() {
            return this.args;
        }
    }

    public static class Variant {
        private final String id;
        private final Block log;
        private final Block planks;
        @Nullable
        private final Block strippedLog;
        private final boolean stem;

        public Variant(String id, Block log, Block planks, @Nullable Block strippedLog) {
            this(id, log, planks, strippedLog, false);
        }

        public Variant(String id, Block log, Block planks, @Nullable Block strippedLog, boolean stem) {
            this.id = id;
            this.log = log;
            this.planks = planks;
            this.strippedLog = strippedLog;
            this.stem = stem;
        }

        public String getId() {
            return this.id;
        }

        public Block getLog() {
            return this.log;
        }

        public Block getPlanks() {
            return this.planks;
        }

        @Nullable
        public Block getStrippedLog() {
            return this.strippedLog;
        }

        public boolean isStem() {
            return this.stem;
        }
    }
}

