/*
 * Decompiled with CFR 0.152.
 */
package com.tm.playingcards.entity;

import com.tm.playingcards.entity.base.EntityStacked;
import com.tm.playingcards.init.InitEntityTypes;
import com.tm.playingcards.init.InitItems;
import com.tm.playingcards.util.ChatHelper;
import com.tm.playingcards.util.ItemHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class EntityCardDeck
extends EntityStacked {
    private static final DataParameter<Float> ROTATION = EntityDataManager.func_187226_a(EntityCardDeck.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Byte> SKIN_ID = EntityDataManager.func_187226_a(EntityCardDeck.class, (IDataSerializer)DataSerializers.field_187191_a);

    public EntityCardDeck(EntityType<? extends EntityCardDeck> type, World world) {
        super(type, world);
    }

    public EntityCardDeck(World world, Vector3d position, float rotation, byte skinID) {
        super((EntityType<? extends EntityStacked>)((EntityType)InitEntityTypes.CARD_DECK.get()), world, position);
        this.createAndFillDeck();
        this.shuffleStack();
        this.field_70180_af.func_187227_b(ROTATION, (Object)Float.valueOf(rotation));
        this.field_70180_af.func_187227_b(SKIN_ID, (Object)skinID);
    }

    public float getRotation() {
        return ((Float)this.field_70180_af.func_187225_a(ROTATION)).floatValue();
    }

    public byte getSkinID() {
        return (Byte)this.field_70180_af.func_187225_a(SKIN_ID);
    }

    private void createAndFillDeck() {
        Byte[] newStack = new Byte[52];
        for (byte index = 0; index < 52; index = (byte)(index + 1)) {
            newStack[index] = index;
        }
        this.field_70180_af.func_187227_b(STACK, (Object)newStack);
    }

    public ActionResultType func_184230_a(PlayerEntity player, Hand hand) {
        if (hand == Hand.MAIN_HAND) {
            if (this.getStackAmount() > 0) {
                byte cardID = this.getTopStackID();
                ItemStack card = new ItemStack((IItemProvider)InitItems.CARD_COVERED.get());
                card.func_196085_b((int)cardID);
                ItemHelper.getNBT(card).func_186854_a("UUID", this.func_110124_au());
                ItemHelper.getNBT(card).func_74774_a("SkinID", ((Byte)this.field_70180_af.func_187225_a(SKIN_ID)).byteValue());
                if (!this.field_70170_p.field_72995_K) {
                    ItemHelper.spawnStackAtEntity(this.field_70170_p, (Entity)player, card);
                }
                this.removeFromTop();
                return player.func_184614_ca().func_190926_b() ? ActionResultType.SUCCESS : ActionResultType.FAIL;
            }
            if (this.field_70170_p.field_72995_K) {
                ChatHelper.printModMessage(TextFormatting.RED, "Out of cards!", new Entity[]{player});
            }
        }
        return ActionResultType.FAIL;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (source.func_76364_f() instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)source.func_76364_f();
            if (player.func_213453_ef()) {
                ItemStack deck = new ItemStack((IItemProvider)InitItems.CARD_DECK.get());
                ItemHelper.getNBT(deck).func_74774_a("SkinID", ((Byte)this.field_70180_af.func_187225_a(SKIN_ID)).byteValue());
                ItemHelper.spawnStackAtEntity(this.field_70170_p, (Entity)player, deck);
                this.func_70106_y();
            } else {
                this.shuffleStack();
                if (this.field_70170_p.field_72995_K) {
                    ChatHelper.printModMessage(TextFormatting.GREEN, "You shuffled the deck", new Entity[]{player});
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void moreData() {
        this.field_70180_af.func_187214_a(ROTATION, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(SKIN_ID, (Object)0);
    }

    @Override
    protected void func_70037_a(CompoundNBT nbt) {
        super.func_70037_a(nbt);
        this.field_70180_af.func_187227_b(ROTATION, (Object)Float.valueOf(nbt.func_74760_g("Rotation")));
        this.field_70180_af.func_187227_b(SKIN_ID, (Object)nbt.func_74771_c("SkinID"));
    }

    @Override
    protected void func_213281_b(CompoundNBT nbt) {
        super.func_213281_b(nbt);
        nbt.func_74776_a("Rotation", ((Float)this.field_70180_af.func_187225_a(ROTATION)).floatValue());
        nbt.func_74774_a("SkinID", ((Byte)this.field_70180_af.func_187225_a(SKIN_ID)).byteValue());
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

