/*
 * Decompiled with CFR 0.152.
 */
package com.tm.playingcards.item;

import com.tm.playingcards.entity.EntityCard;
import com.tm.playingcards.entity.EntityCardDeck;
import com.tm.playingcards.init.InitItems;
import com.tm.playingcards.item.base.ItemBase;
import com.tm.playingcards.util.CardHelper;
import com.tm.playingcards.util.ItemHelper;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class ItemCardCovered
extends ItemBase {
    protected boolean covered = true;

    public ItemCardCovered() {
        super(new Item.Properties().func_200917_a(1));
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        CompoundNBT nbt = ItemHelper.getNBT(stack);
        tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.GRAY + "Cover: " + TextFormatting.AQUA + CardHelper.CARD_SKIN_NAMES[nbt.func_74771_c("SkinID")]));
    }

    public void flipCard(ItemStack heldItem, LivingEntity entity) {
        PlayerEntity player;
        if (entity instanceof PlayerEntity && (player = (PlayerEntity)entity).func_184614_ca().func_77973_b() instanceof ItemCardCovered) {
            Item nextCard = (Item)InitItems.CARD.get();
            if (!this.covered) {
                nextCard = (Item)InitItems.CARD_COVERED.get();
            }
            ItemStack newCard = new ItemStack((IItemProvider)nextCard);
            newCard.func_196085_b(heldItem.func_77952_i());
            CompoundNBT heldNBT = ItemHelper.getNBT(heldItem);
            ItemHelper.getNBT(newCard).func_186854_a("UUID", heldNBT.func_186857_a("UUID"));
            ItemHelper.getNBT(newCard).func_74774_a("SkinID", heldNBT.func_74771_c("SkinID"));
            player.func_184611_a(Hand.MAIN_HAND, newCard);
        }
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        if (world.func_82737_E() % 60L == 0L && entity instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)entity;
            BlockPos pos = player.func_233580_cy_();
            UUID id = ItemHelper.getNBT(stack).func_186857_a("UUID");
            if (id.getLeastSignificantBits() == 0L) {
                return;
            }
            List closeDecks = world.func_217357_a(EntityCardDeck.class, new AxisAlignedBB((double)(pos.func_177958_n() - 20), (double)(pos.func_177956_o() - 20), (double)(pos.func_177952_p() - 20), (double)(pos.func_177958_n() + 20), (double)(pos.func_177956_o() + 20), (double)(pos.func_177952_p() + 20)));
            boolean found = false;
            for (EntityCardDeck closeDeck : closeDecks) {
                if (!closeDeck.func_110124_au().equals(id)) continue;
                found = true;
                break;
            }
            if (!found) {
                player.field_71071_by.func_70301_a(itemSlot).func_190918_g(1);
            }
        }
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        PlayerEntity player = context.func_195999_j();
        if (player != null && !player.func_213453_ef()) {
            BlockPos pos = context.func_195995_a();
            List closeDecks = context.func_195991_k().func_217357_a(EntityCardDeck.class, new AxisAlignedBB((double)(pos.func_177958_n() - 8), (double)(pos.func_177956_o() - 8), (double)(pos.func_177952_p() - 8), (double)(pos.func_177958_n() + 8), (double)(pos.func_177956_o() + 8), (double)(pos.func_177952_p() + 8)));
            CompoundNBT nbt = ItemHelper.getNBT(context.func_195996_i());
            UUID deckID = nbt.func_186857_a("UUID");
            for (EntityCardDeck closeDeck : closeDecks) {
                if (!closeDeck.func_110124_au().equals(deckID)) continue;
                World world = context.func_195991_k();
                EntityCard cardDeck = new EntityCard(world, context.func_221532_j(), context.func_195990_h(), nbt.func_74771_c("SkinID"), deckID, this.covered, (byte)context.func_195996_i().func_77952_i());
                world.func_217376_c((Entity)cardDeck);
                context.func_195996_i().func_190918_g(1);
                return ActionResultType.SUCCESS;
            }
        }
        return ActionResultType.PASS;
    }
}

