/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.render.draw;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import journeymap.client.JourneymapClient;
import journeymap.client.data.DataCache;
import journeymap.client.render.draw.DrawWayPointStep;
import journeymap.client.render.map.GridRenderer;
import journeymap.client.waypoint.Waypoint;
import journeymap.common.Journeymap;
import journeymap.common.log.LogFormatter;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.util.math.vector.Vector3d;

public class WaypointDrawStepFactory {
    final List<DrawWayPointStep> drawStepList = new ArrayList<DrawWayPointStep>();

    public List<DrawWayPointStep> prepareSteps(Collection<Waypoint> waypoints, GridRenderer grid, boolean checkDistance, boolean showLabel) {
        Minecraft mc = Minecraft.func_71410_x();
        ClientPlayerEntity player = mc.field_71439_g;
        int maxDistance = JourneymapClient.getInstance().getWaypointProperties().maxDistance.get();
        float waypointLabelScale = JourneymapClient.getInstance().getFullMapProperties().waypointLabelScale.get().floatValue();
        checkDistance = checkDistance && maxDistance > 0;
        Vector3d playerVec = checkDistance ? player.func_213303_ch() : null;
        this.drawStepList.clear();
        try {
            for (Waypoint waypoint : waypoints) {
                DrawWayPointStep wayPointStep;
                double actualDistance;
                if (!waypoint.isEnable() || !waypoint.isInPlayerDimension() || checkDistance && (actualDistance = playerVec.func_72438_d(waypoint.getPosition())) > (double)maxDistance || (wayPointStep = DataCache.INSTANCE.getDrawWayPointStep(waypoint)) == null) continue;
                this.drawStepList.add(wayPointStep);
                wayPointStep.setShowLabel(showLabel);
                wayPointStep.setlabelScale(waypointLabelScale);
            }
        }
        catch (Throwable t) {
            Journeymap.getLogger().error("Error during prepareSteps: " + LogFormatter.toString(t));
        }
        return this.drawStepList;
    }
}

