/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import dev.ftb.mods.ftbchunks.client.CustomMapWidget;
import dev.ftb.mods.ftbchunks.client.FTBChunksClient;
import dev.ftb.mods.ftbchunks.client.LargeMapScreen;
import dev.ftb.mods.ftbchunks.client.PlayerButton;
import dev.ftb.mods.ftbchunks.client.RegionMapButton;
import dev.ftb.mods.ftbchunks.client.WaypointButton;
import dev.ftb.mods.ftbchunks.client.map.MapChunk;
import dev.ftb.mods.ftbchunks.client.map.MapRegion;
import dev.ftb.mods.ftbchunks.client.map.MapRegionData;
import dev.ftb.mods.ftbchunks.client.map.Waypoint;
import dev.ftb.mods.ftblibrary.math.XZ;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import dev.ftb.mods.ftbteams.data.ClientTeam;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;

public class RegionMapPanel
extends Panel {
    public final LargeMapScreen largeMap;
    public double regionX = 0.0;
    public double regionZ = 0.0;
    public int regionMinX;
    public int regionMinZ;
    public int regionMaxX;
    public int regionMaxZ;
    public int blockX = 0;
    public int blockY = 0;
    public int blockZ = 0;
    public int blockIndex = 0;

    public RegionMapPanel(LargeMapScreen panel) {
        super((Panel)panel);
        this.largeMap = panel;
    }

    public void updateMinMax() {
        this.regionMinX = Integer.MAX_VALUE;
        this.regionMinZ = Integer.MAX_VALUE;
        this.regionMaxX = Integer.MIN_VALUE;
        this.regionMaxZ = Integer.MIN_VALUE;
        for (Widget w : this.widgets) {
            if (!(w instanceof RegionMapButton)) continue;
            int qx = ((RegionMapButton)w).region.pos.x;
            int qy = ((RegionMapButton)w).region.pos.z;
            this.regionMinX = Math.min(this.regionMinX, qx);
            this.regionMinZ = Math.min(this.regionMinZ, qy);
            this.regionMaxX = Math.max(this.regionMaxX, qx);
            this.regionMaxZ = Math.max(this.regionMaxZ, qy);
        }
        if (this.regionMinX == Integer.MAX_VALUE) {
            this.regionMaxZ = 0;
            this.regionMaxX = 0;
            this.regionMinZ = 0;
            this.regionMinX = 0;
        }
        this.regionMinX -= 100;
        this.regionMinZ -= 100;
        this.regionMaxX += 101;
        this.regionMaxZ += 101;
    }

    public void scrollTo(double x, double y) {
        this.updateMinMax();
        double dx = this.regionMaxX - this.regionMinX;
        double dy = this.regionMaxZ - this.regionMinZ;
        this.setScrollX((x - (double)this.regionMinX) / dx * (double)this.largeMap.scrollWidth - (double)this.width / 2.0);
        this.setScrollY((y - (double)this.regionMinZ) / dy * (double)this.largeMap.scrollHeight - (double)this.height / 2.0);
    }

    public void resetScroll() {
        this.alignWidgets();
        this.setScrollX((double)(this.largeMap.scrollWidth - this.width) / 2.0);
        this.setScrollY((double)(this.largeMap.scrollHeight - this.height) / 2.0);
    }

    public void addWidgets() {
        for (MapRegion region : this.largeMap.dimension.getRegions().values()) {
            this.add(new RegionMapButton(this, region));
        }
        for (Waypoint waypoint : this.largeMap.dimension.getWaypoints()) {
            this.add(new WaypointButton(this, waypoint));
        }
        RegistryKey dimId = Minecraft.func_71410_x().field_71441_e.func_234923_W_();
        for (AbstractClientPlayerEntity player : Minecraft.func_71410_x().field_71441_e.func_217369_A()) {
            if (this.largeMap.dimension.dimension != dimId) continue;
            this.add(new PlayerButton(this, player));
        }
        FTBChunksClient.addWidgets(this);
        this.alignWidgets();
    }

    public void alignWidgets() {
        this.largeMap.scrollWidth = 0;
        this.largeMap.scrollHeight = 0;
        this.updateMinMax();
        int z = this.largeMap.getRegionButtonSize();
        this.largeMap.scrollWidth = (this.regionMaxX - this.regionMinX) * z;
        this.largeMap.scrollHeight = (this.regionMaxZ - this.regionMinZ) * z;
        for (Widget w : this.widgets) {
            double y;
            double qy;
            if (w instanceof RegionMapButton) {
                double qx = ((RegionMapButton)w).region.pos.x;
                qy = ((RegionMapButton)w).region.pos.z;
                double qw = 1.0;
                double qh = 1.0;
                double x = (qx - (double)this.regionMinX) * (double)z;
                double y2 = (qy - (double)this.regionMinZ) * (double)z;
                w.setPosAndSize((int)x, (int)y2, (int)((double)z * qw), (int)((double)z * qh));
                continue;
            }
            if (w instanceof WaypointButton) {
                double qx = ((double)((WaypointButton)w).waypoint.x + 0.5) / 512.0;
                qy = ((double)((WaypointButton)w).waypoint.z + 0.5) / 512.0;
                int s = Math.max(8, z / 128);
                double x = (qx - (double)this.regionMinX) * (double)z - (double)s / 2.0;
                y = (qy - (double)this.regionMinZ) * (double)z - (double)s;
                w.setPosAndSize((int)x, (int)y, s, s);
                continue;
            }
            if (w instanceof PlayerButton) {
                double qx = ((PlayerButton)w).playerX / 512.0;
                qy = ((PlayerButton)w).playerZ / 512.0;
                int s = Math.max(8, z / 128);
                double x = (qx - (double)this.regionMinX) * (double)z - (double)s / 2.0;
                y = (qy - (double)this.regionMinZ) * (double)z - (double)s / 2.0;
                w.setPosAndSize((int)x, (int)y, s, s);
                continue;
            }
            if (!(w instanceof CustomMapWidget)) continue;
            Vector3d pos = ((CustomMapWidget)w).getPos();
            double qx = (pos.field_72450_a + 0.5) / 512.0;
            double qy2 = (pos.field_72449_c + 0.5) / 512.0;
            int s = Math.max(8, z / 128);
            double x = (qx - (double)this.regionMinX) * (double)z - (double)s / 2.0;
            double y3 = (qy2 - (double)this.regionMinZ) * (double)z - (double)s;
            w.setPosAndSize((int)x, (int)y3, s, s);
        }
        this.setPosAndSize(0, 0, this.parent.width, this.parent.height);
    }

    public void draw(MatrixStack matrixStack, Theme theme, int x, int y, int w, int h) {
        MapRegionData data;
        super.draw(matrixStack, theme, x, y, w, h);
        int dx = this.regionMaxX - this.regionMinX;
        int dy = this.regionMaxZ - this.regionMinZ;
        double px = (double)this.getX() - this.getScrollX();
        double py = (double)this.getY() - this.getScrollY();
        this.regionX = ((double)this.parent.getMouseX() - px) / (double)this.largeMap.scrollWidth * (double)dx + (double)this.regionMinX;
        this.regionZ = ((double)this.parent.getMouseY() - py) / (double)this.largeMap.scrollHeight * (double)dy + (double)this.regionMinZ;
        this.blockX = MathHelper.func_76128_c((double)(this.regionX * 512.0));
        this.blockZ = MathHelper.func_76128_c((double)(this.regionZ * 512.0));
        this.blockIndex = (this.blockX & 0x1FF) + (this.blockZ & 0x1FF) * 512;
        this.blockY = 0;
        MapRegion r = this.largeMap.dimension.getRegions().get(XZ.regionFromBlock((int)this.blockX, (int)this.blockZ));
        if (r != null && (data = r.getData()) != null) {
            this.blockY = data.height[this.blockIndex] & 0xFFFF;
        }
    }

    public void addMouseOverText(TooltipList list) {
        MapRegionData data;
        super.addMouseOverText(list);
        MapRegion r = this.largeMap.dimension.getRegions().get(XZ.regionFromBlock((int)this.blockX, (int)this.blockZ));
        if (r != null && (data = r.getData()) != null) {
            ClientTeam team;
            MapChunk c = data.chunks.get(XZ.of((int)(this.blockX >> 4 & 0x1F), (int)(this.blockZ >> 4 & 0x1F)));
            ClientTeam clientTeam = team = c == null ? null : c.getTeam();
            if (team != null) {
                list.add(team.getName());
            }
        }
    }

    public boolean mousePressed(MouseButton button) {
        if (super.mousePressed(button)) {
            return true;
        }
        if (button.isLeft() && this.isMouseOver()) {
            this.largeMap.prevMouseX = this.getMouseX();
            this.largeMap.prevMouseY = this.getMouseY();
            this.largeMap.grabbed = 1;
            return true;
        }
        return false;
    }

    public void mouseReleased(MouseButton button) {
        super.mouseReleased(button);
        this.largeMap.grabbed = 0;
    }

    public boolean scrollPanel(double scroll) {
        if (this.isMouseOver()) {
            this.largeMap.addZoom(scroll);
            return true;
        }
        return false;
    }

    public void drawBackground(MatrixStack matrixStack, Theme theme, int x, int y, int w, int h) {
        super.drawBackground(matrixStack, theme, x, y, w, h);
    }
}

