/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity;

import com.github.alexthe666.alexsmobs.config.AMConfig;
import com.github.alexthe666.alexsmobs.entity.AMEntityRegistry;
import com.github.alexthe666.alexsmobs.entity.IFollower;
import com.github.alexthe666.alexsmobs.entity.ITargetsDroppedItems;
import com.github.alexthe666.alexsmobs.entity.ai.AnimalAIHurtByTargetNotBaby;
import com.github.alexthe666.alexsmobs.entity.ai.AnimalAILootChests;
import com.github.alexthe666.alexsmobs.entity.ai.AnimalAIPanicBaby;
import com.github.alexthe666.alexsmobs.entity.ai.AnimalAIWanderRanged;
import com.github.alexthe666.alexsmobs.entity.ai.CreatureAITargetItems;
import com.github.alexthe666.alexsmobs.entity.ai.ILootsChests;
import com.github.alexthe666.alexsmobs.entity.ai.RaccoonAIBeg;
import com.github.alexthe666.alexsmobs.entity.ai.RaccoonAIWash;
import com.github.alexthe666.alexsmobs.entity.ai.TameableAIDestroyTurtleEggs;
import com.github.alexthe666.alexsmobs.entity.ai.TameableAIFollowOwner;
import com.github.alexthe666.alexsmobs.misc.AMSoundRegistry;
import com.github.alexthe666.alexsmobs.misc.AMTagRegistry;
import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.animation.AnimationHandler;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.FollowParentGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.MoveThroughVillageAtNightGoal;
import net.minecraft.entity.ai.goal.OwnerHurtByTargetGoal;
import net.minecraft.entity.ai.goal.OwnerHurtTargetGoal;
import net.minecraft.entity.ai.goal.SitGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ItemParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class EntityRaccoon
extends TameableEntity
implements IAnimatedEntity,
IFollower,
ITargetsDroppedItems,
ILootsChests {
    private static final DataParameter<Boolean> STANDING = EntityDataManager.func_187226_a(EntityRaccoon.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> SITTING = EntityDataManager.func_187226_a(EntityRaccoon.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> BEGGING = EntityDataManager.func_187226_a(EntityRaccoon.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> WASHING = EntityDataManager.func_187226_a(EntityRaccoon.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Optional<BlockPos>> WASH_POS = EntityDataManager.func_187226_a(EntityRaccoon.class, (IDataSerializer)DataSerializers.field_187201_k);
    private static final DataParameter<Integer> COMMAND = EntityDataManager.func_187226_a(EntityRaccoon.class, (IDataSerializer)DataSerializers.field_187192_b);
    public float prevStandProgress;
    public float standProgress;
    public float prevBegProgress;
    public float begProgress;
    public float prevWashProgress;
    public float washProgress;
    public float prevSitProgress;
    public float sitProgress;
    public int maxStandTime = 75;
    private int standingTime = 0;
    public int lookForWaterBeforeEatingTimer = 0;
    private int animationTick;
    private Animation currentAnimation;
    @Nullable
    private UUID eggThrowerUUID = null;
    public boolean forcedSit = false;
    public static final Animation ANIMATION_ATTACK = Animation.create((int)12);

    protected EntityRaccoon(EntityType type, World world) {
        super(type, world);
        this.func_184644_a(PathNodeType.WATER_BORDER, 0.0f);
    }

    protected float func_189749_co() {
        return 0.98f;
    }

    protected SoundEvent func_184639_G() {
        return AMSoundRegistry.RACCOON_IDLE;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return AMSoundRegistry.RACCOON_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return AMSoundRegistry.RACCOON_HURT;
    }

    public boolean func_213380_a(IWorld worldIn, SpawnReason spawnReasonIn) {
        return AMEntityRegistry.rollSpawn(AMConfig.raccoonSpawnRolls, this.func_70681_au(), spawnReasonIn);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SitGoal((TameableEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new BreedGoal((AnimalEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(2, (Goal)new RaccoonAIWash(this));
        this.field_70714_bg.func_75776_a(3, (Goal)new TameableAIFollowOwner(this, 1.3, 10.0f, 2.0f, false));
        this.field_70714_bg.func_75776_a(4, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(5, (Goal)new LeapAtTargetGoal((MobEntity)this, 0.4f));
        this.field_70714_bg.func_75776_a(6, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.1, true));
        this.field_70714_bg.func_75776_a(7, (Goal)new AnimalAILootChests((AnimalEntity)this, 16));
        this.field_70714_bg.func_75776_a(8, (Goal)new FollowParentGoal((AnimalEntity)this, 1.1));
        this.field_70714_bg.func_75776_a(9, (Goal)new RaccoonAIBeg(this, 0.65));
        this.field_70714_bg.func_75776_a(10, (Goal)new AnimalAIPanicBaby((AnimalEntity)this, 1.25));
        this.field_70714_bg.func_75776_a(11, (Goal)new StrollGoal(200));
        this.field_70714_bg.func_75776_a(12, (Goal)new TameableAIDestroyTurtleEggs(this, 1.0, 3));
        this.field_70714_bg.func_75776_a(13, (Goal)new AnimalAIWanderRanged((CreatureEntity)this, 120, 1.0, 14, 7));
        this.field_70714_bg.func_75776_a(14, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 15.0f));
        this.field_70714_bg.func_75776_a(14, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new AnimalAIHurtByTargetNotBaby((AnimalEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(1, new CreatureAITargetItems((CreatureEntity)this, false));
        this.field_70715_bh.func_75776_a(3, (Goal)new OwnerHurtByTargetGoal((TameableEntity)this));
        this.field_70715_bh.func_75776_a(4, (Goal)new OwnerHurtTargetGoal((TameableEntity)this));
    }

    public boolean func_184191_r(Entity entityIn) {
        if (this.func_70909_n()) {
            LivingEntity livingentity = this.func_70902_q();
            if (entityIn == livingentity) {
                return true;
            }
            if (entityIn instanceof TameableEntity) {
                return ((TameableEntity)entityIn).func_152114_e(livingentity);
            }
            if (livingentity != null) {
                return livingentity.func_184191_r(entityIn);
            }
        }
        return super.func_184191_r(entityIn);
    }

    public boolean func_70652_k(Entity entityIn) {
        if (this.getAnimation() == NO_ANIMATION) {
            this.setAnimation(ANIMATION_ATTACK);
        }
        return true;
    }

    public boolean func_70877_b(ItemStack stack) {
        return stack.func_77973_b() == Items.field_151025_P;
    }

    public ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        Item item = itemstack.func_77973_b();
        ActionResultType type = super.func_230254_b_(player, hand);
        if (this.func_70909_n() && EntityRaccoon.isFood(itemstack) && !this.func_70877_b(itemstack) && this.func_110143_aJ() < this.func_110138_aP()) {
            if (this.func_184614_ca().func_190926_b()) {
                ItemStack copy = itemstack.func_77946_l();
                copy.func_190920_e(1);
                this.func_184611_a(Hand.MAIN_HAND, copy);
                this.onEatItem();
                if (itemstack.hasContainerItem()) {
                    this.func_199701_a_(itemstack.getContainerItem());
                }
                if (!player.func_184812_l_()) {
                    itemstack.func_190918_g(1);
                }
                this.func_184611_a(Hand.MAIN_HAND, ItemStack.field_190927_a);
            } else {
                this.func_184185_a(SoundEvents.field_187537_bA, this.func_70599_aP(), this.func_70647_i());
                this.func_70691_i(5.0f);
            }
            this.func_175505_a(player, itemstack);
            return ActionResultType.SUCCESS;
        }
        if (type != ActionResultType.SUCCESS && this.func_70909_n() && this.func_152114_e((LivingEntity)player) && !this.func_70877_b(itemstack) && !player.func_225608_bj_()) {
            boolean sit;
            this.setCommand(this.getCommand() + 1);
            if (this.getCommand() == 3) {
                this.setCommand(0);
            }
            player.func_146105_b((ITextComponent)new TranslationTextComponent("entity.alexsmobs.all.command_" + this.getCommand(), new Object[]{this.func_200200_C_()}), true);
            boolean bl = sit = this.getCommand() == 2;
            if (sit) {
                this.forcedSit = true;
                this.func_233687_w_(true);
                return ActionResultType.SUCCESS;
            }
            this.forcedSit = false;
            this.func_233687_w_(false);
            return ActionResultType.SUCCESS;
        }
        return type;
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("RacSitting", this.isSitting());
        compound.func_74757_a("ForcedToSit", this.forcedSit);
        compound.func_74768_a("RacCommand", this.getCommand());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.func_233687_w_(compound.func_74767_n("RacSitting"));
        this.forcedSit = compound.func_74767_n("ForcedToSit");
        this.setCommand(compound.func_74762_e("RacCommand"));
    }

    public void setCommand(int command) {
        this.field_70180_af.func_187227_b(COMMAND, (Object)command);
    }

    public int getCommand() {
        return (Integer)this.field_70180_af.func_187225_a(COMMAND);
    }

    public void func_233687_w_(boolean sit) {
        this.field_70180_af.func_187227_b(SITTING, (Object)sit);
    }

    public boolean isSitting() {
        return (Boolean)this.field_70180_af.func_187225_a(SITTING);
    }

    public static boolean isFood(ItemStack stack) {
        return stack.func_222117_E() || ItemTags.func_199903_a().func_199910_a(AMTagRegistry.RACCOON_FOODSTUFFS).func_230235_a_((Object)stack.func_77973_b());
    }

    public static AttributeModifierMap.MutableAttribute bakeAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, 9.0).func_233815_a_(Attributes.field_233823_f_, 2.0).func_233815_a_(Attributes.field_233821_d_, 0.25);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        Entity entity = source.func_76346_g();
        this.func_233687_w_(false);
        if (entity != null && this.func_70909_n() && !(entity instanceof PlayerEntity) && !(entity instanceof AbstractArrowEntity)) {
            amount = (amount + 1.0f) / 4.0f;
        }
        return super.func_70097_a(source, amount);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.prevStandProgress = this.standProgress;
        this.prevBegProgress = this.begProgress;
        this.prevWashProgress = this.washProgress;
        this.prevSitProgress = this.sitProgress;
        if (this.isStanding() && this.standProgress < 5.0f) {
            this.standProgress += 1.0f;
        }
        if (!this.isStanding() && this.standProgress > 0.0f) {
            this.standProgress -= 1.0f;
        }
        if (this.isBegging() && this.begProgress < 5.0f) {
            this.begProgress += 1.0f;
        }
        if (!this.isBegging() && this.begProgress > 0.0f) {
            this.begProgress -= 1.0f;
        }
        if (this.isWashing() && this.washProgress < 5.0f) {
            this.washProgress += 1.0f;
        }
        if (!this.isWashing() && this.washProgress > 0.0f) {
            this.washProgress -= 1.0f;
        }
        if (this.isSitting() && this.sitProgress < 5.0f) {
            this.sitProgress += 1.0f;
        }
        if (!this.isSitting() && this.sitProgress > 0.0f) {
            this.sitProgress -= 1.0f;
        }
        if (this.isStanding() && ++this.standingTime > this.maxStandTime) {
            this.setStanding(false);
            this.standingTime = 0;
            this.maxStandTime = 75 + this.field_70146_Z.nextInt(50);
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.lookForWaterBeforeEatingTimer > 0) {
                --this.lookForWaterBeforeEatingTimer;
            } else if (!this.isWashing() && this.canTargetItem(this.func_184614_ca())) {
                this.onEatItem();
                if (this.func_184614_ca().hasContainerItem()) {
                    this.func_199701_a_(this.func_184614_ca().getContainerItem());
                }
                this.func_184614_ca().func_190918_g(1);
            }
        }
        if (this.isWashing() && this.getWashPos() != null) {
            BlockPos washingPos = this.getWashPos();
            if (this.func_70092_e((double)washingPos.func_177958_n() + 0.5, (double)washingPos.func_177956_o() + 0.5, (double)washingPos.func_177952_p() + 0.5) < 3.0) {
                int j = 0;
                while ((float)j < 4.0f) {
                    double d2 = this.field_70146_Z.nextDouble();
                    double d3 = this.field_70146_Z.nextDouble();
                    Vector3d vector3d = this.func_213322_ci();
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_218422_X, (double)washingPos.func_177958_n() + d2, (double)((float)washingPos.func_177956_o() + 0.8f), (double)washingPos.func_177952_p() + d3, vector3d.field_72450_a, vector3d.field_72448_b, vector3d.field_72449_c);
                    ++j;
                }
            } else {
                this.setWashing(false);
            }
        }
        if (!this.field_70170_p.field_72995_K && this.func_70638_az() != null && this.func_70685_l((Entity)this.func_70638_az()) && this.func_70032_d((Entity)this.func_70638_az()) < 4.0f && this.getAnimation() == ANIMATION_ATTACK && this.getAnimationTick() == 5) {
            float f1 = this.field_70177_z * ((float)Math.PI / 180);
            this.func_213317_d(this.func_213322_ci().func_72441_c((double)(-MathHelper.func_76126_a((float)f1) * -0.06f), 0.0, (double)(MathHelper.func_76134_b((float)f1) * -0.06f)));
            this.func_70638_az().func_233627_a_(0.35f, this.func_70638_az().func_226277_ct_() - this.func_226277_ct_(), this.func_70638_az().func_226281_cx_() - this.func_226281_cx_());
            this.func_70638_az().func_70097_a(DamageSource.func_76358_a((LivingEntity)this), (float)this.func_110148_a(Attributes.field_233823_f_).func_111125_b());
        }
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
    }

    public void onEatItem() {
        this.func_70691_i(10.0f);
        this.field_70170_p.func_72960_a((Entity)this, (byte)92);
        this.func_184185_a(SoundEvents.field_187537_bA, this.func_70599_aP(), this.func_70647_i());
    }

    public void postWashItem(ItemStack stack) {
        if (stack.func_77973_b() == Items.field_151110_aK && this.eggThrowerUUID != null && !this.func_70909_n()) {
            if (this.func_70681_au().nextFloat() < 0.3f) {
                this.func_70903_f(true);
                this.func_184754_b(this.eggThrowerUUID);
                PlayerEntity player = this.field_70170_p.func_217371_b(this.eggThrowerUUID);
                if (player instanceof ServerPlayerEntity) {
                    CriteriaTriggers.field_193136_w.func_193178_a((ServerPlayerEntity)player, (AnimalEntity)this);
                }
                this.field_70170_p.func_72960_a((Entity)this, (byte)7);
            } else {
                this.field_70170_p.func_72960_a((Entity)this, (byte)6);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 92) {
            for (int i = 0; i < 6 + this.field_70146_Z.nextInt(3); ++i) {
                double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                double d0 = this.field_70146_Z.nextGaussian() * 0.02;
                double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                this.field_70170_p.func_195594_a((IParticleData)new ItemParticleData(ParticleTypes.field_197591_B, this.func_184586_b(Hand.MAIN_HAND)), this.func_226277_ct_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf()) - (double)this.func_213311_cf() * 0.5, this.func_226278_cu_() + (double)(this.func_213302_cg() * 0.5f) + (double)(this.field_70146_Z.nextFloat() * this.func_213302_cg() * 0.5f), this.func_226281_cx_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf()) - (double)this.func_213311_cf() * 0.5, d0, d1, d2);
            }
        } else {
            super.func_70103_a(id);
        }
    }

    public boolean isStanding() {
        return (Boolean)this.field_70180_af.func_187225_a(STANDING);
    }

    public void setStanding(boolean standing) {
        this.field_70180_af.func_187227_b(STANDING, (Object)standing);
    }

    public boolean isBegging() {
        return (Boolean)this.field_70180_af.func_187225_a(BEGGING);
    }

    public void setBegging(boolean begging) {
        this.field_70180_af.func_187227_b(BEGGING, (Object)begging);
    }

    public boolean isWashing() {
        return (Boolean)this.field_70180_af.func_187225_a(WASHING);
    }

    public void setWashing(boolean washing) {
        this.field_70180_af.func_187227_b(WASHING, (Object)washing);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(STANDING, (Object)false);
        this.field_70180_af.func_187214_a(SITTING, (Object)false);
        this.field_70180_af.func_187214_a(BEGGING, (Object)false);
        this.field_70180_af.func_187214_a(WASHING, (Object)false);
        this.field_70180_af.func_187214_a(COMMAND, (Object)0);
        this.field_70180_af.func_187214_a(WASH_POS, Optional.empty());
    }

    public BlockPos getWashPos() {
        return ((Optional)this.field_70180_af.func_187225_a(WASH_POS)).orElse(null);
    }

    public void setWashPos(BlockPos washingPos) {
        this.field_70180_af.func_187227_b(WASH_POS, Optional.ofNullable(washingPos));
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int i) {
        this.animationTick = i;
    }

    public Animation getAnimation() {
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        this.currentAnimation = animation;
        if (animation == ANIMATION_ATTACK) {
            this.maxStandTime = 15;
            this.setStanding(true);
        }
    }

    public Animation[] getAnimations() {
        return new Animation[]{ANIMATION_ATTACK};
    }

    @Nullable
    public AgeableEntity func_241840_a(ServerWorld serverWorld, AgeableEntity ageableEntity) {
        return (AgeableEntity)AMEntityRegistry.RACCOON.func_200721_a((World)serverWorld);
    }

    public void func_213352_e(Vector3d vec3d) {
        if (this.isSitting() || this.isWashing()) {
            if (this.func_70661_as().func_75505_d() != null) {
                this.func_70661_as().func_75499_g();
            }
            vec3d = Vector3d.field_186680_a;
        }
        super.func_213352_e(vec3d);
    }

    @Override
    public boolean shouldFollow() {
        return this.getCommand() == 1;
    }

    @Override
    public boolean canTargetItem(ItemStack stack) {
        return EntityRaccoon.isFood(stack);
    }

    @Override
    public void onGetItem(ItemEntity e) {
        this.lookForWaterBeforeEatingTimer = 100;
        ItemStack duplicate = e.func_92059_d().func_77946_l();
        duplicate.func_190920_e(1);
        if (!this.func_184586_b(Hand.MAIN_HAND).func_190926_b() && !this.field_70170_p.field_72995_K) {
            this.func_70099_a(this.func_184586_b(Hand.MAIN_HAND), 0.0f);
        }
        this.func_184611_a(Hand.MAIN_HAND, duplicate);
        this.eggThrowerUUID = e.func_92059_d().func_77973_b() == Items.field_151110_aK ? e.func_200214_m() : null;
    }

    @Override
    public boolean isLootable(IInventory inventory) {
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            if (!this.shouldLootItem(inventory.func_70301_a(i))) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean shouldLootItem(ItemStack stack) {
        return EntityRaccoon.isFood(stack);
    }

    public BlockPos getLightPosition() {
        BlockPos pos = new BlockPos(this.func_213303_ch());
        if (!this.field_70170_p.func_180495_p(pos).func_200132_m()) {
            return pos.func_177984_a();
        }
        return pos;
    }

    class StrollGoal
    extends MoveThroughVillageAtNightGoal {
        public StrollGoal(int p_i50726_3_) {
            super((CreatureEntity)EntityRaccoon.this, p_i50726_3_);
        }

        public void func_75249_e() {
            super.func_75249_e();
        }

        public boolean func_75250_a() {
            return super.func_75250_a() && this.func_220759_g();
        }

        public boolean func_75253_b() {
            return super.func_75253_b() && this.func_220759_g();
        }

        private boolean func_220759_g() {
            return !EntityRaccoon.this.isWashing() && !EntityRaccoon.this.isSitting() && EntityRaccoon.this.func_70638_az() == null;
        }
    }
}

