/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.guns.client.handler;

import com.mrcrayfish.controllable.Controllable;
import com.mrcrayfish.controllable.client.Action;
import com.mrcrayfish.controllable.client.Controller;
import com.mrcrayfish.controllable.client.gui.navigation.BasicNavigationPoint;
import com.mrcrayfish.controllable.client.gui.navigation.NavigationPoint;
import com.mrcrayfish.controllable.event.ControllerEvent;
import com.mrcrayfish.controllable.event.GatherActionsEvent;
import com.mrcrayfish.controllable.event.GatherNavigationPointsEvent;
import com.mrcrayfish.guns.Config;
import com.mrcrayfish.guns.client.GunButtonBindings;
import com.mrcrayfish.guns.client.handler.AimingHandler;
import com.mrcrayfish.guns.client.handler.ReloadHandler;
import com.mrcrayfish.guns.client.handler.ShootingHandler;
import com.mrcrayfish.guns.client.screen.WorkbenchScreen;
import com.mrcrayfish.guns.common.Gun;
import com.mrcrayfish.guns.init.ModSyncedDataKeys;
import com.mrcrayfish.guns.item.GunItem;
import com.mrcrayfish.guns.item.attachment.IScope;
import com.mrcrayfish.guns.item.attachment.impl.Scope;
import com.mrcrayfish.guns.network.PacketHandler;
import com.mrcrayfish.guns.network.message.MessageAttachments;
import com.mrcrayfish.guns.network.message.MessageUnload;
import com.mrcrayfish.guns.util.GunEnchantmentHelper;
import com.mrcrayfish.obfuscate.common.data.SyncedPlayerData;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ControllerHandler {
    private int reloadCounter = -1;

    @SubscribeEvent
    public void onButtonInput(ControllerEvent.ButtonInput event) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        if (player != null && world != null && Minecraft.func_71410_x().field_71462_r == null) {
            ItemStack heldItem = player.func_184614_ca();
            int button = event.getButton();
            if (button == GunButtonBindings.SHOOT.getButton()) {
                if (heldItem.func_77973_b() instanceof GunItem) {
                    event.setCanceled(true);
                    if (event.getState()) {
                        ShootingHandler.get().fire((PlayerEntity)player, heldItem);
                    }
                }
            } else if (button == GunButtonBindings.AIM.getButton()) {
                if (heldItem.func_77973_b() instanceof GunItem) {
                    event.setCanceled(true);
                }
            } else if (button == GunButtonBindings.STEADY_AIM.getButton()) {
                if (heldItem.func_77973_b() instanceof GunItem) {
                    event.setCanceled(true);
                }
            } else if (button == GunButtonBindings.RELOAD.getButton()) {
                if (heldItem.func_77973_b() instanceof GunItem) {
                    event.setCanceled(true);
                    if (event.getState()) {
                        this.reloadCounter = 0;
                    }
                }
            } else if (button == GunButtonBindings.OPEN_ATTACHMENTS.getButton() && heldItem.func_77973_b() instanceof GunItem && Minecraft.func_71410_x().field_71462_r == null) {
                event.setCanceled(true);
                if (event.getState()) {
                    PacketHandler.getPlayChannel().sendToServer((Object)new MessageAttachments());
                }
            }
        }
    }

    @SubscribeEvent
    public void onControllerTurn(ControllerEvent.Turn event) {
        ItemStack heldItem;
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player != null && (heldItem = player.func_184614_ca()).func_77973_b() instanceof GunItem && AimingHandler.get().isAiming()) {
            double adsSensitivity = (Double)Config.CLIENT.controls.aimDownSightSensitivity.get();
            event.setYawSpeed(10.0f * (float)adsSensitivity);
            event.setPitchSpeed(7.5f * (float)adsSensitivity);
            Scope scope = Gun.getScope(heldItem);
            if (scope != null && scope.isStable() && Controllable.isButtonPressed((int)GunButtonBindings.STEADY_AIM.getButton())) {
                event.setYawSpeed(event.getYawSpeed() / 2.0f);
                event.setPitchSpeed(event.getPitchSpeed() / 2.0f);
            }
        }
    }

    @SubscribeEvent
    public void updateAvailableActions(GatherActionsEvent event) {
        ItemStack heldItem;
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71462_r != null) {
            return;
        }
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player != null && (heldItem = player.func_184614_ca()).func_77973_b() instanceof GunItem) {
            IScope iscope;
            Scope scope;
            ItemStack scopeStack;
            event.getActions().put(GunButtonBindings.AIM, new Action("Aim", Action.Side.RIGHT));
            event.getActions().put(GunButtonBindings.SHOOT, new Action("Shoot", Action.Side.RIGHT));
            GunItem gunItem = (GunItem)heldItem.func_77973_b();
            Gun modifiedGun = gunItem.getModifiedGun(heldItem);
            CompoundNBT tag = heldItem.func_77978_p();
            if (tag != null && tag.func_74762_e("AmmoCount") < GunEnchantmentHelper.getAmmoCapacity(heldItem, modifiedGun)) {
                event.getActions().put(GunButtonBindings.RELOAD, new Action("Reload", Action.Side.LEFT));
            }
            if ((scopeStack = Gun.getScopeStack(heldItem)).func_77973_b() instanceof IScope && AimingHandler.get().isAiming() && (scope = (Scope)(iscope = (IScope)scopeStack.func_77973_b()).getProperties()).isStable()) {
                event.getActions().put(GunButtonBindings.STEADY_AIM, new Action("Hold Breath", Action.Side.RIGHT));
            }
        }
    }

    @SubscribeEvent
    public void onRender(TickEvent.RenderTickEvent event) {
        Gun gun;
        ItemStack heldItem;
        Controller controller = Controllable.getController();
        if (controller == null) {
            return;
        }
        if (event.phase == TickEvent.Phase.END) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        ClientPlayerEntity player = mc.field_71439_g;
        if (player == null) {
            return;
        }
        if (Controllable.isButtonPressed((int)GunButtonBindings.SHOOT.getButton()) && Minecraft.func_71410_x().field_71462_r == null && (heldItem = player.func_184614_ca()).func_77973_b() instanceof GunItem && (gun = ((GunItem)heldItem.func_77973_b()).getModifiedGun(heldItem)).getGeneral().isAuto()) {
            ShootingHandler.get().fire((PlayerEntity)player, heldItem);
        }
        if (mc.field_71462_r == null && this.reloadCounter != -1 && Controllable.isButtonPressed((int)GunButtonBindings.RELOAD.getButton())) {
            ++this.reloadCounter;
        }
        if (this.reloadCounter > 40) {
            ReloadHandler.get().setReloading(false);
            PacketHandler.getPlayChannel().sendToServer((Object)new MessageUnload());
            this.reloadCounter = -1;
        } else if (this.reloadCounter > 0 && !Controllable.isButtonPressed((int)GunButtonBindings.RELOAD.getButton())) {
            ReloadHandler.get().setReloading((Boolean)SyncedPlayerData.instance().get((PlayerEntity)player, ModSyncedDataKeys.RELOADING) == false);
            this.reloadCounter = -1;
        }
    }

    public static boolean isAiming() {
        Controller controller = Controllable.getController();
        return controller != null && Controllable.isButtonPressed((int)GunButtonBindings.AIM.getButton());
    }

    public static boolean isShooting() {
        Controller controller = Controllable.getController();
        return controller != null && Controllable.isButtonPressed((int)GunButtonBindings.SHOOT.getButton());
    }

    @SubscribeEvent
    public void onGatherNavigationPoints(GatherNavigationPointsEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71462_r instanceof WorkbenchScreen) {
            int i;
            WorkbenchScreen workbench = (WorkbenchScreen)mc.field_71462_r;
            int startX = workbench.getGuiLeft();
            int startY = workbench.getGuiTop();
            for (i = 0; i < workbench.getTabs().size(); ++i) {
                int tabX = startX + 28 * i + 14;
                int tabY = startY - 14;
                event.addPoint((NavigationPoint)new BasicNavigationPoint((double)tabX, (double)tabY));
            }
            for (i = 0; i < 6; ++i) {
                int itemX = startX + 172 + 40;
                int itemY = startY + i * 19 + 63 + 9;
                event.addPoint((NavigationPoint)new BasicNavigationPoint((double)itemX, (double)itemY));
            }
        }
    }
}

