/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.ui;

import architectury_inject_FTBLibrary1165_common_6a9ec1f118dd42fc81cfa4c524e35928.PlatformMethods;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.ui.BaseScreen;
import java.util.List;
import java.util.Stack;
import me.shedaniel.architectury.annotations.ExpectPlatform;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.world.World;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL11;

public class GuiHelper {
    private static final Stack<Scissor> SCISSOR = new Stack();
    public static final BaseScreen BLANK_GUI = new BaseScreen(){

        @Override
        public void addWidgets() {
        }

        @Override
        public void alignWidgets() {
        }
    };

    public static void setupDrawing() {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableAlphaTest();
        RenderSystem.defaultAlphaFunc();
        RenderSystem.enableDepthTest();
        RenderHelper.func_74518_a();
    }

    public static void playSound(SoundEvent event, float pitch) {
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)event, (float)pitch));
    }

    public static void drawTexturedRect(MatrixStack matrixStack, int x, int y, int w, int h, Color4I col, float u0, float v0, float u1, float v1) {
        if (u0 == u1 || v0 == v1) {
            Tessellator tesselator = Tessellator.func_178181_a();
            BufferBuilder buffer = tesselator.func_178180_c();
            buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
            GuiHelper.addRectToBuffer(matrixStack, buffer, x, y, w, h, col);
            tesselator.func_78381_a();
        } else {
            Tessellator tesselator = Tessellator.func_178181_a();
            BufferBuilder buffer = tesselator.func_178180_c();
            buffer.func_181668_a(7, DefaultVertexFormats.field_227851_o_);
            GuiHelper.addRectToBufferWithUV(matrixStack, buffer, x, y, w, h, col, u0, v0, u1, v1);
            tesselator.func_78381_a();
        }
    }

    public static void addRectToBuffer(MatrixStack matrixStack, BufferBuilder buffer, int x, int y, int w, int h, Color4I col) {
        if (w <= 0 || h <= 0) {
            return;
        }
        Matrix4f m = matrixStack.func_227866_c_().func_227870_a_();
        int r = col.redi();
        int g = col.greeni();
        int b = col.bluei();
        int a = col.alphai();
        buffer.func_227888_a_(m, (float)x, (float)(y + h), 0.0f).func_225586_a_(r, g, b, a).func_181675_d();
        buffer.func_227888_a_(m, (float)(x + w), (float)(y + h), 0.0f).func_225586_a_(r, g, b, a).func_181675_d();
        buffer.func_227888_a_(m, (float)(x + w), (float)y, 0.0f).func_225586_a_(r, g, b, a).func_181675_d();
        buffer.func_227888_a_(m, (float)x, (float)y, 0.0f).func_225586_a_(r, g, b, a).func_181675_d();
    }

    public static void addRectToBufferWithUV(MatrixStack matrixStack, BufferBuilder buffer, int x, int y, int w, int h, Color4I col, float u0, float v0, float u1, float v1) {
        if (w <= 0 || h <= 0) {
            return;
        }
        Matrix4f m = matrixStack.func_227866_c_().func_227870_a_();
        int r = col.redi();
        int g = col.greeni();
        int b = col.bluei();
        int a = col.alphai();
        buffer.func_227888_a_(m, (float)x, (float)(y + h), 0.0f).func_225586_a_(r, g, b, a).func_225583_a_(u0, v1).func_181675_d();
        buffer.func_227888_a_(m, (float)(x + w), (float)(y + h), 0.0f).func_225586_a_(r, g, b, a).func_225583_a_(u1, v1).func_181675_d();
        buffer.func_227888_a_(m, (float)(x + w), (float)y, 0.0f).func_225586_a_(r, g, b, a).func_225583_a_(u1, v0).func_181675_d();
        buffer.func_227888_a_(m, (float)x, (float)y, 0.0f).func_225586_a_(r, g, b, a).func_225583_a_(u0, v0).func_181675_d();
    }

    public static void drawHollowRect(MatrixStack matrixStack, int x, int y, int w, int h, Color4I col, boolean roundEdges) {
        if (w <= 1 || h <= 1 || col.isEmpty()) {
            col.draw(matrixStack, x, y, w, h);
            return;
        }
        RenderSystem.disableTexture();
        Tessellator tesselator = Tessellator.func_178181_a();
        BufferBuilder buffer = tesselator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        GuiHelper.addRectToBuffer(matrixStack, buffer, x, y + 1, 1, h - 2, col);
        GuiHelper.addRectToBuffer(matrixStack, buffer, x + w - 1, y + 1, 1, h - 2, col);
        if (roundEdges) {
            GuiHelper.addRectToBuffer(matrixStack, buffer, x + 1, y, w - 2, 1, col);
            GuiHelper.addRectToBuffer(matrixStack, buffer, x + 1, y + h - 1, w - 2, 1, col);
        } else {
            GuiHelper.addRectToBuffer(matrixStack, buffer, x, y, w, 1, col);
            GuiHelper.addRectToBuffer(matrixStack, buffer, x, y + h - 1, w, 1, col);
        }
        tesselator.func_78381_a();
        RenderSystem.enableTexture();
    }

    public static void drawRectWithShade(MatrixStack matrixStack, int x, int y, int w, int h, Color4I col, int intensity) {
        RenderSystem.disableTexture();
        Tessellator tesselator = Tessellator.func_178181_a();
        BufferBuilder buffer = tesselator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        GuiHelper.addRectToBuffer(matrixStack, buffer, x, y, w - 1, 1, col);
        GuiHelper.addRectToBuffer(matrixStack, buffer, x, y + 1, 1, h - 1, col);
        col = col.mutable().addBrightness(-intensity);
        GuiHelper.addRectToBuffer(matrixStack, buffer, x + w - 1, y, 1, 1, col);
        GuiHelper.addRectToBuffer(matrixStack, buffer, x, y + h - 1, 1, 1, col);
        col = col.mutable().addBrightness(-intensity);
        GuiHelper.addRectToBuffer(matrixStack, buffer, x + w - 1, y + 1, 1, h - 2, col);
        GuiHelper.addRectToBuffer(matrixStack, buffer, x + 1, y + h - 1, w - 1, 1, col);
        tesselator.func_78381_a();
        RenderSystem.enableTexture();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static FontRenderer getFont(ItemStack stack) {
        return PlatformMethods.platform("getFont", (ItemStack)stack);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean shouldShowDurability(ItemStack stack) {
        return (boolean)PlatformMethods.platform("shouldShowDurability", (ItemStack)stack);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static double getDamageLevel(ItemStack stack) {
        return (double)PlatformMethods.platform("getDamageLevel", (ItemStack)stack);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static int getDurabilityColor(ItemStack stack) {
        return (int)PlatformMethods.platform("getDurabilityColor", (ItemStack)stack);
    }

    public static boolean drawItem(MatrixStack matrixStack, ItemStack stack, double x, double y, float scaleX, float scaleY, boolean renderOverlay, @Nullable String text) {
        boolean flatLight;
        if (stack.func_190926_b() || (double)scaleX == 0.0 || (double)scaleY == 0.0) {
            return false;
        }
        Minecraft mc = Minecraft.func_71410_x();
        Tessellator tesselator = Tessellator.func_178181_a();
        ItemRenderer itemRenderer = mc.func_175599_af();
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(x, y, 0.0);
        matrixStack.func_227862_a_(scaleX, scaleY, 1.0f);
        mc.func_110434_K().func_110577_a(AtlasTexture.field_110575_b);
        mc.func_110434_K().func_229267_b_(AtlasTexture.field_110575_b).func_174937_a(false, false);
        RenderSystem.enableRescaleNormal();
        GuiHelper.setupDrawing();
        matrixStack.func_227861_a_(8.0, 8.0, (double)itemRenderer.field_77023_b);
        matrixStack.func_227862_a_(1.0f, -1.0f, 1.0f);
        matrixStack.func_227862_a_(16.0f, 16.0f, 16.0f);
        IRenderTypeBuffer.Impl renderTypeBufferImpl = mc.func_228019_au_().func_228487_b_();
        IBakedModel bakedModel = itemRenderer.func_184393_a(stack, (World)mc.field_71441_e, (LivingEntity)mc.field_71439_g);
        boolean bl = flatLight = !bakedModel.func_230044_c_();
        if (flatLight) {
            RenderHelper.func_227783_c_();
        }
        itemRenderer.func_229111_a_(stack, ItemCameraTransforms.TransformType.GUI, false, matrixStack, (IRenderTypeBuffer)renderTypeBufferImpl, 0xF000F0, OverlayTexture.field_229196_a_, bakedModel);
        renderTypeBufferImpl.func_228461_a_();
        RenderSystem.enableDepthTest();
        if (flatLight) {
            RenderHelper.func_227784_d_();
        }
        RenderSystem.disableAlphaTest();
        RenderSystem.disableRescaleNormal();
        if (renderOverlay) {
            float f3;
            FontRenderer fr = GuiHelper.getFont(stack);
            if (fr == null) {
                fr = mc.field_71466_p;
            }
            if (stack.func_190916_E() != 1 || text != null) {
                String s = text == null ? String.valueOf(stack.func_190916_E()) : text;
                matrixStack.func_227861_a_(0.0, 0.0, (double)(itemRenderer.field_77023_b + 20.0f));
                fr.func_228079_a_(s, (float)(17 - fr.func_78256_a(s)), 9.0f, 0xFFFFFF, true, matrixStack.func_227866_c_().func_227870_a_(), (IRenderTypeBuffer)renderTypeBufferImpl, false, 0, 0xF000F0);
                renderTypeBufferImpl.func_228461_a_();
            }
            if (GuiHelper.shouldShowDurability(stack)) {
                RenderSystem.disableDepthTest();
                RenderSystem.disableTexture();
                RenderSystem.disableAlphaTest();
                RenderSystem.disableBlend();
                double health = GuiHelper.getDamageLevel(stack);
                int i = Math.round(13.0f - (float)health * 13.0f);
                int j = GuiHelper.getDurabilityColor(stack);
                GuiHelper.draw(matrixStack, tesselator, 2, 13, 13, 2, 0, 0, 0, 255);
                GuiHelper.draw(matrixStack, tesselator, 2, 13, i, 1, j >> 16 & 0xFF, j >> 8 & 0xFF, j & 0xFF, 255);
                RenderSystem.enableBlend();
                RenderSystem.enableAlphaTest();
                RenderSystem.enableTexture();
                RenderSystem.enableDepthTest();
            }
            float f = f3 = mc.field_71439_g == null ? 0.0f : mc.field_71439_g.func_184811_cZ().func_185143_a(stack.func_77973_b(), mc.func_184121_ak());
            if (f3 > 0.0f) {
                RenderSystem.disableDepthTest();
                RenderSystem.disableTexture();
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                GuiHelper.draw(matrixStack, tesselator, 0, MathHelper.func_76141_d((float)(16.0f * (1.0f - f3))), 16, MathHelper.func_76123_f((float)(16.0f * f3)), 255, 255, 255, 127);
                RenderSystem.enableTexture();
                RenderSystem.enableDepthTest();
            }
        }
        matrixStack.func_227865_b_();
        return true;
    }

    private static void draw(MatrixStack matrixStack, Tessellator tesselator, int x, int y, int width, int height, int red, int green, int blue, int alpha) {
        Matrix4f m = matrixStack.func_227866_c_().func_227870_a_();
        BufferBuilder renderer = tesselator.func_178180_c();
        renderer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        renderer.func_227888_a_(m, (float)x, (float)y, 0.0f).func_225586_a_(red, green, blue, alpha).func_181675_d();
        renderer.func_227888_a_(m, (float)x, (float)(y + height), 0.0f).func_225586_a_(red, green, blue, alpha).func_181675_d();
        renderer.func_227888_a_(m, (float)(x + width), (float)(y + height), 0.0f).func_225586_a_(red, green, blue, alpha).func_181675_d();
        renderer.func_227888_a_(m, (float)(x + width), (float)y, 0.0f).func_225586_a_(red, green, blue, alpha).func_181675_d();
        tesselator.func_78381_a();
    }

    public static void pushScissor(MainWindow screen, int x, int y, int w, int h) {
        if (SCISSOR.isEmpty()) {
            GL11.glEnable((int)3089);
        }
        Scissor scissor = SCISSOR.isEmpty() ? new Scissor(x, y, w, h) : ((Scissor)SCISSOR.lastElement()).crop(x, y, w, h);
        SCISSOR.push(scissor);
        scissor.scissor(screen);
    }

    public static void popScissor(MainWindow screen) {
        SCISSOR.pop();
        if (SCISSOR.isEmpty()) {
            GL11.glDisable((int)3089);
        } else {
            ((Scissor)SCISSOR.lastElement()).scissor(screen);
        }
    }

    public static String clickEventToString(@Nullable ClickEvent event) {
        if (event == null) {
            return "";
        }
        switch (event.func_150669_a()) {
            case OPEN_URL: 
            case CHANGE_PAGE: {
                return event.func_150668_b();
            }
            case OPEN_FILE: {
                return "file:" + event.func_150668_b();
            }
            case RUN_COMMAND: {
                return "command:" + event.func_150668_b();
            }
            case SUGGEST_COMMAND: {
                return "suggest_command:" + event.func_150668_b();
            }
        }
        return "";
    }

    public static void addStackTooltip(ItemStack stack, List<ITextComponent> list) {
        GuiHelper.addStackTooltip(stack, list, null);
    }

    public static void addStackTooltip(ItemStack stack, List<ITextComponent> list, @Nullable ITextComponent prefix) {
        List tooltip = stack.func_82840_a((PlayerEntity)Minecraft.func_71410_x().field_71439_g, (ITooltipFlag)(Minecraft.func_71410_x().field_71474_y.field_82882_x ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL));
        list.add((ITextComponent)(prefix == null ? ((ITextComponent)tooltip.get(0)).func_230532_e_().func_240699_a_(stack.func_77953_t().field_77937_e) : prefix.func_230532_e_().func_230529_a_((ITextComponent)tooltip.get(0))));
        for (int i = 1; i < tooltip.size(); ++i) {
            list.add((ITextComponent)new StringTextComponent("").func_240699_a_(TextFormatting.GRAY).func_230529_a_((ITextComponent)tooltip.get(i)));
        }
    }

    private static class Scissor {
        private final int x;
        private final int y;
        private final int w;
        private final int h;

        private Scissor(int _x, int _y, int _w, int _h) {
            this.x = _x;
            this.y = _y;
            this.w = Math.max(0, _w);
            this.h = Math.max(0, _h);
        }

        public Scissor crop(int sx, int sy, int sw, int sh) {
            int x0 = Math.max(this.x, sx);
            int y0 = Math.max(this.y, sy);
            int x1 = Math.min(this.x + this.w, sx + sw);
            int y1 = Math.min(this.y + this.h, sy + sh);
            return new Scissor(x0, y0, x1 - x0, y1 - y0);
        }

        public void scissor(MainWindow screen) {
            double scale = screen.func_198100_s();
            int sx = (int)((double)this.x * scale);
            int sy = (int)((double)(screen.func_198087_p() - (this.y + this.h)) * scale);
            int sw = (int)((double)this.w * scale);
            int sh = (int)((double)this.h * scale);
            GL11.glScissor((int)sx, (int)sy, (int)sw, (int)sh);
        }
    }
}

