/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.items;

import de.maxhenkel.car.ModItemGroups;
import de.maxhenkel.car.blocks.ModBlocks;
import de.maxhenkel.car.corelib.energy.EnergyUtils;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class ItemBattery
extends Item {
    public ItemBattery() {
        super(new Item.Properties().func_200917_a(1).func_200916_a(ModItemGroups.TAB_CAR).func_200918_c(500));
        this.setRegistryName(new ResourceLocation("car", "battery"));
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.battery_energy", new Object[]{new StringTextComponent(String.valueOf(this.getEnergy(stack))).func_240699_a_(TextFormatting.DARK_GRAY)}).func_240699_a_(TextFormatting.GRAY));
        tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.battery").func_240699_a_(TextFormatting.GRAY));
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    public boolean func_77616_k(ItemStack stack) {
        return false;
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        IEnergyStorage storage;
        if (context.func_195991_k().func_180495_p(context.func_195995_a()).func_177230_c().equals(ModBlocks.GENERATOR) && (storage = EnergyUtils.getEnergyStorage((IWorldReader)context.func_195991_k(), context.func_195995_a(), context.func_196000_l())) != null) {
            ItemStack stack = context.func_195999_j().func_184586_b(context.func_221531_n());
            int energyToFill = stack.func_77952_i();
            int amount = storage.extractEnergy(energyToFill, false);
            stack.func_196085_b(energyToFill - amount);
            context.func_195999_j().func_184611_a(context.func_221531_n(), stack);
            return ActionResultType.SUCCESS;
        }
        return super.func_195939_a(context);
    }

    public int getEnergy(ItemStack stack) {
        return this.getMaxDamage(stack) - this.getDamage(stack);
    }

    public void setEnergy(ItemStack stack, int energy) {
        this.setDamage(stack, Math.max(this.getMaxDamage(stack) - energy, 0));
    }

    @Nullable
    public ICapabilityProvider initCapabilities(final ItemStack stack, @Nullable CompoundNBT nbt) {
        return new ICapabilityProvider(){

            @Nonnull
            public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
                if (cap == CapabilityEnergy.ENERGY) {
                    return LazyOptional.of(() -> new BatteryEnergyStorage(stack)).cast();
                }
                return LazyOptional.empty();
            }
        };
    }

    public class BatteryEnergyStorage
    implements IEnergyStorage {
        private ItemStack stack;

        public BatteryEnergyStorage(ItemStack stack) {
            this.stack = stack;
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            int amount = Math.min(maxReceive, ItemBattery.this.getMaxDamage(this.stack) - ItemBattery.this.getEnergy(this.stack));
            if (!simulate) {
                ItemBattery.this.setEnergy(this.stack, ItemBattery.this.getEnergy(this.stack) + amount);
            }
            return amount;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            return 0;
        }

        public int getEnergyStored() {
            return ItemBattery.this.getEnergy(this.stack);
        }

        public int getMaxEnergyStored() {
            return ItemBattery.this.getMaxDamage(this.stack);
        }

        public boolean canExtract() {
            return false;
        }

        public boolean canReceive() {
            return true;
        }
    }
}

