/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteams.data;

import dev.ftb.mods.ftbteams.data.FTBTUtils;
import dev.ftb.mods.ftbteams.data.Team;
import dev.ftb.mods.ftbteams.data.TeamManager;
import dev.ftb.mods.ftbteams.data.TeamRank;
import dev.ftb.mods.ftbteams.data.TeamType;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import org.jetbrains.annotations.Nullable;

public class PlayerTeam
extends Team {
    public String playerName = "";

    public PlayerTeam(TeamManager m) {
        super(m);
    }

    @Override
    public TeamType getType() {
        return TeamType.PLAYER;
    }

    @Override
    protected void serializeExtraNBT(CompoundNBT tag) {
        tag.func_74778_a("player_name", this.playerName);
    }

    @Override
    public void deserializeNBT(CompoundNBT tag) {
        super.deserializeNBT(tag);
        this.playerName = tag.func_74779_i("player_name");
    }

    @Nullable
    public ServerPlayerEntity getPlayer() {
        return FTBTUtils.getPlayerByUUID(this.manager.server, this.id);
    }

    @Override
    public TeamRank getHighestRank(UUID playerId) {
        if (playerId.equals(this.id)) {
            return TeamRank.OWNER;
        }
        return super.getHighestRank(playerId);
    }

    @Override
    public List<ServerPlayerEntity> getOnlineMembers() {
        ServerPlayerEntity p = this.getPlayer();
        return p == null ? Collections.emptyList() : Collections.singletonList(p);
    }
}

