/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.client.map;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.ftb.mods.ftbchunks.FTBChunks;
import dev.ftb.mods.ftbchunks.client.FTBChunksClient;
import dev.ftb.mods.ftbchunks.client.map.ColorsFromRegion;
import dev.ftb.mods.ftbchunks.client.map.MapIOUtils;
import dev.ftb.mods.ftbchunks.client.map.MapManager;
import dev.ftb.mods.ftbchunks.client.map.MapRegion;
import dev.ftb.mods.ftbchunks.client.map.MapTask;
import dev.ftb.mods.ftbchunks.client.map.SyncTXTask;
import dev.ftb.mods.ftbchunks.client.map.Waypoint;
import dev.ftb.mods.ftbchunks.client.map.WaypointType;
import dev.ftb.mods.ftblibrary.math.XZ;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.util.RegistryKey;
import net.minecraft.world.World;
import org.jetbrains.annotations.Nullable;

public class MapDimension
implements MapTask {
    private static MapDimension current;
    public final MapManager manager;
    public final RegistryKey<World> dimension;
    public final String safeDimensionId;
    public final Path directory;
    private Map<XZ, MapRegion> regions;
    private List<Waypoint> waypoints;
    public boolean saveData;

    public static MapDimension getCurrent() {
        if (current == null) {
            current = MapManager.inst.getDimension((RegistryKey<World>)Minecraft.func_71410_x().field_71441_e.func_234923_W_());
        }
        return current;
    }

    public static void updateCurrent() {
        current = null;
    }

    public MapDimension(MapManager m, RegistryKey<World> id) {
        this.manager = m;
        this.dimension = id;
        this.safeDimensionId = this.dimension.func_240901_a_().toString().replace(':', '_');
        this.directory = this.manager.directory.resolve(this.safeDimensionId);
        this.saveData = false;
    }

    public String toString() {
        return this.safeDimensionId;
    }

    public Collection<MapRegion> getLoadedRegions() {
        return this.regions == null ? Collections.emptyList() : this.regions.values();
    }

    public MapDimension created() {
        this.manager.saveData = true;
        return this;
    }

    public Map<XZ, MapRegion> getRegions() {
        if (this.regions == null) {
            this.regions = new HashMap<XZ, MapRegion>();
            if (Files.notExists(this.directory, new LinkOption[0])) {
                try {
                    Files.createDirectories(this.directory, new FileAttribute[0]);
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }
            if (!MapIOUtils.read(this.directory.resolve("dimension.regions"), stream -> {
                stream.readByte();
                byte version = stream.readByte();
                int s = stream.readShort();
                for (int i = 0; i < s; ++i) {
                    byte x = stream.readByte();
                    byte z = stream.readByte();
                    MapRegion c = new MapRegion(this, XZ.of((int)x, (int)z));
                    this.regions.put(c.pos, c);
                }
            })) {
                this.saveData = true;
            }
        }
        return this.regions;
    }

    @Nullable
    public int[] getColors(int x, int z, ColorsFromRegion colors) {
        MapRegion region = this.getRegions().get(XZ.of((int)x, (int)z));
        return region == null ? null : colors.getColors(region.getDataBlocking());
    }

    public MapRegion getRegion(XZ pos) {
        return this.getRegions().computeIfAbsent(pos, p -> new MapRegion(this, (XZ)p).created());
    }

    public List<Waypoint> getWaypoints() {
        block15: {
            if (this.waypoints == null) {
                this.waypoints = new ArrayList<Waypoint>();
                Path file = this.directory.resolve("waypoints.json");
                if (Files.exists(file, new LinkOption[0])) {
                    try (BufferedReader reader = Files.newBufferedReader(file);){
                        JsonObject json = (JsonObject)FTBChunks.GSON.fromJson((Reader)reader, JsonObject.class);
                        if (!json.has("waypoints")) break block15;
                        for (JsonElement e : json.get("waypoints").getAsJsonArray()) {
                            JsonObject o = e.getAsJsonObject();
                            Waypoint w = new Waypoint(this);
                            w.hidden = o.get("hidden").getAsBoolean();
                            w.name = o.get("name").getAsString();
                            w.x = o.get("x").getAsInt();
                            w.y = o.has("y") ? o.get("y").getAsInt() : -1;
                            w.z = o.get("z").getAsInt();
                            w.color = 0xFFFFFF;
                            if (o.has("color")) {
                                try {
                                    w.color = Integer.decode(o.get("color").getAsString());
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            if (o.has("type")) {
                                w.type = WaypointType.valueOf(o.get("type").getAsString().toUpperCase());
                            }
                            this.waypoints.add(w);
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        }
        return this.waypoints;
    }

    public void release() {
        for (MapRegion region : this.getLoadedRegions()) {
            region.release();
        }
        this.regions = null;
        this.waypoints = null;
    }

    @Override
    public void runMapTask(MapManager m) {
        try {
            JsonObject json = new JsonObject();
            JsonArray waypointArray = new JsonArray();
            for (Waypoint w : this.getWaypoints()) {
                JsonObject o = new JsonObject();
                o.addProperty("hidden", Boolean.valueOf(w.hidden));
                o.addProperty("name", w.name);
                o.addProperty("x", (Number)w.x);
                o.addProperty("y", (Number)w.y);
                o.addProperty("z", (Number)w.z);
                o.addProperty("color", String.format("#%06X", 0xFFFFFF & w.color));
                o.addProperty("type", w.type.name().toLowerCase());
                waypointArray.add((JsonElement)o);
            }
            json.add("waypoints", (JsonElement)waypointArray);
            try (BufferedWriter writer = Files.newBufferedWriter(this.directory.resolve("waypoints.json"), new OpenOption[0]);){
                FTBChunks.GSON.toJson((JsonElement)json, (Appendable)writer);
            }
            Collection<MapRegion> regionList = this.getRegions().values();
            if (regionList.isEmpty()) {
                return;
            }
            MapIOUtils.write(this.directory.resolve("dimension.regions"), stream -> {
                stream.writeByte(0);
                stream.writeByte(1);
                stream.writeShort(regionList.size());
                for (MapRegion region : regionList) {
                    stream.writeByte(region.pos.x);
                    stream.writeByte(region.pos.z);
                }
            });
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void sync() {
        long now = System.currentTimeMillis();
        this.getRegions().values().stream().sorted(Comparator.comparingDouble(MapRegion::distToPlayer)).forEach(region -> FTBChunksClient.queue(new SyncTXTask((MapRegion)region, now)));
    }
}

