/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.FirstPersonRenderer;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.HandSide;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3f;

public abstract class ItemMapLikeRenderer {
    protected abstract void renderItem(MatrixStack var1, IRenderTypeBuffer var2, ItemStack var3);

    protected void renderItemFirstPerson(MatrixStack transform, IRenderTypeBuffer render, int lightTexture, Hand hand, float pitch, float equipProgress, float swingProgress, ItemStack stack) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        transform.func_227860_a_();
        if (hand == Hand.MAIN_HAND && player.func_184592_cb().func_190926_b()) {
            this.renderItemFirstPersonCenter(transform, render, lightTexture, pitch, equipProgress, swingProgress, stack);
        } else {
            this.renderItemFirstPersonSide(transform, render, lightTexture, hand == Hand.MAIN_HAND ? player.func_184591_cq() : player.func_184591_cq().func_188468_a(), equipProgress, swingProgress, stack);
        }
        transform.func_227865_b_();
    }

    private void renderItemFirstPersonSide(MatrixStack transform, IRenderTypeBuffer render, int combinedLight, HandSide side, float equipProgress, float swingProgress, ItemStack stack) {
        Minecraft minecraft = Minecraft.func_71410_x();
        float offset = side == HandSide.RIGHT ? 1.0f : -1.0f;
        transform.func_227861_a_((double)(offset * 0.125f), -0.125, 0.0);
        if (!minecraft.field_71439_g.func_82150_aj()) {
            transform.func_227860_a_();
            transform.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(offset * 10.0f));
            minecraft.func_175597_ag().func_228401_a_(transform, render, combinedLight, equipProgress, swingProgress, side);
            transform.func_227865_b_();
        }
        transform.func_227860_a_();
        transform.func_227861_a_((double)(offset * 0.51f), (double)(-0.08f + equipProgress * -1.2f), -0.75);
        float f1 = MathHelper.func_76129_c((float)swingProgress);
        float f2 = MathHelper.func_76126_a((float)(f1 * (float)Math.PI));
        float f3 = -0.5f * f2;
        float f4 = 0.4f * MathHelper.func_76126_a((float)(f1 * ((float)Math.PI * 2)));
        float f5 = -0.3f * MathHelper.func_76126_a((float)(swingProgress * (float)Math.PI));
        transform.func_227861_a_((double)(offset * f3), (double)(f4 - 0.3f * f2), (double)f5);
        transform.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(f2 * -45.0f));
        transform.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(offset * f2 * -30.0f));
        this.renderItem(transform, render, stack);
        transform.func_227865_b_();
    }

    private void renderItemFirstPersonCenter(MatrixStack transform, IRenderTypeBuffer render, int combinedLight, float pitch, float equipProgress, float swingProgress, ItemStack stack) {
        Minecraft minecraft = Minecraft.func_71410_x();
        FirstPersonRenderer renderer = minecraft.func_175597_ag();
        float swingRt = MathHelper.func_76129_c((float)swingProgress);
        float tX = -0.2f * MathHelper.func_76126_a((float)(swingProgress * (float)Math.PI));
        float tZ = -0.4f * MathHelper.func_76126_a((float)(swingRt * (float)Math.PI));
        transform.func_227861_a_(0.0, (double)(-tX / 2.0f), (double)tZ);
        float pitchAngle = renderer.func_178100_c(pitch);
        transform.func_227861_a_(0.0, (double)(0.04f + equipProgress * -1.2f + pitchAngle * -0.5f), (double)-0.72f);
        transform.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(pitchAngle * -85.0f));
        if (!minecraft.field_71439_g.func_82150_aj()) {
            transform.func_227860_a_();
            transform.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(90.0f));
            renderer.func_228403_a_(transform, render, combinedLight, HandSide.RIGHT);
            renderer.func_228403_a_(transform, render, combinedLight, HandSide.LEFT);
            transform.func_227865_b_();
        }
        float rX = MathHelper.func_76126_a((float)(swingRt * (float)Math.PI));
        transform.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(rX * 20.0f));
        transform.func_227862_a_(2.0f, 2.0f, 2.0f);
        this.renderItem(transform, render, stack);
    }
}

