/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.core.apis;

import dan200.computercraft.api.lua.ILuaAPI;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.core.apis.IAPIEnvironment;
import dan200.computercraft.core.apis.TermMethods;
import dan200.computercraft.core.computer.IComputerEnvironment;
import dan200.computercraft.core.terminal.Terminal;
import dan200.computercraft.shared.util.Colour;
import javax.annotation.Nonnull;

public class TermAPI
extends TermMethods
implements ILuaAPI {
    private final Terminal terminal;
    private final IComputerEnvironment environment;

    public TermAPI(IAPIEnvironment environment) {
        this.terminal = environment.getTerminal();
        this.environment = environment.getComputerEnvironment();
    }

    @Override
    public String[] getNames() {
        return new String[]{"term"};
    }

    @LuaFunction(value={"nativePaletteColour", "nativePaletteColor"})
    public final Object[] nativePaletteColour(int colour) throws LuaException {
        int actualColour = 15 - TermAPI.parseColour(colour);
        Colour c = Colour.fromInt(actualColour);
        float[] rgb = c.getRGB();
        Object[] rgbObj = new Object[rgb.length];
        for (int i = 0; i < rgbObj.length; ++i) {
            rgbObj[i] = Float.valueOf(rgb[i]);
        }
        return rgbObj;
    }

    @Override
    @Nonnull
    public Terminal getTerminal() {
        return this.terminal;
    }

    @Override
    public boolean isColour() {
        return this.environment.isColour();
    }
}

